sub load{
	use utf8;
    my $file = shift;
    -e $file or return 0;
    my @data;
    open (my $fh, "<:encoding(utf8)", $file )or die qq(can not open "$file");
    eval{ flock($fh,2); };
    while( <$fh> ){
        chomp;
        my @cells = split /\t/;
        # のびのび
        if ($#cells < 100){
        	for (my $i = $#cells; $i < 100; $i++){
        		push @cells, "";
        	}
        }
        push @data, \@cells;
    }
    close $fh;
    @data;
}

sub save{
	use utf8;
    my $file = shift;
    #-e $file or warn qq(not found "$file");
    my @data;
    my $count = 0;
    foreach my $cell ( @_ ){
    	if($count > 10000000){last;}
        my $str = join "\t", @{$cell};
        chomp($str);
        push @data, "$str\n";
        $count++;
        $sleep_count++;
    }
    open my $fh, ">:encoding(utf8)", $file;
    eval{ flock($fh,2); };
    print $fh @data;
    close $fh;
    "saved";
    if ($sleep_count > 50){
		sleep 1;
		$sleep_count = 0;
	}
}

sub load_data{
	use utf8;
	my $ref_game_ref_data = shift;
	my %game_ref_data = %{$ref_game_ref_data};
	
	# 更新結果格納配列
	my @log = ( );
	# 継続内容格納配列
	my @act = ( );
	
	# 継続データをロードして、tsvファイルを二次元配列の形で取得する
	# 継続データはcgiファイルだけれど、直接読み取りを500エラーで防いでいるだけのtsvファイル
	my @keizoku_list = &load( "../log_keizoku/log_keizoku.cgi" );
	
	# キャラデータ読み込み
	my @chara_list = &load( "../SAVE_DATA/CHARA_DATA.tsv");
	
	# 継続データを各種データに転記しておく
	# eno1番から最後尾までループして更新結果を出力する
	for (my $eno=1; $eno<=$#keizoku_list; $eno++){
		# データがない場合飛ばす
		unless ($keizoku_list[$eno]){next;}
		# キャラ名転記
		$chara_list[$eno][1] = $keizoku_list[$eno][1];
		# 日記転記
		$act[$eno][2] = $keizoku_list[$eno][2];
	}
	
	# 各種データをリファレンスにして、引き出しにしまっておく
	$game_ref_data{'log'} = \@log;
	$game_ref_data{'act'} = \@act;
	$game_ref_data{'keizoku'} = \@keizoku_list;
	$game_ref_data{'chara'} = \@chara_list;
	
	# ロード後のリファレンスを保持した配列をリファレンスで返す
	return \%game_ref_data;
}

sub save_data{
	use utf8;
	my $ref_game_ref_data = shift;
	my %game_ref_data = %{$ref_game_ref_data};
	
	# 必要なデータを配列に戻す
	my @chara_list = @{$game_ref_data{'chara'}};
	
	# tsvで出力する
	&save( '../SAVE_RESULT/CHARA_DATA.tsv', @chara_list );
	
	return 1;
}

sub html_output{
	use utf8;
	my $ref_game_ref_data = shift;
	my %game_ref_data = %{$ref_game_ref_data};
	
	my @log = @{$game_ref_data{'log'}};
	my @chara_list = @{$game_ref_data{'chara'}};
	
	my $header2 = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' . "\n";
	$header2 .= '<html lang="ja" xml:lang="ja" xmlns="http://www.w3.org/1999/xhtml">' . "\n";
	$header2 .= '<head>' . "\n";
	$header2 .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />' . "\n";
	
	my $header = '<meta name="keywords" content="定期更新型ネットゲーム" />' . "\n";
	$header .= '<meta name="description" content="このサイトは定期更新型ネットゲームです" />' . "\n";
	$header .= '<meta http-equiv="content-script-type" content="text/javascript" />' . "\n";
	$header .= '<meta http-equiv="content-style-type" content="text/css" />' . "\n";
	$header .= '<link href="../css/base.css" rel="stylesheet" type="text/css" />' . "\n";
	$header .= '<script type="text/javascript" src="../js/jquery-1.11.3.min.js"></script>' . "\n";
	
	$header .= '</head>' . "\n";
	
	my $foot = '' . "\n";
	$foot .= '<div id="foot">' . "\n";
	# コピーライト名を各自変えておくこと
	$foot .= '<p> (c)<script type="text/javascript">document.write(new Date().getFullYear())</script> <a href="./">定期GM</a></p>' . "\n";
	$foot .= '</div>' . "\n";
	$foot .= '</body>' . "\n";
	$foot .= '</html>' . "\n";
	
	# eno1番から最後尾までループして更新結果を出力する
	for (my $eno=1; $eno<=$#chara_list; $eno++){
		if ($log[$eno]){
			
			my $name = $chara_list[$eno][1];
			unless($name){next;}
			
			
			my $a_eno = int($eno / 1000);
			my $b_eno = $eno % 1000;
			my $c_eno = int($b_eno / 100);
			my $d_eno = $b_eno % 100;
			my $e_eno = int($d_eno / 10);
			my $f_eno = $d_eno % 10;
			
			my $str = $header2;
			
			$str .= "<TITLE>ENo." . $a_eno . $c_eno . $e_eno. $f_eno . "　" . $name . "</TITLE>\n";
			$str .= '<link rel="shortcut icon" href="../favicon.ico" >' . "\n";
			
			$str .= $header;
			
			$str .= "<h1>ENo." . $a_eno . $c_eno . $e_eno. $f_eno . "　" . $name . "</h1>\n";
			
			
			my $day = $chara_list[$eno][6];
			if ($day eq ""){$day = 0;}
			$str .= "<h2>第" . $day . "回目　" . $time_log . "の" . $name . "</h2>\n";
			
			# 更新結果を転写
			$str .= $log[$eno];
			
			
			
			$str .= $foot;
			
			# htmlページとして出力
			my $file = '../RESULT/c' . $a_eno . $c_eno . $e_eno. $f_eno . '.html';
			open(OUT,">$file");
			print OUT encode('utf8', $str);
			close(OUT);
		}
		
	}
	return \%game_ref_data;
}

1;
