package mine;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

/**
 * XN[KvȂꍇ̓XN[o[ɂȂݒ肪\ȃXN[yCłB<br>
 * XN[o[L̐ݒ肪o邱ƈȊOJScrollPaneƓEEEƎv܂B<br>
 * 
 * @author MINE
 * 
 */
public class MineScrollPane extends JScrollPane
{
  /** ɃXN[̕KvȂꍇ̓o[𖳌ɂ|V[ */
	public static final int HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED = 33;
  /** ɃXN[̕KvȂꍇ̓o[𖳌ɂ|V[ */
	public static final int VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED = 23;
	
  /** ̃XN[o[̕\|V[ۑϐ */
	private int hScrollBarPolicy;
  /** ̃XN[o[̕\|V[ۑϐ */
	private int vScrollBarPolicy;
	
	/**
	 * ftHgRXgN^<br>
	 * @see JScrollPane#JScrollPane()
	 */
	public MineScrollPane() {
		super();
	}
	
	/**
	 * XN[yCɕ\R|[lgw肷RXgN^<br>
	 * @param view \R|[lg
	 * @see JScrollPane#JScrollPane(java.awt.Component)
	 */
	public MineScrollPane(Component view) {
		super(view);
	}
	
	/**
	 * XN[yCɕ\R|[lgƃXN[o[̕\|V[w肷RXgN^<br>
	 * @param view \R|[lg
	 * @param vsbPolicy ̃XN[o[̕\|V[
	 * @param hsbPolicy s̃XN[o[̕\|V[
	 * @see JScrollPane#JScrollPane(java.awt.Component, int, int)
	 */
	public MineScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
		super(view, vsbPolicy, hsbPolicy);
	}
	
	/**
	 * XN[o[̕\|V[w肷RXgN^<br>
	 * @param vsbPolicy ̃XN[o[̕\|V[
	 * @param hsbPolicy s̃XN[o[̕\|V[
	 * @see JScrollPane#JScrollPane(int, int)
	 */
	public MineScrollPane(int vsbPolicy, int hsbPolicy) {
		super(vsbPolicy, hsbPolicy);
	}

  /**
   * ̃XN[o[쐬郁\bhB<br>
   * I[o[Ch{@link MyAdjustmentListener}ǉB
   * @return AdjustmentListenerǉ̃XN[o[
   * @see JScrollPane#createHorizontalScrollBar()
   */
	public JScrollBar createHorizontalScrollBar() {
		JScrollBar horizontalScrollBar = super.createHorizontalScrollBar();
		horizontalScrollBar.addAdjustmentListener(new MyAdjustmentListener());
		return horizontalScrollBar;
	}
	
  /**
   * ̃XN[o[쐬郁\bhB<br>
   * I[o[Ch{@link MyAdjustmentListener}ǉB
   * @return AdjustmentListenerǉ̃XN[o[
   * @see JScrollPane#createVerticalScrollBar()
   */
	public JScrollBar createVerticalScrollBar() {
		JScrollBar verticalScrollBar = super.createVerticalScrollBar();
    verticalScrollBar.addAdjustmentListener(new MyAdjustmentListener());
		return verticalScrollBar;
	}
	
	/**
   * ̃XN[o[|V[ݒ肷郁\bhB<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}ݒ肳ꍇ<br>
   * {@link JScrollPane#setHorizontalScrollBarPolicy(int)}ɂ{@link javax.swing.ScrollPaneConstants#HORIZONTAL_SCROLLBAR_ALWAYS HORIZONTAL_SCROLLBAR_ALWAYS}ݒ肷
   * @see JScrollPane#getHorizontalScrollBarPolicy()
	 */
  public void setHorizontalScrollBarPolicy(int hsbPolicy) {
		if (hsbPolicy == HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED) {
			super.setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_ALWAYS);
		}
		else {
			super.setHorizontalScrollBarPolicy(hsbPolicy);
		}
		hScrollBarPolicy = hsbPolicy;
	}
	
  /**
   * ̃XN[o[|V[ݒ肷郁\bhB<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}ݒ肳ꍇ<br>
   * {@link JScrollPane#setVerticalScrollBarPolicy(int)}ɂ{@link javax.swing.ScrollPaneConstants#VERTICAL_SCROLLBAR_ALWAYS VERTICAL_SCROLLBAR_ALWAYS}ݒ肷
   * @see JScrollPane#getVerticalScrollBarPolicy()
   */
	public void setVerticalScrollBarPolicy(int vsbPolicy) {
		if (vsbPolicy == VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED) {
			super.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_ALWAYS);
		}
		else {
			super.setVerticalScrollBarPolicy(vsbPolicy);
		}
		vScrollBarPolicy = vsbPolicy;
	}

  /**
   * ̃XN[o[̕\|V[擾郁\bhB<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}ݒ肳Ă邩łB<br>
   * {@link JScrollPane#getHorizontalScrollBarPolicy()}JScrollPanȅŎgp邽߁A<br>
   * I[o[Ch͂ȂB
   * @return ̃XN[o[̕\|V[
   */
	public int getHorizontalScrollBarPolicyCustum() {
		return hScrollBarPolicy;
	}
	
  /**
   * ̃XN[o[̕\|V[擾郁\bhB<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}ݒ肳Ă邩łB<br>
   * {@link JScrollPane#getVerticalScrollBarPolicy()}JScrollPanȅŎgp邽߁A<br>
   * I[o[Ch͂ȂB
   * @return ̃XN[o[̕\|V[
   */
	public int getVerticalScrollBarPolicyCustum() {
		return vScrollBarPolicy;
	}
	
	/**
   * XN[̗LɂLE؂ւ邽߂AdjustmentListenerB<br>
   * @author MINE
   *
	 */
  private class MyAdjustmentListener implements AdjustmentListener
	{
		public void adjustmentValueChanged(AdjustmentEvent e) {
      //̃XN[o[̏ꍇ
			if (e.getSource().equals(getHorizontalScrollBar())) {
				JScrollBar scrollBar = getHorizontalScrollBar();
        //HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDEDݒ肳Ăꍇ
				if (getHorizontalScrollBarPolicyCustum() == HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED) {
          //XN[yCĂꍇ̂݃XN[̗LŗLE؂ւ
					if (isEnabled()) {
						int maximum = scrollBar.getMaximum();
						int visibleAmount = scrollBar.getVisibleAmount();
            //maximum-visibleAmount0̎̓XN[KvȎȂ̂ŗLɂB
            //0̎̓XN[̕KvȂ̂Ŗɂ
						scrollBar.setEnabled((maximum - visibleAmount) > 0);
					}
				}
			}
      //̃XN[o[̏ꍇ
			else if (e.getSource().equals(getVerticalScrollBar())) {
				JScrollBar scrollBar = getVerticalScrollBar();
        //VERTICAL_SCROLLBAR_ENABLED_AS_NEEDEDݒ肳Ăꍇ
				if (getVerticalScrollBarPolicyCustum() == VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED) {
          //XN[yCĂꍇ̂݃XN[̗LŗLE؂ւ
					if (isEnabled()) {
						int maximum = scrollBar.getMaximum();
						int visibleAmount = scrollBar.getVisibleAmount();
            //maximum-visibleAmount0̎̓XN[KvȎȂ̂ŗLɂB
            //0̎̓XN[̕KvȂ̂Ŗɂ
						scrollBar.setEnabled((maximum - visibleAmount) > 0);
					}
				}
			}
		}
	}
}
