package mine;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

/**
 * XN[KvȂꍇ̓XN[o[ɂȂݒ肪\ȃXN[yCłB<br>
 * XN[o[L̐ݒ肪o邱ƈȊOJScrollPaneƓEEEƎv܂B<br>
 * 
 * @author MINE
 * 
 */
public class MineScrollPane extends JScrollPane
{
  /** ɃXN[̕KvȂꍇ̓o[𖳌ɂ|V[ */
	public static final int HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED = 33;
  /** ɃXN[̕KvȂꍇ̓o[𖳌ɂ|V[ */
	public static final int VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED = 23;
  
  /** ɃXN[̕KvȂꍇ̓o[TCYςɂ|V[ */
  public static final int HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED = 34;
  
  /** ɃXN[̕KvȂꍇ̓o[TCYςɂ|V[ */
  public static final int VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED = 24;
	
	/**
	 * ftHgRXgN^<br>
	 * @see JScrollPane#JScrollPane()
	 */
	public MineScrollPane() {
		super();
	}
	
	/**
	 * XN[yCɕ\R|[lgw肷RXgN^<br>
	 * @param view \R|[lg
	 * @see JScrollPane#JScrollPane(java.awt.Component)
	 */
	public MineScrollPane(Component view) {
		super(view);
	}
	
	/**
	 * XN[yCɕ\R|[lgƃXN[o[̕\|V[w肷RXgN^<br>
	 * @param view \R|[lg
	 * @param vsbPolicy ̃XN[o[̕\|V[
	 * @param hsbPolicy s̃XN[o[̕\|V[
	 * @see JScrollPane#JScrollPane(java.awt.Component, int, int)
	 */
	public MineScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
		super(view, vsbPolicy, hsbPolicy);
	}
	
	/**
	 * XN[o[̕\|V[w肷RXgN^<br>
	 * @param vsbPolicy ̃XN[o[̕\|V[
	 * @param hsbPolicy s̃XN[o[̕\|V[
	 * @see JScrollPane#JScrollPane(int, int)
	 */
	public MineScrollPane(int vsbPolicy, int hsbPolicy) {
		super(vsbPolicy, hsbPolicy);
	}

  /**
   * ̃XN[o[쐬郁\bhB<br>
   * I[o[Ch{@link MyAdjustmentListener}ǉB
   * @return AdjustmentListenerǉ̃XN[o[
   * @see JScrollPane#createHorizontalScrollBar()
   */
	public JScrollBar createHorizontalScrollBar() {
		JScrollBar horizontalScrollBar = super.createHorizontalScrollBar();
		horizontalScrollBar.addAdjustmentListener(new MyAdjustmentListener());
		return horizontalScrollBar;
	}
	
  /**
   * ̃XN[o[쐬郁\bhB<br>
   * I[o[Ch{@link MyAdjustmentListener}ǉB
   * @return AdjustmentListenerǉ̃XN[o[
   * @see JScrollPane#createVerticalScrollBar()
   */
	public JScrollBar createVerticalScrollBar() {
		JScrollBar verticalScrollBar = super.createVerticalScrollBar();
    verticalScrollBar.addAdjustmentListener(new MyAdjustmentListener());
		return verticalScrollBar;
	}
	
	/**
   * ̃XN[o[|V[ݒ肷郁\bhB<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED}w肳Ă<br>
   * {@link JScrollPane#setHorizontalScrollBarPolicy(int)}Ɠ̓삷悤ɃI[o[ChB
   * @see JScrollPane#getHorizontalScrollBarPolicy()
   * @see #getHorizontalScrollBarPolicyCustum()
	 */
  public void setHorizontalScrollBarPolicy(int hsbPolicy) {
    switch(hsbPolicy) {
      //HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDEDHORIZONTAL_SCROLLBAR_FILLE_AS_NOT_NEEDEDw肳ꂽ
      //̃XN[o[|V[ύXꂽoEhvpeBʒmāAXN[yC`悵ȂB
      case HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED:
      case HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED:
        int old = horizontalScrollBarPolicy;
        horizontalScrollBarPolicy = hsbPolicy;
        firePropertyChange("horizontalScrollBarPolicy", old, hsbPolicy);
        revalidate();
        repaint();
        break;
      default:
        super.setHorizontalScrollBarPolicy(hsbPolicy);
    }
	}
	
  /**
   * ̃XN[o[|V[ݒ肷郁\bhB<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED}w肳Ă<br>
   * {@link JScrollPane#setVerticalScrollBarPolicy(int)}Ɠ̓삷悤ɃI[o[ChB
   * @see JScrollPane#getVerticalScrollBarPolicy()
   * @see #getVerticalScrollBarPolicyCustum()
   */
	public void setVerticalScrollBarPolicy(int vsbPolicy) {
    switch(vsbPolicy) {
      //VERTICAL_SCROLLBAR_ENABLED_AS_NEEDEDVERTICAL_SCROLLBAR_FILLE_AS_NOT_NEEDEDw肳ꂽ
      //̃XN[o[|V[ύXꂽoEhvpeBʒmāAXN[yC`悵ȂB
      case VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED:
      case VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED:
        int old = verticalScrollBarPolicy;
        verticalScrollBarPolicy = vsbPolicy;
        firePropertyChange("verticalScrollBarPolicy", old, vsbPolicy);
        revalidate();
        repaint();
        break;
      default:
        super.setVerticalScrollBarPolicy(vsbPolicy);
		}
	}
  
  /**
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳ĂĂ<br>
   * ł{@link ScrollPaneConstants#HORIZONTAL_SCROLLBAR_AS_NEEDED}ݒ肳ꂽꍇƓɂȂĂ܂̂<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ăꍇ<br>
   * {@link ScrollPaneConstants#HORIZONTAL_SCROLLBAR_ALWAYS}Ԃ悤ɃI[o[ChB<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ă邩̔<br>
   * {@link #getHorizontalScrollBarPolicyCustum()}gpB
   * 
   * @see #getHorizontalScrollBarPolicyCustum()
   */
  public int getHorizontalScrollBarPolicy() {
    if (horizontalScrollBarPolicy > HORIZONTAL_SCROLLBAR_ALWAYS) {
      return HORIZONTAL_SCROLLBAR_ALWAYS;
    }
    else {
      return horizontalScrollBarPolicy;
    }
  }
  
  /**
   * ̃XN[o[̕\|V[擾郁\bhB<br>
   * {@link #HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ă邩łB<br>
   * 
   * @return ̃XN[o[̕\|V[
   */
	public int getHorizontalScrollBarPolicyCustum() {
		return horizontalScrollBarPolicy;
	}
	
  /**
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳ĂĂ<br>
   * ł{@link ScrollPaneConstants#VERTICAL_SCROLLBAR_AS_NEEDED}ݒ肳ꂽꍇƓɂȂĂ܂̂<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ăꍇ<br>
   * {@link ScrollPaneConstants#VERTICAL_SCROLLBAR_ALWAYS}Ԃ悤ɃI[o[ChB<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ă邩̔<br>
   * {@link #getVerticalScrollBarPolicyCustum()}gpB
   * 
   * @see #getVerticalScrollBarPolicyCustum()
   */
  public int getVerticalScrollBarPolicy() {
    if (verticalScrollBarPolicy > VERTICAL_SCROLLBAR_ALWAYS) {
      return VERTICAL_SCROLLBAR_ALWAYS;
    }
    else {
      return verticalScrollBarPolicy;
    }
  }
  
  /**
   * ̃XN[o[̕\|V[擾郁\bhB<br>
   * {@link #VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED}܂{@link #VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED}ݒ肳Ă邩łB<br>
   * 
   * @return ̃XN[o[̕\|V[
   */
	public int getVerticalScrollBarPolicyCustum() {
		return verticalScrollBarPolicy;
	}
	
	/**
   * XN[̗LɂLE؂ւ邽߂AdjustmentListenerB<br>
   * @author MINE
   *
	 */
  private class MyAdjustmentListener implements AdjustmentListener
	{
		public void adjustmentValueChanged(AdjustmentEvent e) {
      //XN[yCĂꍇ̂݃XN[o[̏ԂύX
      if (isEnabled()) {
        JScrollBar scrollBar = (JScrollBar)e.getSource();
        //̃XN[o[̏ꍇ
  			if (scrollBar.equals(getHorizontalScrollBar())) {
          int maximum = scrollBar.getMaximum();
          int visibleAmount = scrollBar.getVisibleAmount();

          switch (getHorizontalScrollBarPolicyCustum()) {
            //HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDEDݒ肳Ăꍇ
            case HORIZONTAL_SCROLLBAR_ENABLED_AS_NEEDED:
              //maximumvisibleAmountlłȂ̓XN[KvȎȂ̂ŗLɂB
              //l̎̓XN[̕KvȂ̂Ŗɂ
  						scrollBar.setEnabled(maximum != visibleAmount);
    					break;
              //HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDEDݒ肳Ăꍇ
            case HORIZONTAL_SCROLLBAR_FILL_AS_NOT_NEEDED:
              //XN[KvȂ͍ől1₵ăXN[o[TCYςɂȂĂ悤Ɍ
              if (maximum == visibleAmount) {
                scrollBar.setMaximum(maximum + 1);
              }
              break;
          }
  			}
        //̃XN[o[̏ꍇ
  			else if (scrollBar.equals(getVerticalScrollBar())) {
          int maximum = scrollBar.getMaximum();
          int visibleAmount = scrollBar.getVisibleAmount();

          switch (getVerticalScrollBarPolicyCustum()) {
            //VERTICAL_SCROLLBAR_ENABLED_AS_NEEDEDݒ肳Ăꍇ
            case VERTICAL_SCROLLBAR_ENABLED_AS_NEEDED:
              //maximumvisibleAmountlłȂ̓XN[KvȎȂ̂ŗLɂB
              //l̎̓XN[̕KvȂ̂Ŗɂ
              scrollBar.setEnabled(maximum != visibleAmount);
              break;
            //VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDEDݒ肳Ăꍇ
            case VERTICAL_SCROLLBAR_FILL_AS_NOT_NEEDED:
              //XN[KvȂ͍ől1₵ăXN[o[TCYςɂȂĂ悤Ɍ
              if (maximum == visibleAmount) {
                scrollBar.setMaximum(maximum + 1);
              }
              break;
          }
  			}
      }
		}
	}
}
