package mine.whitespacefield;

import java.util.HashMap;

import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.Document;

import mine.whitespacefield.plaf.metal.MetalWhiteSpaceVisibleTextFieldUI;
import mine.whitespacefield.plaf.motif.MotifWhiteSpaceVisibleTextFieldUI;
import mine.whitespacefield.plaf.windows.WindowsWhiteSpaceVisibleTextFieldUI;
import mine.whitespacefield.text.DrawCharSPInterface;


import com.sun.java.swing.plaf.motif.MotifTextFieldUI;
import com.sun.java.swing.plaf.windows.WindowsTextFieldUI;

/**
 * ̕摜}`ɂĕ\łJTextFieldB<br>
 * ^uɂΉĂ܂A\tŃ^uƕ`悪܂B
 * (JTextField悤ɂȂ邯ǁAȂ͂킩܂EEE)
 * 
 * @author Mine
 * @since 2013/04/06
 */
public class WhiteSpaceVisibleTextField extends JTextField
{
  /** 蕶ƁA摜}`ɒuĕ\C^[tF[X֘At}bv */
  private HashMap<String, DrawCharSPInterface> drawCharSPMap;
  
  /**
   * ftHg̃RXgN^B
   * @see JTextField#JTextField()
   */
  public WhiteSpaceVisibleTextField() {
    super();
    init();
  }
  
  /**
   * w肷RXgN^B
   * @param text \eLXg܂null
   * @see JTextField#JTextField(String)
   */
  public WhiteSpaceVisibleTextField(String text) {
    super(text);
    init();
  }
  
  /**
   * 񐔂w肷RXgN^B
   * @param columns K؂ȕ̌vZɎgp񐔁B񐔂0ɐݒ肷ƁAK؂ȕ̓R|[lg̎玩RɓlɂȂ
   * @see JTextField#JTextField(int)
   */
  public WhiteSpaceVisibleTextField(int columns) {
    super(columns);
    init();
  }
  
  /**
   * Ɨ񐔂w肷RXgN^B
   * @param text \eLXg܂null
   * @param columns K؂ȕ̌vZɎgp񐔁B񐔂0ɐݒ肷ƁAK؂ȕ̓R|[lg̎玩RɓlɂȂ
   */
  public WhiteSpaceVisibleTextField(String text, int columns) {
    super(text, columns);
    init();
  }
  
  /**
   * hLgAA񐔂w肷RXgN^B
   * @param doc gpeLXgXg[WBnull̏ꍇ́AcreateDefaultModel\bhĂяoƂɂăftHg̒l񋟂
   * @param text \eLXg܂null
   * @param columns K؂ȕ̌vZɎgp񐔁B񐔂0ɐݒ肷ƁAK؂ȕ̓R|[lg̎玩RɓlɂȂ
   */
  public WhiteSpaceVisibleTextField(Document doc, String text, int columns) {
    super(doc, text, columns);
    init();
  }
  
  /**
   * ̕摜}`ɂĕ\UI̐ݒƁA}bv̏܂B
   */
  private void init() {
    TextUI ui = getUI();
    if (ui.getClass().equals(WindowsTextFieldUI.class)) {
      setUI(new WindowsWhiteSpaceVisibleTextFieldUI());
    }
    else if (ui.getClass().equals(MotifTextFieldUI.class)) {
      setUI(new MotifWhiteSpaceVisibleTextFieldUI());
    }
    else if (ui.getClass().equals(MetalTextFieldUI.class)) {
      setUI(new MetalWhiteSpaceVisibleTextFieldUI());
    }
    
    drawCharSPMap = new HashMap<String, DrawCharSPInterface>(0);
  }
  
  /**
   * u镶ƁA\摜܂͐}`̃C^[tF[X֘At܂B
   * @param c u镶B1łȂƒuȂ̂Œ
   * @param charSP \摜܂͐}`̃C^[tF[X
   * @return ȑOɊ֘AtĂC^[tF[XB֘AtȂꍇnull
   */
  public DrawCharSPInterface putDrawCharSP(String c, DrawCharSPInterface charSP) {
    return drawCharSPMap.put(c, charSP);
  }
  
  /**
   * 蕶ƁA摜}`ɒuĕ\C^[tF[X̊֘AtA蕶uȂ悤ɂ܂B
   */
  public void clearDrawCharSP() {
    drawCharSPMap.clear();
  }
  
  /**
   * 蕶ƁA摜}`ɒuĕ\C^[tF[X֘At}bv擾܂B<br>
   * ̃\bh́A{@link mine.whitespacefield.text.WhiteSpaceVisibleView}Ŏgp邽߂publicɂȂĂ܂A
   * 擾}bvύXȂƂ߂܂B
   * @return 蕶ƁA摜}`ɒuĕ\C^[tF[X֘At}bv
   */
  public HashMap<String, DrawCharSPInterface> getDrawCharSPMap() {
    return drawCharSPMap;
  }
}
