package mine.whitespacefield.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.HashMap;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;

import mine.whitespacefield.WhiteSpaceVisibleTextField;

/**
 * ̕摜}`ɂăeLXgtB[hɕ\邽߂ViewB
 * 
 * @author Mine
 * @since 2013/04/06
 */
public class WhiteSpaceVisibleView extends FieldView
{
  /**
   * RXgN^B
   * @param elem vf
   */
  public WhiteSpaceVisibleView(Element elem) {
    super(elem);
  }
  
  /**
   * ̕摜}`ɂĕ`悷邽߂ɃI[o[ChĂ܂B
   */
  public void paint(Graphics g, Shape allocation) {
    super.paint(g, allocation);
    paintCustomParagraph(g, allocation);
  }
  
  /**
   * ̕摜}`ɂĕ`悵܂B
   * @param g gp`\
   * @param a `̂߂Ɋ蓖Ăꂽ̈
   */
  private void paintCustomParagraph(Graphics g, Shape a) {
    try {
      //񂪒ăXN[Ă邩Ȃ̂ŁA`̈XN[̍Wɕϊ
      //(悭ĂȂǁAԂ񂱂ȈӖ)
      Shape paragraph = modelToView(getStartOffset(), a, Position.Bias.Backward);
      Rectangle r = paragraph.getBounds();
      
      //蕶up}bvEĂ
      HashMap<String, DrawCharSPInterface> charSPMap = ((WhiteSpaceVisibleTextField)getContainer()).getDrawCharSPMap();
      
      Graphics2D g2 = (Graphics2D)g;
      //Xg[NobNAbv
      Stroke stroke = g2.getStroke();
      //tHg擾
      FontMetrics fontMetrics = g.getFontMetrics();
      //\镶ׂ̂Ẵ^u̒̍v
      int sumOfTabs  = 0;
      //`̈ɕ`悷镶擾
      String text = getDocument().getText(getStartOffset(), getEndOffset()).toString();
      for(int i = 0; i < text.length(); i++) {
        //1oBsubstringgĂ̂́AƂ̏ŕ̕sǂBƂCɂĂ܂
        String s = text.substring(i, i+1);
        //܂ŕ\̒
        int previousStringWidth = fontMetrics.stringWidth(text.substring(0, i)) + sumOfTabs;
        //ɕ\镶XW
        int x = r.x + previousStringWidth;
        //̒
        int h = r.height-fontMetrics.getDescent();
        //摜}`\邽߂̃C^[tF[X擾
        DrawCharSPInterface drawCharSP = charSPMap.get(s);
        //`悷镶ɑΉC^[tF[XΉ摜܂͐}``
        if (drawCharSP != null) {
          //^u̎́A^u̕vZȂƂȂ̂ŕʏ
          if ("\t".equals(s)) {
            int tabWidth = (int)nextTabStop(x, i) - x;
            drawCharSP.drawCharSP(g2, x, r.y, tabWidth, h);
            sumOfTabs += tabWidth;
          }
          //ȊO̓C^[tF[X̕`揈
          else {
            drawCharSP.drawCharSP(g2, x, r.y, fontMetrics.stringWidth(s), h);
          }
        }
        //obNAbvXg[Nɖ߂
        g2.setStroke(stroke);
      }
    }
    catch(BadLocationException e) {
      //modelToView()getText()ŔX^bNg[Xo
      e.printStackTrace();
    }
  }
}
