package mine.whitespacefield.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

import mine.whitespacefield.WhiteSpaceVisibleTextField;
import mine.whitespacefield.text.DrawCharSPInterface;

public class Main extends JFrame
{
  public Main() {
    setTitle("蕶ũeXg");
    getContentPane().add(new Panel());
    pack();
    setLocationRelativeTo(null);
    setDefaultCloseOperation(EXIT_ON_CLOSE);
  }
  public static void main(String[] args) {
    Main main = new Main();
    main.setVisible(true);
  }
}

class Panel extends JPanel
{
  private WhiteSpaceVisibleTextField field = new WhiteSpaceVisibleTextField(20);
  private JTextField oriField = new JTextField(20);

  public Panel() {
    setPreferredSize(new Dimension(240,120));
    
    //^uo^
    field.putDrawCharSP("\t", new DrawTab());
    //pXy[Xo^
    field.putDrawCharSP(" ", new DrawSpace());
    //SpXy[Xo^
    field.putDrawCharSP("@", new DrawLargeSpace());
    
    //\镶
    String str = "\ta b@c";
    field.setText(str);
    oriField.setText(str);
    
    add(field);
    add(oriField);
  }
}

/**
 * Word̔pXy[X̂悤ɁA_ɕ\܂B
 * 
 * @author Mine
 *
 */
class DrawSpace implements DrawCharSPInterface
{
  private static final Color color = new Color(120, 130, 110);
  
  public void drawCharSP(Graphics g, int x, int y, int w, int h) {
    Graphics2D g2 = (Graphics2D)g;
    
    g2.setPaint(color);
    
    int midx = x+w/2;
    int midy = y+h/2;
    int r = 1;
    
    g2.fillOval(midx-r, midy-r, r*2, r*2);
  }
}

/**
 * Word̃^û悤ɁAɕ\܂B
 * 
 * @author Mine
 *
 */
class DrawTab implements DrawCharSPInterface
{
  private static final Color color = new Color(120, 130, 110);
  
  public void drawCharSP(Graphics g, int x, int y, int w, int h) {
    Graphics2D g2 = (Graphics2D)g;
    
    g2.setPaint(color);
    
    int midx = x+w/2;
    int midy = y+h/2;
    int length = 3;
    
    g2.fillPolygon(new int[]{midx, midx+length, midx}, new int[]{midy+length, midy, midy-length}, 3);
    g2.drawLine(midx-length, midy, midx, midy);
  }
}

/**
 * Word̑SpXy[X̂悤ɁAɕ\܂B
 * 
 * @author Mine
 *
 */
class DrawLargeSpace implements DrawCharSPInterface
{
  private static final Color pc = new Color(120, 130, 110);
  
  public void drawCharSP(Graphics g, int x, int y, int w, int h) {
    Graphics2D g2 = (Graphics2D)g;
    
    g2.setColor(pc);
    g2.drawRect(x + 1, y + 1, w - 2, h - 2);
  }
}