package mine.whitespacefield.text;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/**
 * ̕摜}`ɂăeLXgtB[hɕ\邽߂ViewԂEditorKitB
 * 
 * @author Mine
 * @since 2013/04/06
 */
public class WhiteSpaceVisibleEditorKit extends StyledEditorKit
{
  public ViewFactory getViewFactory() {
    return new WhiteSpaceVisibleViewFactory();
  }
  
  static class WhiteSpaceVisibleViewFactory implements ViewFactory
  {
    public View create(Element elem) {
      String kind = elem.getName();
      if (kind != null) {
        if (kind.equals(AbstractDocument.ContentElementName)) {
          return new LabelView(elem);
        }
        else if (kind.equals(AbstractDocument.ParagraphElementName)) {
          return new WhiteSpaceVisibleView(elem);
        }
        else if (kind.equals(AbstractDocument.SectionElementName)) {
          return new BoxView(elem, View.Y_AXIS);
        }
        else if (kind.equals(StyleConstants.ComponentElementName)) {
          return new ComponentView(elem);
        }
        else if (kind.equals(StyleConstants.IconElementName)) {
          return new IconView(elem);
        }
      }
      return new LabelView(elem);
    }
  }
}
