/****************************************************************************
 *   $Id: blinky.c 59919 2012-12-03 13:13:39Z anderslu $
 *   Project: NXP LPC8xx Blinky example
 *
 *   Description:
 *     This file contains LED blink code example which include timer, 
 *     GPIO initialization, and clock monitoring.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation is hereby granted, under NXP Semiconductors' 
 * relevant copyright in the software, without fee, provided that it 
 * is used in conjunction with NXP Semiconductors microcontrollers. This 
 * copyright, permission, and disclaimer notice must appear in all copies of 
 * this code.
 
****************************************************************************/
#include "LPC8xx.h"                        /* LPC8xx definitions */
#include "lpc8xx_clkconfig.h"
#include "lpc8xx_gpio.h"
#include "lpc8xx_mrt.h"
#include "lpc8xx_uart.h"

uint32_t u_get_IrCode(uint32_t,uint32_t);
uint32_t u_decode_IrCode(int);
uint32_t u_ir_code;

extern uint32_t mrt_counter;

extern volatile uint32_t UARTRxCount;
extern volatile uint32_t RxErrorCount;
extern volatile uint8_t UARTRxBuffer[BUFSIZE];

void SwitchMatrix_Init();
void IOCON_Init();

#define u_GPIO_GetValue GPIOGetPinValue

/* Main Program */

int main (void) {
  uint32_t i;
  uint32_t j;
  uint8_t txdata[8];
  
  
  SystemCoreClockUpdate();
  SwitchMatrix_Init();
  IOCON_Init();
  UARTInit(LPC_USART0, 115200);
  init_mrt(SystemCoreClock/1000);
 

  //GPIO 
  //  PIN2=IR_input
  //  PIN5=UART_TX
  
  //PIN2 INPUT
  GPIOSetDir( PORT0, 4, 0 );

  //PIN8 OUTPUT
  GPIOSetDir( PORT0, 0, 1 );
  GPIOSetBitValue( PORT0, 0, 0 );

  //Set for interrupt
  GPIOSetPinInterrupt( 0, PORT0, 4, 0,0 );
  GPIOPinIntEnable( 0, 0);


  u_ir_code=0;
  while (1)  /* Loop forever */
  {

    //ir_code擾łUARTœ]
    if(u_ir_code!=0){
      GPIOSetBitValue( PORT0, 0, 1 ); //LED ON

      //UART_TX
      for(j=0;j<8;j++){
        txdata[j]=(u_ir_code>>(j*8))&0xFF;
      }
      UARTSend(LPC_USART0, txdata, 8);
      u_ir_code=0;

      GPIOSetBitValue( PORT0, 0, 0 ); //LED OFF
    }

  }
}


/*******************************************************************************
* GPIO荞݃nh
*  PORT0_4P̃GbWŊ荞ݏJnāARR[h擾
*******************************************************************************/
void PININT0_IRQHandler(void){
  uint32_t regVal;
  uint32_t code;
  
  code=0;
  regVal = GPIOPinIntStatus(0);
  GPIOPinIntDisable(0,0);
  if ( regVal ) {
    code=u_get_IrCode(PORT0,4);
  }
  
  if(code>0){
    u_ir_code=code;
  }

  GPIOPinIntClear( 0 );
  GPIOPinIntEnable( 0, 0);
  return;
}

  
/*******************************************************************************
* ԊOR@R[h擾
*  Port = { GPIOA , ...}
*  Pin = { GPIO_Pin_0 , ...}
*******************************************************************************/
uint32_t u_get_IrCode(uint32_t Port, uint32_t Pin){
  uint32_t Code;    //IRR[h(߂l)
  uint32_t  CodeSize;//IRR[hbit
  uint32_t fTimeOut; //[vItO
  uint32_t TimeOutLimit; //^CAEgl
  uint32_t t;
  uint32_t Tcycle;
  uint32_t Tcycle1;
  uint32_t TcycleLeadH;
  uint32_t TcycleLeadL;
  
  Code=0;
  CodeSize=0;
  fTimeOut=0;
  Tcycle=146; //= 512us/3.5us@GPIO_R , 512/7us@GPIO_RW
  Tcycle1=Tcycle*2; 
  TcycleLeadH=Tcycle*10; 
  TcycleLeadL=Tcycle*6; 
  TimeOutLimit=Tcycle*20;
  
  
  //LeaderR[h̃`FbN
  t=0;
  while(u_GPIO_GetValue(Port,Pin)==0 && t<TimeOutLimit){
    t++;
  }
  //TimeOut
  if(t<TcycleLeadL || t>=TimeOutLimit){
    fTimeOut=1;
    Code=0;
  }
  else{
    if(t>0){
      GPIOSetBitValue(0,0,0);
      GPIOSetBitValue(0,0,1);
      GPIOSetBitValue(0,0,0);
    }
  }
    
  //Cf[^̎擾
  //  - TimeOut܂ő
  while(fTimeOut==0){
    //HԂ̃`FbN
    t=0;
    while(u_GPIO_GetValue(Port,Pin)==1 && t<TimeOutLimit){
      t++;
    }
    
    if(t>=Tcycle1*5){ //TimeOut
      fTimeOut=1;
    }
    else if(t>Tcycle1){    //Bit=1
      Code=(Code<<1) +1;
    }
    else{    //Bit=0
      Code=(Code<<1) +0;
    }
    
    //LԂ̃`FbN
    t=0;
    while(u_GPIO_GetValue(Port,Pin)==0 && t<TimeOutLimit){
      t++;
    }
    
    if(t>=TimeOutLimit){ //TimeOut
      fTimeOut=1;
    }
    
    CodeSize++;
    if(CodeSize>64){
      fTimeOut=1;
    }
  }
  
  //擾f[^Zꍇ͖Ƃ
  if(CodeSize<8 || CodeSize>128){
    Code=0;
  }
  
  return Code;
}


