#include "main.h"

#define TIME_9600 94

int8 sending_buffer;
int8 bit_counter;
int1 busy_serial;

#int_RTCC
void  RTCC_isr(void) 
{
   if( !--bit_counter )
   {
      // stop bit sent
      disable_interrupts( INT_RTCC );
      busy_serial = 0;
   }
   else
   {
	   // data sending
      output_bit( TxD , bit_test(sending_buffer,0) );
      set_timer0( TIME_9600 );
      
      // 1bit right shift . MSB is filled '0'
      //degug:shift_right( &sending_buffer , 1 , 1 );
		shift_right( &sending_buffer , 1 , 0 );
      
   }
}

void put_byte( int8 send_byte )
{
	//debug:sending_buffer = send_byte;
	sending_buffer = ~send_byte;
	bit_counter = 0x0A;
	busy_serial = 1;
	// send start bit
	//degug:output_bit( TxD , 0 );
	output_bit( TxD , 1 );
	clear_interrupt(INT_RTCC);
	enable_interrupts( INT_RTCC );
	set_timer0( TIME_9600 );
}

void main()
{
	int8 cSend = 0;
	setup_adc_ports(NO_ANALOGS|VSS_VDD);
	setup_adc(ADC_OFF);
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1);
	setup_timer_1(T1_DISABLED);
	setup_timer_2(T2_DISABLED,0,1);
	setup_comparator(NC_NC);
	setup_vref(FALSE);
	enable_interrupts(GLOBAL);
	setup_oscillator(OSC_8MHZ);
	
	port_a_pullups(FALSE);
	//degug:output_bit( TxD , 1 );
	output_bit( TxD , 0 );
	// startup timer
	delay_ms(1000);
	
	output_bit( PIN_A1 , 1 );
	busy_serial = 0;
		
	// TODO: USER CODE!!
	while(1)
	{
		for(cSend=65; cSend < 91 ; cSend++)
		{
		 	while( busy_serial );
		 	
			 	put_byte( cSend );
				delay_ms(2);
			
		}
	}	 	

}
