﻿/////////////////////////////////////////////////
//　ルビ化ver1.0
//　http://sysys.blog.shinobi.jp/Entry/34/
/////////////////////////////////////////////////

var kugiriMoji="｜";//区切り文字
var maeKakko="《";//前カッコ
var ushiroKakko="》";//後カッコ
var monoRubyKugiri=" 　";//後カッコ
var Log=false;//ログをExtendScript Toolkitに書き出す
var KugiriShouryakuDame=false;

app.scriptPreferences.enableRedraw=false;
if (app.scriptPreferences.version>=7) {
    app.doScript(main,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
} else {
    main();
}
function main(){
    var Sel=app.activeDocument.selection;
    var myDiag=app.dialogs.item("ルビ化.jsx");
    if (Sel.length==0) {
        if (myDiag==null) {
            with (myDiag=app.dialogs.add({name:"ルビ化.jsx"})){
                with (dialogColumns.add()){
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"区切り文字"});
                        textEditboxes.add({editContents:kugiriMoji});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"前カッコ"});
                        textEditboxes.add({editContents:maeKakko});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"後カッコ"});
                        textEditboxes.add({editContents:ushiroKakko});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"モノルビの区切り"});
                        textEditboxes.add({editContents:monoRubyKugiri});
                    }
                    checkboxControls.add({staticLabel:"ExtendScript Toolkitにログ書き出し",checkedState:Log});
                    checkboxControls.add({staticLabel:"区切り文字の省略を許さない",checkedState:KugiriShouryakuDame});
                }
            }
        }
        myDiag.show();
        return;
    } 
    if (!(myDiag==null)) {
        kugiriMoji=myDiag.dialogColumns[0].dialogRows[0].textEditboxes[0].editContents.replace(/([\$\(\)\*\+\.\[\]\?\^\{\}\|\/\\])/g,"\\$1");
        maeKakko=myDiag.dialogColumns[0].dialogRows[1].textEditboxes[0].editContents.replace(/([\$\(\)\*\+\.\[\]\?\^\{\}\|\/\\])/g,"\\$1");
        ushiroKakko=myDiag.dialogColumns[0].dialogRows[2].textEditboxes[0].editContents.replace(/([\$\(\)\*\+\.\[\]\?\^\{\}\|\/\\])/g,"\\$1");
        monoRubyKugiri=myDiag.dialogColumns[0].dialogRows[3].textEditboxes[0].editContents.replace(/([\$\(\)\*\+\.\[\]\?\^\{\}\|\/\\])/g,"\\$1");
        Log=myDiag.dialogColumns[0].checkboxControls[0].checkedState;
        KugiriShouryakuDame=myDiag.dialogColumns[0].checkboxControls[1].checkedState;
    }
    var monoRubyKugiriReg=RegExp("["+monoRubyKugiri+"]","g");
    var SelTexts=getTextObjs(Sel)
    for (var m=0;m<SelTexts.length;m++){
        if (SelTexts[m].contents=="") SelTexts[m]=SelTexts[m].parent;
        if (SelTexts[m].contents=="") continue;
        SetRuby(SelTexts[m]);
    }
    function getTextObjs(Objs) {
        var TextObjs=[];
        for (var n=0;n<Objs.length;n++){
            if (Objs[n].constructor.name=="Table") {
                TextObjs=TextObjs.concat(Objs[n].cells.everyItem().texts[0].getElements());
            } else if (Objs[n].hasOwnProperty("texts")) {
                TextObjs=TextObjs.concat(Objs[n].texts.everyItem().getElements());
            } else if (Objs[n].constructor.name=="Group") {
                TextObjs=TextObjs.concat(getTextObjs(Objs[n].pageItems.everyItem().getElements()));
            }
        }
        return TextObjs;
    }
    function SetRuby(TextObj){
        app.findGrepPreferences = NothingEnum.nothing;
        if (KugiriShouryakuDame){
            app.findGrepPreferences.findWhat ="["+kugiriMoji+"].+?["+maeKakko+"].+?["+ushiroKakko+"]";
        } else {
            app.findGrepPreferences.findWhat ="(["+kugiriMoji+"]?[々〇〻\\x{3400}-\\x{9FFF}\\x{F900}-\\x{FAFF}\\x{020000}-\\x{02FFFF}]+?["+maeKakko+"].+?["+ushiroKakko+"])|(["+kugiriMoji+"].+?["+maeKakko+"].+?["+ushiroKakko+"])";
        }
        var RubyTextList=TextObj.findGrep();
        for (var i=RubyTextList.length-1;i>=0;i--) {
            app.findGrepPreferences.findWhat ="(["+kugiriMoji+maeKakko+ushiroKakko+"]|[^"+kugiriMoji+maeKakko+ushiroKakko+"]+)";
            var MatchTexts=RubyTextList[i].findGrep();
            if (MatchTexts.length==5){
                var counter=1;
                var KugiriText=MatchTexts[0];
            } else if (MatchTexts.length==4){
                var counter=0;
                var KugiriText=null;
            } else {
                if (Log) $.writeln("書式エラー:"+RubyTextList[i].contents);
                continue;
            }
            var OyamojiText=MatchTexts[counter];
            var MaeKakkoText=MatchTexts[counter+1];
            var RubyText=MatchTexts[counter+2];
            var UshiroKakkoText=MatchTexts[counter+3];
            var RubyString=RubyText.contents;
            if (Log) var re=OyamojiText.contents+","+RubyString;
            OyamojiText.rubyFlag=true;
            if (RubyString.match(monoRubyKugiriReg)!=null && RubyString.split(monoRubyKugiriReg).length==OyamojiText.characters.length) {
                OyamojiText.rubyType=RubyTypes.PER_CHARACTER_RUBY;
                if (Log) re+=" , "+"モノ";
                RubyString=RubyString.replace(monoRubyKugiriReg," ");
            } else {
                OyamojiText.rubyType=RubyTypes.GROUP_RUBY;
                if (Log) re+=" , "+"グループ";
            }
            OyamojiText.rubyString=RubyString;
            UshiroKakkoText.remove();
            RubyText.remove();
            MaeKakkoText.remove();
            if (KugiriText!=null) KugiriText.remove();
            if (Log) $.writeln(re+"\r");
        }
    }
}