﻿/////////////////////////////////////////////////
//　1000を一〇〇〇に ver1.1
//　http://sysys.blog.shinobi.jp/Entry/39/
/////////////////////////////////////////////////

// 選択中のテキスト、テキストフレーム、テキストフレームを含むグループ、または表のセル（複数選択可）からテキストオブジェクトを取得
// カーソルを置いてる場合はその親（ストーリー、セル、脚注など）を取得
var SelTexts=getTextObjsP(app.activeDocument.selection);

//ChangeGrepXの第1引数が検索文字列（正規表現）
//第2引数がマッチした文字列を受け取って置換文字列を返す関数
ChangeGrepX(
    "\\d+",
    function(s){
        s=s.replace(/[0０]/g,"〇");
        s=s.replace(/[1１]/g,"一");
        s=s.replace(/[2２]/g,"二");
        s=s.replace(/[3３]/g,"三");
        s=s.replace(/[4４]/g,"四");
        s=s.replace(/[5５]/g,"五");
        s=s.replace(/[6６]/g,"六");
        s=s.replace(/[7７]/g,"七");
        s=s.replace(/[8８]/g,"八");
        s=s.replace(/[9９]/g,"九");
        return s;
    }
);

//続けて複数書いてもいいよ
//ChangeGrepX(
//    …
//)

/////////////////////////////////////////////////////////////////////////////
function ChangeGrepX(regstr,func) {
    if (app.scriptPreferences.version>=7) {
        app.doScript(ChangeGrepXMain,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
    } else {
        ChangeGrepXMain();
    }
    function ChangeGrepXMain(){
        app.findGrepPreferences=NothingEnum.nothing;
        app.findGrepPreferences.findWhat =regstr;
        for (var i=0;i<SelTexts.length;i++){
            if (SelTexts[i].contents=="") continue;
            var foundTexts=SelTexts[i].findGrep();
            for (var j=foundTexts.length-1;j>=0;j--){
                foundTexts[j].contents=func(foundTexts[j].contents);
            }
        }
    }
}
function getTextObjsP(Objs) {
    var TextObjs=[];
    for (var n=0;n<Objs.length;n++){
        if (Objs[n].constructor.name=="InsertionPoint") {
            TextObjs=TextObjs.concat(Objs[n].parent.texts[0].getElements());
        } else if (Objs[n].constructor.name=="Table") {
            TextObjs=TextObjs.concat(Objs[n].cells.everyItem().texts[0].getElements());
        } else if (Objs[n].hasOwnProperty("texts")) {
            TextObjs=TextObjs.concat(Objs[n].texts.everyItem().getElements());
        } else if (Objs[n].constructor.name=="Group") {
            TextObjs=TextObjs.concat(getTextObjs(Objs[n].pageItems.everyItem().getElements()));
        }
    }
    return TextObjs;
}
