﻿///////////////////////////////////////////////////////////
//   イラレの選択画像をこれに再リンク ver 1.1 
//   http://sysys.blog.shinobi.jp/Entry/81/
//
//   このスクリプトは、したたか企画さんの スクリプトでのアクション動的生成を簡単にするライブラリを使用しています
//   http://sttk3.com/blog/tips/illustrator/dynamic-generate-action.html
//
//////////////////////////////////////////////////////////


switch (BridgeTalk.appName) {
    case "bridge" :
        var aiKoredeRelinkMenu = new MenuElement("command", "イラレの選択画像をこれに再リンク","at the end of Thumbnail", "aiKoredeRelinkMenu");
        aiKoredeRelinkMenu.onSelect = $.os.indexOf("indows")>0?function () {
            //win
            if (BridgeTalk.getStatus("illustrator")!=="IDLE") return;
            var path=app.document.selections[0].path;
            var bt=new BridgeTalk;
            bt.target="illustrator";
            bt.body="app.executeMenuCommand('Adobe Bridge Browse');"
                +"if ($.koredeRelink==undefined) $.evalFile(File('"+$.fileName+"'));"
                +"$.koredeRelink('"+path+"');";
            bt.onResult=function(){app.documents[0].chooseMenuItem("ReturnToApplication")};
            bt.send();
        }:function(){
            //mac
            if (BridgeTalk.getStatus("illustrator")!=="IDLE") return;
            var path=app.document.selections[0].path;
            var bt=new BridgeTalk;
            bt.target="illustrator";
            bt.body="if ($.koredeRelink==undefined) $.evalFile(File('"+$.fileName+"'));"
                +"$.koredeRelink('"+path+"');";
            bt.send();
            BridgeTalk.bringToFront("illustrator");
        };
        break;
    case "illustrator" :
        $.koredeRelink=function (path) {
            var ustringPath=ustring2(path);
            var actionCode=("""/version 3
/name [ 12
    6b6f7265646552656c696e6b
]
/isOpen 1
/actionCount 1
/action-1 {
    /name [ 6
        686169636869
    ]
    /keyIndex 0
    /colorIndex 0
    /isOpen 1
    /eventCount 1
    /event-1 {
        /useRulersIn1stQuadrant 0
        /internalName (adobe_placeDocument)
        /localizedName [ 6
            e9858de7bdae
        ]
        /isOpen 1
        /isOn 1
        /hasDialog 1
        /showDialog 0
        /parameterCount 4
        /parameter-1 {
            /key 1851878757
            /showInPalette -1
            /type (ustring)
            /value [ """+ustringPath.length+"""
                """+ustringPath.hex+"""
            ]
        }
        /parameter-2 {
            /key 1818848875
            /showInPalette -1
            /type (boolean)
            /value 1
        }
        /parameter-3 {
            /key 1919970403
            /showInPalette -1
            /type (boolean)
            /value 1
        }
        /parameter-4 {
            /key 1953329260
            /showInPalette -1
            /type (boolean)
            /value 0
        }
    }
}""");
            tempAction(actionCode, function(actionItems) {
                actionItems[0].exec() ;
            }) ;
    

/**
  * アクションのソースコード内のNameやustringを作る機能
  * @param {String} str 変換したい文字列
  * @return {Object} {
  *   source : strそのまま, 
  *   hex : utf8の16進数文字コード, 
  *   length : 文字数
  * }
  *2 : 念のためtoLowerCaseをつけた
*/
function ustring2(str) {
  var tempStr = str.replace(/[0-9A-Za-z!'()*._~-]/g, function(c) {
    return c.charCodeAt(0).toString(16) ;
  }) ;
  tempStr = encodeURIComponent(tempStr).replace(/%/g, '').toLowerCase() ;
  var len = tempStr.length / 2 ;
  var res = {source : str, hex : tempStr, length : len} ;
  return res ;
}
 
/**
  * アクションを文字列から生成し実行するブロック構文。終了時・エラー発生時の後片付けは自動
  * @param {String} actionCode アクションのソースコード
  * @param {Function} func ブロック内処理をここに記述する
  * @return なし
*/
function tempAction(actionCode, func) {
  // utf8の16進数文字コードをJavaScript内部で扱える文字列に変換する
  var hexToString = function(hex) {
    var res = decodeURIComponent(hex.replace(/(.{2})/g, '%$1')) ;
    return res ;
  } ;
 
  // ActionItemのconstructor。ActionItem.exec()を使えばわざわざ名前を直接指定しなくても実行できる
  var ActionItem = function ActionItem(index, name, parent) {
    this.index = index ;
    this.name = name ; // actionName
    this.parent = parent ; // setName
  } ;
  ActionItem.prototype.exec = function(showDialog) {
    doScript(this.name, this.parent, showDialog) ;
  } ;
  
  // ActionItemsのconstructor。
  // ActionItems['actionName'],  ActionItems.getByName('actionName'),  
  // ActionItems[0],  ActionItems.index(-1)
  // などの形式で中身のアクションを取得できる
  var ActionItems = function ActionItems() {
    this.length = 0 ;
  } ;
  ActionItems.prototype.getByName = function(nameStr) {
    for(var i = 0, len = this.length ; i < len ; i++) {
      if(this[i].name == nameStr) {return this[i] ;}
    }
  } ;
  ActionItems.prototype.index = function(keyNumber) {
    var res ;
    if(keyNumber >= 0) {
      res = this[keyNumber] ;
    } else {
      res = this[this.length + keyNumber] ;
    }
    return res ;
  } ;
  
  // アクションセット名を取得
  var regExpSetName = /^\/name\s+\[\s+\d+\s+([^\]]+?)\s+\]/m ;
  var setName = hexToString(actionCode.match(regExpSetName)[1].replace(/\s+/g, '')) ;
  
  // セット内のアクションを取得
  var regExpActionNames = /^\/action-\d+\s+\{\s+\/name\s+\[\s+\d+\s+([^\]]+?)\s+\]/mg ;
  var actionItemsObj = new ActionItems() ;
  var i = 0 ;
  var matchObj ;
  while(matchObj = regExpActionNames.exec(actionCode)) {
    var actionName = hexToString(matchObj[1].replace(/\s+/g, '')) ;
    var actionObj = new ActionItem(i, actionName, setName) ;
    actionItemsObj[actionName] = actionObj ;
    actionItemsObj[i] = actionObj ;
    i++ ;
    if(i > 1000) {break ;} // limiter
  }
  actionItemsObj.length = i ;
  
  // aiaファイルとして書き出し
  var failed = false ;
  var aiaFileObj = new File(Folder.temp + '/tempActionSet.aia') ;
  try {
    aiaFileObj.open('w') ;
    aiaFileObj.write(actionCode) ;
  } catch(e) {
    failed = true ;
    alert(e) ;
    return ;
  } finally {
    aiaFileObj.close() ;
    if(failed) {try {aiaFileObj.remove() ;} catch(e) {}}
  }
  
  // 同名アクションセットがあったらunloadする。これは余計なお世話かもしれない
  try {app.unloadAction(setName, '') ;} catch(e) {}
  
  // アクションを読み込み実行する
  var actionLoaded = false ;
  try {
    app.loadAction(aiaFileObj) ;
    actionLoaded = true ;
    func.call(func, actionItemsObj) ;
  } catch(e) {
    alert(e) ;
  } finally {
    // 読み込んだアクションと，そのaiaファイルを削除
    if(actionLoaded) {app.unloadAction(setName, '') ;}
    aiaFileObj.remove() ;
  }
}

        }
        break;
}