#include "stdafx.h"
#include "csadll.h"

CSADLL gCsaDll("sikou.dll");

CSADLL::CSADLL(const char *filename)
	: pf_sikou_ini(NULL), pf_sikou(NULL), pf_sikou_end(NULL),
	  pf_getName(NULL), pf_setProtocol(NULL), version(0), proto_ver(0)
{
	hInstDLL = LoadLibrary(filename);
	if (hInstDLL != NULL) {
		pf_sikou_ini = (void (*)(int* c))GetProcAddress(hInstDLL, "sikou_ini");
		pf_sikou_end = (void (*)())GetProcAddress(hInstDLL, "sikou_end");
		pf_sikou = (int (*)(int, unsigned char [][2], int*, int*, int*, int*))GetProcAddress(hInstDLL, "sikou");
		pf_getName = (int (*)(char *, int))GetProcAddress(hInstDLL, "getName");
		pf_setProtocol = (void (*)(int))GetProcAddress(hInstDLL, "setProtocol");
	} else {
		LPVOID lpMsgBuf;

		FormatMessage( 
		    FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		    FORMAT_MESSAGE_FROM_SYSTEM | 
		    FORMAT_MESSAGE_IGNORE_INSERTS,
		    NULL,
		    GetLastError(),
		    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg
		    (LPTSTR) &lpMsgBuf,
		    0,
		    NULL 
		);

		//ŕKvɉ lpMsgBuf Ɋւ鏈s
		// ...
		MessageBox( NULL, (const char*)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
		LocalFree( lpMsgBuf );
	}
	strncpy(dllname, filename, sizeof(dllname));
	if (pf_getName) {
		version = (*pf_getName)(dllname, sizeof(dllname));
	}
	if (pf_setProtocol) {
		(*pf_setProtocol)(SIKOU_IF_VERSION);
	}

}

CSADLL::~CSADLL()
{
	if (hInstDLL) {
		FreeLibrary(hInstDLL);
		hInstDLL = NULL;
	}
}

void CSADLL::sikou_ini(int* c)
{
	if (pf_sikou_ini && pf_sikou && pf_sikou_end) {
		(*pf_sikou_ini)(c);
	} else {
		::MessageBox(NULL, "DLL[hł܂\nI܂", "Error!", MB_OK);
		if (pf_sikou_ini == NULL) {
			::MessageBox(NULL, "pf_sikou_ini == NULL", "Error!", MB_OK);
		}
		exit(1);
	}
}

int  CSADLL::sikou(int tesu, unsigned char kifu[][2], int* timer_sec, int* i_moto, int* i_saki, int* i_naru)
{
	int ret;
	if (pf_sikou_ini && pf_sikou && pf_sikou_end) {
		ret = (*pf_sikou)(tesu, kifu, timer_sec, i_moto, i_saki, i_naru);
	} else {
		::MessageBox(NULL, "DLL[hł܂\nI܂", "Error!", MB_OK);
		ret = 0;
		exit(1);
	}
	return ret;
}

void CSADLL::sikou_end()
{
	if (pf_sikou_ini && pf_sikou && pf_sikou_end) {
		(*pf_sikou_end)();
	}
}

int CSADLL::getName(char *name, int size) const
{
	if (size > sizeof(dllname)) {
		size = sizeof(dllname);
	}
	strncpy(name, dllname, size);
	return version;
}

int CSADLL::getVersion() const
{
	return version;
}

void CSADLL::setProtocol(int ver)
{
	if (pf_setProtocol) {
		(*pf_setProtocol)(ver);
		proto_ver = ver;
	}
}

int CSADLL::getProtocol() const
{
	return proto_ver;
}
