typedef unsigned __int64 uint64;
typedef __int64 int64;

int popcnt_a(unsigned int u)
{
	int cnt=0;
	for (; u; u &= u-1) cnt++;
	return cnt;
}

int popcnt_b(unsigned int u)
{
	u = (u & 0x55555555) + ((u >>  1) & 0x55555555);
	u = (u & 0x33333333) + ((u >>  2) & 0x33333333);
	u = (u & 0x0F0F0F0F) + ((u >>  4) & 0x0F0F0F0F);
	u = (u & 0x00FF00FF) + ((u >>  8) & 0x00FF00FF);
	u = (u & 0x0000FFFF) + ((u >> 16) & 0x0000FFFF);
	return u;
}

int popcnt64_a(uint64 u)
{
	int cnt=0;
	for (; u; u &= u-1) cnt++;
	return cnt;
}

int popcnt64_b(uint64 u)
{
	u = (u & 0x5555555555555555UI64) + ((u >>  1) & 0x5555555555555555UI64);
	u = (u & 0x3333333333333333UI64) + ((u >>  2) & 0x3333333333333333UI64);
	u = (u & 0x0F0F0F0F0F0F0F0FUI64) + ((u >>  4) & 0x0F0F0F0F0F0F0F0FUI64);
	u = (u & 0x00FF00FF00FF00FFUI64) + ((u >>  8) & 0x00FF00FF00FF00FFUI64);
	u = (u & 0x0000FFFF0000FFFFUI64) + ((u >> 16) & 0x0000FFFF0000FFFFUI64);
	u = (u & 0x00000000FFFFFFFFUI64) + ((u >> 32) & 0x00000000FFFFFFFFUI64);
	return (int)u;
}
