/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class Stamp {
    private BufferedImage image;
    private JFrame win;
    private int time;
    private boolean show;
    private String url;
    private int x = 0;
    private int y = 0;

    Stamp(String string, JFrame jFrame) {
        this.url = string;
        try {
            this.image = ImageIO.read(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            this.image = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            this.image = null;
        }
        this.win = jFrame;
        this.init();
    }

    Stamp(File file, JFrame jFrame, String string) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            this.image = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            this.image = null;
        }
        this.url = string;
        this.win = jFrame;
        this.init();
    }

    Stamp(BufferedImage bufferedImage, JFrame jFrame, String string) {
        this.image = bufferedImage;
        this.win = jFrame;
        this.url = string;
        this.init();
    }

    Stamp(Stamp stamp) {
        this.image = stamp.getImage();
        this.win = stamp.getWin();
        this.url = stamp.getUrl();
        this.init();
    }

    public void newPlace() {
        this.x = (int)(Math.random() * 640.0);
        this.y = (int)(Math.random() * 480.0);
    }

    private void init() {
        this.newPlace();
        this.time = 100;
        this.show = true;
    }

    public void draw(Graphics graphics) {
        if (this.show) {
            graphics.drawImage(this.image, this.x - this.getHeight() / 2, this.y - this.getHeight() / 2, this.getWidth(), this.getHeight(), this.win);
        }
        this.process();
    }

    public boolean isShow() {
        return this.show;
    }

    private void process() {
        --this.time;
        if (this.time < 0) {
            this.show = false;
        }
    }

    protected BufferedImage getImage() {
        return this.image;
    }

    protected JFrame getWin() {
        return this.win;
    }

    public String getUrl() {
        return this.url;
    }

    private int getWidth() {
        int n = 0;
        try {
            n = (int)this.win.getContentPane().getSize().getWidth() / 5;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }

    private int getHeight() {
        int n = 0;
        try {
            n = (int)((double)this.getWidth() * ((double)this.image.getHeight() / (double)this.image.getWidth()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }
}

