/*
  LScript Layout
  CoinRig_ds for LW2020
  V1.15
  Daisuke Suzuki
  History: 2021/05/30
*/

//-----------------------------------------

@version 2.6
@warnings
@script generic
@name CoinRig_ds


generic
{
    scn = Scene();
    seled_Item = scn.getSelect();
	sel_count = seled_Item.count();
	
	if(sel_count == 0)
    {
	  error("Please select the object.");
	  return;
    }
	
	sel_size = seled_Item.size();
	sel_Item_name = seled_Item[sel_size].name;
	A_pos = scn.schemaPosition(sel_Item_name);
	A_pos_x = A_pos[1];
    A_pos_y = A_pos[2];
	
	
    Un_c ="Under_coin";
    UP_c ="UP_coin";
	Rt_c ="Right_coin";
	Lt_c ="Left_coin";
  
    var1 = false;
	var2 = "_";
	
	reqbegin("CoinRig_ds");
	reqsize(210,90);
	
	c1 = ctlchoice("",var1,@"1.Generate Null","2.Coin Setup"@);
    ctlposition(c1,10,12);
	
	c2 = ctlstring("Suffix Name :",var2);//Name
    ctlposition(c2,15,34);
	
	ctlactive(c1,"LC1",c2);
	
	
	return if !reqpost();
	
	var1 = getvalue(c1);
	var2 = getvalue(c2);
	
	reqend();
	
	
	if(var1 == 1)
	{
      sc1 = true;
    }
    if(var1 == 2)
	{
      sc2 = true;
    }

//-----------------------------------------
if(sc1)
    {
      AddNull(Un_c);
	  ItemColor(12);
	  Position(0,-0.01,0);
	  SchematicPosition( 2.5 + A_pos_x ,-0.4 + A_pos_y);
	  AddNull(UP_c);
	  ItemColor(10);
	  SchematicPosition( 2.5 + A_pos_x ,0.4 + A_pos_y);
	  PositionItem(Un_c);
	  YController(7);
	  YTransform(-1,0);
	  ItemLock(1);
	  
	  AddNull(Rt_c);
	  ItemColor(5);
	  Position(-0.05,0,0);
	  SchematicPosition( 1.5 + A_pos_x ,A_pos_y);
	  AddNull(Lt_c);
	  ItemColor(3);
	  SchematicPosition( 3.5 + A_pos_x ,A_pos_y);
	  PositionItem(Rt_c);
	  XController(7);
	  XTransform(-1,0);
	  YController(7);
	  YTransform(1,0);
	  ItemLock(1);
	  
	  SelectByName(Un_c);
    }
	
	
if(sc2)
    {
	    if(Un_c == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(UP_c == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(Rt_c == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		if(Lt_c == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the coin object.");
	     return;
        }
		
	    SelectByName(UP_c);
		CreateKey(0);
		scn = Scene();
        sel_Itemh = scn.getSelect();
	    Height_pos = sel_Itemh[1].getPosition(0).y;
		
	    SelectByName(Lt_c);
		CreateKey(0);
		scn = Scene();
        sel_Itemw = scn.getSelect();
	    Wide_pos = sel_Itemw[1].getPosition(0).x;
        Spe_pos = round(Wide_pos * 1.2,3);
		Spe_pos_b = round(Wide_pos / 3,3);
		
		Master_c = "Master"+var2;
		AddNull(Master_c);
		ItemColor(1);
		customshape(7, Spe_pos, 1,  false, false, nil);//shape, filled, scale, axis, xray, drawto
		//addNullShape: shape, scale, axis, filled = false, xray=false, drawto=nil
		//customshape: item, shape, fill, scale, axis, linkto
		//customshape(item_name, 6, 0, Spe_pos, 1, nil);
		SchematicPosition(A_pos_x ,-2.2 + A_pos_y);
		
		ctrl_c_none = "ctrl_none"+var2;
		AddNull(ctrl_c_none);
		ItemVisibility(1);
	    ItemColor(8);
		SchematicPosition(A_pos_x ,0.8 + A_pos_y);
		
		ParentItem(Master_c);
		Position(0,Wide_pos*2,0);
		
		ctrl_c = "CTRL"+var2;
		AddNull(ctrl_c);
	    ItemColor(14);
		customshape(3, Spe_pos_b, 1, false, false, nil);
		//customshape(item_name, 2, 0, Spe_pos_b, 1, nil);
		SchematicPosition(-1.4 + A_pos_x ,0.3 + A_pos_y);
		ParentItem(ctrl_c_none);
		Position(0,0,0);
		
		h_coin = "Height"+var2;
		AddNull(h_coin);
		ItemVisibility(1);
		SchematicPosition(-0.5 + A_pos_x ,-1.6 + A_pos_y);
		ParentItem(Master_c);
		Position(0,Wide_pos,0);
		
		expr_c = "Expr"+var2;
		AddNull(expr_c);
		ItemVisibility(1);
		SchematicPosition(-0.5 + A_pos_x ,-1.3 + A_pos_y);
		ParentItem(h_coin);
		Position(0,0,0);
		
		rot1_c = "rot1"+var2;
		AddNull(rot1_c);
		ItemVisibility(1);
		SchematicPosition(-0.5 + A_pos_x ,-1.0 + A_pos_y);
		ParentItem(expr_c);
		Position(0,-Wide_pos,0);
		
		
		Tilt_a = "Tilt_a"+var2;
		AddNull(Tilt_a);
		ItemColor(14);
		ItemLock(1);
		SchematicPosition(0.5 + A_pos_x ,-1.6 + A_pos_y);
		ParentItem(rot1_c);
		Position(Wide_pos,0,0);
		
		Tilt_b = "Tilt_b"+var2;
		AddNull(Tilt_b);
		ItemColor(10);
		ItemLock(1);
		SchematicPosition(0.5 + A_pos_x ,-1.3 + A_pos_y);
		ParentItem(Tilt_a);
		Position(-Wide_pos*2,0,0);
		
		Tilt_c = "Tilt_c"+var2;
		AddNull(Tilt_c);
		ItemColor(11);
		ItemLock(1);
		SchematicPosition(0.5 + A_pos_x ,-1.0 + A_pos_y);
		ParentItem(Tilt_b);
		Position(Wide_pos,0,Wide_pos);

		Tilt_d = "Tilt_d"+var2;
		AddNull(Tilt_d);
		ItemColor(9);
		ItemLock(1);
		SchematicPosition(0.5 + A_pos_x ,-0.7 + A_pos_y);
		ParentItem(Tilt_c);
		Position(0,0,-Wide_pos*2);
		
		
		rot2_c = "rot2"+var2;
		AddNull(rot2_c);
		ItemVisibility(1);
		SchematicPosition(-0.5 + A_pos_x ,-0.7 + A_pos_y);
		ParentItem(Tilt_d);
		Position(0,Height_pos,Wide_pos);
		
		
		SelectByName(sel_Item_name);
		ParentItem(rot2_c);
		Position(0,0,0);
		
		
		//Add Expression
	       obj = Mesh();
		   
		    //Expression Create
           qq="\"";
           ExpName_B = sel_Item_name + var2 + "_B";
	       ExpEquation_B = "-deg([" + ctrl_c + ".Position.X])/" + Wide_pos;
           CommandExec_B = ("GE_CreateExpression "+ qq + ExpName_B + qq + " " + qq + ExpEquation_B +qq);
           CommandInput(CommandExec_B);
		   qq="\"";
		   ExpName_P = sel_Item_name + var2 + "_P";
	       ExpEquation_P = "deg([" + ctrl_c + ".Position.Z])/" + Wide_pos;
           CommandExec_P = ("GE_CreateExpression "+ qq + ExpName_P + qq + " " + qq + ExpEquation_P +qq);
           CommandInput(CommandExec_P);
	

	  
           //Expression tekiyou
		   qq="\"";
	       Channnel_Expr_B = expr_c + ".Rotation.B";
	       CommandExec_B = ("GE_AttachExpression "+ qq + Channnel_Expr_B + qq + "" + qq + ExpName_B + qq);
           CommandInput(CommandExec_B);
		   qq="\"";
		   Channnel_Expr_P = expr_c + ".Rotation.P";
	       CommandExec_P = ("GE_AttachExpression "+ qq + Channnel_Expr_P + qq + "" + qq + ExpName_P + qq);
           CommandInput(CommandExec_P);
		   
		//Follower
		SelectByName(expr_c);
		PositionItem(ctrl_c);
        XController(7);
        YController(7);
        ZController(7);
		
		SelectByName(rot1_c);
		RotationItem(ctrl_c);
        HController(7);
		
		
		SelectByName(Tilt_a);
		RotationItem(ctrl_c);
        BController(7);
		LimitB();
	    BLimits(-180,0);
		
		SelectByName(Tilt_b);
		RotationItem(ctrl_c);
        BController(7);
		LimitB();
	    BLimits(0,180);
		
		SelectByName(Tilt_c);
		RotationItem(ctrl_c);
        PController(7);
		LimitP();
	    PLimits(0,180);
		
		SelectByName(Tilt_d);
		RotationItem(ctrl_c);
        PController(7);
		LimitP();
	    PLimits(-180,0);
		
		SelectByName(rot2_c);
		RotationItem(ctrl_c);
        HController(7);
		HTransform(-1.0,0);
		
		SelectByName(Un_c);
		AddToSelection(UP_c);
		AddToSelection(Rt_c);
		AddToSelection(Lt_c);
		ClearSelected(1);
		
		SelectByName(ctrl_c);
		RotateTool();
    }
}

LC1: value
{
  return(value==2);
}
customshape: shape, scale, axis, filled = false, xray=false, drawto=nil
{
	var s0 = @"False","True"@;
    var ls = @"Standard","Box", "Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
    f1 = s0[1+filled];
    f2 = s0[1+xray];
	
	pp = "=\""; qq="\" ";
	AdShape = "Generic_AddItemShape ";
	Rep = "Replace"; Sha = "Shape"; Axi = "Axis"; Scl = "Scale";
	Fld = "Filled"; XRy = "XRay"; LTo = "LineTo";
	
    ss = AdShape + Rep + pp + true + qq + Sha + pp + ls[shape] + qq + Axi;
	ss +=  pp + axis + qq + Scl + pp + scale + qq + Fld + pp + f1 + qq + XRy + qq;
	if (!drawto.isNil())
	ss += LTo + pp + hex(drawto.id) + "\"";

    CommandInput(ss);
}
