/*
  LScript Layout
  BallRig_ds　for LW2020
  V1.15
  Daisuke Suzuki
  History: 2014/06/21
*/

//-----------------------------------------

@version 2.6
@warnings
@script generic
@name BallRig_ds


generic
{
    scn = Scene();
    seled_Item = scn.getSelect();
	sel_count = seled_Item.count();
	
	if(sel_count == 0)
    {
	  error("Please select the object.");
	  return;
    }
	
	sel_size = seled_Item.size();
	sel_Item_name = seled_Item[sel_size].name;
	A_pos = scn.schemaPosition(sel_Item_name);
	A_pos_x = A_pos[1];
    A_pos_y = A_pos[2];
	
    Un_b ="Under_ball";
    UP_b ="UP_ball";
  
    var1 = false;
	var2 = "_";
	
	reqbegin("BallRig_ds");
	reqsize(210,90);
	
	c1 = ctlchoice("",var1,@"1.Generate Null","2.Ball Setup"@);
    ctlposition(c1,10,12);
	
    c2 = ctlstring("Suffix Name :",var2);//Name
    ctlposition(c2,15,34);
	
	ctlactive(c1,"LC1",c2);

	
	return if !reqpost();
	
	var1 = getvalue(c1);
	var2 = getvalue(c2);
	
	reqend();
	
	
	if(var1 == 1)
	{
      sc1 = true;
    }
    if(var1 == 2)
	{
      sc2 = true;
    }

//-----------------------------------------
if(sc1)
    {
      AddNull(Un_b);
	  ItemColor(12);
	  Position(0,-0.01,0);
	  SchematicPosition( 1.0 + A_pos_x ,-0.4 + A_pos_y);
	  AddNull(UP_b);
	  ItemColor(10);
	  SchematicPosition( 1.0 + A_pos_x ,0.4 + A_pos_y);
	  PositionItem(Un_b);
	  YController(7);
	  YTransform(-1,0);
	  Position(0,0.1,0);
	  SelectByName(Un_b);
    }
	
if(sc2)
    {
	    if(Un_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the ball object.");
	     return;
        }
		if(UP_b == sel_Item_name)
        {
         SelectByName(sel_Item_name);
	     error("Please select the ball object.");
	     return;
        }
		
	    SelectByName(UP_b);
		CreateKey(0);
		scn = Scene();
        sel_Item = scn.getSelect();
	    Unb_pos = sel_Item[1].getPosition(0).y;
		Spe_pos = round(Unb_pos * 1.4,3);
		Spe_pos_b = round(Unb_pos / 3,3);
		
		Master_b = "Master"+var2;
		AddNull(Master_b);
		ItemColor(1);
		//customshape: shape, scale, axis, filled = false, xray=false, drawto=nil
		customshape(7, Spe_pos, 1, false, false, nil);
		SchematicPosition(0 + A_pos_x ,-1 + A_pos_y);
		
		ctrl_b = "CTRL"+var2;
		AddNull(ctrl_b);
		RotateTool();
		EnableYP();
		EnableZB();
	    ItemColor(14);
		customshape(3, Spe_pos_b, 1, false, false, nil);
		//customshape(item_name, 2, 0, Spe_pos_b, 1, nil);
		SchematicPosition(1.0 + A_pos_x ,-0.5 + A_pos_y);
		
		SelectByName(ctrl_b);
		ParentItem(Master_b);
		Position(0,Unb_pos,0);
		
		Expr_b = "Expr"+var2;
		AddNull(Expr_b);
		ItemVisibility(1);
		MoveTool();
		EnableXH();
		EnableYP();
		EnableZB();
		RotateTool();
		EnableXH();
		EnableYP();
		EnableZB();
		SchematicPosition(0 + A_pos_x ,-0.5 + A_pos_y);
		ParentItem(ctrl_b);
		Position(0,0,0);
		
		SelectByName(sel_Item_name);
		ParentItem(Expr_b);
		Position(0,0,0);
		
		rot_base_b = "rot_base"+var2;
		AddNull(rot_base_b);
		ItemColor(14);
		MoveTool();
		EnableXH();
		EnableYP();
		EnableZB();
		SchematicPosition(0 + A_pos_x ,0.5 + A_pos_y);
		ParentItem(sel_Item_name);
		Position(0,0,0);
		
		rot_b = "rot"+var2;
		AddNull(rot_b);
		ItemColor(10);
		ParentItem(rot_base_b);
		Position(0,Unb_pos,0);
		MoveTool();
		EnableXH();
		EnableYP();
		EnableZB();
		SchematicPosition(-1.0 + A_pos_x ,0.5 + A_pos_y);
		
		
		//Add Expression
	       obj = Mesh();
		   
		    //Expression Create
           qq="\"";
           ExpName_B = sel_Item_name + var2 + "_B";
	       ExpEquation_B = "-deg([" + ctrl_b + ".Position.X])/" + Unb_pos;
           CommandExec_B = ("GE_CreateExpression "+ qq + ExpName_B + qq + " " + qq + ExpEquation_B +qq);
           CommandInput(CommandExec_B);
		   qq="\"";
		   ExpName_P = sel_Item_name + var2 + "_P";
	       ExpEquation_P = "deg([" + ctrl_b + ".Position.Z])/" + Unb_pos;
           CommandExec_P = ("GE_CreateExpression "+ qq + ExpName_P + qq + " " + qq + ExpEquation_P +qq);
           CommandInput(CommandExec_P);
	

	  
           //Expression tekiyou
		   qq="\"";
	       Channnel_Expr_B = Expr_b + ".Rotation.B";
	       CommandExec_B = ("GE_AttachExpression "+ qq + Channnel_Expr_B + qq + "" + qq + ExpName_B + qq);
           CommandInput(CommandExec_B);
		   qq="\"";
		   Channnel_Expr_P = Expr_b + ".Rotation.P";
	       CommandExec_P = ("GE_AttachExpression "+ qq + Channnel_Expr_P + qq + "" + qq + ExpName_P + qq);
           CommandInput(CommandExec_P);
		   
		   
		SelectByName(Un_b);
		AddToSelection(UP_b);
		ClearSelected(1);
    }
}

LC1: value
{
  return(value==2);
}
customshape: shape, scale, axis, filled = false, xray=false, drawto=nil
{
	var s0 = @"False","True"@;
    var ls = @"Standard","Box", "Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
    f1 = s0[1+filled];
    f2 = s0[1+xray];
	
	pp = "=\""; qq="\" ";
	AdShape = "Generic_AddItemShape ";
	Rep = "Replace"; Sha = "Shape"; Axi = "Axis"; Scl = "Scale";
	Fld = "Filled"; XRy = "XRay"; LTo = "LineTo";
	
    ss = AdShape + Rep + pp + true + qq + Sha + pp + ls[shape] + qq + Axi;
	ss +=  pp + axis + qq + Scl + pp + scale + qq + Fld + pp + f1 + qq + XRy + pp + f2 + qq;
	if (!drawto.isNil())
	ss += LTo + pp + hex(drawto.id) + "\"";

    CommandInput(ss);
}