/*
  LScript Layout
  CopyPose_ds
  V1.1
  Daisuke Suzuki
  History: 2015/02/17
*/

@warnings
@script generic
@name CopyPose_ds

scn;

generic
{
   scn = Scene();
   time = scn.currenttime;
   sfs = scn.previewstart;
   sfe = scn.previewend;
   fps = scn.fps;
   EndFrame = time*fps;
   sel_Item = scn.getSelect();
   sel_size = sel_Item.size();
   Skip_Num = 0;

	if(sel_size == nil)
	{
		error("Please select the item.");
		return;
	}
	
   var1 = recall( "Cis", 1);
   var2 = EndFrame;
	
   reqbegin("CopyPose_ds");
   reqsize(200,90);
	
	c1 = ctlchoice("",var1,@"Copy","Mirror","Reverse"@);
    ctlposition(c1,5,7,184);
	
	c2 = ctlminislider("Pose Frame",var2,sfs,sfe);
    ctlposition(c2,12,35,155);
	
	return if !reqpost();
	
   var1 = getvalue(c1);
   var2 = getvalue(c2);
	
	reqend();
	
//-----------------------------------------
   cpt = var2/fps;

    if(var1 == 1)
    {
        for(i = sel_size ; 0 < i ; i --)
	    {
            Create_Key1(sel_Item[i], cpt, var1);
	        Skip_Num ++;
	    }
    }

    if(var1 > 1)
    {
	    if(sel_size < 2)
	    {
		    error("Please select the item.");
		    return;
	    }
	
	    hanbun = sel_size / 2;
	
        for(i = sel_size ; hanbun < i ; i --)
	    {
	        mir_item = hanbun - Skip_Num;
            Create_Key23(sel_Item[mir_item], sel_Item[i], cpt, var1);
	        Skip_Num ++;
	    }
    }
	
    for(i = sel_size ; i >= 1 ; i --)
	{
		if(i == sel_size)
		{
			sel_id = sel_Item[sel_size].id;
			SelectItem(sel_id);
		}
		else
		{
			sel_id = sel_Item[i].id;
			AddToSelection(sel_id);
		}
	}
	store( "Cis", var1 );
}

Create_Key1: Copy_Item, cpt, var1
{
    var t_pos = <0, 0, 0>;
    var t_rot = <0, 0, 0>;
    var t_scl = <0, 0, 0>;

    SelectItem(Copy_Item);
    selected_Item = scn.getSelect();
    t_pos = selected_Item[1].getPosition(cpt);
    t_rot = selected_Item[1].getRotation(cpt);
    t_scl = selected_Item[1].getScaling(cpt);

    Position(t_pos.x, t_pos.y, t_pos.z);
    Rotation(t_rot.h, t_rot.p, t_rot.b);
    Scale(t_scl.x,t_scl.y,t_scl.z);
}

Create_Key23: name_A, name_B, cpt, var1
{
    var t_pos = <0, 0, 0>;
    var t_rot = <0, 0, 0>;
    var t_scl = <0, 0, 0>;
    var pos = <0, 0, 0>;
    var rot = <0, 0, 0>;
    var scl = <0, 0, 0>;

    SelectItem(name_A);
    AddToSelection(name_B);
    selected_Item = scn.getSelect();
    t_pos = selected_Item[1].getPosition(cpt);
    t_rot = selected_Item[1].getRotation(cpt);
    t_scl = selected_Item[1].getScaling(cpt);
    pos = selected_Item[2].getPosition(cpt);
    rot = selected_Item[2].getRotation(cpt);
    scl = selected_Item[2].getScaling(cpt);

    if(var1 == 2)
    {
        Choice_Mirror(name_A, t_pos, t_rot, t_scl);
    }

    if(var1 == 3)
    {
        Choice_Reverse(name_A, name_B, t_pos, t_rot, t_scl, pos, rot, scl);
    }
}

Choice_Mirror: name_A, t_pos, t_rot, t_scl
{
    t_pos.x = t_pos.x*-1;

    SelectItem(name_A);
    Position(t_pos.x, t_pos.y, t_pos.z);
    Rotation(-t_rot.h, t_rot.p, -t_rot.b);
    Scale(t_scl.x, t_scl.y, t_scl.z);
}

Choice_Reverse: name_A, name_B, t_pos, t_rot, t_scl, pos, rot, scl
{
    t_pos.x = t_pos.x*-1;
    pos.x = pos.x*-1;

    SelectItem(name_A);
    Position(t_pos.x, t_pos.y, t_pos.z);
    Rotation(-t_rot.h, t_rot.p, -t_rot.b);
    Scale(t_scl.x, t_scl.y, t_scl.z);

    SelectItem(name_B);
    Position(pos.x, pos.y, pos.z);
    Rotation(-rot.h, rot.p, -rot.b);
    Scale(scl.x, scl.y, scl.z);
}