/*
  LScript Layout
  BlendShape_ds
  LW2020
  V1.6
  Daisuke Suzuki
  History: 2021/06/16
*/
//-----------------------------------------

@name BlendShape_ds
@script generic
@version 2.6
@warnings

c2;
c3;

joy_icon   = @ ".mmmmmmmmmmmmm..", 
               ".m...........m..", 
               ".m...........m..", 
               ".m...........m..", 
               ".m...........m..", 
               ".m.....m.....m..", 
               ".m....m.m....m..", 
               ".m.....m.....m..", 
               ".m...........m..", 
               ".m...........m..", 
               ".m...........m..", 
               ".m...........m..", 
               ".mmmmmmmmmmmmm.." 
               @; 
			   
ht_icon   = @ "......mmm.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......mmm.......", 
               ".....mmmmm......", 
               "......mmm.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......m.m.......", 
               "......mmm......." 
               @; 
			   
wd_icon   = @ "................", 
               "................", 
               "................", 
               "................", 
               ".......m........", 
               ".mmmmmmmmmmmmm..", 
               ".m...mmmmm...m..", 
               ".mmmmmmmmmmmmm..", 
               ".......m........", 
               "................", 
               "................", 
               "................", 
               "................" 
               @; 
			   
@define JOYSTICK 1
@define HEIGHT 2
@define WIDE 3
  
generic
{
  Skip = 1;
  
  icon[JOYSTICK] = Icon(joy_icon);
  icon[HEIGHT] = Icon(ht_icon);
  icon[WIDE] = Icon(wd_icon);
  
    scn = Scene();
    selected_Item = scn.getSelect();
	
    if(selected_Item == nil)
    {
	  error("Please select the null.");
	  return;
    }
	selected_size = selected_Item.size();
	
  col = @"Black","Dark Blue","Dark Green",
         "Dark Cyan","Dark Red","Purple",
		 "Brown","Grey","Blue","Green",
         "Cyan","Red","Magenta","Orange","White"@;
  
    var1 = 1;
    var2 = 100;
    var3 = 1;
	var4 = 0;
	var5 = 0;
	var6 = 0;
	IS_Label = "";
	cpnt = 11;
	cpnt2 = 8;
	
  
    reqbegin("BlendShape_ds");
    reqsize(232,140);

	c1 = ctlchoice("",var1,@icon[JOYSTICK].asStr(),icon[HEIGHT].asStr(),"Up","Dw",icon[WIDE].asStr(),"Rt","Lt"@); 
    ctlposition(c1,10,10);
	
	c2 = ctlminislider("",var2,0,10000);
    ctlposition(c2,112,38,0,20);

    c3 = ctldistance("Scale",var3);
    ctlposition(c3,17,38,96);
	
	c4 = ctlpopup("",cpnt,col);//Color
    ctlposition(c4,135,38,85,20);
	
	c5 = ctlcheckbox("",var4);
    ctlposition(c5,16,61,16);
	
	c6 = ctlnumber("Min",var5);
    ctlposition(c6,40,61,80);
	
	c7 = ctlnumber("Max",var6);
    ctlposition(c7,135,61,80);
	
	c8 = ctlstring("Label",IS_Label);//Name
    ctlposition(c8,17,88,117);
	
	c9 = ctlpopup("",cpnt2,col);//Color
    ctlposition(c9,135,88,85,20);
	

	
	
	ctlrefresh(c2,"refresh1");
	
	ctlvisible(c1,"LC1",c5);//checkbox var4
	ctlactive(c5,"LC2",c6,c7);
	ctlactive(c8,"LC3",c9);

	
	
    return if !reqpost();

    var1 = getvalue(c1);
	var2 = getvalue(c2);
	var3 = getvalue(c3);
	cpnt = getvalue(c4);
	var4 = getvalue(c5);
	var5 = getvalue(c6);
	var6 = getvalue(c7);
	IS_Label = getvalue(c8);
	cpnt2 = getvalue(c9);
	

	reqend();
	
//-----------------------------------------
    CS_Scale = var3*2;
	min_s = abs(var5);
	max_s = abs(var6);
	s_scale = min_s + max_s;
	pos_scale = (max_s - min_s)/2;
	pos2_scale = s_scale/2;
	
	for(i = 1; i <= selected_size ; i++)
    {
	 sel_n = selected_Item[i].name;
	 scn = Scene();
	 A_pos = scn.schemaPosition(sel_n);
     A_pos_x = A_pos[1];
     A_pos_y = A_pos[2];
	 
	 SelectByName(sel_n);
     bs = "_Base";
     Rename(sel_n + bs);
	 sel_Item = scn.getSelect();
	 dl_item = sel_Item[i];
	 ItemColor(8);
     //ItemVisibility(VIS_VISIBLE);
     ItemLock(1);
	 customshape(9, 1.0, 0, false, false, nil,nil, nil);
	 
	 spce = "_Space";
     AddNull(sel_n + spce);
     ItemLock(1);
     ItemColor(1);
	 ParentItem(sel_n + bs);
	 Position(0,0,0);
	 if(1 == var1|| 2 == var1|| 5 == var1)//ジョイスティック、センタースライダー
	 {
	    if(var4 == true)//センタースライダー min max 有効
		{
		    if(var1 ==1)//Joystick
			    customshape(2, var3*2, 0, false, false, nil,nil, nil);
			else//C_Slider x2
				customshape(2, s_scale, 0, false, false, nil,nil, nil);
		}
		else//センタースライダー 無効
		{
		    customshape(2, var3*2, 0, false, false, nil,nil, nil);
		}
	 }
	 else//スライダー
	 {
	 　　 if(var4 == true)//センタースライダー min max 有効
		    customshape(2, max_s, 0, false, false, nil,nil, nil);
		else
		    customshape(2, var3, 0, false, false, nil,nil, nil);
	 }
	 SchematicPosition(A_pos_x , (0.2+A_pos_y));
	 
	    if(var1 == 1)
		{
	     Scale(1,1,0);
	    }
		if(var1 == 2)
		{
		 if(var4 == true)
		 {
		    Position(0,pos_scale,0);
			dir = CS_Scale / s_scale;
			Fix_s = dir * 0.025;
			Scale(Fix_s,1,0);
		 }
		 else
		 Scale(0.025,1,0);
		}
		if(var1 == 3)
		{
		 if(var4 == true)
		 {
			Position(0,max_s / 2,0);
		    dir = CS_Scale / max_s;
			Fix_s = dir * 0.025;
			Scale(Fix_s,1,0);
		    SelectItem(sel_n + bs);
		    AddPosition(0,-max_s/2,0);
		    SelectItem(sel_n + spce);
		 }
		 else
		 {
		    Position(0,var3/2,0);
		    Scale(0.05,1,0);
		    SelectItem(sel_n + bs);
		    AddPosition(0,-var3/2,0);
		    SelectItem(sel_n + spce);
		 }
		}
		if(var1 == 4)
		{
		 if(var4 == true)
		 {
			Position(0,-max_s / 2,0);
		    dir = CS_Scale / max_s;
			Fix_s = dir * 0.025;
			Scale(Fix_s,1,0);
		    SelectItem(sel_n + bs);
		    AddPosition(0,max_s/2,0);
		    SelectItem(sel_n + spce);
		 }
		 else
		 {
		    Position(0,-var3/2,0);
		    Scale(0.05,1,0);
		    SelectItem(sel_n + bs);
		    AddPosition(0,var3/2,0);
		    SelectItem(sel_n + spce);
			}
		}
		if(var1 == 5)
		{
		 if(var4 == true)
		 {
		    Position(pos_scale,0,0);
			dir = CS_Scale / s_scale;
			Fix_s = dir * 0.025;
			Scale(1,Fix_s,0);
		 }
		 else
		 Scale(1,0.025,0);
		}
		if(var1 == 6)
		{
		 if(var4 == true)
		 {
			Position(max_s / 2,0,0);
		    dir = CS_Scale / max_s;
			Fix_s = dir * 0.025;
			Scale(1,Fix_s,0);
		    SelectItem(sel_n + bs);
		    AddPosition(-max_s / 2,0,0);
		    SelectItem(sel_n + spce);
		 }
		 else
		 {
		    Position(var3/2,0,0);
		    Scale(1,0.05,0);
		    SelectItem(sel_n + bs);
		    AddPosition(-var3/2,0,0);
		    SelectItem(sel_n + spce);
		 }
		}
		if(var1 == 7)
		{
		 if(var4 == true)
		 {
			Position(-max_s / 2,0,0);
		    dir = CS_Scale / max_s;
			Fix_s = dir * 0.025;
			Scale(1,Fix_s,0);
		    SelectItem(sel_n + bs);
		    AddPosition(max_s / 2,0,0);
		    SelectItem(sel_n + spce);
		 }
		 else
		 {
		     Position(-var3/2,0,0);
		     Scale(1,0.05,0);
		     SelectItem(sel_n + bs);
		     AddPosition(var3/2,0,0);
		     SelectItem(sel_n + spce);
		 }
		}
	 MoveTool();
	 EnableXH();
     EnableYP();
     EnableZB();

	 pntr = "_Pnt";
	 AddNull(sel_n + pntr);
	 ParentItem(sel_n + bs);
	 Position(0,0,0);
     ItemColor(cpnt);
	 pticon = round(var3 / 16.5, 3);
	 //customshape(item, 6, 0, pticon, 2, nil);
	 customshape(7, pticon, 2, false, false, nil,nil, dl_item);
	 if(IS_Label != "")//Label
	 SchematicPosition(A_pos_x , (1.0+A_pos_y));
	 else
	 SchematicPosition(A_pos_x , (0.8+A_pos_y));
	 
	 MoveTool();
	    if(var1 == 1)
		{
	     EnableZB();
	    }
	 	if(var1 == 2)
		{
		 EnableXH();
         EnableZB();
         LimitY();
		 if(var4 == true)
		 YLimits(-min_s,max_s);
		 else
	     YLimits(-var3,var3);
		}
		if(var1 == 3)
		{
		 EnableXH();
         EnableZB();
         LimitY();
		 if(var4 == true)
	     YLimits(0,max_s);
		 else
		 YLimits(0,var3);
		}
		if(var1 == 4)
		{
		 EnableXH();
         EnableZB();
         LimitY();
		 if(var4 == true)
	     YLimits(-max_s,0);
		 else
	     YLimits(-var3,0);
		}
		if(var1 == 5)
		{
		 EnableYP();
         EnableZB();
         LimitX();
		 if(var4 == true)
		 XLimits(-min_s,max_s);
		 else
	     XLimits(-var3,var3);
		}
		if(var1 == 6)
		{
		 EnableYP();
         EnableZB();
         LimitX();
		 if(var4 == true)
	     XLimits(0,max_s);
		 else
		 XLimits(0,var3);
		}
		if(var1 == 7)
		{
		 EnableYP();
         EnableZB();
         LimitX();
		 if(var4 == true)
	     XLimits(-max_s,0);
		 else
		 XLimits(-var3,0);
		}
		if(IS_Label != "")//Label
		{
		    lbl = "_Label";
	        AddNull(sel_n + lbl);
			ItemColor(cpnt2);
	        ParentItem(sel_n + bs);
			SchematicPosition(A_pos_x , (0.4+A_pos_y));
			ItemLock(1);
	        
		    if(var1 == 1)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,0, nil);
			 pt_y = round(var3 *0.05, 3);
	         Position(-var3, var3+pt_y, 0);
	        }
	 	    if(var1 == 2)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,1, nil);
			 if(var4 == true)
			 {
			    pt_y = round(var3 *0.1, 3);
				Position(0, max_s+pt_y, 0);
			 }
			 else
			 {
			    pt_y = round(var3 *0.1, 3);
	            Position(0, max_s+pt_y, 0);
			 }
		    }
		    if(var1 == 3)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,1, nil);
			 pt_y = round(var3 *0.2, 3);
	         Position(0, -pt_y, 0);
		    }
		    if(var1 == 4)
		    {
             customshape(9, 1.0, 0, false, false, IS_Label,1, nil);
			 pt = var3 * 0.5;
			 pt_y = round(pt *0.2, 3);
	         Position(0, pt_y, 0);
		    }
		    if(var1 == 5)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,1, nil);
			 pt = var3 * 0.05;
			 pt_y = round(pt *1.1, 3);
	         Position(0, pt+pt_y, 0);
		    }
		    if(var1 == 6)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,0, nil);
			 pt = var3 * 0.05;
			 pt_y = round(pt *1.1, 3);
	         Position(0, pt+pt_y, 0);
		    }
		    if(var1 == 7)
		    {
			 customshape(9, 1.0, 0, false, false, IS_Label,2, nil);
			 pt = var3 * 0.05;
			 pt_y = round(pt *1.1, 3);
	         Position(0, pt+pt_y, 0);
		    }
		    MoveTool();
	        EnableXH();
            EnableYP();
            EnableZB();
		}
		
	 Skip ++;
	}
	SelectItem(sel_n + bs);
}
customshape: shape, scale, axis, filled = false, xray=false, label = nil,jtfy=nil, linkto=nil
{

	var s0 = @"False","True"@;
    var ls = @"Standard","Box", "Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
    f1 = s0[1+filled];
    f2 = s0[1+xray];
	
    ss = "Generic_AddItemShape Replace=\""+ true +"\" ";
    ss += "Shape=\""+ls[shape]+"\" Axis=\""+axis+"\" Scale=\""+scale+"\" ";
    ss += "Filled=\""+f1+"\" XRay=\""+f2+"\" ";
	if(label != nil)
	{
	ss += "Label=\""+label+"\" ";
	ss += "Justification=\""+jtfy+"\" ";
	}
    if(linkto != nil)
	ss += "LineTo=\""+hex(linkto.id)+"\" ";

    CommandInput(ss);
}
LC1: value
{
  return(value!=1);
}
LC2: value
{
  return(value==1);
}
LC3: value
{
  return(value!=nil);
}
refresh1: value
{
  setvalue(c3, value*.01);
}