/*
  LScript Layout
  EditShape_ds
  LW11.6~
  V1.5
  Daisuke Suzuki
  History: 2021/12/28
  
  ItemShape編集ツール用MCスクリプト。
  GNスクリプト「Open_GN_EditShape2_ds」で、コマンドボタン追加/ショートカットキー適用が可能。
*/
//-----------------------------------------

@version 2.7
@warnings
@script master
@name EditShape2_ds

c4;
c20;
c23;
c24;
c26;
c29;
c30;
c31;
c32;
lf_cnt;
Sel_Col;
Unsel_Col;
lf_selcolor_1;
lf_selcolor_2;
lf_selcolor_3;
lf_Unselcolor_1;
lf_Unselcolor_2;
lf_Unselcolor_3;
presetcolor;

//add
c1;c2;c3;c5;c6;c7;c8;c9;c10;
c11;c12;c13;c14;c15;c16;c17;c18;c19;
c21;c22;c25;c27;c28;


create
{
}

flags
{
  return(SCENE);
}

process: event, command
{
  if(reqisopen())
  requpdate();
}

options
{
    if(reqisopen())
    reqend();
    else
    {

			shape_select = 1;
	itemshape[1] = "Box";itemshape[2] = "Pyramid";itemshape[3] = "Diamond";itemshape[4] = "Tetra";itemshape[5] = "Ring";
	var	shape_select = recall( "sp", shape_select ) ;
	
	axis = 1;
	choice1[1] = "X";choice1[2] = "Y";choice1[3] = "Z";
	var	axis = recall( "ax", axis ) ;
	
	va1 = 1;
	sp_scale = 1;
	var	sp_scale = recall( "scl", sp_scale ) ;
	
	fill = 0;
	var	fill = recall( "fil", fill ) ;
	
	xray = 0;
	var	xray = recall( "xry", xray ) ;
	
	label_ck = 0;
	var	label_ck = recall( "lblck", label_ck ) ;
	
	
	Label_text = "";
	var	Label_text = recall( "lbltxt", Label_text ) ;
	
	lbl_cnt =1;
	choice2[1] = "none";choice2[2] = "Prefix";choice2[3] = "Suffix";
	var	lbl_cnt = recall( "lblcnt", lbl_cnt ) ;
	
	lf_cnt =1;
	choice5[1] = "1";choice5[2] = "2";choice5[3] = "3";
	var	lf_cnt = recall( "lf_cnt", lf_cnt ) ;
	
	jtfy =2;
	choice3[1] = "Left";
	choice3[2] = "Center";
	choice3[3] = "Right";
	var	jtfy = recall( "jtfy", jtfy ) ;
	
	dlt_item = nil;
	var	dlt_item = recall( "dltitm", dlt_item ) ;
	
	Sel_Col = 1;
	Unsel_Col = 1;
	choice4[1] = "Black";choice4[2] = "Dark Blue";choice4[3] = "Dark Green";choice4[4] = "DarkCyan";choice4[5] = "Dark Red";
	choice4[6] = "Dark Magenta";choice4[7] = "Brown";choice4[8] = "Gray";choice4[9] = "Blue";choice4[10] = "Green";
	choice4[11] = "Cyan";choice4[12] = "Red";choice4[13] = "Magenta";choice4[14] = "Orange";choice4[15] = "White";
	var	Sel_Col = recall( "selcol", Sel_Col ) ;
	var	Unsel_Col = recall( "unselcol", Unsel_Col ) ;
	
	selcol_ck = 0;
	var	selcol_ck = recall( "sel_ck", selcol_ck ) ;
	selcolor = <0,0,0>;
	var	selcolor = recall( "selc", selcolor ) ;
	Unselcol_ck = 0;
	var	Unselcol_ck = recall( "unsel_ck", Unselcol_ck ) ;
	Unselcolor = <0,0,0>;
	var	Unselcolor = recall( "unselc", Unselcolor ) ;
	textcol_ck = 0;
	var	textcol_ck = recall( "txt_ck", textcol_ck ) ;
	textcolor = <0,0,0>;
	var	textcolor = recall( "textc", textcolor ) ;
	
	littlefilled = 0;
	var	littlefilled = recall( "lf", littlefilled ) ;
	
	lf_selcolor_1 = <255,240,182>;//1
	var	lf_selcolor_1 = recall( "lfselc_1", lf_selcolor_1 ) ;
	lf_Unselcolor_1 = <0,0,0>;
	var	lf_Unselcolor_1 = recall( "lfunselc_1", lf_Unselcolor_1 ) ;
	
	lf_selcolor_2 = <255,240,182>;//2
	var	lf_selcolor_2 = recall( "lfselc_2", lf_selcolor_2 ) ;
	lf_Unselcolor_2 = <0,0,0>;
	var	lf_Unselcolor_2 = recall( "lfunselc_2", lf_Unselcolor_2 ) ;
	
	lf_selcolor_3 = <255,240,182>;//3
	var	lf_selcolor_3 = recall( "lfselc_3", lf_selcolor_3 ) ;
	lf_Unselcolor_3 = <0,0,0>;
	var	lf_Unselcolor_3 = recall( "lfunselc_3", lf_Unselcolor_3 ) ;
	opc1 = 1;
	var	opc1 = recall( "Opc_1", opc1 ) ;
	opc2 = 0.2;
	var	opc2 = recall( "Opc_2", opc2 ) ;
	
        //-----------------------------------------
		
		reqbegin("EditShape2_ds");
		reqsize(216,525);
		//-----------------------------------------

	c1 = ctlpopup("Shape",shape_select,itemshape);ctlposition(c1,10,10,194,18);
	c2 = ctlchoice("Axis",axis,choice1);ctlposition(c2,18,30,186,18);
	c3 = ctlminislider("",va1,1,50000);ctlposition(c3,120,50,0,18);
	c4 = ctldistance("Scale",sp_scale);ctlposition(c4,14,50,108,18);
	c5 = ctlcheckbox("Filled",fill);ctlposition(c5,48,70,75);
	c6 = ctlcheckbox("XRay",xray);ctlposition(c6,129,70,75);
	
	s1 = ctlsep(0,215);ctlposition(s1,0,100);
	
	c7 = ctlcheckbox("Label",label_ck);ctlposition(c7,48,112,155);
	c8 = ctlstring("",Label_text);ctlposition(c8,42,134,160);
	c9 = ctlchoice("Count",lbl_cnt,choice2);ctlposition(c9,12,154,188);
	c10 = ctlchoice("justification",jtfy,choice3);ctlposition(c10,12,174,188);
	c11 = ctlallitems("Draw Line To",dlt_item);ctlposition(c11,12,194,188);
	
	c12 = ctlcheckbox("Sel Color",selcol_ck);ctlposition(c12,5,219,87);
	c13 = ctlcolor("",selcolor);ctlposition(c13,80,219,120);
	c14 = ctlcheckbox("Un Sel Col",Unselcol_ck);ctlposition(c14,5,239,87);
	c15 = ctlcolor("",Unselcolor);ctlposition(c15,80,239,120);
	c16 = ctlcheckbox("Text Col",textcol_ck);ctlposition(c16,5,259,87);
	c17 = ctlcolor("",textcolor);ctlposition(c17,80,259,120);
	c18 = ctlpercent("Opacity",opc1);ctlposition(c18,10,283,168);
	
	s2 = ctlsep(0,215);ctlposition(s2,0,314);

	c19 = ctlcheckbox("+ Little Filled",littlefilled);ctlposition(c19,5,326,110);
	
	//add
	c28 = ctlchoice("",lf_cnt,choice5);ctlposition(c28,116,326,84);
	
	c20 = ctlpopup("Select Color",Sel_Col,choice4);ctlposition(c20,26,348,150);
	c21 = ctlbutton("",20,"Preset_Sel_Col");ctlposition(c21,180,348);
	c22 = ctlbutton("Reset",46,"Reset_Col");ctlposition(c22,34,368);
	c23 = ctlcolor("1",lf_selcolor_1);ctlposition(c23,80,368,120);//1
	//add
	c29 = ctlcolor("2",lf_selcolor_2);ctlposition(c29,80,368,120);//2
	c30 = ctlcolor("3",lf_selcolor_3);ctlposition(c30,80,368,120);//3
	
	c24 = ctlpopup("Un Select Color",Unsel_Col,choice4);ctlposition(c24,8,388,168);
	c25 = ctlbutton("",20,"Preset_Unsel_Col");ctlposition(c25,180,388);
	c26 = ctlcolor("1",lf_Unselcolor_1);ctlposition(c26,80,408,120);//1
	//add
	c31 = ctlcolor("2",lf_Unselcolor_2);ctlposition(c31,80,408,120);//2
	c32 = ctlcolor("3",lf_Unselcolor_3);ctlposition(c32,80,408,120);//3
	
	c27 = ctlpercent("Opacity",opc2);ctlposition(c27,10,433,168);
	
	s3 = ctlsep(0,215);ctlposition(s3,0,463);
	ok = ctlbutton("OK",80,"ok_editshape_ds_start");
	    ctlposition(ok,10,473);
	del = ctlbutton("Delete",80,"del_ds");
	    ctlposition(del,124,473);
	ena = ctlbutton("[Sel]Hide/Show",80,"ena_ds");
	    ctlposition(ena,10,496);
	vis = ctlbutton("[All]Hide/Show",80,"vis_ds");
	    ctlposition(vis,124,496);
		
	del_ok = ctlbutton("Del -> OK",60,"scls_ds");
	    ctlposition(del_ok,144,50,60,18);
	
	ctlrefresh(c3,"refresh1");
	ctlactive(c7,"AC1",c8,c9,c10);
	ctlactive(c12,"AC2",c13);
	ctlactive(c14,"AC3",c15);
	ctlactive(c16,"AC4",c17);
	ctlactive(c19,"AC5",c20,c21,c22,c23,c24,c25,c26,c27,c28,c29,c30,c31,c32);
	//add
	ctlvisible(c28,"VS1",c23,c26);
	ctlvisible(c28,"VS2",c29,c31);
	ctlvisible(c28,"VS3",c30,c32);

		reqopen();
	}
}
scls_ds
{
    del_ds();
	ok_editshape_ds_start();
}
ok_editshape_ds_start
{
  scn = Scene();
  Sel_Item = scn.getSelect();
  Sel_Cnt = Sel_Item.count();
  Sel_Gns = Sel_Item[Sel_Cnt].genus;
  
	
  if(Sel_Gns != 1)
    {
	  error("Please select the object.");
	  return;
    }
	shape_select = getvalue(c1);
	axis = getvalue(c2);
	va1 = getvalue(c3);
	sp_scale = getvalue(c4);
	fill = getvalue(c5);
	xray = getvalue(c6);
	label_ck = getvalue(c7);
	Label_text = getvalue(c8);
	lbl_cnt = getvalue(c9);
	jtfy = getvalue(c10);
	dlt_item = getvalue(c11);
	selcol_ck = getvalue(c12);
	selcolor = getvalue(c13);
	Unselcol_ck = getvalue(c14);
	Unselcolor = getvalue(c15);
	textcol_ck = getvalue(c16);
	textcolor = getvalue(c17);
	opc1 = getvalue(c18);
	
	littlefilled = getvalue(c19);
	
	Sel_Col = getvalue(c20);
	lf_selcolor_1 = getvalue(c23);
	lf_selcolor_2 = getvalue(c29);
	lf_selcolor_3 = getvalue(c30);
	Unsel_Col = getvalue(c24);
    lf_Unselcolor_1 = getvalue(c26);
	lf_Unselcolor_2 = getvalue(c31);
	lf_Unselcolor_3 = getvalue(c32);
	
	opc2 = getvalue(c27);
	lf_cnt = getvalue(c28);
	
		total_ck = selcol_ck + Unselcol_ck + textcol_ck;
	
	if(total_ck ==0)
	flags = 0;
	if(total_ck ==1)
	{
	    if(selcol_ck ==1)
		flags = 1;
		if(Unselcol_ck ==1)
		flags = 2;
		if(textcol_ck ==1)
		flags = 4;
	}
	if(total_ck ==2)
	{
	    if(selcol_ck ==1 && Unselcol_ck ==1)
		flags = 3;
		if(selcol_ck ==1 && textcol_ck ==1)
		flags = 5;
		if(Unselcol_ck ==1 && textcol_ck ==1)
		flags = 6;
	}
	if(total_ck ==3)
	flags = 7;
	
	switch(shape_select)//Shape
    {
        case 1:Output_Shape = 1;break;       //Box
		case 2:Output_Shape = 3;break;       //Pyramid
		case 3:Output_Shape = 4;break;       //Diamond
		case 4:Output_Shape = 5;break;       //Tetra
		case 5:Output_Shape = 6;break;       //Ring
    }
	switch(axis)//Axis
    {
        case 1:Axis = 0;break;       //X
		case 2:Axis = 1;break;       //Y
		case 3:Axis = 2;break;       //Z
    }
	switch(jtfy)//jtfyification
    {
        case 1:jtfy = 0;break;       //Left
		case 2:jtfy = 1;break;       //Center
		case 3:jtfy = 2;break;       //Right
    }

//----------------------------------------- Add_ItemShape

    switch(lf_cnt)//color choice
		{
		    case 1:
            lf_selcolor = lf_selcolor_1;
			lf_Unselcolor = lf_Unselcolor_1;
			break;
		    case 2:
            lf_selcolor = lf_selcolor_2;
			lf_Unselcolor = lf_Unselcolor_2;
			break;
		    case 3:
			lf_selcolor = lf_selcolor_3;
			lf_Unselcolor = lf_Unselcolor_3;
			break;
		}
	labelSkip =1;
    if(Sel_Cnt != 1)
	{
        for(i = Sel_Cnt ; i >= 1 ; i --)
	    {
		    if(label_ck == true)
			{
			    switch(lbl_cnt)//Count
                {
                    case 1:Label_text2 = Label_text;break;                                   //none
		            case 2:Label_text2 = labelSkip.asStr(2,true)+"_"+Label_text;break;       //Prefix
		            case 3:Label_text2 = Label_text+"_"+labelSkip.asStr(2,true);break;       //Suffix
                }
				labelSkip++;
			}
	    customshape(Sel_Item[i], Output_Shape, Axis, sp_scale, fill, xray, label_ck,  Label_text2, jtfy, dlt_item, selcol_ck, selcolor, Unselcol_ck, Unselcolor, textcol_ck, textcolor, opc1);
	    }
    }
	else
	{
	    if(label_ck == true)
		{
			switch(lbl_cnt)//Count
            {
                case 1:Label_text2 = Label_text;break;                                   //none
		        case 2:Label_text2 = labelSkip.asStr(2,true)+"_"+Label_text;break;       //Prefix
		        case 3:Label_text2 = Label_text+"_"+labelSkip.asStr(2,true);break;       //Suffix
                }
		}
		customshape(Sel_Item[1], Output_Shape, Axis, sp_scale, fill, xray, label_ck, Label_text2, jtfy, dlt_item, selcol_ck, selcolor, Unselcol_ck, Unselcolor, textcol_ck, textcolor, opc1);
	}
	//, selcol_ck, selcolor
//----------------------------------------- Add_+ Little Filled

    if(littlefilled ==1)
	{
	    if(Sel_Cnt != 1)
	    {
            for(i = Sel_Cnt ; i >= 1 ; i --)
	        {
			customshape(Sel_Item[i], Output_Shape, Axis, sp_scale, true, xray, 0,  nil, 1, nil, true, lf_selcolor, true, lf_Unselcolor, false, textcolor, opc2);
	        }
        }
	    else
	    {
			customshape(Sel_Item[1], Output_Shape, Axis, sp_scale, true, xray, 0,  nil, 1, nil, true, lf_selcolor, true, lf_Unselcolor, false, textcolor, opc2);
	    }
	}
	
//----------------------------------------- 

	SelectItem(Sel_Item[Sel_Cnt].name); //sel_modosu
		    for(i =1 ; i < Sel_Cnt ; i++)
	        {
		        AddToSelection(Sel_Item[i].name);
		    }
			
    store( "sp", shape_select );
	store( "ax", axis );
	store( "scl", sp_scale );
	store( "fil", fill );
	store( "xry", xray );
	store( "lblck", label_ck );
	store( "lbltxt", Label_text );
	store( "lblcnt", lbl_cnt );
	store( "jtfy", jtfy );
	if(dlt_item != nil)
	store( "dltitm", dlt_item.name );
	else
	store( "dltitm", nil );
	store( "selcol", Sel_Col );
	store( "unselcol", Unsel_Col );
	store( "sel_ck", selcol_ck );
	store( "selc", selcolor );
	store( "unsel_ck", Unselcol_ck );
	store( "unselc", Unselcolor );
	store( "txt_ck", textcol_ck );
	store( "textc", textcolor );
	store( "lf", littlefilled );
	store( "lfselc_1", lf_selcolor_1 );
	store( "lfselc_2", lf_selcolor_2 );
	store( "lfselc_3", lf_selcolor_3 );
	store( "lfunselc_1", lf_Unselcolor_1 );
	store( "lfunselc_2", lf_Unselcolor_2 );
	store( "lfunselc_3", lf_Unselcolor_3 );
	store( "Opc_1", opc1 );
	store( "Opc_2", opc2 );
	store( "lf_cnt", lf_cnt );
}
del_ds
{
/*
  DeleteShape_ds
  V1.0
  History: 2017/10/09
*/

  //CustomObjHandler
  SevType = SERVER_CUSTOMOBJ_H;
  SevName = "LW_ItemShape";

  scn = Scene();
  sel_Item = scn.getSelect();
  item = scn.firstSelect();
  selected_size = sel_Item.size();
  list = sel_Item[selected_size].server(SevType);

	    if(list == nil)
		{
		 //error("CustomObjHandler list is empty.");
	     return;
	    }
		
		for(i = selected_size; i >= 1 ; i--)
	    {
		    SelectItem(sel_Item[i].name);
			list2 = sel_Item[i].server(SevType);
		    listCnt = size(list2);

		    for(x = listCnt; x >= 1 ; x--)
	        {
			    if(list2[x] == SevName)
			    {
				  RemoveServer(SevType,x);
			    }
	        }
		}
		SelectItem(sel_Item[selected_size].name); //sel_modosu
		    for(i =1 ; i < selected_size ; i++)
	        {
		        AddToSelection(sel_Item[i].name);
		    }
//CommandInput("Generic_DeleteShape_ds");
}
ena_ds
{
/*
  EnableShape_ds
  V1.0
  History: 2017/10/09
*/

  //CustomObjHandler
  SevType = SERVER_CUSTOMOBJ_H;
  SevName = "LW_ItemShape";

  scn = Scene();
  sel_Item = scn.getSelect();
  item = scn.firstSelect();
  selected_size = sel_Item.size();
  list = sel_Item[selected_size].server(SevType);

	    if(list == nil)
		{
		 //error("CustomObjHandler list is empty.");
	     return;
	    }
		
		for(i = selected_size; i >= 1 ; i--)
	    {
		    SelectItem(sel_Item[i].name);
			list2 = sel_Item[i].server(SevType);
			
			if(list2 != nil)
			{
		        listCnt = size(list2);
		
		        for(x = 1; x <= listCnt ; x++)
	            {
			        if(list2[x] == SevName)
			        {
			          isDisabled = sel_Item[i].serverFlags( SevType, x );
			          EnableServer(SevType,x,isDisabled);
			        }
	            }
			}
		}
		SelectItem(sel_Item[selected_size].name); //sel_modosu
		    for(i =1 ; i < selected_size ; i++)
	        {
		        AddToSelection(sel_Item[i].name);
		    }
//CommandInput("Generic_EnableShape_ds");
}
vis_ds
{
/*
  VisibleShape_ds
  V1.0
  History: 2014/10/04
*/

  //CustomObjHandler
  SevType = SERVER_CUSTOMOBJ_H;
  SevName = "LW_ItemShape";
  Skip = 1;

  scn = Scene();
  sel_Item = scn.getSelect();
  sel_size = sel_Item.size();
  list = sel_Item[1].server(SevType);


	
	SelectItem(sel_Item[1].id);
	enableshape(SevName, SevType, list, sel_Item);
	PreviousItem();
	scn = Scene();
    selected_Item = scn.getSelect();
	sel = selected_Item[1].id;
	
    done = false;
    while(!done)
    {
	    if(sel != sel_Item[1].id)
	    {
		 list = selected_Item[1].server(SevType);
		 enableshape(SevName, SevType, list, selected_Item);
		 PreviousItem();
	    }
	  
	    if(sel == sel_Item[1].id)//owari
	    {
		  done = true;
	      return;
		}
	  scn = Scene();
      selected_Item = scn.getSelect();
	  sel = selected_Item[1].id;
	  SelectItem(sel);
      Skip ++;
    }
//CommandInput("Generic_VisibleShape_ds");
}
enableshape: SevName, SevType, list, selitem
{
	//list2 = sel_Item[i].server(SevType);
	if(list != nil)
	{
	    listCnt = size(list);
		
	    for(x = 1; x <= listCnt ; x++)
	    {
	        if(list[x] == SevName)
			{
			    isDisabled = selitem[1].serverFlags( SevType, x );
			    EnableServer(SevType,x,isDisabled);
			}
	    }
	}
}

customshape: item, shape, axis, scale, filled, xray, label_ck, label, jtfy, linkto, selc, selCol, unselc, UnselCol, txtc, txtCol, opacity
{
	SelectItem(item.id);
	var s0 = @"False","True"@;
    var ls = @"Standard","Box", "Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
    f1 = s0[1+filled];
    f2 = s0[1+xray];
	f3 = s0[1+selc];
	f4 = s0[1+unselc];
	f5 = s0[1+txtc];
	
	shape = shape + 1;

    ss = "Generic_AddItemShape Replace=\""+ true +"\" ";
    ss += "Shape=\""+ls[shape]+"\" ";
	ss += "Axis=\""+axis+"\" Scale=\""+scale+"\" ";
    ss += "Filled=\""+f1+"\" ";
	ss += "XRay=\""+f2+"\" ";
	if(label_ck == 1)
	{
	    if(label != nil)
		{
	        ss += "Label=\""+label+"\" ";
		    ss += "jtfyification=\""+jtfy+"\" ";
		}
	}
    if(linkto != nil)
	ss += "LineTo=\""+hex(linkto.id)+"\" ";
	if(selc == true)
	{
	    selCol = <selCol.r/255,selCol.g/255,selCol.b/255>;
		ss += "UseSelectedColor=\""+f3+"\" ";
	    ss += "SelectedColor=\""+selCol+"\" ";
	}
	if(unselc == 1)
	{
	    UnselCol = <UnselCol.r/255,UnselCol.g/255,UnselCol.b/255>;
		ss += "UseUnselectedColor=\""+f4+"\" ";
	    ss += "UnselectedColor=\""+UnselCol+"\" ";
	}
	if(txtc == 1)
	{
	    txtCol = <txtCol.r/255,txtCol.g/255,txtCol.b/255>;
		ss += "UseTextColor=\""+f5+"\" ";
	    ss += "TextColor=\""+txtCol+"\" ";
	}
	ss += "Opacity=\""+opacity+"\"";

    CommandInput(ss);
}

Preset_Sel_Col
{
lf_cnt = getvalue(c28);
        switch(lf_cnt)//color choice
		{
		    case 1:
			presetcolor(Sel_Col,c20,lf_selcolor_1,c23);
			break;
		    case 2:
			presetcolor(Sel_Col,c20,lf_selcolor_2,c29);
			break;
		    case 3:
			presetcolor(Sel_Col,c20,lf_selcolor_3,c30);
			break;
		}
	//presetcolor(Sel_Col,c20,lf_selcolor,c23);
}
Preset_Unsel_Col
{
lf_cnt = getvalue(c28);
        switch(lf_cnt)//color choice
		{
		    case 1:
			presetcolor(Unsel_Col,c24,lf_Unselcolor_1,c26);
			break;
		    case 2:
			presetcolor(Unsel_Col,c24,lf_Unselcolor_2,c31);
			break;
		    case 3:
			presetcolor(Unsel_Col,c24,lf_Unselcolor_3,c32);
			break;
		}
	//presetcolor(Unsel_Col,c24,lf_Unselcolor,c26);
}
presetcolor: get_name, get_num, case_col, set_num
{
    get_name = getvalue(get_num);
	
	switch(get_name)
    {
        case 1:case_col = <0/255,0/255,0/255>;break;       //Black 0 0 0
		case 2:case_col = <0/255,48/255,128/255>;break;    //Dark Blue 0 48 128
		case 3:case_col = <0/255,96/255,0/255>;break;      //Dark Green 0 96 0
		case 4:case_col = <32/255,96/255,112/255>;break;   //Dark Cyan 32 96 112
		case 5:case_col = <112/255,0/255,0/255>;break;     //Dark Red 112 0 0
		case 6:case_col = <112/255,32/255,112/255>;break;  //Dark Magenta 112 32 112
		case 7:case_col = <112/255,80/255,0/255>;break;    //Brown 112 80 0
		case 8:case_col = <176/255,176/255,176/255>;break; //Gray 176 176 176
		case 9:case_col = <32/255,160/255,240/255>;break;  //Blue 32 160 240
		case 10:case_col = <32/255,224/255,32/255>;break;  //Green 32 224 32
		case 11:case_col = <96/255,224/255,240/255>;break; //Cyan 96 224 240
		case 12:case_col = <240/255,32/255,32/255>;break;  //Red 240 32 32
		case 13:case_col = <240/255,96/255,240/255>;break; //Magenta 240 96 240
		case 14:case_col = <240/255,192/255,32/255>;break; //Orange 240 192 32
		case 15:case_col = <240/255,240/255,240/255>;break;//White 240 240 240
    }
	setvalue(set_num, case_col);
}

Reset_Col
{
lf_cnt = getvalue(c28);
        switch(lf_cnt)//color choice
		{
		    case 1:
			lf_selcolor_1 = <255/255,240/255,182/255>;//255 240 182
			setvalue(c23, lf_selcolor_1);
			break;
		    case 2:
			lf_selcolor_2 = <255/255,240/255,182/255>;//255 240 182
			setvalue(c29, lf_selcolor_2);
			break;
		    case 3:
			lf_selcolor_3 = <255/255,240/255,182/255>;//255 240 182
			setvalue(c30, lf_selcolor_3);
			break;
		}
}
refresh1: value
{
   setvalue(c4, value*.001);
}
AC1: value
{
  return(value==1);
}
AC2: value
{
  return(value==1);
}
AC3: value
{
  return(value==1);
}
AC4: value
{
  return(value==1);
}
AC5: value
{
  return(value==1);
}
VS1: value
{
  return(value==1);
}
VS2: value
{
  return(value==2);
}
VS3: value
{
  return(value==3);
}