/*
  LScript Layout
  Add Null as Parent
  Rename:Add_ParentNull
  LW9.6~
  V1.1
  Daisuke Suzuki
  History: 2022/05/04
*/

//-----------------------------------------

@name Add_ParentNull
@script generic
@version 2.5
@warnings

generic
{
    scn = Scene();
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	Sel_Gns = Sel_Item[Sel_Size].genus;
	
	
	if(Sel_Gns != 1)
    {
	  error("Please select the Null.");
	  return;
    }
	for(i = Sel_Size ; 1 <= i ; i --)
	{
		sel_n = Sel_Item[i].name;
		p_name = "Null";
		reqbegin("Please name.");
        reqsize(220,90);
		
		c1 = ctltext("","Select: " + sel_n);
        ctlposition(c1,10,7,50,10);
		c2 = ctlstring("Parent Name",p_name);
        ctlposition(c2,10,35,200);
		
		return if !reqpost();
		p_name = getvalue(c2);
	    if(p_name == nil)
		{
		    warn("Please name the null.");
		    return;
		}
		reqend();
		
		if(sel_n == p_name)
		{
		    d_name = p_name + " (2)";
			sel_n = sel_n + " (1)";
		}
		else
		d_name = p_name;
		
		//AddNull("none_" + Sel_Item[i].name);
		AddNull(p_name);
	    A_pos = scn.schemaPosition(sel_n);
	    A_pos_x = A_pos[1];
        A_pos_y = A_pos[2];
		SchematicPosition(A_pos_x,(0.4+A_pos_y));
		if(Sel_Item[i].parent != nil)
		{
		    RefreshNow();
            ParentItem(Sel_Item[i].parent.name);
		}
		pos = Sel_Item[i].getPosition(0);
		Position(pos);
		//ItemVisibility(VIS_VISIBLE);
        //ItemLock(1);
		
		selected = Scene().getSelect();
	    parent = selected[1];
		
		SelectItem(Sel_Item[i].id);
		ParentItem(parent.id);
		RefreshNow();
		Position(0,0,0);
		RefreshNow();
		CreateKey(0);
	}
	for(i = Sel_Size ; 1 <= i ; i --)
	{
		if(i == Sel_Size)
		{
			SelectItem(Sel_Item[Sel_Size].id);
		}
		else
		{
			AddToSelection(Sel_Item[i].id);
		}
	}
}