/*
  LScript Layout
  Add_Sel_SameAsNull
  LW9.6~
  V1.03
  Daisuke Suzuki
  History: 2022/06/14
*/

//-----------------------------------------

@name Add_Sel_SameAsNull
@script generic
@version 2.5
@warnings

generic
{
    scn = Scene();
	fps = scn.fps;
	imaTime = scn.currenttime;
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	Sel_Gns = Sel_Item[Sel_Size].genus;
	
	if(Sel_Size == nil)
    {
	  error("Please select the item.");
	  return;
    }
	
	ParentInPlace(1);

	for(i = Sel_Size ; 1 <= i ; i --)
	{
		sel_n = Sel_Item[i].name;
		c_name = recall( "Cnm_rec", "Null" );
		reqbegin("Please name.");
        reqsize(220,90);
		
		c1 = ctltext("","Select: " + sel_n);
        ctlposition(c1,10,7,50,10);
		c2 = ctlstring("Name",c_name);
        ctlposition(c2,10,35,200);
		
		return if !reqpost();
		c_name = getvalue(c2);
	    if(c_name == nil)
		{
		    warn("Please name the null.");
		    return;
		}
		reqend();
		if(sel_n == c_name)
		{
		    d_name = c_name + " (2)";
			sel_n = sel_n + " (1)";
		}
		else
		d_name = c_name;
		
		AddNull(d_name);
	    A_pos = scn.schemaPosition(sel_n);
	    A_pos_x = A_pos[1];
        A_pos_y = A_pos[2];
		SchematicPosition(A_pos_x,(-0.4+A_pos_y));
		Gt_pos = Sel_Item[i].getWorldPosition(imaTime);
		Gt_Rot = Sel_Item[i].getWorldRotation(imaTime);
		Position(Gt_pos);
		Rotation(Gt_Rot);
		RefreshNow();
		CreateKey(0);
		Sav_Name[i] = d_name;
		store( "Cnm_rec", c_name );
	}
	for(i = Sav_Name.size() ; 1 <= i ; i --)
	{
		if(i == count)
		{
			SelectItem(Sav_Name[Sav_Name.size()]);
		}
		else
		{
			AddToSelection(Sav_Name[i]);
		}
	}
}