/*
  LScript Layout
  Parenter_ds LockInPlace
  LW11.6~
  V1.01
  Daisuke Suzuki
  History: 2022/09/01
*/
//-----------------------------------------
//CharSelectManager専用
//実行には固定するアイテムの選択が条件。(1Sel or 2Selects.)
//固定は1SelectModeと2SelectMode(FootRig)で行う。
@name Parenter_ds_LockInPlace
@script master
@version 2.6
@warnings

foot_icon  = @ ".........mmmmm..", 
               ".........mmmmm..", 
               ".........mmmmm..", 
               ".........mmmm...", 
               ".........mmmm...", 
               ".........mmmm...", 
               ".......mmmmmm...", 
               ".....mmmmmmmmm..", 
               ".mmmmmmmmmmmmm..", 
               ".mmmmmmmmmmmmm..", 
               "..mmmmm....mmm..", 
               "................", 
               "................" 
               @; 
box_icon   = @ "................", 
               "................", 
               "......mmmmmmm...", 
               ".....m.....mm...", 
               "....m.....m.m...", 
               "...mmmmmmm..m...", 
               "...m.....m..m...", 
               "...m.....m..m...", 
               "...m.....m..m...", 
               "...m.....m.m....", 
               "...m.....mm.....", 
               "...mmmmmmm......", 
               "................" 
               @; 
ball_icon  = @ "................", 
               "................", 
               "......mmm.......", 
               "....m..m..m.....", 
               "...m...m...m....", 
               "..m....m....m...", 
               "..mmmmmmmmmmm...", 
               "..m....m....m...", 
               "...m...m...m....", 
               "....m..m..m.....", 
               "......mmm.......", 
               "................", 
               "................" 
               @; 
@define FOOT 1
@define BOX 2
@define BALL 3

c1;
c2;
c3;
c4;
c5;
c6;
c7;
c8;
c9;
c10;
Sel_Item;
Sel_Item2;
Sel_Size;
imaTime;
maeTime;
var1;
var3;
var5;
cpnt;

sps;
var6;
var8;

c_lnr = CHAN_LINEAR;
sel_LK;
BlendItem;

create
{
}

flags
{
  return(SCENE);
}

process: event, command
{
	if(reqisopen())
    requpdate();
}

options
{
    if(reqisopen())
    reqend();
    else
    {
		ParentInPlace(1);
		getSelected();
		icon[FOOT] = Icon(foot_icon); 
	    icon[BOX] = Icon(box_icon); 
	    icon[BALL] = Icon(ball_icon); 
	    Ft_Icon = icon[FOOT].asStr()+" Foot rig";
	    Box_Icon = icon[BOX].asStr()+" LegGoal";
	    Ball_Icon = icon[BALL].asStr()+" ToeGoal";
	
	    col = @"Black","Dark Blue","Dark Green",
         "Dark Cyan","Dark Red","Purple",
		 "Brown","Grey","Blue","Green",
         "Cyan","Red","Magenta","Orange","White"@;
		 
		shapes = @"(none)","Standard","Box","Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
		
	    var1 = recall( "LI_Gen", 1 );
		
	    var2 = 100;
		var3 = recall( "IS_BOX_SCALE", 1 ) ;
	    var4 = 100;
		var5 = recall( "IS_BALL_SCALE", 1 ) ;
		cpnt = recall( "IS_COL", 10 ) ;
		//var6 = recall( "IS_CK_BOX", 0 ) ;
		sps = recall( "IS_SHAPES", 1 ) ;
		var6 = recall( "IS_AXIS", 0 ) ;
		var7 = 100;
		var8 = recall( "IS_SP_SCALE", 1 ) ;

	    reqbegin("Parenter_ds [LockInPlace]");
	    reqsize(334,146);
	
	    c1 = ctlchoice("LockItem Generate",var1,@"Add look solo",Ft_Icon@);
        ctlposition(c1,10,10,310);
	
	    s0 = ctlsep(0,350);
        ctlposition(s0,0,40);
	
	    c2 = ctlminislider("",var2,0,10000);
        ctlposition(c2,140,50,0,20);

        c3 = ctldistance(Box_Icon,var3);
        ctlposition(c3,10,50,130);
	
	    c4 = ctlminislider("",var4,0,10000);
        ctlposition(c4,140,74,0,20);

        c5 = ctldistance(Ball_Icon,var5);
        ctlposition(c5,10,74,130);
	
	    c6 = ctlpopup("Color",cpnt,col);//Color
        ctlposition(c6,170,50,150);
		
		
		c7 = ctlpopup("ItemShape",sps,shapes);//1Sel_Shape
        ctlposition(c7,10,50,152);
		
		c8 = ctlchoice("",var6,@"X","Y","Z"@);
        ctlposition(c8,5,74,70);
		
		c9 = ctlminislider("",var7,0,10000);
        ctlposition(c9,140,74,0,20);

        c10 = ctldistance("",var8);
        ctlposition(c10,74,74,66);
	
	
	    scl_tes1 = ctlbutton("Add or Change",60,"scls_ts1");//test
	    ctlposition(scl_tes1,170,74,95);
	
	    /*
		scl_tes2 = ctlbutton("Del -> Add",60,"scls_ts2");//del -> test
	    ctlposition(scl_tes2,206,74,72);
		*/
	
	    scl_tes3 = ctlbutton("Delete",60,"scls_ts3");//del -> test
	    ctlposition(scl_tes3,270,74,50);
		
		s1 = ctlsep(0,350);
        ctlposition(s1,0,104);
		
		Lock = ctlbutton("               OK",60,"LockItm");
	    ctlposition(Lock,10,116,150);
		
		Close = ctlbutton("             Close",60,"toziru");
	    ctlposition(Close,170,116,150);
	
	    ctlrefresh(c2,"refresh1");
	    ctlrefresh(c4,"refresh2");
		ctlrefresh(c9,"refresh3");
		ctlvisible(c1,"lock_act",c2,c3,c4,c5);
		ctlvisible(c1,"lock_act2",c7,c8,c9,c10);
	
	    var1 = getvalue(c1);
	    var2 = getvalue(c2);
	    var3 = getvalue(c3);
	    var4 = getvalue(c4);
	    var5 = getvalue(c5);
		cpnt = getvalue(c6);
		sps = getvalue(c7);
		var6 = getvalue(c8);
	    var7 = getvalue(c9);
	    var8 = getvalue(c10);

        reqopen();
    }
}
LockItm//OK
{
	var1 = getvalue(c1);
	cpnt = getvalue(c6);
	
	sel_n = Sel_Item[Sel_Size].name + "_LKBase";//LKBaseは有るか？
	SelectByName(sel_n);
	scn = Scene();
    Sel_Item2 = scn.getSelect();
	if(Sel_Item2[1].name != sel_n)
    {
		Sel(Sel_Item, Sel_Size);
		//DeleteKey(imaTime);
	    error("Make sure the Parenter_ds startup is not running or generate a LockItem base for the "+ Sel_Item[Sel_Size].name +".");
	    return;
    }
	
	if(Sel_Size == 1)//Solo
    {
		sel_n = Sel_Item[Sel_Size].name + "_test";//テストシェイプがある場合、削除
	    SelectByName(sel_n);
	    scn = Scene();
		fps = scn.fps;
        Sel_Item2 = scn.getSelect();
	    sel_n2 = Sel_Item2[1].name;
	    if(sel_n == sel_n2)
        {
            ClearSelected(1);
        }
		//LockItem作成
		sel_n = Sel_Item[Sel_Size].name + "_LKBase";
	    SelectByName(sel_n);
		scn = Scene();
	    Sel_Item3 = scn.getSelect();
	    Sel_Size3 = Sel_Item3.size();
		Child = Sel_Item3[Sel_Size3].firstChild();
		cld = Child;
		A_pos = scn.schemaPosition(Sel_Item3[Sel_Size3].name);
		count = 1;

		done = false;
		while(!done)
		{
			if(cld == nil)
			{
				Generate_Lock(sel_n, A_pos, count);
				done = true;
			}
			else
			{
				cld = Sel_Item3[Sel_Size3].nextChild(); 
				if(cld != nil)
				{
					count++;
				}
			}
		}
		BlendItem = Sel_Item[Sel_Size].name + "_LKBlend";
		SelectByName(BlendItem);
		
		scn = Scene();
	    Blend_Item = scn.getSelect();
	    item = Blend_Item[1];
		bl_pos_x = item.getPosition(0).x;
		if(bl_pos_x == 1)//BlendItemが0フレームで1mだった場合、0mにする。
		{
		    GoToFrame(0);
			Position(0,0,0);
			RefreshNow();
			CreateKey(0);
		}
		GoToFrame(imaTime*fps);
		Position(1,0,0);
		RefreshNow();
		CreateKey(imaTime);
		if(imaTime != 0)
		{
		    GoToFrame(maeTime*fps);
		    Position(0,0,0);
		    RefreshNow();
		    CreateKey(maeTime);
		    GoToFrame(imaTime*fps);
		}
	    chan = item.firstChannel();
	    while(chan)
	    {
	        key = chan.keyExists(maeTime);//各チャンネルにキーがあるかどうか？
	        if(key == nil)//キーが無い。
	        {
	        	chan = item.nextChannel();
	        }
	        else//キーがある。キーカーブ変更。
	        {
	        	chan.setKeyCurve(maeTime,c_lnr);
	        	chan = item.nextChannel();
	        }
	    }
		sameAsitem();
    }
	else//FtRig
	{
	    var3 = getvalue(c3);//BOX
		var5 = getvalue(c5);//BALL
		
		sel_n = Sel_Item[Sel_Size].name + "_test";//テストシェイプがある場合、削除
	    SelectByName(sel_n);
	    scn = Scene();
		fps = scn.fps;
        Sel_Item2 = scn.getSelect();
	    sel_n2 = Sel_Item2[1].name;
	    if(sel_n == sel_n2)
        {
	        AddToSelection(Sel_Item[1].name + "_test");
            ClearSelected(1);
        }
		//LockItem作成
		sel_n = Sel_Item[Sel_Size].name + "_LKBase";
	    SelectByName(sel_n);
		scn = Scene();
	    Sel_Item3 = scn.getSelect();
	    Sel_Size3 = Sel_Item3.size();
		Child = Sel_Item3[Sel_Size3].firstChild();
		cld = Child;
		A_pos = scn.schemaPosition(Sel_Item3[Sel_Size3].name);
		count = 1;

		done = false;
		while(!done)
		{
			if(cld == nil)
			{
				Generate_Lock(sel_n, A_pos, count);
				done = true;
			}
			else
			{
				cld = Sel_Item3[Sel_Size3].nextChild(); 
				if(cld != nil)
				{
					count++;
				}
			}
		}
		BlendItem = Sel_Item[Sel_Size].name + "_LKBlend";
		SelectByName(BlendItem);
		
		scn = Scene();
	    Blend_Item = scn.getSelect();
	    item = Blend_Item[1];
		bl_pos_x = item.getPosition(0).x;
		if(bl_pos_x == 1)//BlendItemが0フレームで1mだった場合、0mにする。
		{
		    GoToFrame(0);
			Position(0,0,0);
			RefreshNow();
			CreateKey(0);
		}
		GoToFrame(imaTime*fps);
		Position(1,0,0);
		RefreshNow();
		CreateKey(imaTime);
		if(imaTime != 0)
		{
		    GoToFrame(maeTime*fps);
		    Position(0,0,0);
		    RefreshNow();
		    CreateKey(maeTime);
		    GoToFrame(imaTime*fps);
		}
		
	    chan = item.firstChannel();
	    while(chan)
	    {
	        key = chan.keyExists(maeTime);//各チャンネルにキーがあるかどうか？
	        if(key == nil)//キーが無い。
	        {
	        	chan = item.nextChannel();
	        }
	        else//キーがある。キーカーブ変更。
	        {
	        	chan.setKeyCurve(maeTime,c_lnr);
	        	chan = item.nextChannel();
	        }
	    }
		sameAsitem();
	}
	store( "LI_Gen", var1 );
	reqabort(true);
}
toziru
{
    sel_n = Sel_Item[Sel_Size].name + "_test";
	SelectByName(sel_n);
	scn = Scene();
    Sel_Item2 = scn.getSelect();
	sel_n2 = Sel_Item2[1].name;
	if(sel_n == sel_n2)
    {
		for(i = Sel_Size ; 1 <= i ; i --)//ダミーシェイプがある場合、削除。
	    {
	        sel_nm = Sel_Item[i].name + "_test";
	        SelectByName(sel_nm);
		    ClearSelected(1);
	    }
		Sel(Sel_Item, Sel_Size);
    }
	reqabort(true);
}
Generate_Lock: LKBase, A_pos, count
{
    var3 = getvalue(c3);
	var5 = getvalue(c5);
	cpnt = getvalue(c6);
	cnt = count.asStr(3,true);
	AddY = -1 * count;
	scn = Scene();
    fps = scn.fps;

	for(i = Sel_Size ; 1 <= i ; i --)
	{
		sel_LK[i] = Sel_Item[i].name + "_LK_" + cnt;
		AddNull(sel_LK[i]);
		ItemColor(cpnt);

		if(i == Sel_Size)
		{
		    if(var1 ==2)
			{
				customshape(2, var3, 0, false, false, nil,nil, nil);
			}
			else
			{
				shape = sps - 1;
			    customshape(shape, var8, var6, false, false, nil,nil, nil);
			}
			SchematicPosition(A_pos[1] , A_pos[2] + AddY );
			RefreshNow();
			ParentItem(LKBase);
			sameAsitem2(1, Sel_Item[i].name, 7);
			GoToFrame(imaTime*fps);
			RefreshNow();
			CreateKey(imaTime);
			CreateKey(0);
			sameAsitem2(0, 0, 1);
		}
		else
		{
		    customshape(3, var5, 0, false, false, nil,nil, nil);
			SchematicPosition(A_pos[1] + 1.0 , A_pos[2] + AddY );
			RefreshNow();
			ParentItem(Sel_Item[2].name + "_LK_" + cnt);
			sameAsitem2(1, Sel_Item[i].name, 7);
			GoToFrame(imaTime*fps);
			RefreshNow();
			CreateKey(imaTime);
			CreateKey(0);
			sameAsitem2(0, 0, 1);
		}
		scn = Scene();
	    Sel_Item4 = scn.getSelect();
	    item = Sel_Item4[1];
	    chan = item.firstChannel();
	    while(chan)
	    {
	        key = chan.keyExists(imaTime);//各チャンネルにキーがあるかどうか？
	        if(key == nil)//キーが無い。
	        {
	        	chan = item.nextChannel();
	        }
	        else//キーがある。キーカーブ変更。
	        {
	        	chan.setKeyCurve(imaTime,c_lnr);
	        	chan = item.nextChannel();
	        }
	    }
	}
}
sameAsitem
{
    expr(0, nil);
	for(i = Sel_Size ; 1 <= i ; i --)
	{
	    item = Sel_Item[i].name;
		SelectItem(item);
		PositionItemWorld(1);
        PositionItem(sel_LK[i]);
        XController(7);
        YController(7);
        ZController(7);
		CommandInput("AddEnvelope Ctrl.PosItemBlend");
	
	    RotationItemWorld(1);
        RotationItem(sel_LK[i]);
        HController(7);
        PController(7);
        BController(7);
		CommandInput("AddEnvelope Ctrl.RotItemBlend");
		expr(1, item);
	}
}
sameAsitem2: wd, item, md
{
    PositionItemWorld(wd);
        PositionItem(item);//item or 0
        XController(md);
        YController(md);
        ZController(md);
        RotationItemWorld(wd);
        RotationItem(item);
        HController(md);
        PController(md);
        BController(md);
}
expr: sw, item
{
    //Lock Expression Create
	if(sw == 0)
	{
        qq="\"";
   	    ExpName = BlendItem;
	    ExpEquation = "clamp([" + BlendItem + ".Position.X],0.000,1.000)";
        CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
        CommandInput(CommandExec);
	}
    //Lock Expression Tekiyou
	if(sw == 1)
	{
	    ExpName_Lock = BlendItem;
		Tgt_Channnel_Lock = item + ".Ctrl.PosItemBlend";
        qq="\"";
        CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel_Lock + qq + "" + qq + ExpName_Lock + qq);
        CommandInput(CommandExec);

	    Tgt_Channnel_Lock = item + ".Ctrl.RotItemBlend";
        qq="\"";
        CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel_Lock + qq + "" + qq + ExpName_Lock + qq);
	    CommandInput(CommandExec);
	}
}
scls_ts1
{
	sel_n = Sel_Item[Sel_Size].name + "_test";
	SelectByName(sel_n);
	scn = Scene();
    Sel_Item2 = scn.getSelect();
	sel_n2 = Sel_Item2[1].name;
	if(sel_n == sel_n2)
    {
	    del_ds();
    }
	ok_ds();
}
/*
scls_ts2
{
    del_ds();
	ok_ds();
}
*/
scls_ts3
{
    del_ds();
}
ok_ds
{
	var1 = getvalue(c1);
	var3 = getvalue(c3);
	var5 = getvalue(c5);
	cpnt = getvalue(c6);
	sps = getvalue(c7);
	var6 = getvalue(c8);
	var8 = getvalue(c10);
	
	sel_n = Sel_Item[Sel_Size].name + "_test";
	SelectByName(sel_n);
	
	scn = Scene();
    Sel_Item2 = scn.getSelect();
	sel_n2 = Sel_Item2[1].name;
	if(sel_n == sel_n2)
    {
		Sel(Sel_Item, Sel_Size);
	    error("I already have a test shape.");
	    return;
    }
	if(var1 == 2)//FtMode
	{
	    if(Sel_Size == 2)
		{
		    for(i = Sel_Size ; 1 <= i ; i --)
	        {
	            sel_n = Sel_Item[i].name + "_test";
		        AddNull(sel_n);
		        ItemColor(cpnt);
				sameAsitem2(1, Sel_Item[i].name, 7);
		        RefreshNow();
		        CreateKey(imaTime);
				sameAsitem2(0, 0, 1);
		        if(i == Sel_Size)
		        customshape(2, var3, 0, false, false, nil,nil, nil);
		        else
		        customshape(3, var5, 0, false, false, nil,nil, nil);
	        }
	        store( "IS_BOX_SCALE", var3 );
	        store( "IS_BALL_SCALE", var5 );
		    Sel(Sel_Item, Sel_Size);
		}
		else
		{
		    SelectItem(Sel_Item[Sel_Size].name);
			error("Please set to [Add look solo] mode");
	        return;
		}
	}
	else//Solo
	{
	    if(Sel_Size == 1)
		{
		    AddNull(sel_n);
		    ItemColor(cpnt);
			sameAsitem2(1, Sel_Item[Sel_Size].name, 7);
		    RefreshNow();
		    CreateKey(imaTime);
			sameAsitem2(0, 0, 1);
		    if(sps != 1)
		    {
		        shape = sps - 1;
			    customshape(shape, var8, var6, false, false, nil,nil, nil);
			    SelectItem(Sel_Item[Sel_Size].name);
			    store( "IS_SHAPES", sps );
	            store( "IS_AXIS", var6 );
			    store( "IS_SP_SCALE", var8 );
		    }
		}
		else
		{
		    Sel(Sel_Item, Sel_Size);
			error("Please set to [Foot rig] mode");
	        return;
		}
	}
	store( "IS_COL", cpnt );
}
del_ds
{
	sel_n = Sel_Item[Sel_Size].name + "_test";
	SelectByName(sel_n);
	
	scn = Scene();
    Sel_Item2 = scn.getSelect();
	sel_n2 = Sel_Item2[1].name;
	if(sel_n != sel_n2)
    {
	  error("There is no test shape.");
	  return;
    }
	if(Sel_Size == 2)
    AddToSelection(Sel_Item[1].name + "_test");
    ClearSelected(1);
	Sel(Sel_Item, Sel_Size);
}
refresh1: value
{
  setvalue(c3, value*.01);
}
refresh2: value
{
  setvalue(c5, value*.01);
}
refresh3: value
{
  setvalue(c10, value*.01);
}
lock_act: value
{
    return(value != 1);
}
lock_act2: value
{
    return(value == 1);
}
getSelected
{
    scn = Scene();
	imaTime = scn.currenttime;
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	if(Sel_Item == nil)
	{
		error("Please select the object.");
		return;
	}
	
	for(i = Sel_Size ; 1 <= i ; i --)//現在のフレームにキーがあるか？
	{
		item = Sel_Item[i];
		chan = item.firstChannel();
	    while(chan)
	    {
		    key = chan.keyExists(imaTime);//各チャンネルにキーがあるか？
			if(key == nil)//キーが無い。
			{
				ima_key[i] = nil;
				chan = item.nextChannel();
			}
			else//キーがある。
			{
				ima_key[i] = true;
				chan = item.nextChannel();
				chan = false;
			}
	    }
	}
	RefreshNow();
	CreateKey(imaTime);
	if(Sel_Size == 2)
	{
	    SelectItem(Sel_Item[Sel_Size].name);
		PreviousKey();
		maeTime = scn.currenttime;
		NextKey();
		Sel(Sel_Item, Sel_Size);
	}
	else
	{
		PreviousKey();
		maeTime = scn.currenttime;
		NextKey();
	}
}
Sel: Sel_Item, Sel_Size
{
    for(i = Sel_Size ; i >= 1 ; i --)
	{
		if(i == Sel_Size)
		{
			sel_id = Sel_Item[Sel_Size].id;
			SelectItem(sel_id);
		}
		else
		{
			sel_id = Sel_Item[i].id;
			AddToSelection(sel_id);
		}
	}
}
customshape: shape, scale, axis, filled = false, xray=false, label = nil,jtfy=nil, linkto=nil
{

	var s0 = @"False","True"@;
    var ls = @"Standard","Box", "Ball","Pyramid","Diamond","Tetra","Ring","Grid","None"@;
    f1 = s0[1+filled];
    f2 = s0[1+xray];
	
    ss = "Generic_AddItemShape Replace=\""+ true +"\" ";
    ss += "Shape=\""+ls[shape]+"\" Axis=\""+axis+"\" Scale=\""+scale+"\" ";
    ss += "Filled=\""+f1+"\" XRay=\""+f2+"\" ";
	if(label != nil)
	{
	ss += "Label=\""+label+"\" ";
	ss += "Justification=\""+jtfy+"\" ";
	}
    if(linkto != nil)
	ss += "LineTo=\""+hex(linkto.id)+"\" ";

    CommandInput(ss);
}