/*
  LScript Layout
  Parenter_ds_UnLock
  LW11.6~
  V1.0
  Daisuke Suzuki
  History: 2022/05/26
*/
//-----------------------------------------
//CharSelectManager専用
//実行にはアイテム選択が条件。固定されてるアイテムを選択し、同位置にあるLockItemを検索して情報取得。
//AddLookSoloは1アイテムの選択が条件。
//FtRigモードは、LegGoalとToeGoalが選択条件。
//LockToItemは固定する側されてる側のアイテムが選択条件。

//Lockスタート値はBlendItemのKeyで判断。

@version 2.6
@warnings
@script generic
@name Parenter_ds_UnLock

foot_icon  = @ ".........mmmmm..", 
               ".........mmmmm..", 
               ".........mmmmm..", 
               ".........mmmm...", 
               ".........mmmm...", 
               ".........mmmm...", 
               ".......mmmmmm...", 
               ".....mmmmmmmmm..", 
               ".mmmmmmmmmmmmm..", 
               ".mmmmmmmmmmmmm..", 
               "..mmmmm....mmm..", 
               "................", 
               "................" 
               @; 
lock_icon  = @ "............", 
               "............", 
               "..mmm.......", 
               ".m...m......", 
               ".m...m......", 
               ".m...m......", 
               "mmmmmmm.....", 
               "mmmmmmm.....", 
               "mmmmmmm.....", 
               "mmmmmmm.....", 
               "mmmmmmm.....", 
               "............", 
               "............" 
               @; 
			   
@define FOOT 1
@define LOCK 2
del_lk_n;
fps;
imaTime;
ima_key;
generic
{
    ParentInPlace(1);
	icon[FOOT] = Icon(foot_icon); 
    Ft_Icon = icon[FOOT].asStr()+" Foot rig";
	icon[LOCK] = Icon(lock_icon); 
    Lk_Icon = icon[LOCK].asStr()+"ItemLock";
	
	scn = Scene();
	fps = scn.fps;
	imaTime = scn.currenttime;
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	if(Sel_Item == nil)
	{
		error("Please select the object.");
		return;
	}
	
	for(i = Sel_Size ; 1 <= i ; i --)//現在のフレームにキーがあるか？
	{
		item = Sel_Item[i];
		chan = item.firstChannel();
	    while(chan)
	    {
		    key = chan.keyExists(imaTime);//各チャンネルにキーがあるか？
			if(key == nil)//キーが無い。
			{
				ima_key[i] = nil;
				chan = item.nextChannel();
			}
			else//キーがある。
			{
				ima_key[i] = true;
				chan = item.nextChannel();
				chan = false;
			}
	    }
	}
	//RefreshNow();
	//CreateKey(imaTime);
	
	BlendItem = Sel_Item[Sel_Size].name + "_LKBlend";
	SelectByName(BlendItem);
	Ble_Item = scn.getSelect();
	Bl_Item = Ble_Item[1].name;
	
	if(Ble_Item[1].name != BlendItem)
    {
	    //DeleteKey(imaTime);
		BlendItem = Sel_Item[Sel_Size].name + "_LTBlend";
		SelectByName(BlendItem);
	    Ble_Item = scn.getSelect();
	    Bl_Item = Ble_Item[1].name;
		if(Ble_Item[1].name != BlendItem)//BlendItemが無い。
		{
		    error("Make sure the Parenter_ds startup is not running or generate a LockItem base for the "+ Sel_Item[Sel_Size].name +".");
	        return;
		}
    }
	
	PreviousKey();
	maeTime = scn.currenttime;
	GoToFrame(imaTime*fps);
	Sel(Sel_Item, Sel_Size);

    col = @"Black","Dark Blue","Dark Green",
         "Dark Cyan","Dark Red","Purple",
		 "Brown","Grey","Blue","Green",
         "Cyan","Red","Magenta","Orange","White"@;
		 
	//var1 = recall( "UL_MODE", 1 );
	var2 = 0;
	var3 = recall( "UL_HID", 0 ) ;
	var4 = recall( "nande", 0 ) ;
	var4 = recall( "UL_ItemLock", 0 ) ;
	cpnt = recall( "UL_COL", 3 ) ;
	var5 = recall( "UL_KEY", 3 ) ;
	var6 = maeTime*fps;
	var7 = imaTime*fps;
	
	reqbegin("Parenter_ds [UnLock]");
	reqsize(334,150);
	
	//c1 = ctlchoice("UnLock",var1,@"Add look solo",Ft_Icon,"LockToItem"@);
    //ctlposition(c1,10,10,310);
	
	//s0 = ctlsep(0,350);
    //ctlposition(s0,0,40);
	
	c2 = ctlcheckbox("LockItem changes after UnLock",var2);
    ctlposition(c2,10,10,310);
	
	c3 = ctlcheckbox("Hidden",var3);
    ctlposition(c3,10,32);
	
	c4 = ctlcheckbox(Lk_Icon,var4);
    ctlposition(c4,84,32,92);

	c5 = ctlpopup("Color",cpnt,col);//Color
    ctlposition(c5,180,32,140);
	
	s1 = ctlsep(0,350);
    ctlposition(s1,0,60);

	c6 = ctlchoice("CreateKey",var5,@"Not CreateKey","CreateKey","Motion baker"@);
    ctlposition(c6,10,70,310);
	
	c7 = ctlminislider("S :",var6,-10000,10000);
    ctlposition(c7,72,94,90);
	
	c8 = ctlminislider("E :",var7,-10000,10000);
    ctlposition(c8,208,94,90);
	
	ctlactive(c2,"LC1",c3,c4,c5);
	ctlactive(c6,"LC2",c7,c8);

    
	return if !reqpost();
	
	//var1 = getvalue(c1);
	var2 = getvalue(c2);
	var3 = getvalue(c3);
	var4 = getvalue(c4);
	cpnt = getvalue(c5);
	var5 = getvalue(c6);
	var6 = getvalue(c7);
	var7 = getvalue(c8);
	
	sel_n = Sel_Item[Sel_Size].name;
	//sel_c = Sel_Item[Sel_Size].firstChild();
	//lok_n = Sel_Item[1].name;
	lok_c = Sel_Item[1].firstChild();
	//lok_base = Sel_Item[1].parent;
	//lok_del = lok_base.name - "_LKBase";
	
	BaseItem = Sel_Item[Sel_Size].name + "_LKBase";
	SelectByName(BaseItem);
	Bs_Item = scn.getSelect();
	Bs_Item_n = Bs_Item[1].name;

	if(BaseItem == Bs_Item_n)//LockInPlaceアイテム又はStartUpで作成したアイテムのLockToItem
	{
		GL_x = round(Sel_Item[Sel_Size].getWorldPosition(imaTime).x,5);
	    GL_y = round(Sel_Item[Sel_Size].getWorldPosition(imaTime).y,5);
	    GL_z = round(Sel_Item[Sel_Size].getWorldPosition(imaTime).z,5);
		
	    SelectItem(Sel_Item[Sel_Size].name + "_LKBase");
	    scn = Scene();
        Sel_Item2 = scn.getSelect();
        Sel_Size2 = Sel_Item2.size();
        cld = Sel_Item2[Sel_Size2].firstChild();//BlendItem
	    cld = Sel_Item2[Sel_Size2].nextChild(); 

	    done = false;//ロックアイテム数検索
	    while(!done)
	    {
		
		    if(cld == nil)//ロックアイテム無し。
			{
				switch(var5)//CreateKey
	            {
					case 1://Not
	                expr(2, Sel_Item, Sel_Size);
		            BlendResetter(1, Sel_Item, Sel_Size, imaTime);
			
			        for(i = Sel_Size ; 1 <= i ; i --)//元々、キーが作成されてなかったフレームの場合、キーを削除する。
	                {
				        if(ima_key[i] == nil)
				        {
					        SelectItem(Sel_Item[i].id);
					        DeleteKey(imaTime);
				        }
			        }
		            break;
		            case 2://Create
			        Ft_Item = Sel_Item[Sel_Size].name;
                    Lc_Item = Sel_Item[1].name;
			        LockKeyPaste(Ft_Item, Lc_Item, var2, var3, var4, var6, var7, cpnt);
		            expr(2, Sel_Item, Sel_Size);
		            BlendResetter(1, Sel_Item, Sel_Size, imaTime);
		            break;
		            case 3://Bake
		            SelectItem(Sel_Item[1].name);
			        LI_After(var2, var3, var4, cpnt);
			        Baker(Sel_Item, Sel_Size, var6, var7);
			        expr(2, Sel_Item, Sel_Size);
	                BlendResetter(1, Sel_Item, Sel_Size, imaTime);
		            break;
                }
				SelectItem(Sel_Item[Sel_Size].name + "_LTBlend");
				ClearSelected(1);
				done = true;
			}
		    else
		    {
			    LK_x = round(cld.getWorldPosition(imaTime).x,5);
		        LK_y = round(cld.getWorldPosition(imaTime).y,5);
		        LK_z = round(cld.getWorldPosition(imaTime).z,5);
			    if(GL_x == LK_x)
			    {
			        if(GL_y == LK_y)
				    {
				        if(GL_z == LK_z)
				    	{
							SelectItem(cld);//LockItem(LegGoal_LK00)
							del_lk_n = strright( cld.name, 7);//文字列の右端からの部分文字列（7文字）を返す。
							scn = Scene();
                            Sel_Item3 = scn.getSelect();
                            Sel_Size3 = Sel_Item3.size();
                            lok_c = Sel_Item3[Sel_Size3].firstChild();//LockItem(ToeGoal_LK00)
		
		                    if(lok_c != nil)//ToeGoal_LK00有り  FtRig
		                    {
			                    AddToSelection(lok_c.name);//ToeGoal
		                    }
		                    RefreshNow();
		                    CreateKey(imaTime);
                            Sel_Item4 = scn.getSelect();
                            Sel_Size4 = Sel_Item4.size();
		
		                    if(lok_c != nil)//FtRig
		                    {
			                    sel_c = lok_c.name - del_lk_n;
								SelectItem(sel_n);
			                    AddToSelection(sel_c);
			                    Sel_Item5 = scn.getSelect();
                                Sel_Size5 = Sel_Item5.size();
		                    }
		                    else//Solo
		                    {
		                        SelectItem(sel_n);
			                    Sel_Item5 = scn.getSelect();
                                Sel_Size5 = Sel_Item5.size();
		                    }
	                        switch(var5)//CreateKey
		                    {
		                        case 1://Not
			                    if(lok_c == nil)
			                    expr(0, Sel_Item, Sel_Size);
			                    if(lok_c != nil)
			                    expr(1, Sel_Item5, Sel_Size5);
			                    BlendResetter(0, Sel_Item, Sel_Size, imaTime);

							    for(i = Sel_Size ; 1 <= i ; i --)//元々、キーが作成されてなかったフレームの場合、キーを削除する。
	                            {
							        if(ima_key[i] == nil)
									{
										SelectItem(Sel_Item[i].id);
										DeleteKey(imaTime);
									}
								}
		                        break;
		                        case 2://Create
							    if(cld.name == Sel_Item[1].name)
								{
									for(i = Sel_Size5 ; 1 <= i ; i --)//LockToItemの選択の場合
	                                {
			                            Ft_Item = Sel_Item5[i].name;
				                        Lc_Item = Sel_Item4[i].name;
			                            LockKeyPaste(Ft_Item, Lc_Item, var2, var3, var4, var6, var7, cpnt);
			                        }
							    }
								else//LockInPlaceの選択の場合
								{
			                        for(i = Sel_Size ; 1 <= i ; i --)
	                                {
			                            Ft_Item = Sel_Item5[i].name;
				                        Lc_Item = Sel_Item4[i].name;
			                            LockKeyPaste(Ft_Item, Lc_Item, var2, var3, var4, var6, var7, cpnt);
			                        }
								}
			                    if(lok_c == nil)//Solo
			                    expr(0, Sel_Item, Sel_Size);
			                    if(lok_c != nil)//FtRig
			                    expr(1, Sel_Item5, Sel_Size5);
			                    BlendResetter(0, Sel_Item5, Sel_Size5, imaTime);
		                        break;
		                        case 3://Bake
			                    for(i = Sel_Size ; 1 <= i ; i --)
	                            {
				                    Lc_Item = Sel_Item4[i].name;
				                    SelectItem(Lc_Item);
			                        LI_After(var2, var3, var4, cpnt);
			                    }
			                    if(lok_c == nil)//Solo
			                    {
			                        Baker(Sel_Item5, Sel_Size5, var6, var7);
			                        expr(0, Sel_Item, Sel_Size);
			                    }
			                    if(lok_c != nil)//FtRig
			                    {
			                        Baker(Sel_Item5, Sel_Size5, var6, var7);
			                        expr(1, Sel_Item5, Sel_Size5);
			                    }
			                    BlendResetter(0, Sel_Item5, Sel_Size5, imaTime);
		                        break;
		                    }
							done = true;
				    	}
			        }
		        }
				cld = Sel_Item2[Sel_Size2].nextChild(); 
	        }
	    }
	}
	else//LockToNull
	{
		switch(var5)//CreateKey
	    {
		    case 1://Not
	        expr(2, Sel_Item, Sel_Size);
		    BlendResetter(1, Sel_Item, Sel_Size, imaTime);
			
			for(i = Sel_Size ; 1 <= i ; i --)//元々、キーが作成されてなかったフレームの場合、キーを削除する。
	        {
				if(ima_key[i] == nil)
				{
					SelectItem(Sel_Item[i].id);
					DeleteKey(imaTime);
				}
			}
		    break;
		    case 2://Create
			Ft_Item = Sel_Item[Sel_Size].name;
            Lc_Item = Sel_Item[1].name;
			LockKeyPaste(Ft_Item, Lc_Item, var2, var3, var4, var6, var7, cpnt);
		    expr(2, Sel_Item, Sel_Size);
		    BlendResetter(1, Sel_Item, Sel_Size, imaTime);
		    break;
		    case 3://Bake
		    SelectItem(Sel_Item[1].name);
			LI_After(var2, var3, var4, cpnt);
			Baker(Sel_Item, Sel_Size, var6, var7);
			expr(2, Sel_Item, Sel_Size);
	        BlendResetter(1, Sel_Item, Sel_Size, imaTime);
		    break;
        }
		SelectItem(Sel_Item[Sel_Size].name + "_LTBlend");
				ClearSelected(1);
	}

	GoToFrame(imaTime*fps);
	Sel(Sel_Item, Sel_Size);
	
	store( "UL_MODE", var1 );
	store( "UL_HID", var3 );
	store( "UL_ItemLock", var4 );
	store( "UL_COL", cpnt );
	store( "UL_KEY", var5 );
}
LockToItm
{
    
}
LockKeyPaste: item, LockItem, var2, var3, var4, var6, var7, cpnt
{
	GoToFrame(var6);//StartFrameへ移動
	SelectItem(LockItem);
	LI_After(var2, var3, var4, cpnt);
	scn = Scene();
	fps = scn.fps;
	bakeTime = scn.currenttime;
	SelectItem(item);//Lockされてるアイテムのキー作成
	RefreshNow();
	CreateKey(bakeTime);
	GoToFrame(imaTime*fps);
	CreateKey(imaTime);
	GoToFrame(var6);
	
	if(bakeTime == 0)
	{
	    NextKey();
		bakeTime = scn.currenttime;
		
	}
	done = false;
	while(!done)
	{
	    if(bakeTime == 0)
		{
		    done = true;
		}
		else
		{
		    if(bakeTime*fps == var7)
		    {
		        SelectItem(item);
			    bakeTime = scn.currenttime;
			    RefreshNow();
	            CreateKey(bakeTime);
				done = true;
		    }
		    else
		    {
		        SelectItem(LockItem);
			    NextKey();
			
			    SelectItem(item);
			    bakeTime = scn.currenttime;
			    RefreshNow();
	            CreateKey(bakeTime);
		    }
		}
	}
}
Baker: Sel_Item, Sel_Size, var6, var7
{
	GoToFrame(var6);
	Sel(Sel_Item, Sel_Size);

	for(i = var6 ; i <= var7 ; i ++)
	{
		scn = Scene();
		bakeTime = scn.currenttime;
		RefreshNow();
		CreateKey(bakeTime);
		NextFrame();
	}
}
expr: sw, Sel_Item, Sel_Size
{
    //Lock Expression kaizyo
	if(sw == 0)
	{
		qq="\"";
	    ExpName = Sel_Item[Sel_Size].name + "_LKBlend";
	    Tgt_Channnel_pos = Sel_Item[Sel_Size].name + ".Ctrl.PosItemBlend";
	    CommandExec_pos = ("GE_DetachExpression "+ qq + Tgt_Channnel_pos + qq + "" + qq + ExpName + qq);
        CommandInput(CommandExec_pos);
	
	    Tgt_Channnel_rot = Sel_Item[Sel_Size].name + ".Ctrl.RotItemBlend";
	    CommandExec_rot = ("GE_DetachExpression "+ qq + Tgt_Channnel_rot + qq + "" + qq + ExpName + qq);
        CommandInput(CommandExec_rot);
	}
	if(sw == 1)
	{
	    for(i = Sel_Size ; 1 <= i ; i --)
	    {
		    qq="\"";
	        ExpName = Sel_Item[2].name + "_LKBlend";
	        Tgt_Channnel_pos = Sel_Item[i].name + ".Ctrl.PosItemBlend";
	        CommandExec_pos = ("GE_DetachExpression "+ qq + Tgt_Channnel_pos + qq + "" + qq + ExpName + qq);
            CommandInput(CommandExec_pos);
	
	        Tgt_Channnel_rot = Sel_Item[i].name + ".Ctrl.RotItemBlend";
	        CommandExec_rot = ("GE_DetachExpression "+ qq + Tgt_Channnel_rot + qq + "" + qq + ExpName + qq);
            CommandInput(CommandExec_rot);
		}
	}
	if(sw == 2)
	{
		qq="\"";
	    ExpName = Sel_Item[Sel_Size].name + "_LTBlend";
	    Tgt_Channnel_pos = Sel_Item[Sel_Size].name + ".Ctrl.PosItemBlend";
	    CommandExec_pos = ("GE_DetachExpression "+ qq + Tgt_Channnel_pos + qq + "" + qq + ExpName + qq);
        CommandInput(CommandExec_pos);
	
	    Tgt_Channnel_rot = Sel_Item[Sel_Size].name + ".Ctrl.RotItemBlend";
	    CommandExec_rot = ("GE_DetachExpression "+ qq + Tgt_Channnel_rot + qq + "" + qq + ExpName + qq);
        CommandInput(CommandExec_rot);
	}
	if(sw != 2)
	{
	    for(i = Sel_Size ; 1 <= i ; i --)
	    {
	        SelectItem(Sel_Item[i].name);
		    PositionItemWorld(0);
            PositionItem(0);
            CommandInput("RemoveEnvelope Ctrl.PosItemBlend");
            XController(1);
            YController(1);
            ZController(1);
            RotationItemWorld(0);
            RotationItem(0);
            CommandInput("RemoveEnvelope Ctrl.RotItemBlend");
            HController(1);
            PController(1);
            BController(1);
	    }
	}
	else
	{
	    SelectItem(Sel_Item[Sel_Size].name);
		PositionItemWorld(0);
        PositionItem(0);
        CommandInput("RemoveEnvelope Ctrl.PosItemBlend");
        XController(1);
        YController(1);
        ZController(1);
        RotationItemWorld(0);
        RotationItem(0);
        CommandInput("RemoveEnvelope Ctrl.RotItemBlend");
        HController(1);
        PController(1);
        BController(1);
	}
	CommandInput("GE_ClearUnusedExpressions");
}
LI_After: var2, var3, var4, cpnt
{
    if(var2 == true)
	{
		if(var3 == true)
		ItemVisibility(1);
		if(var4 == true)
		ItemLock(1);
		ItemColor(cpnt);
	}
}
BlendResetter: sw, Sel_Item, Sel_Size, imaTime//sw 0=LockInPlace 1=LockToItem
{
    if(sw == 0)
	SelectItem(Sel_Item[Sel_Size].name + "_LKBlend");//LockInPlace BlendItem
	if(sw == 1)
	SelectItem(Sel_Item[Sel_Size].name + "_LTBlend");//LockInPlace BlendItem
	GoToFrame(imaTime*fps);
	NextKey();//最初のフレーム
	scn = Scene();
	firstTime = scn.currenttime;
	NextKey();//次のキーフレーム
	nextTime  = scn.currenttime;
	done = false;
	while(!done)
	{
		if(firstTime == nextTime)
		done = true;
		else
		{
			DeleteKey(nextTime);
			NextKey();
	        nextTime  = scn.currenttime;
		}
	}
}
Sel: Sel_Item, Sel_Size
{
    for(i = Sel_Size ; i >= 1 ; i --)
	{
		if(i == Sel_Size)
		{
			sel_id = Sel_Item[Sel_Size].id;
			SelectItem(sel_id);
		}
		else
		{
			sel_id = Sel_Item[i].id;
			AddToSelection(sel_id);
		}
	}
}
LC1: value
{
  return(value==1);
}
LC2: value
{
  return(value!=1);
}