/*
  LScript Layout
  Parenter_ds_LockToItem
  LW11.6~
  V1.0
  Daisuke Suzuki
  History: 2022/05/26
*/
//-----------------------------------------
//CharSelectManager専用
//実行にはアイテム選択が条件。「固定されるアイテム -> 固定するアイテム」の順で選択することが条件。
//LockInPlaceで生成したLockItemへ再び固定させることが可能。

@version 2.6
@warnings
@script generic
@name Parenter_ds_LockToItem

fps;
Sel_Item;
Sel_Size;
Selected_Item;
Selected_Size;
imaTime;
maeTime;
sel_n;
sel_PrtB_n;
A_pos_x;
A_pos_y;
BlendItem;
LK_n;
min_Time;
c_lnr = CHAN_LINEAR;

generic
{
    ParentInPlace(1);
	scn = Scene();
	fps = scn.fps;
	imaTime = scn.currenttime;
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	if(Sel_Size != 2)
	{
		error("Please select two object.");
		return;
	}
	sel_n = Sel_Item[Sel_Size].name;
	
	for(i = Sel_Size ; 1 <= i ; i --)//現在のフレームにキーがあるか？
	{
		item = Sel_Item[i];
		chan = item.firstChannel();
	    while(chan)
	    {
		    key = chan.keyExists(imaTime);//キーがあるか？
			if(key == nil)//キーが無い。
			{
				ima_key[i] = nil;
				chan = item.nextChannel();
			}
			else//キーがある。
			{
				ima_key[i] = true;
				Key_Cnt = chan.keyCount;//キーフレームの数
				
				for(i = Key_Cnt ; 1 <= i ; i --)//現在のフレームにキーがあるか？
	            {
				    Key_id = chan.keys[i];//キーフレームID(key)
					Key_Time[i] = chan.getKeyTime(Key_id);//指定したキーに対するTimeの値を返します。
				}
				
				count = Key_Cnt - 1;
				for(i = Key_Cnt ; 1 < i ; i --)//始まりのキーのタイムを取得。
	            {
				    if(i == Key_Cnt)
					{
					    min_Time = min(Key_Time[i], Key_Time[count]);
					}
					else
					{
					    min_Time = min(min_Time, Key_Time[count]);
					}
					count--;
				}
				chan = false;
			}
	    }
	}
	if(ima_key[2] == nil)//Lockされるアイテムにキーが無ければ、キー作成してそのフレーム値を記憶しキーを削除する。
	{
	    SelectByName(sel_n);
	    RefreshNow();
	    CreateKey(imaTime);
	    //imaTime = scn.currenttime;
	    PreviousKey();
	    maeTime = scn.currenttime;
	    NextKey();
		DeleteKey(imaTime);
	}
	else
	{
	    SelectByName(sel_n);
		PreviousKey();
	    maeTime = scn.currenttime;
	    NextKey();
	}
	LK_n[2] = Sel_Item[1].name;
	lok_c = Sel_Item[1].firstChild();
	
	lok_base = Sel_Item[1].parent;
	
	if(lok_base != nil)//Lockの親アイテム有り。
	{
	    lok_del = lok_base.name - "_LKBase";
		//info("LockInPlace");
		if(sel_n == lok_del)//LockBase有り　ReLock Solo or FtRig
		{
		    
			if(lok_c == nil)//Lock子アイテム無し　Solo
			{
				LockItm(0, Sel_Item, Sel_Size, nil);
			}
			else//Lock子アイテム有り　FtRig
			{
				LK_n[1] = lok_c.name;
				LK_num = LK_n[2] - sel_n;//_LK00
	            sel_n_toe = LK_n[1] - LK_num;//ToeGoal
				SelectItem(sel_n);
				AddToSelection(sel_n_toe);
				scn = Scene();
                Selected_Item = scn.getSelect();
                Selected_Size = Selected_Item.size();
				LockItm(1, Selected_Item, Selected_Size, nil);
			}
		}
		else//LockBase無し　LockToItem
		{
		    //info("LockToItem");
			Sel_PrtBase(Sel_Item, Sel_Size);
		    LockItm(2, Sel_Item, Sel_Size, sel_PrtB_n);
		}
	}
	else//Lockの親アイテム無し。　LockToNullへ
	{
	    //info("LockToItem");
		Sel_PrtBase(Sel_Item, Sel_Size);
		LockItm(2, Sel_Item, Sel_Size, sel_PrtB_n);
	}
}
LockItm: sw, Sel_Item, Sel_Size, sel_PrtB_n
{
    // 0 Solo
	// 1 FtRig
	// 2 LockToItem

	if(sw == 2)//LockToItem
	{
		BlendItem = Sel_Item[Sel_Size].name + "_LTBlend";
	    AddNull(BlendItem);//BlendItem
        ItemColor(1);
        SchematicPosition((A_pos_x) , (-0.4+A_pos_y));
        SelectByName(BlendItem);
        RefreshNow();
        ParentItem(sel_PrtB_n);
        ItemLock(1);
        ItemVisibility(1);
	}
	if(sw != 2)//Solo or FtRig
	{
	    BlendItem = Sel_Item[Sel_Size].name + "_LKBlend";
		SelectByName(BlendItem);
	}
	scn = Scene();
	Blend_Item = scn.getSelect();
	item = Blend_Item[1];
	bl_pos_x = item.getPosition(0).x;
	if(bl_pos_x == 1)//BlendItemが0フレームで1mだった場合、0mにする。
	{
		GoToFrame(0);
		Position(0,0,0);
	    RefreshNow();
	    CreateKey(0);
	}
	GoToFrame(imaTime*fps);
	Position(1,0,0);
	RefreshNow();
	CreateKey(imaTime);
	if(imaTime != maeTime)//現在のフレームがスタートフレームの場合、ブレンディングモーションは作成しない。
	{
		GoToFrame(maeTime*fps);
	    Position(0,0,0);
	    RefreshNow();
	    CreateKey(maeTime);
	    GoToFrame(imaTime*fps);
	}

	chan = item.firstChannel();
	while(chan)
	{
	    key = chan.keyExists(maeTime);//各チャンネルにキーがあるかどうか？
	    if(key == nil)//キーが無い。
	    {
	        chan = item.nextChannel();
	    }
	    else//キーがある。キーカーブ変更。
	    {
	        chan.setKeyCurve(maeTime,c_lnr);
	        chan = item.nextChannel();
	    }
	}
	if(sw != 1)//Solo and LockToItem 0 3
	{
	    expr(0, nil);
	    SelectItem(sel_n);
	    PositionItemWorld(1);
        PositionItem(LK_n[2]);
        XController(7);
        YController(7);
        ZController(7);
	    CommandInput("AddEnvelope Ctrl.PosItemBlend");
	
	    RotationItemWorld(1);
        RotationItem(LK_n[2]);
        HController(7);
        PController(7);
        BController(7);
	    CommandInput("AddEnvelope Ctrl.RotItemBlend");
	    expr(1, sel_n);
	}
	else//FtRig 1
	{
		sameAsitem(Selected_Item, Selected_Size, LK_n);
	}

}
Sel_PrtBase: Sel_Item, Sel_Size
{
    sel = Sel_Item[Sel_Size];
	SelectByName(sel.name);
    done = false;
    while(!done)
    {
        if(sel != nil)
	        sel = sel.parent;
	    if(sel == nil)
	    {
		    scn = Scene();
            sel_Item = scn.getSelect();
            sel_size = sel_Item.size();
            sel_PrtB_n = sel_Item[sel_size].name;//MasterItem
            A_pos = scn.schemaPosition(sel_PrtB_n);
            A_pos_x = A_pos[1];
            A_pos_y = A_pos[2];

	        done = true;
	        return;
	    }
	    SelectByName(sel.name);
    }
}
sameAsitem: Sel_Item, Sel_Size, LK_n
{
    expr(0, nil);
	for(i = Sel_Size ; 1 <= i ; i --)
	{
	    item = Sel_Item[i].name;
		SelectItem(item);
		PositionItemWorld(1);
        PositionItem(LK_n[i]);
        XController(7);
        YController(7);
        ZController(7);
		CommandInput("AddEnvelope Ctrl.PosItemBlend");
	
	    RotationItemWorld(1);
        RotationItem(LK_n[i]);
        HController(7);
        PController(7);
        BController(7);
		CommandInput("AddEnvelope Ctrl.RotItemBlend");
		expr(1, item);
	}
}
expr: sw, item
{
    //Lock Expression Create
	if(sw == 0)
	{
        qq="\"";
   	    ExpName = BlendItem;
	    ExpEquation = "clamp([" + BlendItem + ".Position.X],0.000,1.000)";
        CommandExec = ("GE_CreateExpression "+ qq + ExpName + qq + " " + qq + ExpEquation +qq);
        CommandInput(CommandExec);
	}
    //Lock Expression Tekiyou
	if(sw == 1)
	{
	    ExpName_Lock = BlendItem;
		Tgt_Channnel_Lock = item + ".Ctrl.PosItemBlend";
        qq="\"";
        CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel_Lock + qq + "" + qq + ExpName_Lock + qq);
        CommandInput(CommandExec);

	    Tgt_Channnel_Lock = item + ".Ctrl.RotItemBlend";
        qq="\"";
        CommandExec = ("GE_AttachExpression "+ qq + Tgt_Channnel_Lock + qq + "" + qq + ExpName_Lock + qq);
	    CommandInput(CommandExec);
	}
}
Sel: Sel_Item, Sel_Size
{
    for(i = Sel_Size ; i >= 1 ; i --)
	{
		if(i == Sel_Size)
		{
			sel_id = Sel_Item[Sel_Size].id;
			SelectItem(sel_id);
		}
		else
		{
			sel_id = Sel_Item[i].id;
			
			AddToSelection(sel_id);
		}
	}
}