/*
  LScript Layout
  BonesToNulls_ds
  LW11~
  V1.1
  Daisuke Suzuki
  History: 2023/02/08
*/
//-----------------------------------------

@name BonesToNulls_ds
@script generic
@version 2.6
@warnings

Sel_Item;
Sel_Size;

generic
{
    var1 = recall( "mode", 1 ) ;
	var2 = 0;
	var3 = 0;
	var4 = 0;
	tchnm = "";
	obj_c = nil;
	var5 = 0;
	var6 = 0;
	var7 = 0;
	
	reqbegin("BonesToNulls_ds");
    reqsize(230,150);
	
	s0 = ctlsep(0,230);
    ctlposition(s0,0,28);
	
	c1 = ctlchoice("",var1,@"SkelegonsToNulls","BonesToNulls"@);
    ctlposition(c1,2,5,220,18);
	
	c2 = ctlcheckbox("Bones -> Nulls [ Same Rotation ]",var2);
    ctlposition(c2,6,36,212,18);
	
	c3 = ctlcheckbox("Add",var3);
    ctlposition(c3,6,56,56,18);
	
	c4 = ctlchoice("",var4,@"Pfx","Sfx"@);
    ctlposition(c4,56,56,66,18);
	
	c5 = ctlstring("",tchnm);//Name
    ctlposition(c5,120,56,98,18);
	
	c6 = ctlmeshitems("Object to Convert",obj_c);
	ctlposition(c6,6,76,212,18);
	
	c7 = ctlcheckbox("Apply Skelegon Hierarchy",var5);
    ctlposition(c7,6,96,212,18);
	
	c8 = ctlcheckbox("Delete Selected Bones",var6);
    ctlposition(c8,6,76,212,18);
	
	c9 = ctlcheckbox("Apply Bone Hierarchy",var7);
    ctlposition(c9,6,96,212,18);
	
	ctlvisible(c1,"AC1",c6,c7);
	ctlvisible(c1,"AC2",c8,c9);
	
	ctlactive(c3,"AC3",c4,c5);
	ctlactive(c6,"AC4",c7);
	
	
	return if !reqpost();
	
	var1 = getvalue(c1);
	var2 = getvalue(c2);
	var3 = getvalue(c3);
	var4 = getvalue(c4);
	tchnm = getvalue(c5);
	obj_c = getvalue(c6);
	var5 = getvalue(c7);
	var6 = getvalue(c8);
	var7 = getvalue(c9);
	
	if(var1 == 1)//SkelegonToNulls
	{
	    if(obj_c == nil)
		{
		    error("Please select the skelegon object.");
		}
		else
		{
		    SelectItem(obj_c);
			CommandInput("SkelegonsToBones");
			SelectChild();
			CommandInput("Generic_selectchildren");
			scn = Scene();
            Sel_Item = scn.getSelect();
            Sel_Size = Sel_Item.size();
			
			bone_to_nulls(Sel_Item, Sel_Size, var2, var3, var4, var5, var6, var7, tchnm);
		}
	}
	else//BoneToNulls
	{
	    scn = Scene();
        Sel_Item = scn.getSelect();
        Sel_Size = Sel_Item.size();
		gns = Sel_Item[Sel_Size].genus;
	    if(gns != 4)
		{
		    error("Please select the bone.");
		}
		bone_to_nulls(Sel_Item, Sel_Size, var2, var3, var4, var5, var6, var7, tchnm);
	}
	store( "mode", var1 );
}	

bone_to_nulls: Sel_Item, Sel_Size, var2, var3, var4, var5, var6, var7, tchnm
{
	count = 0;
	for(i = Sel_Size ; 1 <= i ; i --)
	{
	    if(var3 == 0)//Add off
		{
			sel = Sel_Item[i].name;
		}
		else//on
		{
			if(var4 == 1)//Pfx
			{
				sel = tchnm + "_" + Sel_Item[i].name;
			}
			if(var4 == 2)//Sfx
			{
				sel = Sel_Item[i].name + "_" + tchnm;
			}
		}
		AddNull(sel);
		scn = Scene();
        null_Item = scn.getSelect();
	    nulls[i] = null_Item[1];
		count++;
	}

	if(var5 == true  || var7 == true)
	{
	    for(i = Sel_Size ; 1 <= i ; i --)//hierarcy
	    {
	        SelectItem(nulls[i].id);
		    oya = Sel_Item[i].parent;
		    if(i == Sel_Size)
		    {
			    if(oya != nil)
			    {
			        ParentItem(oya.name);
					SameAsItem(1, 0, Sel_Item, i);
			    }
		    }
		    else
		    {
		        oya = Sel_Item[i].parent;
			    done = false;
			    while(!done)
	            {
			        if(var3 == 0)//Add off
				    {
					    null_n = nulls[count].name;
				    }
			        else//on
				    {
				        if(var4 == 1)//Pfx
					    {
						    Pfx = tchnm + "_";
						    null_n  =  nulls[count].name - Pfx;
					    }
					    if(var4 == 2)//Sfx
					    {
					        Sfx = "_" + tchnm;
						    null_n  =  nulls[count].name - Sfx;
					    }
			    	}
				    if(oya.name == null_n)//名称一致
	                {
					    ParentItem(nulls[count].id);
						SameAsItem(1, 0, Sel_Item, i);
					    done = true;
	                }
	                else//名称不一致
	                {
				        count--;
	                }
			    }
		    }
	    }
	}
	if(var2 == 1)//sameAsitem
	{
	    for(i = Sel_Size ; 1 <= i ; i --)
	    {
		    SelectItem(nulls[i].id);
			SameAsItem(1, 1, Sel_Item, i);
	    }
	}
	for(i = Sel_Size ; 1 <= i ; i --)
	{
		if(i == Sel_Size)
		{
			SelectItem(Sel_Item[Sel_Size].id);
		}
		else
		{
			AddToSelection(Sel_Item[i].id);
		}
	}
	if(var6 == 1)
	{
	    ClearSelected(1);
	}	
}

SameAsItem: Pos, Rot, Sel_Item, Size
{
    if(Pos == 1)
	{
	    PositionItemWorld(1);
        PositionItem(Sel_Item[Size].id);
        XController(7);
        YController(7);
        ZController(7);
	    RefreshNow();
	    CreateKey(0);
	
	    PositionItemWorld(0);
        PositionItem(0);
        XController(1);
        YController(1);
        ZController(1);
	}
	if(Rot == 1)
	{
	    RotationItemWorld(1);
        RotationItem(Sel_Item[Size].id);
        HController(7);
        PController(7);
        BController(7);
	    RefreshNow();
	    CreateKey(0);
	
	    RotationItemWorld(0);
        RotationItem(0);
        HController(1);
        PController(1);
        BController(1);
	}
}
AC1: value
{
  return(value==1);
}
AC2: value
{
  return(value!=1);
}
AC3: value
{
  return(value==1);
}
AC4: value
{
  return(value!=nil);
}