/*
  LScript Layout
  Add_Light_ds
  LW11~
  V1.0
  Daisuke Suzuki
  History: 2023/02/06
*/

//-----------------------------------------

@name Add_Light_ds
@script generic
@version 2.5
@warnings

generic
{
    scn = Scene();
    sel_Item = scn.getSelect();
	sel_Size = sel_Item.size();
	cb_sel_n = "SelectItem (" + sel_Size + ")";
	
	var	lt_c = recall( "sc", 1 );
	choice_a[1] = "DistantLight";
	choice_a[2] = "PointLight";
	choice_a[3] = "SpotLight";
	var	Light_n = recall( "lc",  "Light" );
	
	var	cnt_on = recall( "co", 0 );
	var	cnt_mode = recall( "cm", 1 );
	choice_b[1] = "Generate";
	choice_b[2] = cb_sel_n;
	
	NumLights = 1;
	
	choice_c[1] = "none";
	choice_c[2] = "Child";
	choice_c[3] = "Same Position";
	
	var	pos_mode = recall( "pm", 1 );
	var var3 = recall( "name_save3", 1 );
	var	Num_nb = recall( "name_save2", 1 );
    var var4 = recall( "name_save4", 1 );
	
	reqbegin("Add_Light_ds");
	reqsize(300,192);
	
	c1 = ctlchoice("",lt_c,choice_a);
    ctlposition(c1,5,5,282);
	c2 = ctlstring("Light Name",Light_n);
    ctlposition(c2,12,32,275);
	
	s0 = ctlsep(0,298);//-----------------------
    ctlposition(s0,0,58);

	c3 = ctlcheckbox("",cnt_on);
    ctlposition(c3,10,64,20,20);
	c4 = ctlchoice("",cnt_mode,choice_b);
    ctlposition(c4,30,64,257);
	
	c5 = ctlminislider("Lights to Add",NumLights,1,1000);//Generate
    ctlposition(c5,15,86,250);
	c6 = ctlchoice("",pos_mode,choice_c);//Sel
    ctlposition(c6,30,86,257);
	
	c7 = ctlchoice("Name cnt Save Mode ",var3,@"1~","Add++"@);
	ctlposition(c7,15,108,272);
	c8 = ctlminislider("Cnt Start",Num_nb,1,1000);
    ctlposition(c8,15,130,90);
    c9 = ctlchoice("",var4,@"1","01","001","0001"@);
    ctlposition(c9,134,130,153);
	
	ctlvisible(c4,"gen_act1",c5);
	ctlvisible(c4,"gen_act2",c6);
	ctlactive(c3,"cntr",c4,c5,c6,c7,c8,c9);
	
	return if !reqpost();
	
	lt_c = getvalue(c1);
	Light_n = getvalue(c2);
	cnt_on = getvalue(c3);
	cnt_mode = getvalue(c4);
	NumLights = getvalue(c5);
	pos_mode = getvalue(c6);
	
    var3 = getvalue(c7);
	Num_nb = getvalue(c8);
    var4 = getvalue(c9);
    
	reqend();
	count = Num_nb;
	
	if(cnt_on == false)
	{
	    CommandInput("AddLight " + choice_a[lt_c] + " " + Light_n);
	}
	else
	{
	    if(cnt_mode == 1)//generate
		{
		    for(i = NumLights ; i >= 1 ; i --)
			{
				Light_nn = Light_n + "_" + count.asStr(var4,true);
				CommandInput("AddLight " + choice_a[lt_c] + " " + Light_nn);
				count ++;
			}
		}
		else//select
		{
		    if(sel_Item == nil)
            {
	            error("Please select the Item.");
	            return;
            }
			for(i = sel_Size ; i >= 1 ; i --)
			{
				Light_nn = Light_n + "_" + count.asStr(var4,true);
				
				switch(pos_mode)
                {
	                case 1://none
					CommandInput("AddLight " + choice_a[lt_c] + " " + Light_nn);
	                break;
	                case 2://child
					CommandInput("AddLight " + choice_a[lt_c] + " " + Light_nn);
					ParentItem(sel_Item[i].id);
					A_pos = scn.schemaPosition(sel_Item[i].name);
                    A_pos_x = A_pos[1];
                    A_pos_y = A_pos[2];
					SchematicPosition((A_pos_x) , (-0.4+A_pos_y));
					Position(0,0,0);
					Rotation(0,0,0);
					RefreshNow();
	                CreateKey(0);

	                break;
	                case 3://same pos
					CommandInput("AddLight " + choice_a[lt_c] + " " + Light_nn);
					SameAsItem(1,1,sel_Item,i);
					/*
		            PositionItemWorld(1);
                    PositionItem(sel_Item[i].name);
                    XController(7);
                    YController(7);
                    ZController(7);
	
	                RotationItemWorld(1);
                    RotationItem(sel_Item[i].name);
                    HController(7);
                    PController(7);
                    BController(7);
					*/

	                break;
                }
				count ++;
			}
		}
	}
	
    //AddLight(1,Light_n);
	
	
	//ExcludeObject(); 含まないオブジェクト
	store( "sc", lt_c );
	store( "lc", Light_n );
	store( "co", cnt_on );
	store( "cm", cnt_mode );
	store( "pm", pos_mode );

	switch(var3)
    {
	    case 1:
	    store( "name_save2", 1 );
	    break;
	    //case 2:
	    //store( "name_save2", Num_nb );
	    //break;
	    case 2:
		if(cnt_mode == 1)
	    {
		    AddNum = Num_nb + NumLights;
		}
		else
		{
		    AddNum = Num_nb + sel_Size;
		}
	    
		
	    store( "name_save2", AddNum );
	    break;
    }
	store( "name_save3", var3 );
    store( "name_save4", var4 );
}
SameAsItem: Pos, Rot, Sel_Item, Size
{
    if(Pos == 1)
	{
	    PositionItemWorld(1);
        PositionItem(Sel_Item[Size].id);
        XController(7);
        YController(7);
        ZController(7);
	    RefreshNow();
	    CreateKey(0);
	
	    PositionItemWorld(0);
        PositionItem(0);
        XController(1);
        YController(1);
        ZController(1);
	}
	if(Rot == 1)
	{
	    RotationItemWorld(1);
        RotationItem(Sel_Item[Size].id);
        HController(7);
        PController(7);
        BController(7);
	    RefreshNow();
	    CreateKey(0);
	
	    RotationItemWorld(0);
        RotationItem(0);
        HController(1);
        PController(1);
        BController(1);
	}
}
cntr: value
{
  return(value==1);
}
gen_act1: value
{
    return(value == 1);
}
gen_act2: value
{
    return(value == 2);
}