/*
  LScript Layout
  MotHandler_ds
  LW11~
  V1.2
  Daisuke Suzuki
  History: 2024/03/24
           2014/09/28
*/

//-----------------------------------------

@name MotHandler_ds
@script generic
@version 2.6
@warnings

SavType;
generic
{
    scn = Scene();
    selected_Item = scn.getSelect();
	SavType = "ItemMotionHandler";
    if(selected_Item == nil)
    {
	  error("Please select the Item.");
	  return;
    }
	selected_size = selected_Item.size();
	cnt = selected_size - 1;
	imhlist = selected_Item[selected_size].server(SavType);
	
	var1 = recall( "MOT_H_1", 1 ) ;
	var2 = recall( "MOT_H_2", 0 ) ;
	var3 = recall( "MOT_H_3", 2 ) ;
	var4 = recall( "MOT_H_4", 1 ) ;
	var5 = recall( "MOT_H_5", 0 ) ;
	var6 = recall( "MOT_H_6", 1 ) ;
	
	choice[1] = "(none)";
	choice[2] = "LW_Expression";
	choice[3] = "FlockItemMotion";
	choice[4] = "LW_Follower";
	choice[5] = "Relativity";
	choice[6] = "NodalMotion";
	choice[7] = "nodeItemMotion";
	
	
    reqbegin("MotHandler_ds");
    reqsize(220,160);

	s0 = ctlsep(0,220);
    ctlposition(s0,0,88);
	
	c1 = ctlpopup("Name",var1,choice);
    ctlposition(c1,10,10,200,18);
	
	c2 = ctlcheckbox("",var2);
    ctlposition(c2,8,40,16,18);
	
	c3 = ctlchoice("",var3,@"Add","Delete"@);
    ctlposition(c3,24,40,186,18);
	
	c4 = ctlchoice("",var4,@"all","on","off"@);
    ctlposition(c4,24,62,186,18);
	
	c5 = ctlcheckbox("",var5);
    ctlposition(c5,8,100,16,18);
	
    c6 = ctlchoice("",var6,@"change","on","off"@);
    ctlposition(c6,24,100,186,18);
	
	ctlactive(c2,"LC1",c3,c4);
	ctlvisible(c3,"LC2",c4);
	ctlactive(c5,"LC3",c6);
	
	return if !reqpost();
	
	var1 = getvalue(c1);
	var2 = getvalue(c2);
	var3 = getvalue(c3);
	var4 = getvalue(c4);
	var5 = getvalue(c5);
	var6 = getvalue(c6);
	
	reqend();
	
    if(var5 == 1)
	{
      imh_off = true;
    }
    if(var5 == 2)
	{
      imh_on = true;
    }
	
//-----------------------------------------
	if(var1 == 1)
    {
	    warn("Please select the handler name.");
	    CommandInput("Generic_MotHandler_ds");
	    return;
    }
	
	if(var2 == 1)//add_delete_on
	{
		if(var3 == 1)
		{
		    if(choice[var1] == choice[3])//flock
	        {
		        for(i = cnt; i >= 0 ; i--)
	            {
			        if(i > 0)
			        {
	                    SelectItem(selected_Item[i].name);
	                    ApplyServer(SavType,"FlockItemMotion");
			        }
		            if(i == 0)
			        {
			            SelectItem(selected_Item[selected_size].name);
			            ApplyServer(SavType,"FlockItemMotion");
			        }
			    }
		        RefreshNow();
		        SelectItem(selected_Item[selected_size].name);
                EditServer(SavType,1);
		    }
	        if(choice[var1] != choice[3])//flock以外
		    {
		        for(i = selected_size; i >= 1 ; i--)
	            {
	                SelectItem(selected_Item[i].name);
	                ApplyServer(SavType,choice[var1]);
			    }
			        SelectItem(selected_Item[selected_size].name);
			    for(i =1 ; i < selected_size ; i++)
	            {
		            AddToSelection(selected_Item[i].name);
			    }
		    }
		}
		else//Delete
		{
		    if(imhlist == nil)
	        {
		        error("Modifire list is empty.");
	            return;
	        }
		    for(i = selected_size; i >= 1 ; i--)
	        {
	            SelectItem(selected_Item[i].name);
		        counter = size(imhlist);
				cntr = 1;
				
                for(x = 1; x <= counter; x++)
                {
                    imhlist = selected_Item[i].server(SavType);
					switch(var4)
	                {
		                case 1://allDel
						
					    if(imhlist[cntr] == choice[var1])
                        {
							RemoveServer(SavType,cntr);
                        }
						else
						{
						    cntr++;
						}
						
		                break;
				        case 2://onDel
					    isDisabled = selected_Item[i].serverFlags( SavType, cntr );
						if(imhlist[cntr] == choice[var1])
                        {
							if(isDisabled == 0)
			                {
			                    RemoveServer(SavType,cntr);
			                }
							else
							{
							    cntr++;
							}
                        }
						else
						{
						    cntr++;
						}
			            
		                break;
				        case 3://offDel
					    isDisabled = selected_Item[i].serverFlags( SavType, cntr );
						if(imhlist[cntr] == choice[var1])
                        {
							if(isDisabled == 1)
			                {
			                    RemoveServer(SavType,cntr);
			                }
							else
							{
							    cntr++;
							}
                        }
						else
						{
						    cntr++;
						}
		                break;
				    }
                }
				
		    }
		    SelectItem(selected_Item[selected_size].name); 
		    for(i =1 ; i < selected_size ; i++)
	        {
		        AddToSelection(selected_Item[i].name);
		    }
		}
	}

	if(var5 == 1)//ON OFF CHANGE
	{
		if(imhlist == nil)
	    {
		    error("Modifire list is empty.");
	        return;
	    }
		for(i = selected_size; i >= 1 ; i--)
	    {
		    SelectItem(selected_Item[i].name);
		    counter = size(imhlist);
			cntr = 1;
		    switch(var6)
	        {
		        case 1://change
			    for(x = 1; x <= counter; x++)
                {
			        isDisabled = selected_Item[i].serverFlags( SavType, x );
					if(imhlist[x] == choice[var1])
                    {
						if(isDisabled == 1)
			            {
			                EnableServer(SavType,x,1);
			            }
						else
						{
							EnableServer(SavType,x,0);
						}
                    }
			    }
		        break;
			    case 2://on
				editSav( counter, imhlist, choice[var1], SavType, isDisabled, 1);
			    
		        break;
			    case 3://off
			    editSav( counter, imhlist, choice[var1], SavType, isDisabled, 0);
		        break;
		    }
	    }
	    SelectItem(selected_Item[selected_size].name); 
	    for(i =1 ; i < selected_size ; i++)
	    {
	        AddToSelection(selected_Item[i].name);
	    }
	}
	store( "MOT_H_1", var1 );
	store( "MOT_H_2", var2 );
	store( "MOT_H_3", var3 );
	store( "MOT_H_4", var4 );
	store( "MOT_H_5", var5 );
	store( "MOT_H_6", var6 );
}
editSav: cnt, list, moth, Svtype, isDisabled, num
{
    for(x = 1; x <= cnt; x++)
    {
        if(list[x] == moth)
        {
			EnableServer(Svtype,x,num);
        }
    }
}
LC1: value
{
  return(value==1);
}
LC2: value
{
  return(value==2);
}
LC3: value
{
  return(value==1);
}