/*
  LScript Layout
  SplitTail_ds
  V1.01
  Daisuke Suzuki
  History: 2024/10/06
*/

//-----------------------------------------

@name SplitTail_ds
@script generic
@version 2.6
@warnings

generic
{
    ParentInPlace(true);
	scn = Scene();
    Sel_Item = scn.getSelect();
    Sel_Size = Sel_Item.size();
	Sel_Gns = Sel_Item[Sel_Size].genus;
	sel_n = Sel_Item[Sel_Size].name;
	A_pos = scn.schemaPosition(sel_n);
	A_pos_x = A_pos[1];
    A_pos_y = A_pos[2];
	add_y = -0.25;
	Sel_Pos = Sel_Item[Sel_Size].getPosition(0);
	Sel_Rot = Sel_Item[Sel_Size].getRotation(0);
	
	if(Sel_Gns != 4)
    {
	  error("Please select the bone.");
	  return;
    }
	if(Sel_Size != 1)
    {
	  error("Please select one bone.");
	  return;
    }
	
	var var1 = recall( "name_save1", "" );
	var var2 = recall( "name_save5", 2 );
	var var3 = recall( "name_save2", 1 );
    var var4 = recall( "name_save3", 1 );
    var	Num_nb = recall( "name_save4", 1 );
	
	reqbegin("SplitTail_ds");
	reqsize(250,135);
	c1 = ctlstring("Name",var1);
    ctlposition(c1,12,8,230);
	c2 = ctlminislider("Cnt Start",Num_nb,1,1000);
    ctlposition(c2,12,78,90);
    c3 = ctlchoice("",var3,@"1","01","001","0001"@);
    ctlposition(c3,122,78,120);
    c4 = ctlchoice("Count Save Mode    ",var4,@"1~","Fix","Add++"@);
    ctlposition(c4,12,56,230);
	c5 = ctlminislider("Add bone count",var2,2,1000);
    ctlposition(c5,36,34,184);
	
	return if !reqpost();

    var1 = getvalue(c1);
	var2 = getvalue(c5);
    Num_nb = getvalue(c2);
    var3 = getvalue(c3);
    var4 = getvalue(c4);
    reqend();
	if(var1 == nil)
    {
	  warn("Please teach a name.");
	  CommandInput("Generic_SplitTail_ds");
	  return;
    }
    count = Num_nb;
	count2 = Num_nb;
	
	
	BRLength = Sel_Item[Sel_Size].restlength;
	wr = 2;
	scm_Cnt = 1;
	oya = Sel_Item[Sel_Size].parent;
	
	for(i = 1 ; i <= var2 ; i ++)
	{
	    if(i == 1)
		{
		    oya = Sel_Item[Sel_Size].parent;
			SelectItem(oya.id);
			if(oya.genus == 1)
			AddBone(var1+"_"+count.asStr(var3,true));
			else
			AddChildBone(var1+"_"+count.asStr(var3,true));
			Position(Sel_Pos.x,Sel_Pos.y,Sel_Pos.z);
			Rotation(Sel_Rot.h,Sel_Rot.p,Sel_Rot.b);
			RefreshNow();
			CreateKey(0);
			SchematicPosition((A_pos_x + 1.0) , (A_pos_y));
			BoneRestLength(BRLength / wr);
		}
		else
		{
		    AddChildBone(var1+"_"+count.asStr(var3,true));
			SchematicPosition((A_pos_x + 1.0) , (A_pos_y + (add_y * scm_Cnt)));
			BoneRestLength(BRLength / wr);
			scm_Cnt++;
		}
		wr++;
		count++;
	}
	//ここまでは親から子へ徐々に小さくしたボーンを生成したが、元のスケールと合っていない。
	//以下はスケールを合わせていく。
	
	//現在のボーン全長を計測
	AddChildBone(var1+"_end");
	RefreshNow();
	ParentItem(sel_n);
	CreateKey(0);
	scn = Scene();
    Sel_zt = scn.getSelect();
	zt_Z = Sel_zt[1].getPosition(0).z;
	hiritu = BRLength / zt_Z;
	ClearSelected(1);
	
	for(i = 1 ; i <= var2 ; i ++)
	{
	    if(i == 1)
		{
		    SelectItem(var1+"_"+count2.asStr(var3,true));
			scn = Scene();
            Selected_Item = scn.getSelect();
            Selected_Size = Sel_Item.size();
			BRLength2 = Selected_Item[Selected_Size].restlength;
			koteityo = BRLength2 * hiritu;
			BoneRestLength(koteityo);
		}
		else
		{
		    SelectItem(var1+"_"+count2.asStr(var3,true));
			Position(0,0,koteityo);
			RefreshNow();
			CreateKey(0);
			scn = Scene();
            Selected_Item = scn.getSelect();
            Selected_Size = Sel_Item.size();
			BRLength2 = Selected_Item[Selected_Size].restlength;
			koteityo = BRLength2 * hiritu;
			BoneRestLength(koteityo);
		}
		count2++;
	}
	
	store( "name_save1", var1 );
	store( "name_save5", var2 );
    store( "name_save2", var3 );
    store( "name_save3", var4 );
    switch(var4)
    {
	    case 1:
	    store( "name_save4", 1 );
	    break;
	    case 2:
	    store( "name_save4", Num_nb );
	    break;
	    case 3:
	    AddNum = Num_nb + Sel_Size;
	    store( "name_save4", AddNum );
	    break;
    }
}