/*   setFX_Sheet_CS4 v2.0   2009.05.09

      ・TimeSheet_forMac(Win)関係のAE CS4スクリプト用セットアップ・スクリプト。
      ・コンポ内の選択レイヤー(連番ファイル)に対して各エフェクトを適用後、情報を書き出しTimeSheetアプリを起動します。
      ・既に該当のエフェクトが適用されている場合や、何もレイヤーを選択していない状態だと、既にエフェクトがあるレイヤーのみ
      ・情報を書き出してTimeSheetへ移行します。
      ・Windows & Mac 両対応。
      
      
      AfterEffects CS4 のみ動作確認済
      Windows XP Professional SP3 / MacOS 10.5.6 のみ動作確認済
*/




//==========File Path ※違う場合は必ず書き換えてください=====================================================================

var smPath = null;

if(File.fs == "Windows"){
	
    //プラグインフォルダのパス(Win)
    smPath = "C:/Program Files/Adobe/Adobe After Effects CS4/Support Files/Plug-ins/smooth";
    
    //スクリプトのパス(Win)
    scFile = "C:/Program Files/Adobe/Adobe After Effects CS4/Support Files/Scripts/TimeSheet_CS4_forWin/(TS_Scripts)/exportSheet_CS4.jsx";    
    
}else if(File.fs == "Macintosh"){
	
    //プラグインフォルダのパス(Mac)
    smPath  = "/Applications/Adobe After Effects CS4/Plug-ins/smooth after AE7.0";
    
    //スクリプトのパス(Mac)
    scFile  = "/Applications/Adobe After Effects CS4/Scripts/TimeSheet_CS4_forMac/(TS_Scripts)/exportSheet_CS4.jsx";    

}	

//=======================================================================================



var actComp = app.project;
var actItem = actComp.activeItem;
var fRate = actItem.frameRate;   
var valSM = null;
var activeCompDuration = actItem.duration;

//===========main script===================================================================


    if(actItem != "[object CompItem]" || actItem == null)
    {
            alert("******コンポが選ばれていません******");
    }else
    {   	
    	if(fRate != 24 && fRate != 30){
    		alert("******コンポのフレームレートを 24fr か 30fr にしてください******");
    	}else
    	{
    		
           var actLys = actItem.selectedLayers;
           var allLys = actItem.layers;
           var lyTime = actItem.duration;
           var lyFr = lyTime*actItem.frameRate;    	
       
       
           if(actLys.length > 11){
            	alert("******レイヤーの選択数を１１以下にしてください******");
           }else{
       
    	       chkSM();
    	  
    	       app.beginUndoGroup("setFX_Sheet");
    	  
    	       //レイヤーを選択していた場合、エフェクトを適用
    	       if(actLys.length > 0)
    	       {          		
    	              //"smooth"プラグインがある場合
                      if(valSM)
                      {
                        appTSFX_SM();
                        
    	              //"smooth"プラグインが無い場合
                      }else
                      {
                        appTSFX();              	
                      }                      

        	   }
        	
        	   //"export_Sheet.jsx" を実行 (レイヤー選択の有無に関係なく)
        	   scriptExecute();
        	
               app.endUndoGroup();
             
           }
    	}
    	
    }
    
    
    
    
    
//*********FUNCTION**************************************************************

function chkSM(){
	
//"smooth" プラグインがインストールされているかどうか

	
	fileObj = new File(smPath);
	
	if(fileObj.exists)
	{
              valSM = true;
	}else
	{
		      valSM = false;
	}

}

//********************************************************************************

function chkTSFX_SM( curLayer ){
			
//		TSエフェクトの適用状態をチェック ("smooth"がある場合)


		tsFxflag = [0,0,0,0];
		for( f = 1; f <= curLayer.property("Effects").numProperties; f++ )
		{
			switch ( curLayer.property("Effects")(f).name )
			{
				case "TS_スライダ制御"		 : tsFxflag[0] = f; break;
				case "TS_トランスフォーム"	 : tsFxflag[1] = f; break;
				case "TS_カラーキー"		 : tsFxflag[2] = f; break;	
				case "TS_smooth"		 : tsFxflag[3] = f; break;
			}
		}
}

//********************************************************************************

function chkTSFX( curLayer ){
			
//		TSエフェクトの適用状態をチェック ("smooth"が無い場合)


		tsFxflag = [0,0,0];
		for( f = 1; f <= curLayer.property("Effects").numProperties; f++ )
		{
			switch ( curLayer.property("Effects")(f).name )
			{
				case "TS_スライダ制御"		 : tsFxflag[0] = f; break;
				case "TS_トランスフォーム"	 : tsFxflag[1] = f; break;
				case "TS_カラーキー"		 : tsFxflag[2] = f; break;	
			}
		}
}

//********************************************************************************

		function appTSFX_SM(){
			
//		タイムリマップとTSエフェクトを適用 ("smooth"がある場合)


		for( i = 0; i < actLys.length; i++ )
		{
			var curLayer = actLys[i];
			
			if ( curLayer.canSetTimeRemapEnabled == true )
			{
				if ( curLayer.timeRemapEnabled != true )
				{
					curLayer.timeRemapEnabled = true;
					curLayer.timeRemap.removeKey(2);
					curLayer.startTime = 0;
					curLayer.outPoint = activeCompDuration;
				}
			}
			else
			{
				curLayer.startTime = 0;
				curLayer.outPoint = activeCompDuration;
			}
			
			chkTSFX_SM( curLayer );
			//alert(tsFxflag.toString());
			
			var tsTransformExp = "if ( effect("+"\""+"TS_スライダ制御"+"\""+").param("+"\""+"スライダ"+"\""+") == 0 ) { 0 } else { 100 }";
			var tsTimeRimapExp = "( effect("+"\""+"TS_スライダ制御"+"\""+").param("+"\""+"スライダ"+"\""+") - 1 ) * ( this_comp.frame_duration )";
			
			if ( tsFxflag[0] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("スライダ制御");
				curFx.name = "TS_スライダ制御";
				curFx(1).addKey(0);
				curFx.moveTo(1);
				if ( tsFxflag[1] != 0 && curLayer.property("Effects")("TS_トランスフォーム")(9).expression.indexOf("TS_スライダ制御") != -1 )
				{
					curLayer.property("Effects")("TS_トランスフォーム")(9).expressionEnabled = true;
				}
			}
			
			if ( tsFxflag[1] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("トランスフォーム");
				curFx.name = "TS_トランスフォーム";
				curFx(9).expression = tsTransformExp;
				curFx.moveTo(curLayer.property("Effects")("TS_スライダ制御").propertyIndex+1);
			}
			
			if ( tsFxflag[2] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("カラーキー");
				curFx.name = "TS_カラーキー";
				curFx(1).setValue([1,1,1,1]);
				curFx.moveTo(curLayer.property("Effects")("TS_トランスフォーム").propertyIndex+1);
			}
			
			if ( tsFxflag[3] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("smooth");
				curFx.name = "TS_smooth";
				curFx(1).setValue(true);
				curFx(3).setValue(1);
				curFx.moveTo(curLayer.property("Effects")("TS_カラーキー").propertyIndex+1);
			}
			
			if ( curLayer.canSetTimeRemapEnabled == true && curLayer.timeRemap.expressionEnabled != true )
			{ curLayer.timeRemap.expression = tsTimeRimapExp; }
		}
}

//********************************************************************************

		function appTSFX(){
			
//		タイムリマップとTSエフェクトを適用 ("smooth"が無い場合)


		for( i = 0; i < actLys.length; i++ )
		{
			var curLayer = actLys[i];
			
			if ( curLayer.canSetTimeRemapEnabled == true )
			{
				if ( curLayer.timeRemapEnabled != true )
				{
					curLayer.timeRemapEnabled = true;
					curLayer.timeRemap.removeKey(2);
					curLayer.startTime = 0;
					curLayer.outPoint = activeCompDuration;
				}
			}
			else
			{
				curLayer.startTime = 0;
				curLayer.outPoint = activeCompDuration;
			}
			
			chkTSFX( curLayer );
			//alert(tsFxflag.toString());
			
			var tsTransformExp = "if ( effect("+"\""+"TS_スライダ制御"+"\""+").param("+"\""+"スライダ"+"\""+") == 0 ) { 0 } else { 100 }";
			var tsTimeRimapExp = "( effect("+"\""+"TS_スライダ制御"+"\""+").param("+"\""+"スライダ"+"\""+") - 1 ) * ( this_comp.frame_duration )";
			
			if ( tsFxflag[0] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("スライダ制御");
				curFx.name = "TS_スライダ制御";
				curFx(1).addKey(0);
				curFx.moveTo(1);
				if ( tsFxflag[1] != 0 && curLayer.property("Effects")("TS_トランスフォーム")(9).expression.indexOf("TS_スライダ制御") != -1 )
				{
					curLayer.property("Effects")("TS_トランスフォーム")(9).expressionEnabled = true;
				}
			}
			
			if ( tsFxflag[1] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("トランスフォーム");
				curFx.name = "TS_トランスフォーム";
				curFx(9).expression = tsTransformExp;
				curFx.moveTo(curLayer.property("Effects")("TS_スライダ制御").propertyIndex+1);
			}
			
			if ( tsFxflag[2] == 0 )
			{
				var curFx = curLayer.property("Effects").addProperty("カラーキー");
				curFx.name = "TS_カラーキー";
				curFx(1).setValue([1,1,1,1]);
				curFx.moveTo(curLayer.property("Effects")("TS_トランスフォーム").propertyIndex+1);
			}
			
			
			if ( curLayer.canSetTimeRemapEnabled == true && curLayer.timeRemap.expressionEnabled != true )
			{ curLayer.timeRemap.expression = tsTimeRimapExp; }
		}
}

//********************************************************************************

function scriptExecute(){

//		スクリプトファイルの実行


		var scriptFileName = new File( scFile );
		scriptFileName.open();
		eval(scriptFileName.read());
		scriptFileName.close();
}