﻿/*   CompLayers_Sorting   Ver.2.0 2009.10.09

      ・アクティブコンポ内のレイヤーを指定フレームずつ階段状に並べます。
      ・[Current Fr. Start]にチェックがあればカレントフレームから、
      　チェックが無ければコンポの頭に合わせて並べます。
      ・[inPoint ONLY]または[outPoint ONLY]にチェックがあれば、そのポイントのみ並べます。
      　指定外の方はコンポの頭・尻それぞれに合わせます。

       ===========注意点===============
       "アクティブコンポ"が対象なので、プロジェクトやタイムライン,ウインドウのどれがアクティブかによって
       指定されるコンポが変わってしまいます。
       ダイアログの上部に指定されたコンポ名が出るので、確認しながらの実効をお勧めします。
       
       
       =動作確認済=
       
       AfterEffects 6.5 & CS4        Windows XP sp3
       
       AfterEffects 6.5                Mac OS 10.4.11 
       
       AfterEffects CS4               Mac OS 10.5.7
       

       
       curry_eggs@yahoo.co.jp        curryegg
*/



// **** Main Script ***************************************************************************************************************


(function(){

    var actComp = app.project;
    actItem = actComp.activeItem;


    if(actItem == null)
    {
         alert("******コンポが選ばれていません******");
    }else{

         var targetCompName = actItem.name;
         var CurTime = actItem.time;
         var fFr;
         var eFr;
         var CurFr = CurTime*actItem.frameRate;
         CompDur = actItem.duration;

         //alert(CurFr);


         BuildAndShowDialog(targetCompName);

         if(Btnon == "Cancel")
         {
              alert("******キャンセルされました******");

         }else{
                app.beginUndoGroup("CompLayers_Sorting");
                
                compLys = actItem.layers;
                nCompLys = compLys.length;
                //alert(eachFrEdit.text);


    //カレントフレームからかどうか

                if(sBox == true){fFr = CurFr+1; eFr = CurFr+1;}else{fFr = 1; eFr = CompDur*actItem.frameRate;}

    //ソート選択
               if(sortingA.value==true){DownSorting(fFr, eFr, LyDur);}else if(sortingB.value==true){UpSorting(fFr, eFr, LyDur);}

                actItem.time = CurTime;
            
                app.endUndoGroup();
         }
    }

})();


//*********************Dialog**************************************

		function BuildAndShowDialog(targetCompName)
{
		dlg = new Window ( "dialog" , "CompLayers Sorting  -Ver2.0-" , [0,0,448,240] );
		
		compNameCaption = dlg.add( "statictext" , [16,16,180,36] , "Composition Name :" ); compNameCaption.justify="right";
		compName = dlg.add( "statictext" , [190,16,432,36] , targetCompName );

		panelMain = dlg.add( "panel" , [16,44,432,190] , "Sorting Pallet" );

                        sortingA = panelMain.add( "radiobutton" , [16,24,90,44] , "↓" ); sortingA.value = true;
                        sortingA.helpTip = "※ 降順";
                        sortingB = panelMain.add( "radiobutton" , [16,54,90,74] , "↑" );
                        sortingB.helpTip = "※ 昇順";
                        
			            siChkBox = panelMain.add( "checkbox" , [100,20,235,60] , "(OFF) Layer StartTime" ); siChkBox.value = false; siChkBox.visible = false;
			            siChkBox.helpTip = "※ OFFの場合、レイヤーのStartTimeに対して適用";

		panelSub = panelMain.add( "panel" , [250,20,400,120] , "Option Select" );
                        inBtn = panelSub.add( "radiobutton" , [10,15,140,35] , "Set InPoint ONLY" ); inBtn.value = false;
                        outBtn = panelSub.add( "radiobutton" , [10,40,140,60] , "Set OutPoint ONLY" ); outBtn.value = false;
                        InOutBtn = panelSub.add( "radiobutton" , [10,65,140,85] , "Set In and Out" ); InOutBtn.value = true;


			eachFrCaption = panelMain.add( "statictext" , [13,85,55,105] , "Each Fr." ); eachFrCaption.justify="left";
			eachFrEdit = panelMain.add( "edittext" , [60,82,105,102] , "1" ); eachFrEdit.justify="center";
			
			durationCaption = panelMain.add( "statictext" , [120,85,170,105] , "Duration" ); durationCaption.justify="left";
			durationEdit = panelMain.add( "edittext" , [175,82,215,102] , "1" ); durationEdit.justify="center";
			
			fitCaption = panelMain.add( "statictext" , [120,60,220,73] , "- Another Point -" ); fitCaption.justify="left"; fitCaption.visible = false;
			fitChkBox = panelMain.add( "checkbox" , [120,75,220,105] , "Fit Composition" ); fitChkBox.value = false; fitChkBox.visible = false;
			fitChkBox.helpTip = "※ もう片方のポイントをコンポ尺に合わせる";
			
            startChkBox = panelMain.add( "checkbox" , [18,110,180,130] , "Current Fr. Start" ); startChkBox.value = false;
			startChkBox.helpTip = "※ 現在のフレームを基準に適用";
			
			
			InOutBtn.onClick = function() {
				                                     durationCaption.visible = true;
				                                     durationEdit.visible = true;
                                                     fitChkBox.visible = false;
				                                     fitCaption.visible = false;
				                                     siChkBox.visible = false;
			                                     }
			                                     
			
			inBtn.onClick = function() {
				                                     durationCaption.visible = false;
				                                     durationEdit.visible = false;
                                                     fitChkBox.visible = true;
				                                     fitCaption.visible = true;
				                                     siChkBox.visible = true;
			                                 }
			                                 
			outBtn.onClick = function() {
				                                     durationCaption.visible = false;
				                                     durationEdit.visible = false;
				                                     fitChkBox.visible = true;
				                                     fitCaption.visible = true;
				                                     siChkBox.visible = false;
			                                  }


           siChkBox.onClick = function() {
           	                                         if(siChkBox.value == true){
           	                                         	siChkBox.text = "(ON) Layer InPoint";
           	                                         	siChkBox.helpTip = "※ ONの場合、レイヤーのInPointに対して適用";
           	                                         }else{
           	                                         	siChkBox.text = "(OFF) Layer StartTime";
           	                                         	siChkBox.helpTip = "※ OFFの場合、レイヤーのStartTimeに対して適用";
           	                                         }
                                                 }
		
		cancelBtn = dlg.add( "button" , [230,204,326,229], "Cancel" , {name:"cancel"});
		okBtn = dlg.add( "button" , [336,204,432,229] , "OK" , {name:"ok"} );
		
		okBtn.onClick = function(){
			                                Btnon = "OK";
			                                LyDur = durationEdit.text;
			                                eFrame = eachFrEdit.text;
			                                sBox = startChkBox.value;
			                                fBox = fitChkBox.value;
			                                siBox = siChkBox.value;
			                                dlg.close();
		                                }
		                                
		cancelBtn.onClick = function(){
			                                     Btnon = "Cancel";
			                                     dlg.close();
		                                     }
		                                     
	    dlg.onClose = function() {
	    	                              if(Btnon == null){
	    	                              	dlg.close();
	    	                              	Btnon = "Cancel";
	    	                              }
	                                  }
		                                     
		                                     
		dlg.center();
		dlg.show();

}

//***************************************************************************************************************
//上から並べる
function DownSorting(fFr, eFr, LyDur)
{
uu=0;
for(i=1;i<=nCompLys;i++)
{
          if(compLys[i].locked == false)
          {
                  //alert(compLys[i].name);

//指定フレームの長さで指定フレームずつ並べる
               if(InOutBtn.value==true)
               {                  
                  var ValFr = fFr+((uu*eFrame)-1);
                  if(ValFr < 0){ValFr = 0;}
                  var ValTm = setFrs(ValFr, actItem.frameRate);
                  compLys[i].startTime = ValTm;

                  outFr = eval(ValFr)+eval(LyDur);
                  var endValTm = setFrs(outFr, actItem.frameRate);
                  //alert(outFr);
                  compLys[i].outPoint = endValTm;
                  uu++;
//inPointのみ指定フレームずつ並べる
                }else if(inBtn.value==true)
                {
                  var ValFr = fFr+((uu*eFrame)-1);
                  if(ValFr < 0){
                  	ValFr = 0;
                  }else if(fBox && ValFr >= (CompDur*actItem.frameRate)-1){
                  		ValFr = (CompDur*actItem.frameRate)-2;
                  }
                  var ValTm = setFrs(ValFr, actItem.frameRate);
                  if(siBox){
                  	compLys[i].inPoint = ValTm;
                  }else{
                      compLys[i].startTime = ValTm;
                  }
                  
				if(fBox){compLys[i].outPoint = CompDur;}
                  uu++;
//outPointのみ指定フレームずつ並べる
                }else if(outBtn.value==true)
                {

                  var ValFr = (eFr-(uu*eFrame))-1;
                  if(fBox && ValFr < 1){ValFr = 1;
                  }else if(!fBox && ValFr <= (compLys[i].startTime*actItem.frameRate)){
                  	ValFr = (compLys[i].startTime*actItem.frameRate)+1;
                  }else{
                  	ValFr = ValFr+1;
                  }
                          var ValTm = setFrs(ValFr, actItem.frameRate);
						  
			        	if(fBox){compLys[i].startTime = setFrs(0, actItem.frameRate);}

                          compLys[i].outPoint = ValTm;
                          uu++;
                  
                }
          }
}

}

//***************************************************************************************************************
//下から並べる
function UpSorting(fFr, eFr, LyDur)
{
uu=0;
for(i=0;i<nCompLys;i++)
{


          q = nCompLys-i;
          if(compLys[q].locked == false)
          {
                  //alert(compLys[q].name);

//指定フレームの長さで指定フレームずつ並べる
               if(InOutBtn.value==true)
               {                  
                  var ValFr = fFr+((uu*eFrame)-1);
                  if(ValFr < 0){ValFr = 0;}
                  var ValTm = setFrs(ValFr, actItem.frameRate);
                  compLys[q].startTime = ValTm;

                  outFr = eval(ValFr)+eval(LyDur);
                  var endValTm = setFrs(outFr, actItem.frameRate);
                  //alert(outFr);
                  compLys[q].outPoint = endValTm;
                  uu++;
//inPointのみ指定フレームずつ並べる
               }else if(inBtn.value==true)
               {
                  var ValFr = fFr+((uu*eFrame)-1);
                  if(ValFr < 0){
                  	ValFr = 0;
                  }else if(fBox && ValFr >= (CompDur*actItem.frameRate)-1){
                  		ValFr = (CompDur*actItem.frameRate)-2;
                  }
                  var ValTm = setFrs(ValFr, actItem.frameRate);
                  if(siBox){
                  	compLys[q].inPoint = ValTm;
                  }else{
                      compLys[q].startTime = ValTm;
                  }

				if(fBox){compLys[q].outPoint = CompDur;}
                  uu++;
//outPointのみ指定フレームずつ並べる
               }else if(outBtn.value==true)
               {

                  var ValFr = (eFr-(uu*eFrame))-1;
                  if(fBox && ValFr < 1){ValFr = 1;
                  }else if(!fBox && ValFr <= (compLys[q].startTime*actItem.frameRate)){
                  	ValFr = (compLys[q].startTime*actItem.frameRate)+1;
                  }else{
                  	ValFr = ValFr+1;
                  }
                  
                         var ValTm = setFrs(ValFr, actItem.frameRate);
						 
			       	if(fBox){compLys[q].startTime = setFrs(0, actItem.frameRate);}

                         compLys[q].outPoint = ValTm;
                         uu++;

              }
          }
}

}

//********************************************************************************************************************************

function setFrs(targetFrames, compFrameRate){
	
	var AEVersion=app.version.split(".")[0]*1+app.version.split(".")[1]*.1;
	
	if(AEVersion<7.0)
    {
	    //(1/2^n)を合成して近似値を求める
		var myTargetDuration=targetFrames / compFrameRate;
		var replayCount=18;//初期係数設定値に誤差がある場合はこの値をフォールダウン
        //再帰処理ループ
		while(true)
		{
			var myDuration=myTargetDuration;//再初期化
			var coc=new Array();
			for (cO=0;cO<replayCount;cO++)
			{
				coc[cO]=Math.floor(myDuration);
				if(myTargetDuration%(1/Math.pow(2,cO))==0)
				{
					//割り切れたので終了
					break;
				}else{
					myDuration=(myDuration%1)*2;
				}
			}
			myDuration=0;//使い終わったので再初期化して流用
			for (c=0;c<coc.length;c++)
			{
				myDuration+=(1/Math.pow(2,c))*coc[c];
			}
            //コンポに時間を設定する
			this.duration=myDuration;
            //継続時間が設定値と異なる場合は、設定失敗なので係数を1つ下げて再度トライする
			if(this.duration!=myDuration){replayCount--;continue;}else{break;};
		}
		return this.duration;
		
	//AE7.0以降用同機能コード AE7以降は、同バグがFIXされている為上記のコードは副作用があるので注意
    }else{
    	this.duration = targetFrames / compFrameRate; 
    	return this.duration;
    }
    
}

//***************Function END********************************************************************************************

