//    ReplaceFiles_SameDirectory  ver.1.1  2010.07.07
//
//
//    選択した複数フッテージを一気に "ファイルの置き換え" します。
//
//    選択したフッテージと置き換えるファイルのフォルダの構造が、同じであることが必須
//
//    ファイルやファイルの親フォルダの名前に "_r" や "_R" がある場合は、ドロップダウンリストで選択できます。
//   
//   
//
//
//    =動作確認=
//
//    AfterEffects CS4
//
//    windows XP sp3  &  mac OS 10.5.6
//
//
//   email:   curry_eggs@yahoo.co.jp       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_egg
//
//
//

{
	
	
	//main
	
	app.beginUndoGroup("ReplaceFiles");
	
	ReplaceFiles(this);
	
	app.endUndoGroup();
	
	
	
	
	function ReplaceFiles(thisObj)
	{
		function reFiles()
		{
			//*****ここに登録すると、<入れ替え前フォルダ名 + 追加ネーム>のフォルダ名が、入れ替え先フォルダの対象になります*****
			//入れ替え先フォルダ名の追加ネーム
			this.chrAry = [ "_r", "_R" ];
			
			this.impObj = app.project.items;
			this.selF = new Array();
			this.selFN = new Array();
			this.selFP = new Array();
			this.selP = new Array();
			this.selPN = new Array();
			this.selPath = new Array();
			this.sepObj = new Array();
			this.valCount = 0;
			
			this.valE = false;
			this.valEE = false;
			this.defFol = null;
			
			this.celP = new Array();
			this.cFol = new Array();
			this.cFolN = new Array();
		}
		
		reFiles.prototype =
		{
			sepF: function()
			{
				x=0;
				for(y=1;y<this.impObj.length+1;y++)
				{
					//選択アイテムかどうか
					if(this.impObj[y].selected)
					{
						//フッテージかどうか
				      	if(this.impObj[y].toString() == "[object FootageItem]")
					    {
					    	//平面以外なら取得
					    	if(this.impObj[y].mainSource.toString() != "[object SolidSource]")
					    	{
						    	this.selF[x] = this.impObj[y];
						    	this.selFP[x] = this.impObj[y].file;
						    	this.selFN[x] = this.impObj[y].file.name;
				    	        this.selP[x] = this.impObj[y].file.parent;
				    	        this.selPN[x] = this.impObj[y].file.parent.name;
				    	        this.selPath[x] = this.impObj[y].file.parent;
				    	        x++;
					    	}
				    	}
					}
				}
				
				//選択フッテージが２つ以上の場合
			    if(this.selF.length > 1){
			    	this.chkDefFol();
			    	
			    	if(!this.valE){
				    	this.celPath();
				    	
				    	this.chgPath();
			    	}
			    	
			    }else{
			    	this.valE = true;
			    	alert("******フッテージを２つ以上選択してください******");
			    }
			},
			
			chkDefFol: function()
			{
				var fiPath = this.selP[0];
				var curPath = new Array();
				curPath = this.selP;
				var valP = false;
				
				//各ファイルの共通の階層の親をひたすら探す
			    var ii = 0;
				do{
					
			        valP = false;
			        
					for(var i=1;i<curPath.length;i++){
						//親が同じ階層のものかどうか
						if(String(fiPath) != String(curPath[i])){
							valP = true;
							if(!this.valE && curPath[i] != null){
								curPath[i] = new File(curPath[i]).parent;
							}else{
								this.valE = true;
								valP = false;
							}
						}
					}
					
					if(!this.valE){
						//親が同じ階層のものじゃ無かった場合、１つ上の階層へ
						if(valP){
							fiPath = new File(fiPath).parent;
						//親が同じ階層のものだった場合
						}else{
							this.defFol = fiPath;
						}
				        
				        ii++;
					}
			        
				}while(valP);
				
				if(this.valE){
					alert("******選択したファイルの親フォルダが、異なる階層にあります******");
				}
			},
			
			celPath: function()
			{
				
				for(var i=0;i<this.selP.length;i++){
					if(String(this.selPath[i]) == String(this.defFol)){
						this.celP[i] = String(this.selFP[i]).split(this.defFol)[1];
					}else{
						this.celP[i] = String(this.selPath[i]).split(this.defFol)[1];
					}
				}
			
			},
			
			chgPath: function()
			{
				//フォルダ・セレクト・ダイアログ
				var folderPath = new Folder(this.defFol).selectDlg("各ファイルの共通の親フォルダを選択してください");
				
				//フォルダが選択されてたら
				if(folderPath != null){
					//フォルダ内のリストを取得
					var cFolList = folderPath.getFiles();
					var valB = false;
					var q = 0;
					for(var i=0;i<this.selF.length;i++){
						var qq = 0;
						var valF = false;
						for(ii=0;ii<cFolList.length;ii++){
							var valCA = false;
							var curTarget = null;
							
							//共通フォルダが直親だった場合 (共通フォルダ直下にファイルがある場合)
							if(this.defFol.name.toString() == this.selPN[i]){
								curTarget = this.selFN[i].split(".")[0];
							}else{
								curTarget = this.selPN[i];
							}
							//リスト内のファイルから追加ネームを検索
							for(var iii=0;iii<this.chrAry.length;iii++){
								if(cFolList[ii].name.indexOf(curTarget + this.chrAry[iii]) != -1){
										valCA = true;
										break;
								}
							}
									
							//追加ネームがあった場合
							if(valCA){
								if(qq==0){
									this.cFolN[q] = new Array();
									//配列の最初に元のフォルダ(ファイル)名
									this.cFolN[q][0] = curTarget;
									
									this.cFol[q] = new Array();
									cFile = new File(String(folderPath) + String(this.celP[i]));
									if(cFile.exists){
										this.cFolN[q][1] = curTarget;
										this.cFol[q][0] = i;
										this.cFol[q][1] = String(folderPath) + String(this.celP[i]);
										qq = 2;
									}else{
										this.cFol[q][0] = i;
										qq = 1;
									}
								}
								this.cFol[q][qq] = String(cFolList[ii]);
								this.cFolN[q][qq] = cFolList[ii].name;
								qq++;
								valF = true;
								valB = true;
							}
						}
						
						if(!this.valE){
							//追加ネームがあったら繰り上げ
							if(valF){
								q++;
							//追加ネームがなかったら、入れ替え
							}else{
								var newFile = null;
								//連番ファイルじゃない場合
								if(this.selF[i].duration == 0){
									//直親フォルダの場合
									if(this.celP[i].toString().lastIndexOf(".") == -1){
										newFile = new File(String(folderPath) + String(this.celP[i]) + "/" + this.selFN[i]);
									//ファイルの場合
									}else{
										newFile = new File(String(folderPath) + String(this.celP[i]));
									}
								//連番ファイルの場合
								}else{
									newFile = new File(String(folderPath) + String(this.celP[i]));
								}
					
								//alert(newFile);
								
								//ファイルがあったら入れ替え
								if(newFile.exists){
									this.selF[i].replace(newFile);
									this.valCount++;
								}
							}
						}else{
							break;
						}
					}
					
					if(!this.valE){
						//追加ネームがあった場合は、ダイアログをビルド
						if(valB){
							this.bldUI();
						}else{
							//情報パネル表示
							clearOutput();
							writeLn( "ReplaceFiles Info:" );
							writeLn( this.valCount.toString() + "個のフッテージを入れ替えました。" );
							
							//何も入れ替えていない場合、アラート
							if(this.valCount == 0){
								alert("******対象のフォルダには、フッテージと同じ階層がありませんでした******");
							}
						}
					}
				}
			},
			
			bldUI: function()
			{
			    buildUI = [100,50,660,110 + (50 * this.cFol.length)];
			    bldObj = new Window("palette"," select Folder", buildUI);
			    
			    bldObj.ddlObj = new Array();
			    
			    this.reBldUI(bldObj);
			},
			
			reBldUI: function(chgObj)
			{
			    var selList = new Array();
			    var ddlList = new Array();
			
				for(var f=0;f<this.cFolN.length;f++){
					selList[f] = this.cFolN[f][0];
					this.cFolN[f].shift();
					ddlList[f] = new Array();
					ddlList[f] = this.cFolN[f];
				}
				//alert(selList);
				chgObj.ddlGroup = chgObj.add("panel", [10, 10, 540, 20 + (30 * this.cFol.length)]);
				for(var f=0;f<selList.length;f++){
					selName = chgObj.ddlGroup.add("statictext",[10, 10 + (30 * f), 80, 30 + (30 * f)], selList[f]); selName.justify="left";
					yajiText = chgObj.ddlGroup.add("statictext",[90, 10 + (30 * f), 110, 30 + (30 * f)], "   →   "); yajiText.justify="left";
					chgObj.ddlObj[f] = chgObj.ddlGroup.add("dropdownlist",[120, 10 + (30 * f), 400, 30 + (30 * f)], ddlList[f]);
					chgObj.ddlObj[f].selection = chgObj.ddlObj[f].items[chgObj.ddlObj[f].items.length-1];
				}
				
				chgObj.cancelBtn = chgObj.add( "button" , [320, 30 + (30 * this.cFol.length), 420, 60 + (30 * this.cFol.length)] , "Cancel" , {name:"cancel"} );
				chgObj.cancelBtn.onClick = function()
																				{
																					chgObj.Btnon = "Cansel";
																					chgObj.close();
																				};
				
				chgObj.okBtn = chgObj.add( "button" , [430, 30 + (30 * this.cFol.length), 530, 60 + (30 * this.cFol.length)] , "OK" , {name:"ok"} );
				chgObj.okBtn.onClick = function()
																				{
																					chgObj.Btnon = "OK";
																					chgObj.close();
																				};
				rSelf = this;
				chgObj.onClose = function()
										{
											//  "OK" なら、取得
											if(chgObj.Btnon == "OK"){
												for(var f=0;f<chgObj.ddlObj.length;f++){
													sNum = chgObj.ddlObj[f].selection.index;
													var newFile = null;
													if(rSelf.selF[rSelf.cFol[f][0]].duration == 0){
														//直親フォルダの場合
														if(rSelf.cFol[f][sNum+1].toString().lastIndexOf(".") == -1){
															newFile = new File(rSelf.cFol[f][sNum+1] + "/" + rSelf.selFN[rSelf.cFol[f][0]]);
														//ファイルの場合
														}else{
															newFile = new File(rSelf.cFol[f][sNum+1]);
														}
													}else{
														newFile = new File(rSelf.cFol[f][sNum+1]);
													}
													
													//alert(newFile);
													
													if(newFile.exists){
														rSelf.selF[rSelf.cFol[f][0]].replace(newFile);
														rSelf.valCount++;
														
														//情報パネル表示
														clearOutput();
														writeLn( "ReplaceFiles Info:" );
														writeLn( rSelf.valCount.toString() + "個のフッテージを入れ替えました。" );
													}
												}
											//"OK" 以外なら、アンドゥ
											}else{
												app.executeCommand(16);
											}
										};
										
				chgObj.center();
				chgObj.show();
			}
		}
		
		//sub main
		var RF = new reFiles(thisObj);
		RF.sepF();
		
	}

}