//          PathToCrowd    ver 1.0   2010.12.26
//
//          
//          選択した平面レイヤーにあるパスのポイントの位置に一緒に選択したレイヤーを並べる
//
//
//          スクリプト実行時のルール
//
//          ※ 平面レイヤーにパスがある場合のみ有効 (パスは開閉どちらでも可)
//          ※ その平面レイヤーの下に並べたい素材レイヤーを置く (複数可)
//          ※ 平面レイヤーと並べたい素材レイヤーを一緒に選択して、実行
//          ※ 並べたい素材レイヤーを複数置いた場合は、ランダムチョイスして配置
//
//
//          例 ※タイムライン上でのコンポ内のレイヤー
//
//          1 平面レイヤー2 (パス有)
//          2 素材レイヤー3 (フッテージアイテム or コンポアイテム のみ可)
//          3 素材レイヤー2 (フッテージアイテム or コンポアイテム のみ可)
//          4 平面レイヤー1 (パス有)
//          5 素材レイヤー1 (フッテージアイテム or コンポアイテム のみ可)
//
//
//          上記のレイヤーを選択して実行すると、以下のように生成
//
//          1 Crowd_2 (コンポ  平面レイヤー2 のパスのポイントに素材レイヤー2 と 素材レイヤー3 をランダムチョイスで並べてネスト)
//          2 Crowd_1 (コンポ  平面レイヤー1 のパスのポイントに素材レイヤー1を並べてネスト)
//          3 平面レイヤー2 (パス有)
//          4 平面レイヤー1 (パス有)
//
//
//
//
//
//          ***動作確認済***
//          AfterEffects CS4 JP
//          Windows XP sp3   &   Mac OS 10.5.6
//
//
//          script by curryegg      blog : http://curryegg.blog.shinobi.jp/    email : curry_eggs@yahoo.co.jp
//
//
//




PathToCrowd();




function PathToCrowd()
{
	var actComp = app.project.activeItem;
	var selLys = actComp.selectedLayers;
	var valI = new Array();
	var pathLys = new Array();
	var sozaiLys = new Array();
	
	if(selLys.length > 0){
		
		for(var i=0;i<selLys.length;i++){
			valI[i] = selLys[i].index;
		}
		
		valI.sort();
		
		var u=0;
		var uu=0;
		for(var i=0;i<valI.length;i++){
			if(actComp.layer(valI[i]).mask.numProperties >0){
				pathLys[u] = actComp.layer(valI[i]);
				u++;
				uu = 0;
			}else if(actComp.layer(valI[i]).source == "[object FootageItem]" || actComp.layer(valI[i]).source == "[object CompItem]"){
				if(uu == 0){
					sozaiLys[u-1] = new Array();
					sozaiLys[u-1][0] = actComp.layer(valI[i]);
					uu++;
				}else{
					sozaiLys[u-1][uu] = actComp.layer(valI[i]);
					uu++;
				}
			}
	
		}
		
		var compSize = [app.project.activeItem.width, app.project.activeItem.height];
		var compDur = app.project.activeItem.duration;
		var compFr = app.project.activeItem.frameRate;
		
		pathLys.reverse();
		sozaiLys.reverse();
		
		app.beginUndoGroup("path to Crowd");
		
		for(var c=0;c<pathLys.length;c++){
			mNum = pathLys[c].mask.numProperties;
			var vP = new Array();
			 aMask = pathLys[c].mask(1);
			 aP = aMask.maskPath;
			 aV = aP.value.vertices;
			 var uu=0;
			 for(var i=0;i<aV.length;i++){
			 	vP[uu] = new Array();
			 	vP[uu] = aV[i];
			 	uu++;
			 }
			 nComp = app.project.items.addComp("Crowd_" + (c+1), compSize[0], compSize[1], 1, compDur, compFr);
			 mComp = app.project.activeItem.layers.add(nComp);
			 //mComp.moveAfter(pathLys[c]);
			 
			 if(sozaiLys.length > 0){
			 	for(var i=0;i<vP.length;i++){
			 		rVal = randomPic(sozaiLys[c].length);
			 		//alert(rVal);
			 		nScale = sozaiLys[c][rVal].scale.value;
			 		nLy = nComp.layers.add(sozaiLys[c][rVal].source);
			 		nLy.position.setValue([vP[i][0], vP[i][1]]);
			 		nLy.scale.setValue(nScale);
			 	}
			 }else{
				 valColor = parseFloat(1/255 * (255 - (c*30)));
				 nSolid = nComp.layers.addSolid([valColor, valColor, valColor], "dummy_" + (c+1), 50, 50, 1 ,compDur);
				 for(var i=0;i<vP.length;i++){
				 	nSolid.position.setValue([vP[i][0], vP[i][1]]);
				 	if(i < vP.length-1){
					 	nSolid = nSolid.duplicate();
				 	}
				 }
			 }
		}
		
		
		for(var i=0;i<sozaiLys.length;i++){
			for(var ii=0;ii<sozaiLys[i].length;ii++){
				sozaiLys[i][ii].remove();
			}
		}
		
		app.endUndoGroup();
		
		function randomPic(numPic)
		{
			rNum = Math.floor( Math.random() * numPic );
			return rNum;
		}
	}else{
		alert("******何も選択されていません******");
	}
}