/*   ExportSheet_CS5_5 v1.0   2012.05.30

      ・TimeSheet_CS5_5_forMac(Win)関係のAE スクリプト用エクスポート・スクリプト。(TimeSheet_CS4_forMac(Win)の上位版)
      ・アクティブコンポ内のスライダのあるレイヤーのキー情報を、AE CS5.5 の [ 親フォルダ < _SheetData < SheetData.txt ] に書き込み。
      ・保存したシートファイルは、TimeSheet_forWin(Mac).exe(app)で読み込みが可能。 (実行後に自動的に起動)
      ・Windows & Mac 両対応 & CS5.5 対応版

*/







(function()
{
    exSheet(this);


    function exSheet(thisObj)
    {

        function runScr()
        {
            this.dirFol = null;
            this.actComp = app.project;
            this.actItem = this.actComp.activeItem;
            this.fRate = this.actItem.frameRate;
            this.cName = this.actItem.name.toString();
            this.actLys = this.actItem.selectedLayers;
            this.allLys = this.actItem.layers;
            this.compLys = new Array();
            this.lyTime = this.actItem.duration;
            this.lyFr = Math.floor(this.lyTime * this.actItem.frameRate);
            this.valD = false;
            this.valE = false;

            this.compLysQ = new Array();
            this.numSL = new Array();
            this.lyNames = new Array();
            this.outData = new Array();
            this.wData;
            this.PrData = new Array();
            this.valEXE = false;
        }

        runScr.prototype =
        {
            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                var verVal = parseInt(app.version.split(".")[0]) - 5;
                if(verVal == 5){
                    if(parseInt(app.version.split(".")[1].charAt(0)) == 5){
                        verVal = 5.5;
                    }
                }
                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    if(app.version.indexOf("9") == 0 && $.os.indexOf("64") != -1){
                    //AE CS4 Scriptsフォルダパス<64bit OS時>
                        this.aePath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス<64bit OS時>
                        this.plPath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    }else{
                        //AE Scriptsフォルダパス
                        this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス(Win)
                        this.plPath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    }
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS5_5_forWin/";
                    //TimeSheetアプリ パス
                    this.exePath = this.tsPath + "TimeSheet_forWin.exe";
                    //カレントディレクトリ
                    this.curDir = this.aePath;
                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = "/Applications/Adobe After Effects CS" + verVal + "/Scripts/";
                    //プラグインフォルダのパス(Mac)
                    this.plPath = "/Applications/Adobe After Effects CS" + verVal + "/Plug-ins/";
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS5_5_forMac/";
                    //TimeSheetアプリ パス
                    this.exePath = this.tsPath + "TimeSheet_forMac.app";
                    //サーバーディレクトリ
                    this.curDir = "/Volumes/";
                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }
                //tab space
                this.tabS = "\t";

                //alert(new Folder(this.curDir).exists);
            },

            //JavaScript Debuggerが有効だったら、無効にする
            offDeb: function(){
                 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
                //alert(j);

                if(j == 1)
                {
                        app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
                        app.preferences.saveToDisk();
                        app.preferences.reload();

                        this.valD = true;
                }

            },

            //JavaScript Debuggerの設定を変えてたら、元に戻す
            reDeb: function(){
                   if(this.valD)
                   {
                           app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
                           app.preferences.saveToDisk();
                           app.preferences.reload();
                   }

            },

            //スライダのあるレイヤーのみ取得
            slChk: function(){
                //デバッカーがONだったらOFF
                this.offDeb();

                ee=0;
                for(cc=0;cc<this.compLys.length;cc++)
                {

                    try{
                            if(this.compLys[cc].effect.property("TS_Slider Control").canSetEnabled)
                            {
                                    //キーの数を取得
                                    var chkNum = this.compLys[cc].effect("TS_Slider Control")["ADBE Slider Control-0001"].numKeys;
                                    //alert(chkNum);

                                    //キーがある場合
                                    if(chkNum > 0)
                                    {
                                            this.compLysQ[ee] = this.compLys[cc];
                                            this.numSL[ee] = this.compLys[cc].index;
                                            ee++;
                                    }
                            }
                    }
                    catch(e)
                    {
                            //alert("******aaa******");
                    }
                }
                //alert(this.compLysQ[0].name);

                //デバッカー設定を戻す
                this.reDeb();
            },

            //各レイヤーの名前を取得
            getLyName: function(){
                this.slChk();

                if(this.compLysQ.length > 0)
                {

                    nn=0;
                    while(nn<this.compLysQ.length)
                    {
                            //レイヤーの名前の中に "_ " がどこにあるか検索
                            var numL = this.compLysQ[nn].name.indexOf("_");
                            //無かった場合
                            if(numL == -1)
                            {
                                    //名前が4文字以内ならそのまま表示
                                    if(this.compLysQ[nn].name.length < 4)
                                    {
                                            numL = this.compLysQ[nn].name.length;
                                    //4文字以上なら4文字まで表示
                                    }else{
                                            numL = 4;
                                    }
                        //あった場合で、4文字以上なら "_" の左側の４文字まで表示、4文字以内なら "_" の左側をそのまま表示
                        }else if(numL > 4)
                        {
                                numL = 4;
                        }

                        this.lyNames[nn] = this.numSL[nn] + "_" + this.compLysQ[nn].name.substring(0,numL);

                        //alert(this.lyNames[nn]);
                        nn++;
                    }
                }else{
                        alert("******レイヤーにキーがありません******");
                        this.valE = true;
                }

            },

            //スライダのキー情報を取得
            getData: function(){
                for(var iCol=0;iCol<this.lyNames.length;iCol++)
                {
                    this.outData[iCol] = new Array();

                    //キーの総数
                    var numK = this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].numKeys;
                    //現在のキー番号
                     var nk=1;
                    for(var iRow=0;iRow<this.lyFr;iRow++)
                    {
                    //各キーのフレーム番号を取得
                       //現在のキーがキーの総数以内の場合
                        if(nk <= numK){
                            //現在のキーのフレームＮｏ
                            var numD = Math.floor(this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].keyTime(nk) * this.actItem.frameRate);
                      //現在のキーがキーの総数を越えた場合
                        }else{
                            numD = this.lyFr;
                        }
                    //ここからキー情報
                        //１フレーム目
                        if(iRow == 0){
                            this.outData[iCol][0] = this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].keyValue(nk);
                            nk++;
                        //２フレーム目以降
                        }else{
                            //iRowが現在のキーのフレーム番号より小さい場合
                            if(iRow < numD){
                                //現在のキーがキーの総数以内の場合
                                if(nk <= numK){
                                    this.outData[iCol][iRow] = this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].keyValue(nk-1);
                                //現在のキーがキーの総数を１越えた場合
                                }else{
                                    this.outData[iCol][iRow] = this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].keyValue(nk-1);
                                }
                            //iRowが現在のキーのフレーム番号と同じ場合
                            }else if(iRow == numD){
                                this.outData[iCol][iRow] = this.compLysQ[iCol].effect("TS_Slider Control")["ADBE Slider Control-0001"].keyValue(nk);
                                //現在のキーが総数に満たない場合は、繰上げ
                                if(nk <= numK){
                                    nk++;
                                }
                            }
                        }
                    }
                    //alert(this.outData[iCol][0]);
                }
            },

            //書き出し用テキスト作成
            dataTS: function(){
                //レイヤーの下から取得
                for(var rr=this.outData.length-1;rr>=0;rr--)
                {
                    for(var ww=0;ww<this.lyFr;ww++)
                    {
                        if(rr==this.outData.length-1 && ww==0){
                            this.wData = this.outData[rr][ww] + ",";
                            //alert(wData);
                        }else{
                            this.wData += this.outData[rr][ww] + ",";
                        }
                    }

                    if(rr>0){
                        //セル情報の最後にレイヤーの名前
                        this.wData += this.lyNames[rr]  + this.CF;
                    }else{
                        //最後にカットの名前 + フレームレート
                        this.wData += this.lyNames[rr]+ this.CF + this.cName + this.CF + this.fRate ;
                    }
                }

            },

            //"SheetData.txt" に書き込み
            exportTS: function(){
                var fileObj = new File(this.tsPath + "_SheetData/SheetData.txt");
                //UTF-8にエンコード
                fileObj.encoding = "UTF-8";
                //alert(fileObj.open("w"));
                var flag = fileObj.open("w");
                if (flag)
                {
                    var text = this.wData;
                    //複数行を一気に書き込み
                    fileObj.writeln(text);
                    fileObj.close();

                    this.impPref();
                    this.exportPref();

                    if(! this.valE){
                        //現在表示されている情報を消去
                        clearOutput();
                        //情報パネルに文字列を表示
                        writeLn( "保存しました" );
                    }

                }else{
                    alert("******保存できませんでした******");
			alert(String(fileObj));
                }
            },

            //キーを入力したレイヤーのみ選択状態にする
            activeLys: function(){
                for(i=0;i<this.compLysQ.length;i++){

                        this.compLysQ[i].selected = true;

                }
            },

            //シートデータを読み込んで配列化
            impPref: function(){
                if(! this.valE)
                {
                    var fileObj = new File(this.tsPath + "/_Pref/preferance.txt");

                 //シートファイルがない場合
                    if(! fileObj.exists){
                        alert("******環境設定が見つかりません******");
                        this.valE = true;
                    }else{
                        this.PrData = new Array();
                         if (fileObj.open("r"))
                         {

                        //行(セル)ごとに読み込み
                            try{
                                 for(var rr=0;rr<9;rr++)
                                 {
                                             var txt = new Array();
                                             txt = fileObj.readln();
                                     if(rr==2){
                                             this.PrData[0] = txt.split("Directory :");
                                     }else if(rr==4){
                                             this.PrData[1] = txt.split("Window Pos value :");
                                     }else if(rr==6){
                                             this.PrData[2] = txt.split("Window Pos :");
                                     }
                                 }

                            }catch(e){
                                alert("******読み込みに失敗しました******");
                                this.valE = true;
                            }

                        }else{
                           this.valE = true;
                        }
                  }
               }
            },

            //"SheetData.txt" に書き込み
            exportPref: function(){
                var wPrData = "======TimeSheet.exe(app) 環境設定======" + this.CF +
                                this.CF +
                                "Directory :" + this.PrData[0][1] + this.CF +
                                this.CF +
                                "Window Pos value :" + this.PrData[1][1] + this.CF +
                                this.CF +
                                "Window Pos :" + this.PrData[2][1] + this.CF +
                                this.CF +
                                "Import Chk :true";


                var fileObj = new File(this.tsPath + "/_Pref/preferance.txt");
                //UTF-8にエンコード
                fileObj.encoding = "UTF-8";

                var flag = fileObj.open("w");
                if (flag == true)
                {
                    var text = wPrData;
                    //複数行を一気に書き込み
                    fileObj.writeln(text);
                    fileObj.close();
                }else{
                    alert("******環境設定を保存できませんでした******");
                    this.valE = true;
                }
            },

            //TimeSheet_forWin.exeが立ち上がってるか判別
            exeChk: function(){
                var fileObj = new File(this.tsPath + "/_Pref/exeON.txt");

                //シートファイルがない場合
                if(fileObj.exists){
                    this.valEXE = true;
                }

            },


            runFunc: function()
            {
                this.osChk();

                //レイヤーを選択していた場合
                if(this.actLys.length > 0)
                {
                        //インデックス順に並び替え
                        iii=0;
                        for(i=0;i<this.allLys.length;i++)
                        {
                            for(ii=0;ii<this.actLys.length;ii++)
                            {
                                if(i+1 == this.actLys[ii].index)
                                {
                                        this.compLys[iii] = this.actLys[ii];
                                        iii++
                                }
                            }
                        }
                //レイヤーが選択されていない場合(全てのレイヤーが対象)
                }else
                {
                        for(i=0;i<this.allLys.length;i++)
                        {
                            this.compLys[i] = this.allLys[i+1];
                        }
                }

                this.getLyName();

                if(! this.valE)
                {
                        this.getData();
                        this.dataTS();
                        this.exportTS();

                        if(! this.valE){
                            this.activeLys();

                            this.exeChk();
                            //TimeSheet_forWin.exeが立ち上がっていない場合
                            if(! this.valEXE){
                                //TimeSheetを起動
                                //alert(this.exePath);
                                File(this.exePath).execute();
                            }
                        }
                }
            }
        }





        //main******************************************************
        var ES = new runScr(thisObj);

        //アプリのバージョン確認
        //alert(parseFloat(app.version));
        if (parseFloat(app.version) < 8)
        {
            //alert(pUI.strErr, "blind pnl UI");
            return;
        }else{
            exUI = ES.runFunc(thisObj);
        }
        //**********************************************************
    }
})();