/*   ImportSheet_CS6 v1.0   2012.05.30

      ・TimeSheet_CS6_forMac(Win)関係のAE スクリプト用インポート・スクリプト。
      ・AE CS6 の [ Scripts < _SheetData < SheetData_AE.txt を読み込んで各レイヤーのスライダにキーを入力します。
      ・あらかじめ、[ setFX_Sheet_CS3_6 ]で対象のレイヤーにスライダが適用されていることが必要。
      ・Windows & Mac 両対応 & CS6 対応版

*/








(function()
{
    imSheet(this);


    function imSheet(thisObj)
    {

        function runScr()
        {
            this.dirFol = null;
            this.actComp = app.project;
            this.actItem = this.actComp.activeItem;
            this.fRate = this.actItem.frameRate;

            this.compLys = new Array();
            this.keyType = KeyframeInterpolationType.HOLD;
            this.valFr = null;
            this.valK = null;
            this.valE = false;
            this.valC = false;

            this.compLysQ = new Array();
            this.numSL = new Array();
            this.pClip;
            this.kData = new Array();
            this.celName = new Array();
            this.lCel = new Array();
            this.valD = false;
            this.LastSave = null;

            //0Fr.～24Fr.までの確定値
            this.kFr = [
                             0,
                             0.0416667,
                             0.0833333,
                             0.125,
                             0.1660667,
                             0.208333,
                             0.25,
                             0.291667,
                             0.333333,
                             0.375,
                             0.416667,
                             0.458333,
                             0.5,
                             0.541667,
                             0.583333,
                             0.625,
                             0.666667,
                             0.708333,
                             0.75,
                             0.791667,
                             0.833333,
                             0.875,
                             0.916667,
                             0.958333,
                             1
                         ];
        }

        runScr.prototype =
        {
            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                var verVal = parseInt(app.version.split(".")[0]) - 5;
                if(verVal == 5){
                    if(parseInt(app.version.split(".")[1].charAt(0)) == 5){
                        verVal = 5.5;
                    }
                }
                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    if(app.version.indexOf("9") == 0 && $.os.indexOf("64") != -1){
                    //AE CS4 Scriptsフォルダパス<64bit OS時>
                        this.aePath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス<64bit OS時>
                        this.plPath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    }else{
                        //AE Scriptsフォルダパス
                        this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス(Win)
                        this.plPath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    }
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS6_forWin/";
                    //TimeSheetアプリ パス
                    this.exePath = this.tsPath + "TimeSheet_forWin.exe";
                    //カレントディレクトリ
                    this.curDir = this.aePath;
                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = "/Applications/Adobe After Effects CS" + verVal + "/Scripts/";
                    //プラグインフォルダのパス(Mac)
                    this.plPath = "/Applications/Adobe After Effects CS" + verVal + "4/Plug-ins/";
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS6_forMac/";
                    //TimeSheetアプリ パス
                    this.exePath = this.tsPath + "TimeSheet_forMac.app";
                    //サーバーディレクトリ
                    this.curDir = "/Volumes/";
                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }
                //tab space
                this.tabS = "\t";

                //alert(new Folder(this.curDir).exists);
            },

            //JavaScript Debuggerが有効だったら、無効にする
            offDeb: function(){
                 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
                //alert(j);

                if(j == 1)
                {
                        app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
                        app.preferences.saveToDisk();
                        app.preferences.reload();

                        this.valD = true;
                }

            },

            //JavaScript Debuggerの設定を変えてたら、元に戻す
            reDeb: function(){
                   if(this.valD)
                   {
                           app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
                           app.preferences.saveToDisk();
                           app.preferences.reload();
                   }

            },

            //スライダのあるレイヤーのみ取得
            slChk: function(){
                var ee=0;
                for(var cc=0;cc<this.compLys.length;cc++){

                    this.compLys[cc].selected = false;
                    try{
                        if(this.compLys[cc].effect.property("TS_Slider Control").canSetEnabled){
                            this.compLysQ[ee] = this.compLys[cc];
                            this.numSL[ee] = this.compLys[cc].index;
                            ee++;
                        }
                    }
                    catch(e)
                    {
                        //alert("******aaa******");
                    }
                }
                //alert(this.compLysQ[0].name);
            },

            //シートデータを読み込んで配列化
            impSheet: function(){
                if(! this.valE)
                {
                    var fileObj = new File(this.tsPath + "/_SheetData/SheetData_AE.txt");
                    //alert(fileObj);
                 //シートファイルがない場合
                    if(! fileObj.exists){
                        alert("******シートファイルが見つかりません******");
                        this.valE = true;
                    }else{
                         if (fileObj.open("r"))
                         {
                            var ff = 0;
                        //行(セル)ごとに読み込み
                            try{
                                 do
                                 {
                                     var txt = new Array();
                                   //読み込んだ行(セル)を配列化
                                     txt = fileObj.readln();
                                     this.kData[ff] = txt.split(",");
                                     ff++;
                                     //alert(txt.split(","));
                                 }while(txt.split(",").length != 1);

                            }catch(e){
                                alert("******読み込みに失敗しました******");
                            }

                            this.getCelName();

                        }else{
                           this.valE = true;
                        }
                  }
               }

            },

            //シートデータのセル名を取得(最後の "カットＮｏ"  は読み込まないので -1)
            getCelName: function(){
                for(var vv=0;vv<this.kData.length-1;vv++){
                    this.celName[vv] = this.kData[vv][this.kData[vv].length-1];
                    //alert(this.celName[vv]);
                }
            },

            //ダイアログ
            setDialog: function(){
                var RB = new Array();
                var LB = new Array();
                var LBs = new Array();
                var addC = 0;


                if(this.compLysQ.length > 13){
                    addC = this.compLysQ.length-13;
                }else if(this.celName.length > 13){
                    addC = this.celName.length-13;
                }


                //拡張サイズ
                    var setDlg = new Window ( "dialog" , "Import Sheet" , [0,0,640,400 + (20 * addC)] );

                    var pnlSub2 =setDlg.add( "panel" , [10,20,330,360 + (20 * addC)] , "Link Cell" );
                    var subL = pnlSub2.add( "panel" , [10,20,210,330 + (20 * addC)] , "Comp Lys" );
                    var subLs =  subL.add( "panel" , [110,10,190,300 + (20 * addC)] , "Linked" );

                //コンポレイヤー用テキスト
                    for(var ww=0;ww<this.compLysQ.length;ww++){
                        var aPos = (30+(ww*20));
                        var bPos = (50+(ww*20));

                        LB[ww] = subL.add( "statictext" , [5, aPos ,100, bPos] , this.numSL[ww] +"_"+ this.compLysQ[ww].name.substr(0,6) ); LB[ww].justify="left";
                //入力テキスト
                        var cName = "0";
                        for(var cc=0;cc<this.celName.length;cc++){
                            if(this.celName[cc]==LB[ww].text.substr(0,this.celName[cc].length)){
                                cName = cc+1;
                            }
                        }
                        LBs[ww] = subLs.add( "edittext" , [5, aPos-10 ,75, bPos-10] , cName.toString(),{enterKeySignalOnChange:true} ); LBs[ww].justify="left";
                            LBs[0].active = true;
                    }

                    var subR = pnlSub2.add( "panel" , [220,20,310,330 + (20 * addC)] , "Sheet Cell" );
                //シートセル用テキスト
                    for(var gg=0;gg<this.celName.length+1;gg++){
                        var cPos = ( ( 30 + (this.celName.length*20) ) - (gg*20) );
                        var dPos = ( ( 50 + (this.celName.length*20) ) - (gg*20) );

                //Non用
                        if(gg==0){
                            RB[gg] = subR.add( "statictext" , [5, cPos+1 ,65, dPos+1] ,"0_Non" ); RB[gg].justify="left";
                        }else{
                            RB[gg] = subR.add( "statictext" , [5, cPos ,85, dPos] , gg + "_"+ this.celName[gg-1].substr(0,5) ); RB[gg].justify="left";
                        }
                   }

                    var pstPnl2 = setDlg.add( "panel" , [340,20,630,135] , "Read Me" );
                    var clpText2 = pstPnl2.add( "edittext" , [10,25,280,110],"コンポレイヤー ( 左側 ) に対してシートのセル   " +
                        " ( 右側 ) の数字を割り当ててください。              " +
                        "[ Linked ]に表示されている数字のセルデータを    " +
                        "各レイヤーに入力します。                             ",{multiline:true ,readonly:true}); clpText2.justify="left";


                   var cancelBtn2 = setDlg.add( "button" , [20, 360+(20 * addC) ,120,390 + (20 * addC)] , "Cansel" , {name:"cancel"} );
                   var okBtn2 = setDlg.add( "button" , [130, 360+(20 * addC) ,230,390 + (20 * addC)] , "OK" , {name:"ok"} );
                   var sSelf = this;
                   cancelBtn2.onClick = function() { sSelf.valC = true; setDlg.close(); }
                   okBtn2.onClick = function() { sSelf.linkData(LBs); setDlg.close(); }


                setDlg.center();
                setDlg.show();
            },

            //レイヤーとセルのリンク情報を取得
            linkData: function(LBs){
                this.valE = true;
                //各コンポレイヤーに割り振ったセルを取得
                for(var LL=0;LL<LBs.length;LL++){

                    this.lCel[LL] = LBs[LL].text;

                }
                //"0"じゃない場合
                    if(this.lCel.length > 0){
                        this.valE = false;
                    }

            },

            //各レイヤーにキーをセット
            setLysR: function(){
                var cNum=0;
                //各コンポレイヤーに入力
                for(var ss=0;ss<this.lCel.length;ss++){

                    if(this.lCel[ss] != 0){

                       //スライダーのキー番号
                       var nKey = 1;

                           for(var i=0;i<this.kData[this.lCel[ss]-1].length;i++){
                            //ラストはレイヤー名の情報なのでスルー
                             if(i == this.kData[this.lCel[ss]-1].length-1){
                                    //this.compLys[qq].name = this.kFr[i];
                             }else{
                                /*
                               //フレーム数が24以下の場合
                                if(i+1 <  24){
                                        valFr = kFr[i];

                               //フレーム数が25以上の場合(24で割った整数と、確定値に変換した余りを足算)
                                }else{
                                    if((i+1) % 24 == 0){
                                        valFr = Math.floor((i+1) / 24) + kFr[23] - 1;
                                    }else{
                                       valFr = Math.floor((i+1) / 24) + kFr[((i+1) % 24)-1];
                                    }
                                }
                                */

                                this.valFr = (i) / this.fRate;
                                //alert(this.valFr);
                               //1フレーム目の場合
                                if(i == 0){

                                    //２つ以上キーがあったら削除
                                    var rKey = this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].numKeys;
                                    if(rKey > 1){
                                        for(var nn=1;nn<rKey;nn++){
                                            this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].removeKey(2);
                                        }
                                    }
                                    //レイヤーの[インポイント]からキーを打つ
                                    this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].setValueAtTime(this.compLysQ[ss].inPoint + this.valFr,this.kData[this.lCel[ss]-1][i]);
                                    //キーをホールド
                                    this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].setInterpolationTypeAtKey(nKey,this.keyType);
                                    nKey++;

                               //2フレーム目以降の場合
                                }else{
                                    //前フレームと違うセルならキーを打つ
                                     if(this.kData[this.lCel[ss]-1][i] != this.kData[this.lCel[ss]-1][i-1]){

                                            this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].setValueAtTime(this.compLysQ[ss].inPoint + this.valFr,this.kData[this.lCel[ss]-1][i]);
                                            //キーをホールド
                                            this.compLysQ[ss].effect("TS_Slider Control")["ADBE Slider Control-0001"].setInterpolationTypeAtKey(nKey,this.keyType);
                                            nKey++;
                                     }
                                }
                             }
                           }
                    }else{
                        cNum++;
                    }

                }

                if(cNum == this.lCel.length){
                    this.valC = true;
                    alert("******レイヤーに入力されませんでした******");
                }
            },

            //キーを入力したレイヤーのみ選択状態にする
            activeLys: function(){
                for(var i=0;i<this.compLysQ.length;i++){
                    if(this.lCel[i] != 0){
                        this.compLysQ[i].selected = true;
                    }
                }

            },

            runFunc: function()
            {
                this.osChk();

                if(this.actItem != "[object CompItem]" || this.actItem == null){
                    alert("******コンポが選ばれていません******");
                }else{

                    if(this.fRate != 24 && this.fRate != 30){
                        alert("******コンポのフレームレートを 24fr か 30fr にしてください******");
                    }else
                    {

                       var actLys = this.actItem.selectedLayers;
                       var allLys = this.actItem.layers;
                       var lyTime = this.actItem.duration;
                       var lyFr = lyTime * this.actItem.frameRate;


                        //レイヤーを選択していた場合
                        if(actLys.length > 0){
                            //インデックス順に並び替え
                            iii=0;
                            for(var i=0;i<allLys.length;i++){
                                for(var ii=0;ii<actLys.length;ii++){
                                    if(i+1 == actLys[ii].index){
                                        this.compLys[iii] = actLys[ii];
                                        iii++
                                    }
                                }
                            }
                        //レイヤーが選択されていない場合(全てのレイヤーが対象)
                        }else{
                            for(var i=0;i<allLys.length;i++){
                                this.compLys[i] = allLys[i+1];
                            }
                        }

                        this.offDeb();

                        this.slChk();

                        this.reDeb();

                        //レイヤーにスライダがあった場合
                        if(this.compLysQ.length > 0){
                            this.impSheet();

                            //シートファイルを読み込んだ場合
                            if(! this.valE){
                                this.setDialog();

                                //割り振りがある場合
                                if(! this.valE){
                                    app.beginUndoGroup("ImportSheet");
                                    this.setLysR();
                                    //OKの場合
                                    if(! this.valC){
                                        this.activeLys();
                                    }
                                    app.endUndoGroup();
                                }else{
                                    alert("******レイヤーに入力されませんでした******");
                                }
                            }
                        }else{
                            alert("******レイヤーに[スライダ]がありません******");
                        }

                    }

                }
            }
    }





        //main******************************************************
        var IS = new runScr(thisObj);

        //アプリのバージョン確認
        //alert(parseFloat(app.version));
        if (parseFloat(app.version) < 8)
        {
            //alert(pUI.strErr, "blind pnl UI");
            return;
        }else{
            exUI = IS.runFunc(thisObj);
        }
        //**********************************************************
    }
})();