﻿//    Exp Editor for CS6 ver.2.0  2012.08.07
//
//
//    エクスプレッションを編集するエディターです。
//
//    各レイヤープロパティをmatch nameで取得したりできます。
//
//    CS6 になってやっと edittext の致命的な不具合が解消されたので、ようやく陽の目を見ることが出来ました。
//
//    ちなみにテキスト記入時にアンドゥは効きません。(edittext の仕様)
//
//
//      ***更新***
//      ver.2.0
//      "Mask PropertyGroup"の取得時の不具合を修正 /2012.08.07
//
//      ver.1.0
//      Macでの動作確認済
//      ウインドウリサイズ時の処理を修正 /2012.06.28
//
//      ver.0.2
//      プロパティをmatchName,name,indexで取得できるようにダイアログを追加 /2012.06.26
//
//
//    =動作確認=
//
//    AfterEffects CS6
//
//    windows7 動作確認済
//    mac OS 10.6.8 動作確認済
//
//
//   email:   curry_eggs@yahoo.co.jp       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_eggs




(function()
{


    EX_Obj(this);


	function EX_Obj(thisObj)
	{

		exUI_Obj.prototype =
		{
			//OSが、Win か Mac か
			osCHK: function()
			{
				if($.os.indexOf("Windows")==0){
					this.os = "Win";
					//パスのバックスラッシュ(Win)
					this.cN = "\\";
					//改行コード(Win)
					this.CF = "\r\n";

					this.listSize = [
										[790, 195],
										[250, 178],
										[250, 130],
										[250, 130],
										[250, 40],
										[250, 40],
										[250, 386],
										[250, 274],
										[250, 114],
										[250, 98],
										[350, 226],
										[250,146],
										[250, 210],
										[250, 146],
										[250, 114],
										[250, 114],
										[250, 66],
										[250, 82],
										[350, 354],
										[250, 50],
										[250, 130]
									];

					//this.defPath = String(unescape(new File($.fileName).parent.fsName));
					this.defPath = "C:/Program Files/Adobe/Adobe After Effects CS6/Support Files/Scripts/EXP_Editor_CS6_ver2";
					this.txtPath = this.defPath + "/EXPeditor_customEXP.txt";
					//alert(this.txtPath);
				}else if($.os.indexOf("Mac")==0){
					this.os = "Mac";
					//パスのバックスラッシュ(Mac)
					this.cN = "\n";
					//改行コード(Mac)
					this.CF = "\r";

					this.listSize = [
										[890, 195],
										[200, 178],
										[275, 130],
										[250, 130],
										[250, 35],
										[250, 35],
										[250, 386],
										[250, 275],
										[250, 115],
										[250, 98],
										[365, 227],
										[250,147],
										[250, 210],
										[250, 147],
										[250, 115],
										[250, 115],
										[250, 67],
										[250, 83],
										[373, 355],
										[250, 50],
										[250, 130]
									];

					this.defPath = "/Applications/Adobe After Effects CS6/Scripts/EXP_Editor_CS6_ver2";
					this.txtPath = this.defPath + "/EXPeditor_customEXP.txt";
					//alert(this.txtPath);
				}
				this.cT = "\t";

				//alert(this.txtPath);
			},

			//カスタムエクスプレッションを読み込み
			impTXT: function()
			{
				this.expData = new Array();

				var impFile = new File(this.txtPath);
				if(impFile.exists){
					if(impFile.open("r")){
						try
						{
							var i=0;
							while(!impFile.eof)
							{
								var txt = impFile.readln();

								if(txt.indexOf("expName:") == 0){
									if(this.expData.length == 0){
										this.expData[0] = new Array();
										this.expData[0] = {ename:txt.split("expName:")[1], exp:""};
									}else{
										i++;
										this.expData[i] = new Array();
										this.expData[i] = {ename:txt.split("expName:")[1], exp:""};
									}
								}else{
									this.expData[i].exp += txt + this.CF;
								}
							}
						}catch(e){

						}
					}else{
						alert("******ファイルを読み込めませんでした******");
					}
				}else{
					alert("******ファイルを開けませんでした******");
				}
				//alert(this.expData.length);
			},

			exUI_build: function()
			{
			    this.popObl = null;
			    this.ctmObj = null;

				this.osCHK();
				this.impTXT();
				pSelf = this;
				pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", "", [ 0, 0, 720, 440 ], {resizeable: true});
				pal.onResizing = function()
												{
													if(pal.size[0] < 720){
														pal.size = [720, pal.size[1]];
													}

													pal.size = [pal.size[0], 440];

                                                            pal.exGrp.bounds = [ 0, 0, pal.size[0], pal.size[1]];
                                                            pal.verInfo.location = [pal.size[0] - 260, 18];
                                                            pal.title.location = [pal.size[0] - 130, 5];
                                                            pal.addBtn.location = [15, pal.size[1]-40];
                                                            pal.loadBtn.location = [150, pal.size[1]-40];
                                                            pal.clBtn.location = [pal.size[0]-220, pal.size[1]-40];
                                                            pal.applyBtn.location = [pal.size[0]-120, pal.size[1]-40];
                                                           if(pSelf.os == "Win"){
                                                               pal.edBox.bounds = [150, 50, pal.size[0]-10, pal.size[1]-50];
                                                           }else if(pSelf.os == "Mac"){
                                                               pal.edBox.bounds = [168, 50, pal.size[0]-10, pal.size[1]-52];
                                                           }
												}

				pal.onResize = function()
												{
													if(pal.size[0] < 720){
														pal.size = [720, pal.size[1]];
													}
													pal.size = [pal.size[0], 440];
													if(pal.location[0] < 5 || pal.location[1] < 5){
														pal.center();
													}
												}

				pal.onClose = function()
												{
												    if(pSelf.popObl != null){
    												    pSelf.popObl.close();
    												    pSelf.popObl = null;
												    }
												    if(pSelf.ctmObj != null){
												        pSelf.ctmObj.close();
                                                        pSelf.ctmObj = null;
												    }
												}

				pal.exGrp = pal.add("group", [ 0, 0, pal.size[0], pal.size[1]]);
				this.UI_bgColor255(pal.exGrp, [43,43,43]);
				this.UI_fgColor255(pal.exGrp, [240,240,240]);

				pal.log = pal.exGrp.add("statictext", [5,5,200,40], "");
				this.UI_font(pal.log, "Arial", "BOLD", 15);

				pal.verInfo = pal.exGrp.add("statictext", [pal.size[0] - 260, 18, pal.size[0]-140, 40], "ver.2.0      for CS6");
				this.UI_font(pal.verInfo, "Impact", "REGULAR", 18);
				pal.title = pal.exGrp.add("statictext",[pal.size[0] - 130, 5, pal.size[0]-10, 40], "EXP editor");
				this.UI_font(pal.title, "Impact", "REGULAR", 30);


				if(this.os == "Win"){
					pal.expMenu = pal.exGrp.add("listbox", [5, 50, 145, pal.size[1]-52], this.expMenuList);
				}else{
					pal.expMenu = pal.exGrp.add("listbox", [5, 50, 158, pal.size[1]-52], this.expMenuList);
				}
				pal.expMenu.active = false;
				this.UI_bgColor255(pal.expMenu, [225,230,225]);
				this.UI_fgColor255(pal.expMenu, [70,150,30]);
				pal.expMenu.onChange = function()
														{
															if(this.selection != null){
																pSelf.exList_Bld(pal.location, this.selection, this.selection.index, pal);
																//alert(this.selection.index);
															}
														}

				if(this.os == "Win"){
					pal.edBox = pal.exGrp.add("edittext", [150, 50, pal.size[0]-10, pal.size[1]-50], "", {multiline: true, wantReturn:true});
					pal.edBox.helpTip = "・改行 = Enter" +this.CF+
					                    "・文字を入力直後に Ctrl + Space で文字検索から Custom EXP を呼び出し" +this.CF+
					                    "・Alt + Space で全ての登録された Custom EXP を呼び出し" +this.CF+
					                    "・右方向にのみウインドウの伸縮可";
				}else{
					pal.edBox = pal.exGrp.add("edittext", [168, 50, pal.size[0]-10, pal.size[1]-52], "", {multiline: true, wantReturn:true});
                    　pal.edBox.helpTip = "・改行 = Enter" +this.CF+
					                    "・文字を入力直後に Ctrl + Shift + Space で文字検索から Custom EXP を呼び出し" +this.CF+
					                    "・Option + Space で全ての登録された Custom EXP を呼び出し" +this.CF+
					                    "・右方向にのみウインドウの伸縮可";
				}
				pal.edBox.active = true;
				pal.edBox.addEventListener('keydown',this.edFunc);
				pal.edBox.addEventListener('mousemove', this.mvFunc);
				this.UI_bgColor255(pal.edBox, [230,225,225]);
				this.UI_fgColor255(pal.edBox, [20,20,20]);
				pal.edBox.onChange = function()
														{

														}

				//button
				pal.addBtn = pal.exGrp.add("button", [15, pal.size[1]-40, 140, pal.size[1]-10], "get Property");
				pal.addBtn.helpTip = "選択プロパティを取得";
				this.UI_font(pal.addBtn, "Impact", "REGURAR", 22);
				pal.addBtn.onClick = function()
														{
															pSelf.getProp();
															if(!pSelf.valE){
																app.beginUndoGroup("Exp editor");
																pal.edBox.textselection = pSelf.addProp();
																app.endUndoGroup();
																pal.edBox.active = true;
															}
;														}

				pal.loadBtn = pal.exGrp.add("button", [150, pal.size[1]-40, 250, pal.size[1]-10], "load Exp");
				pal.loadBtn.helpTip = "選択プロパティのエクスプレッションを読み込み";
				this.UI_font(pal.loadBtn, "Impact", "REGURAR", 22);
				pal.loadBtn.onClick = function()
														{
															pSelf.getProp();
															if(!pSelf.valE){
																pSelf.loadExp(pal.edBox);
																pal.edBox.active = true;
															}
														}

				pal.clBtn = pal.exGrp.add("button", [pal.size[0]-220, pal.size[1]-40, pal.size[0]-130, pal.size[1]-10], "clear");
				pal.clBtn.helpTip = "テキストエリアをクリア";
				this.UI_font(pal.clBtn, "Impact", "REGURAR", 22);
				pal.clBtn.onClick = function()
														{
															app.beginUndoGroup("Exp editor");
															pal.edBox.text = "";
															app.endUndoGroup();
															pal.edBox.active = true;
														}

				pal.applyBtn = pal.exGrp.add("button", [pal.size[0]-120, pal.size[1]-40, pal.size[0]-20, pal.size[1]-10], "apply EXP");
				pal.applyBtn.helpTip = "選択プロパティのエクスプレッションに適用" +this.CF+
				                       "クリア状態で適用するとエクスプレッションを解除";
				this.UI_font(pal.applyBtn, "Impact", "REGURAR", 22);
				pal.applyBtn.onClick = function()
														{
															pSelf.getProp();
															if(!pSelf.valE){
																pSelf.applyExp(pal.edBox.text);
																pal.edBox.active = true;
															}
														}

				pal.center();
				this.scXY = [pal.location[0]+pal.edBox.location[0], pal.location[1]+pal.edBox.location[1]];
				pal.show();

			},

			//レイヤープロパティ取得
			getProp: function()
			{
				this.valE = false;
				this.selLys = new Array();
				this.selProp = new Array();
				var selProps = new Array();

				try{
					this.selLys = app.project.activeItem.selectedLayers;
					selProps = this.selLys[0].selectedProperties;
				}catch(e){
					alert("******レイヤーが選ばれていません******");
					this.valE = true;
				}

				if(!this.valE){
					switch(selProps.length)
					{
						case 0: alert("******プロパティが選ばれていません******"); this.valE = true; break;
						default:    //選択されたプロパティの数を調べる
					                var i=0;
									var numP=0;
									do{
										if(String(selProps[i]) == "[object Property]"){
											numP++;
										}
										i++;
									}while(i<selProps.length);

									//1つだったら取得
									if(numP > 1){
										alert("******複数のプロパティが選ばれています******");
										this.valE = true;
									}else{
									    //エクスプレッションが使用できるかどうか(CS6以前にも対応)
										if(selProps[selProps.length-1].expression == undefined){
											alert("******このプロパティにはエクスプレッションを適用できません******");
											this.valE = true;
										//*********************** 要検証 *****************************************************
										}else if(String(selProps[selProps.length-1]) == "[object Property]"){
											var pG = new Array();
											var pP = selProps[selProps.length-1].parentProperty;
											var valP = false;
											var i=0;

											//"PropertyGroup" にたどり着くまで逆からプロパティを取得
											do{
												if(String(pP).indexOf("PropertyGroup") != -1){
													this.selProp[i] = pP;
													pP = this.selProp[i].parentProperty;
													i++;
												}else{
													this.selProp.reverse();
													this.selProp.unshift(app.project.activeItem);

													valP = true;
												}
											}while(!valP);
											this.selProp.push(selProps[selProps.length-1]);
										}
									}
									break;
					}

					//if(!this.valE){alert(this.selProp.length);}
				}

			},

			//エクスプレッションメニュー ダイアログ
			exList_Bld: function(palLoc, menuName, menuNum, pal)
			{
				var ePal = pal;
				var exSelf = this;
				this.popObl = new Window("palette", menuName, [0, 0, this.listSize[menuNum][0], this.listSize[menuNum][1]]);
				this.popObl.addEventListener('mousedown', this.mdFunc1);


				//ヘッダあり
				this.popObl.listPop = this.popObl.add("listbox", [0, 0, this.popObl.size[0], this.popObl.size[1]], this.expList[menuNum], {numberOfColumns: 1, showHeaders: false,columnTitles: [menuName]});
				this.popObl.listPop.addEventListener('mousedown', this.mdFunc1);
				this.UI_bgColor255(this.popObl.listPop, [225,225,230]);
				this.UI_fgColor255(this.popObl.listPop, [70,30,150]);
				this.popObl.listPop.onChange = function()
															{
																if(this.selection != null){
																	ePal.edBox.textselection = this.selection;
																}else{

																}
																exSelf.popObl.close();
																exSelf.popObl = null;
															}
				this.popObl.onClose = function()
													{
														ePal.expMenu.selection = null;
													}

				switch(pal.expMenu.selection.index)
				{
					case 0: this.popObl.location = [palLoc[0]-260, palLoc[1]-(this.listSize[0][1]-40)]; break;
					case 2: this.popObl.location = [palLoc[0]-(this.listSize[2][0]+10), palLoc[1]]; break;
					case 10: this.popObl.location = [palLoc[0]-(this.listSize[10][0]+10), palLoc[1]]; break;
					case 18: this.popObl.location = [palLoc[0]-(this.listSize[18][0]+10), palLoc[1]]; break;
					default: this.popObl.location = [palLoc[0]-this.popObl.size[0]-5 ,palLoc[1]];
				}

				this.popObl.show();
				this.popObl.active = true;
			},

			//カスタムExp 編集ダイアログ
            editCtmExp: function(pal, ctmLoc)
            {
                var rowSize = 12;
                edSelf = this;

                edObj = new Window("dialog", "", [0, 0, 450, 300]);
                if(this.os == "Win"){
                    edObj.location = [ctmLoc[0]-120, ctmLoc[1]-50];
                }else if(this.os == "Mac"){
                    edObj.location = [pal.bounds[0]-460, pal.bounds[1]];
                }

                edObj.edGrp = edObj.add("group", [0, 0, edObj.size[0], edObj.size[1]]);
                this.UI_bgColor255(edObj.edGrp, [200,30,30]);

                edObj.infoA = edObj.edGrp.add("statictext", [10, 2, 150, 20], "edit EXP NAME");
                this.UI_font(edObj.infoA, "Impact", "REGURAR", 15);
                this.UI_fgColor255(edObj.infoA, [240,240,240]);

                edObj.infoB = edObj.edGrp.add("statictext", [170, 2, 300, 20], "edit EXPRESSION");
                this.UI_font(edObj.infoB, "Impact", "REGURAR", 15);
                this.UI_fgColor255(edObj.infoB, [230,230,230]);


                edObj.addExpBtn = edObj.edGrp.add("button", [edObj.size[0]-85, 0, edObj.size[0]-45, 20], "NEW");
                this.UI_font(edObj.addExpBtn, "Arial", "BOLD", 13);
                edObj.addExpBtn.onClick = function()
                                                {
                                                    edObj.close();
                                                    edSelf.impTXT();
                                                    edSelf.addCtmExp(pal, ctmLoc);
                                                }

                edObj.okBtn = edObj.edGrp.add("button", [edObj.size[0]-35, 0, edObj.size[0]-4, 20], "OK");
                this.UI_font(edObj.okBtn, "Arial", "BOLD", 13);
                edObj.okBtn.onClick = function()
                                                {
                                                    edSelf.saveEXP();
                                                    edSelf.impTXT();
                                                    edObj.close();
                                                }

                edObj.scGrp = edObj.edGrp.add("group", [5, 22, edObj.edGrp.size[0]-31, 290]);
                this.UI_bgColor255(edObj.scGrp, [220,220,230]);

                edObj.expGrp2 = edObj.scGrp.add("group", [0, 0, edObj.scGrp.size[0], edObj.scGrp.size[1]]);
                this.UI_bgColor255(edObj.expGrp2, [250,250,250]);

                edObj.expName = new Array();
                edObj.ctmExp = new Array();
                var ii=0;
                for(var i=0;i<this.expData.length;i++){
                    var cNum = String(this.expData[i].exp).split(this.CF).length;
                    if(i == 0){
                        edObj.expName[i] = edObj.expGrp2.add("edittext", [10, 5, 150, 1+20], this.expData[i].ename);
                        edObj.expName[i].id = i;
                        edObj.expName[i].onChange = function()
                                                                        {
                                                                            edSelf.expData[this.id].ename = this.text;
                                                                        }

                        edObj.ctmExp[i] = edObj.expGrp2.add("edittext", [160, 5+(i*(cNum*rowSize)), edObj.expGrp2.size[0]-9, 5+((1+i)*(cNum*rowSize))], this.expData[i].exp, {multiline: true, wantReturn:true});
                        edObj.ctmExp[i].id = i;
                        edObj.ctmExp[i].onChange = function()
                                                                        {
                                                                            edSelf.expData[this.id].exp = this.text;
                                                                        }
                        this.UI_bgColor255(edObj.ctmExp[i], [245,240,235]);
                        this.UI_fgColor255(edObj.ctmExp[i], [170,100,30]);
                    }else{
                        var sY = edObj.ctmExp[i-1].bounds[3];
                        edObj.expName[i] = edObj.expGrp2.add("edittext", [10, sY +2, 150, sY +2+20], this.expData[i].ename);
                        edObj.expName[i].id = i;
                        edObj.expName[i].onChange = function()
                                                                        {
                                                                            edSelf.expData[this.id].ename = this.text;
                                                                        }

                        edObj.ctmExp[i] = edObj.expGrp2.add("edittext", [160, sY +1, edObj.expGrp2.size[0]-9, sY +2+ parseInt(cNum*rowSize)], this.expData[i].exp, {multiline: true, wantReturn:true});
                        edObj.ctmExp[i].id = i;
                        edObj.ctmExp[i].onChange = function()
                                                                        {
                                                                            edSelf.expData[this.id].exp = this.text;
                                                                        }
                        this.UI_bgColor255(edObj.ctmExp[i], [245,240,235]);
                        this.UI_fgColor255(edObj.ctmExp[i], [170,100,30]);
                    }
                    if(i == this.expData.length-1){
                        edObj.expGrp2.bounds = [0, 0, edObj.scGrp.size[0],sY +2+ parseInt(cNum*rowSize)+2];
                        //alert(Math.abs(edObj.ctmExp[i].size[1]) +"_"+ Math.abs(edObj.ctmExp[i].location[1]) +"_"+ Math.abs(cNum*rowSize));
                        //alert(edObj.expGrp2.bounds[3]);
                    }
                }
                //alert(edObj.expGrp2.bounds[3]);
                edObj.scBar = edObj.edGrp.add("scrollbar",[edObj.edGrp.size[0]-30, 22, edObj.edGrp.size[0]-10, edObj.size[1]-10], 0, 0, edObj.expGrp2.size[1] - edObj.scGrp.size[1] + 2);
                edObj.scBar.stepdelta = edObj.scBar.maxvalue / 3;
                edObj.scBar.onChanging = function()
                                                            {
                                                                edObj.expGrp2.location = [0, this.value*-1];
                                                                //pal.log.text = this.value*-1;
                                                            }

                edObj.show();
                //edObj.active = true;
            },

                        //新規追加Exp ダイアログ
            addCtmExp: function(pal, ctmLoc)
            {
                var curExpName = "";
                var curExp = "";
                addSelf = this;

                addObj = new Window("dialog", "", [0, 0, 450, 280]);

                if(this.os == "Win"){
                    addObj.location = [ctmLoc[0]-120, ctmLoc[1]-50];
                }else{
                    addObj.location = [pal.bounds[0]-460, pal.bounds[1]];
                }

                addObj.addGrp = addObj.add("panel", [0, 0, addObj.size[0], addObj.size[1]], "", {borderStyle: "black"});
                this.UI_bgColor255(addObj.addGrp, [255,155,25]);

                addObj.infoA = addObj.addGrp.add("statictext", [10, 2, 150, 20], "add EXP NAME");
                this.UI_font(addObj.infoA, "Impact", "REGURAR", 15);
                this.UI_fgColor255(addObj.infoA, [240,240,240]);

                addObj.infoB = addObj.addGrp.add("statictext", [170, 2, 300, 20], "add EXPRESSION");
                this.UI_font(addObj.infoB, "Impact", "REGURAR", 15);
                this.UI_fgColor255(addObj.infoB, [230,230,230]);

                addObj.addExpGrp = addObj.addGrp.add("group", [5, 22, addObj.addGrp.size[0] - 10, addObj.size[1] - 10]);
                this.UI_bgColor255(addObj.addExpGrp, [220,200,180]);

                addObj.addExpName = addObj.addExpGrp.add("edittext", [10, 5, 150, 1+25], "");
                addObj.addExpName.onChange = function()
                                                                {
                                                                    curExpName = this.text;
                                                                }

                addObj.addExp = addObj.addExpGrp.add("edittext", [160, 5, addObj.addExpGrp.size[0]-9, addObj.addExpGrp.size[1] - 40], "", {multiline: true, wantReturn:true});
                addObj.addExp.onChange = function()
                                                                {
                                                                    curExp = this.text + addSelf.CF;
                                                                }
                this.UI_bgColor255(addObj.addExp, [245,240,235]);
                this.UI_fgColor255(addObj.addExp, [170,100,30]);

                addObj.cclBtn = addObj.addExpGrp.add("button", [addObj.addExpGrp.size[0]-155, addObj.addExpGrp.size[1]-35, addObj.addExpGrp.size[0]-75, addObj.addExpGrp.size[1]-5], "CANCEL");
                this.UI_font(addObj.cclBtn, "Impact", "REGURAR", 22);
                this.UI_fgColor255(addObj.cclBtn, [250,80,60]);
                addObj.cclBtn.onClick = function()
                                                            {
                                                                addObj.close();
                                                            }

                addObj.okBtn = addObj.addExpGrp.add("button", [addObj.addExpGrp.size[0]-65, addObj.addExpGrp.size[1]-35, addObj.addExpGrp.size[0]-5, addObj.addExpGrp.size[1]-5], "SAVE");
                this.UI_font(addObj.okBtn, "Impact", "REGURAR", 22);
                this.UI_fgColor255(addObj.okBtn, [250,80,60]);
                addObj.okBtn.onClick = function()
                                                            {
                                                                if(curExpName != "" && curExp != ""){
                                                                        addSelf.expData.push({ename:curExpName, exp:curExp});
                                                                        addSelf.saveEXP();
                                                                        addObj.close();
                                                                }else{
                                                                    alert("******未記入があると保存できません******");
                                                                }
                                                            }

                addObj.show();
            },

            //カスタムExp 保存
            saveEXP: function()
            {
                var saveTxt = "";
                var valE2 = false;

                this.expData.sort(smallName);

                for(var i=0;i<this.expData.length;i++){
                    if(this.expData[i].ename != "" && this.expData[i].exp != ""){
                        saveTxt += "expName:" + this.expData[i].ename +this.CF+ this.expData[i].exp;
                    }else{
                        valE2 = true;
                    }
                }
                //alert(saveTxt);

                if(saveTxt != ""){
                    var exFile = new File(this.txtPath);

                    //UTF-8にエンコード
                    exFile.encoding = "UTF-8";
                    if(exFile.exists){
                        if(exFile.open("w")){
                            try
                            {
                                //複数行を一気に書き込み
                                exFile.writeln(saveTxt);
                                exFile.close();
                                this.impTXT();
                                if(valE2){
                                    alert("******空欄の項目があったので削除しました******");
                                }
                            }catch(e){

                            }
                        }else{
                            alert("******保存できませんでした******");
                        }
                    }else{
                        alert("******ファイルをありませんでした******");
                    }
                }

                //****** ソート用関数 sort(関数名)******
                //ename
                function smallName(a,b)
                {
                    return (a.ename > b.ename) ? 1 : -1 ;
                }

            },

			//カスタムExp ダイアログ
			customExp_bld:function(pal, ctmLoc, ctmNum, dWord)
			{
				cPal = pal;
				csSelf = this;

                var rowSize = 16;

                this.ctmObj = new Window("dialog", "", [0, 0, 350, 250]);
                if(this.os == "Win"){
                    this.ctmObj.location = [ctmLoc[0]-50, ctmLoc[1]+20];
                }else{
                    this.ctmObj.location = [pal.bounds[0]-360, pal.bounds[1]];
                }
                this.ctmObj.ctmGrp = this.ctmObj.add("panel", [0, 0, this.ctmObj.size[0], this.ctmObj.size[1]], "", {borderStyle: "black"});
                this.UI_bgColor255(this.ctmObj.ctmGrp, [150,150,230]);

                this.ctmObj.xBtn = this.ctmObj.ctmGrp.add("button", [this.ctmObj.size[0]-32, 0, this.ctmObj.size[0]-4, 20], "X");
                this.UI_font(this.ctmObj.xBtn, "Arial", "BOLD", 13);
                this.ctmObj.xBtn.onClick = function()
                                                        {
                                                            csSelf.ctmObj.close();
                                                        }

                this.ctmObj.info = this.ctmObj.ctmGrp.add("statictext", [5, 1, 130, 20], "select custom EXP");
                this.UI_font(this.ctmObj.info, "Impact", "REGURAR", 15);
                this.UI_fgColor255(this.ctmObj.info, [240,240,240]);

                this.ctmObj.addExpBtn = this.ctmObj.ctmGrp.add("button", [this.ctmObj.size[0]-82, 0, this.ctmObj.size[0]-34, 20], "EDIT");
                this.UI_font(this.ctmObj.addExpBtn, "Arial", "BOLD", 13);
                this.ctmObj.addExpBtn.onClick = function()
                                                        {
                                                            csSelf.ctmObj.close();
                                                            csSelf.editCtmExp(cPal, ctmLoc);
                                                        }
                this.ctmObj.expGrp = this.ctmObj.ctmGrp.add("group", [5, 22, this.ctmObj.size[0]-24, this.ctmObj.size[1]-10]);
                this.UI_bgColor255(this.ctmObj.expGrp, [220,220,240]);


                this.ctmObj.expName = new Array();
                this.ctmObj.expCode = new Array();
                for(var i=0;i<ctmNum.length;i++){
                    this.ctmObj.expName[i] = this.expData[ctmNum[i]].ename;
                    this.ctmObj.expCode[i] = this.expData[ctmNum[i]].exp;
                }


                this.ctmObj.ctmExp = this.ctmObj.expGrp.add("edittext", [151, 0, this.ctmObj.expGrp.size[0], this.ctmObj.expGrp.size[1]], this.ctmObj.expCode[0], {multiline: true, readonly: true});
                this.UI_font(this.ctmObj.ctmExp, "Arial", "BLACK", 12);
                this.UI_fgColor255(this.ctmObj.ctmExp, [20,50,30]);

                //ヘッダあり
                this.ctmObj.expListBox = this.ctmObj.expGrp.add("listbox", [0, 0, 150, this.ctmObj.expGrp.size[1]], this.ctmObj.expName, {numberOfColumns: 1});
                this.ctmObj.expListBox.selection = 0;
                this.ctmObj.expListBox.active = true;
                this.ctmObj.expListBox.addEventListener('keydown',this.edFunc2);
                this.UI_bgColor255(this.ctmObj.expListBox, [220,220,230]);
                this.UI_font(this.ctmObj.expListBox, "Arial", "BLACK", 11);
                this.UI_fgColor255(this.ctmObj.expListBox, [70,50,30]);
                this.ctmObj.expListBox.onChange = function()
                                                            {
                                                                if(this.selection != null){
                                                                    csSelf.ctmObj.ctmExp.text = csSelf.ctmObj.expCode[this.selection.index];
                                                                }
                                                            }
                this.ctmObj.expListBox.onDoubleClick = function()
                                                            {
                                                                if(this.selection != null){
                                                                    var motoTxt = csSelf.ctmObj.expCode[this.selection.index];
                                                                    //pal.edBox.active = true;
                                                                    pal.edBox.active = false;
                                                                    pal.edBox.textselection = motoTxt.slice(dWord.length, motoTxt.length-1);
                                                                }else{

                                                                }
                                                                csSelf.ctmObj.close();
                                                                csSelf.ctmObj = null;
                                                            }

                this.ctmObj.show();

			},

			//getPropダイアログ
			getDlg: function()
			{
			    this.prDlg = new Window("dialog", "get Property Option", [0, 0, 300, 150]);
			    this.UI_bgColor255(this.prDlg, [43,43,43]);

			    var lyInfo = this.prDlg.add("statictext", [5, 1, 130, 19], "Layer Option");
			    this.UI_fgColor255(lyInfo, [250,180,60]);

			    this.lyGrp = this.prDlg.add("group", [10, 20, 110, 65]);
                this.lyBtnA = this.lyGrp.add("radiobutton", [0, 4, 100, 24], "get Layer Name");
                this.lyBtnA.helpTip = "レイヤーネームで取得";
                this.UI_fgColor255(this.lyBtnA, [250,180,60]);
                this.lyBtnA.value = true;
                this.lyBtnB = this.lyGrp.add("radiobutton", [0, 26, 100, 46], "get Layer Index");
                this.lyBtnB.helpTip = "レイヤーインデックスで取得";
                this.UI_fgColor255(this.lyBtnB, [250,180,60]);


                var prInfo = this.prDlg.add("statictext", [145, 1, 270, 19], "Property Option");
                this.UI_fgColor255(prInfo, [250,180,60]);

                this.prGrp = this.prDlg.add("group", [150, 20, 300, 85]);
                this.prBtnA = this.prGrp.add("radiobutton", [0, 4, 100, 24], "get matchName");
                this.prBtnA.helpTip = "マッチネームで選択プロパティを取得";
                this.UI_fgColor255(this.prBtnA, [250,180,60]);
                this.prBtnA.value = true;
                this.prBtnB = this.prGrp.add("radiobutton", [0, 26, 130, 46], "get property Name");
                this.prBtnB.helpTip = "プロパティ名で選択プロパティを取得";
                this.UI_fgColor255(this.prBtnB, [250,180,60]);
                this.prBtnC = this.prGrp.add("radiobutton", [0, 48, 130, 68], "get property Index");
                this.prBtnC.helpTip = "プロパティインデックスで選択プロパティを取得";
                this.UI_fgColor255(this.prBtnC, [250,180,60]);

                var prSelf = this;

                var prOKBtn = this.prDlg.add("button",[190,110,290,140],"OK");
                prOKBtn.onClick = function()
                                    {
                                        prSelf.prDlg.close()
                                    }

                this.prDlg.onClose = function()
                                    {
                                        if(prSelf.lyBtnA.value){
                                            prSelf.rdVal[0] = "A";
                                        }else if(prSelf.lyBtnB.value){
                                            prSelf.rdVal[0] = "B";
                                        }

                                        if(prSelf.prBtnA.value){
                                            prSelf.rdVal[1] = "A";
                                        }else if(prSelf.prBtnB.value){
                                            prSelf.rdVal[1] = "B";
                                        }else if(prSelf.prBtnC.value){
                                            prSelf.rdVal[1] = "C"
                                        }
                                    };


			    this.prDlg.center();
			    this.prDlg.show();
			},


			//各ボタン用ファンクション*************************************************************************
			//レイヤープロパティをエディタに追加
			addProp: function()
			{
			    this.rdVal = new Array();
			    this.getDlg();
			    //alert(this.rdVal[0] +"_"+ this.rdVal[1]);

			    if(this.rdVal[0] == "A"){
				    var addTxt = "comp("+"\""+ this.selProp[0].name +"\""+").layer("+"\""+ this.selLys[0].name + "\""+")";
			    }else{
			        var addTxt = "comp("+"\""+ this.selProp[0].name +"\""+").layer("+ this.selLys[0].index +")";
			    }

				for(var i=1;i<this.selProp.length;i++){
				    switch (this.rdVal[1])
				    {
				        case "A": addTxt += "("+"\"" + this.selProp[i].matchName +"\""+")"; break;
				        case "B": addTxt += "("+"\"" + this.selProp[i].name +"\""+")"; break;
				        case "C": addTxt += "(" + this.selProp[i].propertyIndex + ")"; break;
				    }
				}
				//addTxt += ";";
				return addTxt
			},

			//エクスプレッションをレイヤープロパティに適用
			applyExp: function(expTxt)
			{
				try{
					app.beginUndoGroup("Exp editor");
					this.selProp[this.selProp.length-1].expression = expTxt;
					app.endUndoGroup();
				}catch(e){
					alert("******このプロパティにはエクスプレッションを適用できません******");
				}
			},

			//エクスプレッションをエディタにロード
			loadExp: function(expObj){
				app.beginUndoGroup("Exp editor");
				expObj.text = this.selProp[this.selProp.length-1].expression;
				app.endUndoGroup();
			},


			//mouseイベントファンクション**********************************************************
			mdFunc1: function(md)
			{
				if(md.button == 2){
					this.popObl.close();
					this.popObl = null;
				}
			},

			mvFunc: function(mv)
			{
				pSelf.scXY = [mv.screenX, mv.screenY];
			},

			//keyイベントファンクション************************************************************
			edFunc: function(ekd)
			{
				//Key Log
				//pal.log.text = ekd.keyName;
				switch(ekd.keyName)
				{
					case "Space":
                                        if(pSelf.os == "Win"){
                                            if(ekd.ctrlKey)
                                            {
                                                //pal.log.text = pSelf.rWord;
                                                var expNum = new Array();
                                                for(var i=0;i<pSelf.expData.length;i++){
                                                    if(pSelf.rWord != ""){
                                                        if(pSelf.expData[i].ename.indexOf(pSelf.rWord) == 0){
                                                            if(expNum.length == 0){
                                                                expNum[0] = i;
                                                            }else{
                                                                expNum.push(i);
                                                            }
                                                        }
                                                    }
                                                }
                                                //alert(expNum.length);
                                                if(expNum.length > 0){
                                                    pSelf.customExp_bld(pal, pSelf.scXY, expNum, pSelf.rWord);
                                                }
                                            }else if(ekd.altKey){
                                                var expNum = new Array();
                                                for(var i=0;i<pSelf.expData.length;i++){
                                                    expNum[i] = i;
                                                }
                                                pSelf.customExp_bld(pal, pSelf.scXY, expNum, "");
                                            }
                                        }else if(pSelf.os == "Mac"){
                                            if(ekd.shiftKey && ekd.ctrlKey)
                                            {
                                                //pal.log.text = pSelf.rWord;
                                                var expNum = new Array();
                                                for(var i=0;i<pSelf.expData.length;i++){
                                                    if(pSelf.rWord != ""){
                                                        if(pSelf.expData[i].ename.indexOf(pSelf.rWord) == 0){
                                                            if(expNum.length == 0){
                                                                expNum[0] = i;
                                                            }else{
                                                                expNum.push(i);
                                                            }
                                                        }
                                                    }
                                                }
                                                //alert(expNum.length);
                                                if(expNum.length > 0){
                                                    pSelf.customExp_bld(pal, pSelf.scXY, expNum, pSelf.rWord);
                                                }
                                            }else if(ekd.altKey){
                                                var expNum = new Array();
                                                for(var i=0;i<pSelf.expData.length;i++){
                                                    expNum[i] = i;
                                                }
                                                pSelf.customExp_bld(pal, pSelf.scXY, expNum, "");
                                            }
                                        }
									pSelf.rWord = "";
									pal.log.text = ""; break;
									break;
					case "Enter": pSelf.rWord = ""; pal.log.text = ""; break;
					case "Control" : pSelf.rWord = ""; pal.log.text = ""; break;
					case "Escape" : pSelf.rWord = ""; pal.log.text = ""; break;
					case "Alt": pSelf.rWord = ""; pal.log.text = ""; break;
					case "Backspace": pSelf.rWord = pSelf.rWord.substring(0, pSelf.rWord.length-1); pal.log.text = ""; break;
					case "Delete": pSelf.rWord = ""; pal.log.text = ""; break;
					default: var curTxt = ekd.keyName;
								if(ekd.keyName != undefined){
									if(!ekd.shiftKey)
									{
										pSelf.rWord += curTxt.toLowerCase();
									}else{
										pSelf.rWord += curTxt;
									}
									pal.log.text = "";
								}
								break;
				}
			},

			//scriptUI graphics 用ファンクション****************************************************
			//backgroundColor(0～255)
			UI_bgColor255: function(uiObj, uiColor)
			{
				var gColor = new Array();
				for(var i=0;i<3;i++){
					gColor[i] = 1/255*Math.round(uiColor[i]);
					//alert(gColor[i]);
				}
				var gUI = uiObj.graphics;
				var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
				gUI.backgroundColor = uiBrush;
			},

			//foregroundColor(0～255)
			UI_fgColor255: function(uiObj, uiColor)
			{
				var gColor = new Array();
				for(var i=0;i<3;i++){
					gColor[i] = 1/255*Math.round(uiColor[i]);
					//alert(gColor[i]);
				}
				var gUI = uiObj.graphics;
				var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
				gUI.foregroundColor = uiPen;
			},

			//font
			UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
			{
				var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
				var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
				uiObj.graphics.font = gFont;
			}

		}

		function exUI_Obj()
		{
			this.selLys = new Array();
			this.selProp = new Array();
			this.valE = false;
			this.shtKey = false;
			this.scXY = new Array();
			this.rWord = "";
			this.rdVal = new Array();

			//ここからメニューリスト**********************************************************
			this.expMenuList = [
                                    "Global",
                                    "Vector Math",
                                    "Random Numbers",
                                    "Interpolation",
                                    "Color Conversion",
                                    "Other Math",
                                    "JavaScript Math",
                                    "Comp",
                                    "Footage",
                                    "Layer < Sub-objects",
                                    "Layer < General",
                                    "Layer < Properties",
                                    "Layer < 3D",
                                    "Layer < Space Transforms",
                                    "Camera",
                                    "Light",
                                    "Effect",
                                    "Mask",
                                    "Property",
                                    "Key",
                                    "MarkerKey"
								];

			this.expList = [
                                [
                                    "comp(name)",
                                    "footage(name)",
                                    "thisComp",
                                    "time",
                                    "colorDepth",
                                    "posterizeTime(framesPerSecond)",
                                    "timeToFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false)",
                                    "framesToTime(frames, fps = 1.0 / thisComp.frameDuration)",
                                    "timeToTimecode(t = time + thisComp.displayStartTime, timecodeBase = 30, isDuration = false)",
                                    "timeToNTSCTimecode(t - time + thisComp.displayStartTime, ntscDropFrame = false, isDuration = false)",
                                    "timeToFeetAndFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, framesPerFoot = 16, isDuration = false)",
                                    "timeToCurrentFormat(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false, ntscDropFrame = thisComp.ntscDropFrame)"
                                ],
                                [
                                    "add(vec1, vec2)",
                                    "sub(vec1, vec2)",
                                    "mul(vec, amount)",
                                    "div(vec, amount)",
                                    "clamp(value, limit1, limit2)",
                                    "dot(vec1, vec2)",
                                    "cross(vec1, vec2)",
                                    "normalize(vec)",
                                    "length(vec)",
                                    "length(point1, point2)",
                                    "lookAt(fromPoint, ayPoint)"
                                ],
                                [
                                    "seedRandom(seed, timeless = false)",
                                    "random()",
                                    "random(maxValOrArray)",
                                    "random(minValOrArray, maxValOrArray)",
                                    "gaussRandom()",
                                    "gaussRandom(maxValOrArray)",
                                    "gaussRandom(minValOrArray, maxValOrArray)",
                                    "noise(valOrArray)"
                                ],
                                [
                                    "linear(t, value1, value2)",
                                    "linear(t, tMin, tMax, value1, value2)",
                                    "ease(t, value1, value2)",
                                    "ease(t, tMin, tMax, value1, value2)",
                                    "easeIn(t, value1, value2)",
                                    "easeIn(t, tMin, tMax, value1, value2)",
                                    "easeOut(t, value1, value2)",
                                    "easeOut(t, tMin, tMax, value1, value2)"
                                ],
                                [
                                    "rgbToHsl(rgbaArray)",
                                    "hslToRgb(hslaArray)"
                                ],
                                [
                                    "degreesToRadians(degrees)",
                                    "radiansToDegrees(radians)"
                                ],
                                [
                                    "Math.cos(value)",
                                    "Math.acos(value)",
                                    "Math.tan(value)",
                                    "Math.atan(value)",
                                    "Math.atan2(y, x)",
                                    "Math.sin(value)",
                                    "Math.sqrt(value)",
                                    "Math.exp(value)",
                                    "Math.pow(value, exponent)",
                                    "Math.log(value)",
                                    "Math.abs(value)",
                                    "Math.round(value)",
                                    "Math.ceil(value)",
                                    "Math.floor(value)",
                                    "Math.min(value1, value2)",
                                    "Math.max(value1, value2)",
                                    "Math.PI",
                                    "Math.E",
                                    "Math.LOG2E",
                                    "Math.LOG10E",
                                    "Math.LN2",
                                    "Math.LN10",
                                    "Math.SQRT2",
                                    "Math.SQRT1_2"
                                ],
                                [
                                    "layer(index)",
                                    "layer(name)",
                                    "layer(otherLayer, relIndex)",
                                    "marker",
                                    "numLayers",
                                    "activeCamera",
                                    "width",
                                    "height",
                                    "duration",
                                    "ntscDropFrame",
                                    "displayStartTime",
                                    "frameDuration",
                                    "shutterAngle",
                                    "shutterPhase",
                                    "bgColor",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "width",
                                    "height",
                                    "duration",
                                    "frameDuration",
                                    "ntscDropFrame",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "source",
                                    "sourceTime(t = time)",
                                    "effect(name)",
                                    "effect(index)",
                                    "mask(name)",
                                    "mask(index)"
                                ],
                                [
                                    "width",
                                    "height",
                                    "index",
                                    "parent",
                                    "hasParent",
                                    "inPoint",
                                    "outPoint",
                                    "startTime",
                                    "hasVideo",
                                    "hasAudio",
                                    "enabled",
                                    "active",
                                    "audioActive",
                                    "sampleImage(point, radius = [.5, .5], postEffect = true, t = time)"
                                ],
                                [
                                    "anchorPoint",
                                    "position",
                                    "scale",
                                    "rotation",
                                    "opacity",
                                    "audioLevels",
                                    "timeRemap",
                                    "marker",
                                    "name"
                                ],
                                [
                                    "orientation",
                                    "rotationX",
                                    "rotationY",
                                    "rotationZ",
                                    "castsShadows",
                                    "lightTransmission",
                                    "acceptsShadows",
                                    "acceptsLights",
                                    "ambient",
                                    "diffuse",
                                    "specularIntensity",
                                    "specularShininess",
                                    "metal"
                                ],
                                [
                                    "toComp(point, t = time)",
                                    "fromComp(point, t = time)",
                                    "toWorld(point, t = time)",
                                    "fromWorld(point, t = time)",
                                    "toCompVec(vec, t = time)",
                                    "fromCompVec(vec, t = time)",
                                    "toWorldVec(vec, t = time)",
                                    "fromWorldVec(vec, t = time)",
                                    "fromCompToSurface(point, t = time)"
                                ],
                                [
                                    "pointOfInterest",
                                    "zoom",
                                    "depthOfField",
                                    "focusDistance",
                                    "aperture",
                                    "blurLevel",
                                    "active"
                                ],
                                [
                                    "pointOfInterest",
                                    "intensity",
                                    "color",
                                    "coneAngle",
                                    "coneFeather",
                                    "shadowDarkness",
                                    "shadowDiffusion"
                                ],
                                [
                                    "active",
                                    "param(name)",
                                    "param(index)",
                                    "name"
                                ],
                                [
                                    "maskOpacity",
                                    "maskFeather",
                                    "maskExpansion",
                                    "invert",
                                    "name"
                                ],
                                [
                                    "value",
                                    "valueAtTime(t)",
                                    "velocity",
                                    "velocityAtTime(t)",
                                    "speed",
                                    "speedAtTime(t)",
                                    "wiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "temporalWiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "smooth(width = .2, samples = 5, t = time)",
                                    "loopIn(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopOut(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopInDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "loopOutDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "key(index)",
                                    "key(markerName)",
                                    "nearestKey(t)",
                                    "numkeys",
                                    "name",
                                    "active",
                                    "enabled",
                                    "propertyGroup(countUp = 1)",
                                    "propertyIndex"
                                ],
                                [
                                    "value",
                                    "time",
                                    "index"
                                ],
                                [
                                    "comment",
                                    "chapter",
                                    "url",
                                    "frameTarget",
                                    "eventCuePoint",
                                    "cuePointName",
                                    "parameters",
                                    "duration"
                                ]
							]
		}

		//main******************************************************
		var EX = new exUI_Obj(thisObj);

		//アプリのバージョン確認
		//alert(parseFloat(app.version));
		if (parseFloat(app.version) < 11)
		{
			//alert(pUI.strErr, "blind pnl UI");
			return;
		}else{
			exUI = EX.exUI_build(thisObj);
		}
		//**********************************************************
	}
})();