﻿// test_popupUI_CC    14/05/22
//
//  popupのUIテスト
//


(function()
{
    floating_UI(this);

    function floating_UI(thisObj)
    {
        function runScr()
        {
            this.gpSize = 18;
            this.scGP = new Array();
            this.scInfo = new Array();
            this.param = null;
            this.valD = false;
            this.valE = false;

            //ここからメニューリスト**********************************************************
            this.expMenuList = [
                                    "Global",
                                    "Vector Math",
                                    "Random Numbers",
                                    "Interpolation",
                                    "Color Conversion",
                                    "Other Math",
                                    "JavaScript Math",
                                    "Comp",
                                    "Footage",
                                    "Layer < Sub-objects",
                                    "Layer < General",
                                    "Layer < Properties",
                                    "Layer < 3D",
                                    "Layer < Space Transforms",
                                    "Camera",
                                    "Light",
                                    "Effect",
                                    "Mask",
                                    "Property",
                                    "Key",
                                    "MarkerKey"
                                ];

            this.expList = [
                                [
                                    "comp(name)",
                                    "footage(name)",
                                    "thisComp",
                                    "time",
                                    "colorDepth",
                                    "posterizeTime(framesPerSecond)",
                                    "timeToFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false)",
                                    "framesToTime(frames, fps = 1.0 / thisComp.frameDuration)",
                                    "timeToTimecode(t = time + thisComp.displayStartTime, timecodeBase = 30, isDuration = false)",
                                    "timeToNTSCTimecode(t - time + thisComp.displayStartTime, ntscDropFrame = false, isDuration = false)",
                                    "timeToFeetAndFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, framesPerFoot = 16, isDuration = false)",
                                    "timeToCurrentFormat(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false, ntscDropFrame = thisComp.ntscDropFrame)"
                                ],
                                [
                                    "add(vec1, vec2)",
                                    "sub(vec1, vec2)",
                                    "mul(vec, amount)",
                                    "div(vec, amount)",
                                    "clamp(value, limit1, limit2)",
                                    "dot(vec1, vec2)",
                                    "cross(vec1, vec2)",
                                    "normalize(vec)",
                                    "length(vec)",
                                    "length(point1, point2)",
                                    "lookAt(fromPoint, ayPoint)"
                                ],
                                [
                                    "seedRandom(seed, timeless = false)",
                                    "random()",
                                    "random(maxValOrArray)",
                                    "random(minValOrArray, maxValOrArray)",
                                    "gaussRandom()",
                                    "gaussRandom(maxValOrArray)",
                                    "gaussRandom(minValOrArray, maxValOrArray)",
                                    "noise(valOrArray)"
                                ],
                                [
                                    "linear(t, value1, value2)",
                                    "linear(t, tMin, tMax, value1, value2)",
                                    "ease(t, value1, value2)",
                                    "ease(t, tMin, tMax, value1, value2)",
                                    "easeIn(t, value1, value2)",
                                    "easeIn(t, tMin, tMax, value1, value2)",
                                    "easeOut(t, value1, value2)",
                                    "easeOut(t, tMin, tMax, value1, value2)"
                                ],
                                [
                                    "rgbToHsl(rgbaArray)",
                                    "hslToRgb(hslaArray)"
                                ],
                                [
                                    "degreesToRadians(degrees)",
                                    "radiansToDegrees(radians)"
                                ],
                                [
                                    "Math.cos(value)",
                                    "Math.acos(value)",
                                    "Math.tan(value)",
                                    "Math.atan(value)",
                                    "Math.atan2(y, x)",
                                    "Math.sin(value)",
                                    "Math.sqrt(value)",
                                    "Math.exp(value)",
                                    "Math.pow(value, exponent)",
                                    "Math.log(value)",
                                    "Math.abs(value)",
                                    "Math.round(value)",
                                    "Math.ceil(value)",
                                    "Math.floor(value)",
                                    "Math.min(value1, value2)",
                                    "Math.max(value1, value2)",
                                    "Math.PI",
                                    "Math.E",
                                    "Math.LOG2E",
                                    "Math.LOG10E",
                                    "Math.LN2",
                                    "Math.LN10",
                                    "Math.SQRT2",
                                    "Math.SQRT1_2"
                                ],
                                [
                                    "layer(index)",
                                    "layer(name)",
                                    "layer(otherLayer, relIndex)",
                                    "marker",
                                    "numLayers",
                                    "activeCamera",
                                    "width",
                                    "height",
                                    "duration",
                                    "ntscDropFrame",
                                    "displayStartTime",
                                    "frameDuration",
                                    "shutterAngle",
                                    "shutterPhase",
                                    "bgColor",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "width",
                                    "height",
                                    "duration",
                                    "frameDuration",
                                    "ntscDropFrame",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "source",
                                    "sourceTime(t = time)",
                                    "effect(name)",
                                    "effect(index)",
                                    "mask(name)",
                                    "mask(index)"
                                ],
                                [
                                    "width",
                                    "height",
                                    "index",
                                    "parent",
                                    "hasParent",
                                    "inPoint",
                                    "outPoint",
                                    "startTime",
                                    "hasVideo",
                                    "hasAudio",
                                    "enabled",
                                    "active",
                                    "audioActive",
                                    "sampleImage(point, radius = [.5, .5], postEffect = true, t = time)"
                                ],
                                [
                                    "anchorPoint",
                                    "position",
                                    "scale",
                                    "rotation",
                                    "opacity",
                                    "audioLevels",
                                    "timeRemap",
                                    "marker",
                                    "name"
                                ],
                                [
                                    "orientation",
                                    "rotationX",
                                    "rotationY",
                                    "rotationZ",
                                    "castsShadows",
                                    "lightTransmission",
                                    "acceptsShadows",
                                    "acceptsLights",
                                    "ambient",
                                    "diffuse",
                                    "specularIntensity",
                                    "specularShininess",
                                    "metal"
                                ],
                                [
                                    "toComp(point, t = time)",
                                    "fromComp(point, t = time)",
                                    "toWorld(point, t = time)",
                                    "fromWorld(point, t = time)",
                                    "toCompVec(vec, t = time)",
                                    "fromCompVec(vec, t = time)",
                                    "toWorldVec(vec, t = time)",
                                    "fromWorldVec(vec, t = time)",
                                    "fromCompToSurface(point, t = time)"
                                ],
                                [
                                    "pointOfInterest",
                                    "zoom",
                                    "depthOfField",
                                    "focusDistance",
                                    "aperture",
                                    "blurLevel",
                                    "active"
                                ],
                                [
                                    "pointOfInterest",
                                    "intensity",
                                    "color",
                                    "coneAngle",
                                    "coneFeather",
                                    "shadowDarkness",
                                    "shadowDiffusion"
                                ],
                                [
                                    "active",
                                    "param(name)",
                                    "param(index)",
                                    "name"
                                ],
                                [
                                    "maskOpacity",
                                    "maskFeather",
                                    "maskExpansion",
                                    "invert",
                                    "name"
                                ],
                                [
                                    "value",
                                    "valueAtTime(t)",
                                    "velocity",
                                    "velocityAtTime(t)",
                                    "speed",
                                    "speedAtTime(t)",
                                    "wiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "temporalWiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "smooth(width = .2, samples = 5, t = time)",
                                    "loopIn(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopOut(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopInDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "loopOutDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "key(index)",
                                    "key(markerName)",
                                    "nearestKey(t)",
                                    "numkeys",
                                    "name",
                                    "active",
                                    "enabled",
                                    "propertyGroup(countUp = 1)",
                                    "propertyIndex"
                                ],
                                [
                                    "value",
                                    "time",
                                    "index"
                                ],
                                [
                                    "comment",
                                    "chapter",
                                    "url",
                                    "frameTarget",
                                    "eventCuePoint",
                                    "cuePointName",
                                    "parameters",
                                    "duration"
                                ]
                            ]
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CC 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            //ビルド
            bld_DLG: function()
            {
                dSelf = this;
                this.dlg = (thisObj instanceof Panel) ? thisObj : new Window("palette", " test popup UI CC", [ 0, 0, 720, 470 ]);
                this.dlg.addEventListener('mousemove',this.mvFunc);

                var ySize = (this.expMenuList.length*this.gpSize) + (this.expMenuList.length*3)+2;
                this.scGrp = this.dlg.add("panel",[5,5,155,ySize+5],"",{borderStyle:"black"});
                this.UI_bgColor255(this.scGrp,[40,40,40]);

                for(var i=0;i<this.expMenuList.length;i++){
                    this.scGP[i] = this.scGrp.add("group",[0,(i*this.gpSize) + (i*3),150,((i+1)*this.gpSize-1) + ((i+1)*3)]);
                    this.UI_bgColor255(this.scGP[i],[70,70,70]);
                    this.scGP[i].id = i;
                    this.scGP[i].nameID = "GP";
                    this.scGP[i].addEventListener('mouseover',this.moFunc);
                    this.scGP[i].addEventListener('mouseout',this.mouFunc);

                    this.scInfo[i] = this.scGP[i].add("statictext",[5,0,this.scGP[i].size[0],this.scGP[i].size[1]],this.expMenuList[i]); this.scInfo[i].justify = "left";
                    this.UI_fgColor255(this.scInfo[i],[230,230,230]);
                }

                this.logTxt = this.dlg.add("statictext",[10,ySize+5,200,ySize+20],""); this.logTxt.justify = "left";
                this.UI_fgColor255(this.logTxt,[255,190,90]);

                this.dlg.onClose = function()
                                            {
                                                if(dSelf.valD){
                                                    dSelf.popDlg.close();
                                                }
                                            }

                this.dlg.center();
                this.dlg.location[1] -= 50;
                this.dlg.show();
            },

            //ポップアップ ビルド
            popup_Bld: function(dSelf,valY,curIndex)
            {
                if(curIndex == 0){
                    var sizeX = 850;
                }else{
                    var sizeX = 350;
                }
                var sizeY = dSelf.expList[curIndex].length * 21;
                dSelf.popDlg = new Window("window"," ",[0,0,sizeX,sizeY],{borderless: true});
                var listGP = dSelf.popDlg.add("listbox",[0,0,sizeX,sizeY],dSelf.expList[curIndex]);
                listGP.nameID = "WIN";
                listGP.addEventListener('mouseout',this.mouFunc);

                var ddSelf = dSelf;
                listGP.onChange = function()
                                            {
                                                ddSelf.param = listGP.selection;
                                                ddSelf.popDlg.close();
                                                alert(ddSelf.param);
                                            }

                dSelf.popDlg.location = [dSelf.dlg.location[0]+155,valY];
                dSelf.popDlg.show();
                dSelf.valD = true;
            },

            //maouse event*************************************************************************
            //mouseover
            moFunc: function(mo)
            {
                var yLoc = dSelf.dlg.location[1] + dSelf.scGrp.location[1] + dSelf.scGP[this.id].location[1]-20;
                if(this.nameID == "GP"){
                    dSelf.UI_bgColor255(dSelf.scGP[this.id],[120,120,240]);

                    if(dSelf.valD){
                        dSelf.popDlg.close();
                        dSelf.popup_Bld(dSelf,yLoc,this.id);
                    }else{
                        dSelf.popup_Bld(dSelf,yLoc,this.id);
                    }
                }
            },

            //mouseout
            mouFunc: function(mou)
            {
                for(var i=0;i<dSelf.scGP.length;i++){
                    dSelf.UI_bgColor255(dSelf.scGP[i],[70,70,70]);
                }
                if(this.nameID == "WIN"){
                    dSelf.popDlg.close();
                    dSelf.valD = false;
                }
            },

            //mousemove
            mvFunc: function(mv){
                var xMin = dSelf.dlg.location[0] + dSelf.scGrp.location[0]+2;
                var yMin = dSelf.dlg.location[1] + dSelf.scGrp.location[1]+2;
                var yMax = dSelf.dlg.location[1] + dSelf.scGrp.location[1] + dSelf.scGrp.size[1]-2;
                if(mv.screenX <= xMin || mv.screenY <= yMin || yMax <= mv.screenY){
                    if(dSelf.valD){
                        dSelf.popDlg.close();
                        dSelf.valD = false;
                    }
                }
                dSelf.logTxt.text = String(xMin) +"_"+ String(yMin) +"_"+ String(yMax) + " : "+ String(mv.screenX) +" , "+ String(mv.screenY);
            },

            //scriptUI graphics 用ファンクション****************************************************
            //backgroundColor(0～255)
            UI_bgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
                gUI.backgroundColor = uiBrush;
            },

            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.bld_DLG();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CC over)
        if (parseFloat(app.version) < 12)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();