﻿// EXP_Editor_CC ver 1.0   14/06/10
//
//  エクスプレッションを編集するエディターのCC版です。
//  基本的にはCS6版と同じですが、若干変更しています。
//
//  現在、Macでは未検証です。
//
//  email:   curryeggs@gmail.com       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_eggs



(function()
{
    EXP_Editor_CC(this);

    function EXP_Editor_CC(thisObj)
    {
        function runScr()
        {
            //Item
            this.scItem = new Array();
            for(var c=0;c<10;c++){
                //桁数を揃える(頭に0を付ける)
                var aNum = ("0" + (c + 1)).slice(-2);
                this.scItem[c] = "items_" + aNum;
            }

            this.gpSize = 18;
            this.scGP = new Array();
            this.scInfo = new Array();
            this.minMax = new Array();
            this.arrVal = new Array();
            this.upLoc = new Array();
            this.downLoc = new Array();
            this.param = null;
            this.rWord = "";
            this.valD = false;
            this.valD2 = false;
            this.valED = false;
            this.valE = false;

            //ここからリスト**********************************************************
            this.expMenuList = [
                                    ["Global",850],
                                    ["Vector Math",220],
                                    ["Random Numbers",270],
                                    ["Interpolation",220],
                                    ["Color Conversion",200],
                                    ["Other Math",200],
                                    ["JavaScript Math",200],
                                    ["Comp",200],
                                    ["Footage",200],
                                    ["Layer < Sub-objects",200],
                                    ["Layer < General",350],
                                    ["Layer < Properties",200],
                                    ["Layer < 3D",200],
                                    ["Layer < Space Transforms",220],
                                    ["Camera",200],
                                    ["Light",200],
                                    ["Effect",200],
                                    ["Mask",200],
                                    ["Property",350],
                                    ["Key",200],
                                    ["MarkerKey",200]
                                ];

            this.expList = [
                                [
                                    "comp(name)",
                                    "footage(name)",
                                    "thisComp",
                                    "time",
                                    "colorDepth",
                                    "posterizeTime(framesPerSecond)",
                                    "timeToFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false)",
                                    "framesToTime(frames, fps = 1.0 / thisComp.frameDuration)",
                                    "timeToTimecode(t = time + thisComp.displayStartTime, timecodeBase = 30, isDuration = false)",
                                    "timeToNTSCTimecode(t - time + thisComp.displayStartTime, ntscDropFrame = false, isDuration = false)",
                                    "timeToFeetAndFrames(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, framesPerFoot = 16, isDuration = false)",
                                    "timeToCurrentFormat(t = time + thisComp.displayStartTime, fps = 1.0 / thisComp.frameDuration, isDuration = false, ntscDropFrame = thisComp.ntscDropFrame)"
                                ],
                                [
                                    "add(vec1, vec2)",
                                    "sub(vec1, vec2)",
                                    "mul(vec, amount)",
                                    "div(vec, amount)",
                                    "clamp(value, limit1, limit2)",
                                    "dot(vec1, vec2)",
                                    "cross(vec1, vec2)",
                                    "normalize(vec)",
                                    "length(vec)",
                                    "length(point1, point2)",
                                    "lookAt(fromPoint, ayPoint)"
                                ],
                                [
                                    "seedRandom(seed, timeless = false)",
                                    "random()",
                                    "random(maxValOrArray)",
                                    "random(minValOrArray, maxValOrArray)",
                                    "gaussRandom()",
                                    "gaussRandom(maxValOrArray)",
                                    "gaussRandom(minValOrArray, maxValOrArray)",
                                    "noise(valOrArray)"
                                ],
                                [
                                    "linear(t, value1, value2)",
                                    "linear(t, tMin, tMax, value1, value2)",
                                    "ease(t, value1, value2)",
                                    "ease(t, tMin, tMax, value1, value2)",
                                    "easeIn(t, value1, value2)",
                                    "easeIn(t, tMin, tMax, value1, value2)",
                                    "easeOut(t, value1, value2)",
                                    "easeOut(t, tMin, tMax, value1, value2)"
                                ],
                                [
                                    "rgbToHsl(rgbaArray)",
                                    "hslToRgb(hslaArray)"
                                ],
                                [
                                    "degreesToRadians(degrees)",
                                    "radiansToDegrees(radians)"
                                ],
                                [
                                    "Math.cos(value)",
                                    "Math.acos(value)",
                                    "Math.tan(value)",
                                    "Math.atan(value)",
                                    "Math.atan2(y, x)",
                                    "Math.sin(value)",
                                    "Math.sqrt(value)",
                                    "Math.exp(value)",
                                    "Math.pow(value, exponent)",
                                    "Math.log(value)",
                                    "Math.abs(value)",
                                    "Math.round(value)",
                                    "Math.ceil(value)",
                                    "Math.floor(value)",
                                    "Math.min(value1, value2)",
                                    "Math.max(value1, value2)",
                                    "Math.PI",
                                    "Math.E",
                                    "Math.LOG2E",
                                    "Math.LOG10E",
                                    "Math.LN2",
                                    "Math.LN10",
                                    "Math.SQRT2",
                                    "Math.SQRT1_2"
                                ],
                                [
                                    "layer(index)",
                                    "layer(name)",
                                    "layer(otherLayer, relIndex)",
                                    "marker",
                                    "numLayers",
                                    "activeCamera",
                                    "width",
                                    "height",
                                    "duration",
                                    "ntscDropFrame",
                                    "displayStartTime",
                                    "frameDuration",
                                    "shutterAngle",
                                    "shutterPhase",
                                    "bgColor",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "width",
                                    "height",
                                    "duration",
                                    "frameDuration",
                                    "ntscDropFrame",
                                    "pixelAspect",
                                    "name"
                                ],
                                [
                                    "source",
                                    "sourceTime(t = time)",
                                    "effect(name)",
                                    "effect(index)",
                                    "mask(name)",
                                    "mask(index)"
                                ],
                                [
                                    "width",
                                    "height",
                                    "index",
                                    "parent",
                                    "hasParent",
                                    "inPoint",
                                    "outPoint",
                                    "startTime",
                                    "hasVideo",
                                    "hasAudio",
                                    "enabled",
                                    "active",
                                    "audioActive",
                                    "sampleImage(point, radius = [.5, .5], postEffect = true, t = time)"
                                ],
                                [
                                    "anchorPoint",
                                    "position",
                                    "scale",
                                    "rotation",
                                    "opacity",
                                    "audioLevels",
                                    "timeRemap",
                                    "marker",
                                    "name"
                                ],
                                [
                                    "orientation",
                                    "rotationX",
                                    "rotationY",
                                    "rotationZ",
                                    "castsShadows",
                                    "lightTransmission",
                                    "acceptsShadows",
                                    "acceptsLights",
                                    "ambient",
                                    "diffuse",
                                    "specularIntensity",
                                    "specularShininess",
                                    "metal"
                                ],
                                [
                                    "toComp(point, t = time)",
                                    "fromComp(point, t = time)",
                                    "toWorld(point, t = time)",
                                    "fromWorld(point, t = time)",
                                    "toCompVec(vec, t = time)",
                                    "fromCompVec(vec, t = time)",
                                    "toWorldVec(vec, t = time)",
                                    "fromWorldVec(vec, t = time)",
                                    "fromCompToSurface(point, t = time)"
                                ],
                                [
                                    "pointOfInterest",
                                    "zoom",
                                    "depthOfField",
                                    "focusDistance",
                                    "aperture",
                                    "blurLevel",
                                    "active"
                                ],
                                [
                                    "pointOfInterest",
                                    "intensity",
                                    "color",
                                    "coneAngle",
                                    "coneFeather",
                                    "shadowDarkness",
                                    "shadowDiffusion"
                                ],
                                [
                                    "active",
                                    "param(name)",
                                    "param(index)",
                                    "name"
                                ],
                                [
                                    "maskOpacity",
                                    "maskFeather",
                                    "maskExpansion",
                                    "invert",
                                    "name"
                                ],
                                [
                                    "value",
                                    "valueAtTime(t)",
                                    "velocity",
                                    "velocityAtTime(t)",
                                    "speed",
                                    "speedAtTime(t)",
                                    "wiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "temporalWiggle(freq, amp, octaves = 1, amp_mult = .5, t = time)",
                                    "smooth(width = .2, samples = 5, t = time)",
                                    "loopIn(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopOut(type = "+"\""+"cycle"+"\""+", numKeyframes = 0)",
                                    "loopInDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "loopOutDuration(type = "+"\""+"cycle"+"\""+", duration = 0)",
                                    "key(index)",
                                    "key(markerName)",
                                    "nearestKey(t)",
                                    "numkeys",
                                    "name",
                                    "active",
                                    "enabled",
                                    "propertyGroup(countUp = 1)",
                                    "propertyIndex"
                                ],
                                [
                                    "value",
                                    "time",
                                    "index"
                                ],
                                [
                                    "comment",
                                    "chapter",
                                    "url",
                                    "frameTarget",
                                    "eventCuePoint",
                                    "cuePointName",
                                    "parameters",
                                    "duration"
                                ]
                            ];
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CC 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                this.defPath = this.aePath + "EXP_Editor_CC";
                this.txtPath = this.defPath + "/EXPeditor_customEXP.txt";

                //モニター解像度 チェック
                var chkVal = new Array();
                chkVal = $.screens;
                this.moniSize = [Math.floor(String(chkVal[0]).split(":")[1].split("-")[1]), Math.floor(String(chkVal[0]).split(":")[2])];

                //alert(this.aePath);
            },

            //カスタムエクスプレッションを読み込み
            impTXT: function()
            {
                this.expData = new Array();

                var impFile = new File(this.txtPath);
                if(impFile.exists){
                    if(impFile.open("r")){
                        try
                        {
                            var i=0;
                            while(!impFile.eof)
                            {
                                var txt = impFile.readln();

                                if(txt.indexOf("expName:") == 0){
                                    if(this.expData.length == 0){
                                        this.expData[0] = new Array();
                                        this.expData[0] = {ename:txt.split("expName:")[1], exp:""};
                                    }else{
                                        i++;
                                        this.expData[i] = new Array();
                                        this.expData[i] = {ename:txt.split("expName:")[1], exp:""};
                                    }
                                }else{
                                    if(this.expData[i].exp == ""){
                                        this.expData[i].exp = txt;
                                    }else{
                                        this.expData[i].exp += this.CF + txt;
                                    }
                                }
                            }
                        }catch(e){

                        }
                    }else{
                        alert("******ファイルを読み込めませんでした******");
                        this.valE = true;
                    }
                }else{
                    alert("******ファイルを開けませんでした******");
                    this.valE = true;
                }
                //alert(this.expData.length);
            },

            //ビルド
            bld_DLG: function()
            {
                dSelf = this;
                this.dlg = (thisObj instanceof Panel) ? thisObj : new Window("palette", " EXP Editor CC  ver 1.0", [ 0, 0, 720, 470 ], {resizeable: true});
                this.dlg.addEventListener('mousemove',this.mvFunc);

                this.addBtn = this.dlg.add("button", [170, 10, 290, 40], "get Property");
                this.addBtn.helpTip = "選択プロパティを取得";
                this.addBtn.onClick = function()
                                                {
                                                    dSelf.getProp(dSelf);
                                                    if(!dSelf.valE){
                                                        dSelf.edBox.textselection = dSelf.addProp(dSelf);
                                                        dSelf.edBox.active = true;
                                                        dSelf.rWord = "";
                                                        dSelf.log.text = "";
                                                    }
                                                }

                this.loadBtn = this.dlg.add("button", [300, 10, 420, 40], "load Exp");
                this.loadBtn.helpTip = "選択プロパティのエクスプレッションを読み込み";
                this.loadBtn.onClick = function()
                                                {
                                                    dSelf.getProp(dSelf);
                                                    if(!dSelf.valE){
                                                        dSelf.loadExp(dSelf,dSelf.edBox);
                                                        dSelf.edBox.active = true;
                                                        dSelf.rWord = "";
                                                        dSelf.log.text = "";
                                                    }
                                                }

                this.clBtn = this.dlg.add("button", [this.dlg.size[0]-290, 10, this.dlg.size[0]-170, 40], "clear");
                this.clBtn.helpTip = "テキストエリアをクリア";
                this.clBtn.onClick = function()
                                            {
                                                dSelf.edBox.text = "";
                                                dSelf.rWord = "";
                                                dSelf.log.text = "";
                                                dSelf.edBox.active = true;
                                            }

                this.applyBtn = this.dlg.add("button", [this.dlg.size[0]-160, 10, this.dlg.size[0]-50, 40], "apply EXP");
                this.applyBtn.helpTip = "選択プロパティのエクスプレッションに適用" +this.CF+
                                       "クリア状態で適用するとエクスプレッションを解除";
               this.applyBtn.onClick = function()
                                                {
                                                    dSelf.getProp(dSelf);
                                                    if(!dSelf.valE){
                                                        dSelf.applyExp(dSelf,dSelf.edBox.text);
                                                        dSelf.edBox.active = true;
                                                        dSelf.rWord = "";
                                                        dSelf.log.text = "";
                                                    }
                                                }

                var ySize = (this.expMenuList.length * 21) + 2;
                this.scGrp = this.dlg.add("panel",[5,5,155,ySize+5],"",{borderStyle:"black"});
                this.UI_bgColor255(this.scGrp,[40,40,40]);

                for(var i=0;i<this.expMenuList.length;i++){
                    this.scGP[i] = this.scGrp.add("group",[0,(i*this.gpSize) + (i*3),150,((i+1)*this.gpSize-1) + ((i+1)*3)]);
                    this.UI_bgColor255(this.scGP[i],[70,70,70]);
                    this.scGP[i].id = i;
                    this.scGP[i].nameID = "GP";
                    this.upLoc.push(((i+1)*this.gpSize-1) + ((i+1)*3));
                    this.downLoc.push(this.scGP[i].location[1]);
                    this.scGP[i].loc = [this.scGP[i].location[1], ((i+1)*this.gpSize-1) + ((i+1)*3)];
                    this.scGP[i].addEventListener('mouseover',this.moFunc);
                    this.scGP[i].addEventListener('mouseout',this.mouFunc);

                    this.scInfo[i] = this.scGP[i].add("statictext",[5,0,this.scGP[i].size[0],this.scGP[i].size[1]],this.expMenuList[i][0]); this.scInfo[i].justify = "left";
                    this.UI_fgColor255(this.scInfo[i],[230,230,230]);

                    if(i == 0){
                        this.minMax[0] = this.scGP[i].location[1];
                    }else if(i == this.scItem.length-1){
                        this.minMax[1] = this.scGP[i].location[1];
                    }
                }

                this.logInfo = this.dlg.add("statictext", [170,50,225,65],"EXP検索:"); this.logInfo.justify = "left";
                this.UI_fgColor255(this.logInfo,[255,190,90]);
                this.log = this.dlg.add("statictext", [225,50,250,65],""); this.log.justify = "left";
                this.UI_fgColor255(this.log,[255,190,90]);

                var infoTxt = this.dlg.add("statictext", [260,50,710,65],"※ Enter [x NumPad] : 改行 / Alt + X : タブスペース / Alt + Space or 右クリック : EXP検索"); infoTxt.justify = "right";
                this.UI_fgColor255(infoTxt,[230,230,230]);


                this.edBox = this.dlg.add("edittext", [170,70,this.dlg.size[0]-10,this.dlg.size[1]-20], "", {multiline: true, wantReturn:true, borderless: true});
                this.UI_bgColor255(this.edBox,[50,50,50]);
                this.UI_fgColor255(this.edBox,[80,200,255]);
                this.edBox.addEventListener('keydown',this.edFunc);
                this.edBox.addEventListener('mousedown',this.mdFunc);

                this.logTxt = this.dlg.add("statictext",[10,this.dlg.size[1]-20,200,this.dlg.size[1]-5],""); this.logTxt.justify = "left";
                this.UI_fgColor255(this.logTxt,[255,190,90]);

                this.dlg.onResize = function()
                                            {
                                                if(dSelf.dlg.size[0] < 720){dSelf.dlg.size[0] = 720;}
                                                if(dSelf.dlg.size[1] < 470){dSelf.dlg.size[1] = 470;}
                                                dSelf.edBox.size = [dSelf.dlg.size[0]-180,dSelf.dlg.size[1]-90];
                                                dSelf.clBtn.location[0] = dSelf.dlg.size[0]-290;
                                                dSelf.applyBtn.location[0] = dSelf.dlg.size[0]-160;
                                                dSelf.logTxt.location[1] = dSelf.dlg.size[1]-20;
                                            }
                this.dlg.onClose = function()
                                            {
                                                if(dSelf.valD){
                                                    dSelf.popDlg.close();
                                                }
                                                if(dSelf.valDD){
                                                    dSelf.expPopDlg.close();
                                                }
                                            }

                this.edBox.active = true;
                this.dlg.center();
                this.dlg.show();
            },

            //expMenu_Bld
            expMenu_Bld: function(dSelf,valMD,ctmNum)
            {
                dSelf.valDD = false;
                var ySize = ((ctmNum.length+1) * 21) + 2;
                dSelf.expPopDlg = new Window("window"," ",[0,0,150,ySize],{borderless: true});
                dSelf.mnGrp = dSelf.expPopDlg.add("panel",[0,0,dSelf.expPopDlg.size[0],dSelf.expPopDlg.size[1]],"",{borderStyle:"black"});
                dSelf.UI_bgColor255(dSelf.mnGrp,[40,40,40]);

                dSelf.mnGP = new Array();
                dSelf.mnInfo = new Array();
                for(var i=0;i<ctmNum.length+1;i++){
                    dSelf.mnGP[i] = dSelf.mnGrp.add("group",[0,(i*dSelf.gpSize) + (i*3),150,((i+1)*dSelf.gpSize-1) + ((i+1)*3)]);
                    dSelf.UI_bgColor255(dSelf.mnGP[i],[70,70,70]);
                    dSelf.mnGP[i].id = i;
                    if(i == 0){
                        dSelf.mnGP[i].expID = "NON";
                    }else{
                        dSelf.mnGP[i].expID = ctmNum[i-1];
                    }
                    dSelf.mnGP[i].nameID = "GP";
                    dSelf.upLoc.push(((i+1)*dSelf.gpSize-1) + ((i+1)*3));
                    dSelf.downLoc.push(dSelf.mnGP[i].location[1]);
                    dSelf.mnGP[i].loc = [dSelf.mnGP[i].location[1], ((i+1)*dSelf.gpSize-1) + ((i+1)*3)];
                    dSelf.mnGP[i].addEventListener('mouseover',dSelf.moFunc2);
                    dSelf.mnGP[i].addEventListener('mouseout',dSelf.mouFunc2);
                    dSelf.mnGP[i].addEventListener('mousedown',dSelf.mdFunc2);

                    if(i == 0){
                        dSelf.mnInfo[i] = dSelf.mnGP[i].add("statictext",[5,0,dSelf.mnGP[i].size[0],dSelf.mnGP[i].size[1]],"EDIT");
                    }else{
                        dSelf.mnInfo[i] = dSelf.mnGP[i].add("statictext",[5,0,dSelf.mnGP[i].size[0],dSelf.mnGP[i].size[1]],dSelf.expData[ctmNum[i-1]].ename);
                    }
                    dSelf.mnInfo[i].justify = "left";
                    dSelf.UI_fgColor255(dSelf.mnInfo[i],[230,230,230]);

                    if(i == 0){
                        dSelf.minMax[0] = dSelf.mnGP[i].location[1];

                        dSelf.UI_fgColor255(dSelf.mnInfo[i],[250,190,50]);
                        dSelf.mnGP[i].size[1] = dSelf.mnGP[i].size[1]-4;
                        var sepLine = dSelf.mnGrp.add("group",[0,dSelf.mnGP[i].size[1]+1,150,dSelf.mnGP[i].size[1]+3]);
                        dSelf.UI_bgColor255(sepLine,[150,150,150]);
                    }else if(i == dSelf.scItem.length-1){
                        dSelf.minMax[1] = dSelf.mnGP[i].location[1];
                    }
                }

                var ddSelf = dSelf;
                dSelf.expPopDlg.onClose = function()
                                                    {
                                                        if(ddSelf.valD2){
                                                            ddSelf.popDlg2.close();
                                                            ddSelf.valD2 = false;
                                                        }
                                                    }

                if(dSelf.moniSize[1]-50 < valMD[1]+dSelf.expPopDlg.size[1]){
                    valMD[1] = dSelf.moniSize[1]-50-dSelf.expPopDlg.size[1];
                }

                dSelf.expPopDlg.location = valMD;
                dSelf.expPopDlg.show();

                dSelf.valDD = true;
            },

            //popup_Bld
            popup_Bld: function(dSelf,valMD,curIndex)
            {
                var sizeX = dSelf.expMenuList[curIndex][1];
                var sizeY = dSelf.expList[curIndex].length * 20 + 2;
                dSelf.popDlg = new Window("window"," ",[0,0,sizeX,sizeY],{borderless: true});
                var listGP = dSelf.popDlg.add("listbox",[0,0,sizeX,sizeY],dSelf.expList[curIndex]);
                listGP.nameID = "WIN";
                listGP.addEventListener('mouseout',this.mouFunc);

                var ddSelf = dSelf;
                listGP.onChange = function()
                                            {
                                                ddSelf.param = this.selection;
                                                ddSelf.popDlg.close();
                                                ddSelf.valD = false;
                                                if(ddSelf.valDD){
                                                    ddSelf.expPopDlg.close();
                                                    ddSelf.valDD = false;
                                                }
                                                ddSelf.edBox.textselection = ddSelf.param;
                                            }

                if(dSelf.moniSize[1]-50 < valMD[1]+dSelf.popDlg.size[1]){
                    valMD[1] = dSelf.moniSize[1]-50-dSelf.popDlg.size[1];
                }
                dSelf.popDlg.location = valMD;
                dSelf.popDlg.show();
                dSelf.valD = true;
            },

            //popup_Bld2
            popup_Bld2: function(dSelf,valMD,curIndex)
            {
                dSelf.popDlg2 = new Window("window"," ",[0,0,350,200],{borderless: true});
                var cmPnl = dSelf.popDlg2.add("panel",[0,0,dSelf.popDlg2.size[0],dSelf.popDlg2.size[1]],"",{borderStyle:"black"});
                var cmExp = cmPnl.add("statictext",[1,1,dSelf.popDlg2.size[0]-1,dSelf.popDlg2.size[1]-1],dSelf.expData[curIndex].exp,{multiline:true});
                cmExp.nameID = "WIN";
                cmExp.addEventListener('mouseout',this.mouFunc2);
                var ddSelf = dSelf;
                cmExp.onChange = function()
                                            {
                                                ddSelf.param = this.selection;
                                                ddSelf.popDlg2.close();
                                                ddSelf.valD2 = false;
                                                if(ddSelf.valDD){
                                                    ddSelf.expPopDlg.close();
                                                    ddSelf.valDD = false;
                                                }
                                                ddSelf.edBox.textselection = ddSelf.param;
                                            }

                dSelf.popDlg2.location = valMD;
                dSelf.popDlg2.show();
                dSelf.valD2 = true;
            },

            //レイヤープロパティ取得
            getProp: function(gSelf)
            {
                gSelf.selLys = new Array();
                gSelf.selProp = new Array();
                var selProps = new Array();

                try{
                    gSelf.selLys = app.project.activeItem.selectedLayers;
                    selProps = gSelf.selLys[0].selectedProperties;
                }catch(e){
                    alert("******レイヤーが選ばれていません******");
                    gSelf.valE = true;
                }

                if(!gSelf.valE){
                    switch(selProps.length)
                    {
                        case 0: alert("******プロパティが選ばれていません******"); gSelf.valE = true; break;
                        default:    //選択されたプロパティの数を調べる
                                    var i=0;
                                    var numP=0;
                                    do{
                                        if(String(selProps[i]) == "[object Property]"){
                                            numP++;
                                        }
                                        i++;
                                    }while(i<selProps.length);

                                    //1つだったら取得
                                    if(numP > 1){
                                        alert("******複数のプロパティが選ばれています******");
                                        gSelf.valE = true;
                                    }else{
                                        //エクスプレッションが使用できるかどうか(CS6以前にも対応)
                                        if(selProps[selProps.length-1].expression == undefined){
                                            alert("******このプロパティにはエクスプレッションを適用できません******");
                                            gSelf.valE = true;
                                        //*********************** 要検証 *****************************************************
                                        }else if(String(selProps[selProps.length-1]) == "[object Property]"){
                                            var pG = new Array();
                                            var pP = selProps[selProps.length-1].parentProperty;
                                            var valP = false;
                                            var i=0;

                                            //"PropertyGroup" の先頭にたどり着くまで逆からプロパティを取得
                                            do{
                                                //alert(pP);
                                                if(String(pP).indexOf("PropertyGroup") != -1){
                                                    gSelf.selProp[i] = pP;
                                                    pP = gSelf.selProp[i].parentProperty;
                                                    i++;
                                                }else{
                                                    gSelf.selProp.reverse();
                                                    gSelf.selProp.unshift(app.project.activeItem);

                                                    valP = true;
                                                }
                                            }while(!valP);
                                            gSelf.selProp.push(selProps[selProps.length-1]);
                                        }
                                    }
                                    break;
                    }

                    //if(!this.valE){alert(this.selProp.length);}
                }

            },

            //getPropダイアログ
            getDlg: function(gSelf)
            {
                gSelf.prDlg = new Window("dialog", "get Property Option", [0, 0, 300, 150]);
                gSelf.UI_bgColor255(gSelf.prDlg, [43,43,43]);

                var lyInfo = gSelf.prDlg.add("statictext", [5, 1, 130, 19], "Layer Option");
                gSelf.UI_fgColor255(lyInfo, [250,180,60]);

                gSelf.lyGrp = gSelf.prDlg.add("group", [10, 20, 110, 65]);
                gSelf.lyBtnA = gSelf.lyGrp.add("radiobutton", [0, 4, 100, 24], "get Layer Name");
                gSelf.lyBtnA.helpTip = "レイヤーネームで取得";
                gSelf.UI_fgColor255(gSelf.lyBtnA, [250,180,60]);
                gSelf.lyBtnA.value = true;
                gSelf.lyBtnB = gSelf.lyGrp.add("radiobutton", [0, 26, 100, 46], "get Layer Index");
                gSelf.lyBtnB.helpTip = "レイヤーインデックスで取得";
                gSelf.UI_fgColor255(gSelf.lyBtnB, [250,180,60]);


                var prInfo = gSelf.prDlg.add("statictext", [145, 1, 270, 19], "Property Option");
                gSelf.UI_fgColor255(prInfo, [250,180,60]);

                gSelf.prGrp = gSelf.prDlg.add("group", [150, 20, 300, 85]);
                gSelf.prBtnA = gSelf.prGrp.add("radiobutton", [0, 4, 100, 24], "get matchName");
                gSelf.prBtnA.helpTip = "マッチネームで選択プロパティを取得";
                gSelf.UI_fgColor255(gSelf.prBtnA, [250,180,60]);
                gSelf.prBtnA.value = true;
                gSelf.prBtnB = gSelf.prGrp.add("radiobutton", [0, 26, 130, 46], "get property Name");
                gSelf.prBtnB.helpTip = "プロパティ名で選択プロパティを取得";
                gSelf.UI_fgColor255(gSelf.prBtnB, [250,180,60]);
                gSelf.prBtnC = gSelf.prGrp.add("radiobutton", [0, 48, 130, 68], "get property Index");
                gSelf.prBtnC.helpTip = "プロパティインデックスで選択プロパティを取得";
                gSelf.UI_fgColor255(gSelf.prBtnC, [250,180,60]);

                var prSelf = gSelf;

                var prOKBtn = gSelf.prDlg.add("button",[190,110,290,140],"OK");
                prOKBtn.onClick = function()
                                    {
                                        prSelf.prDlg.close()
                                    }

                gSelf.prDlg.onClose = function()
                                    {
                                        if(prSelf.lyBtnA.value){
                                            prSelf.rdVal[0] = "A";
                                        }else if(prSelf.lyBtnB.value){
                                            prSelf.rdVal[0] = "B";
                                        }

                                        if(prSelf.prBtnA.value){
                                            prSelf.rdVal[1] = "A";
                                        }else if(prSelf.prBtnB.value){
                                            prSelf.rdVal[1] = "B";
                                        }else if(prSelf.prBtnC.value){
                                            prSelf.rdVal[1] = "C"
                                        }
                                    };


                gSelf.prDlg.center();
                gSelf.prDlg.show();
            },

            //カスタムExp
            editCmExp: function(dSelf)
            {
                var ddSelf = dSelf;
                var cmList = new Array();
                for(var i=0;i<dSelf.expData.length+1;i++){
                    if(i == 0){
                        cmList.push("New Exp");
                    }else{
                        cmList.push(dSelf.expData[i-1].ename);
                    }
                }

                dSelf.edcmDlg = new Window("dialog", " Edit Custom EXP", [0, 0, 600, 400],{resizeable: true});

                var info1 = dSelf.edcmDlg.add("statictext",[10,40,200,55],"Select EXP"); info1.justify = "left";
                dSelf.UI_fgColor255(info1,[255,190,90]);
                var dlObj = dSelf.edcmDlg.add("dropdownlist",[10,60,200,85],cmList);
                if(0 < dSelf.expData.length){
                    dlObj.selection = 1;
                    var strTxt = [dSelf.expData[0].ename,dSelf.expData[0].exp];
                }else{
                    dlObj.selection = 0;
                    var strTxt = ["※EXPを追加",""];
                }
                dlObj.onChange = function()
                                        {
                                            if(dlObj.selection != null){
                                                if(dlObj.selection.index == 0){
                                                    edNObj.text = "※EXPを追加";
                                                    eddObj.text = "";
                                                    okABtn.text = "Add EXP";
                                                }else{
                                                    edNObj.text = ddSelf.expData[dlObj.selection.index-1].ename;
                                                    eddObj.text = ddSelf.expData[dlObj.selection.index-1].exp;
                                                    okABtn.text = "Edit EXP";
                                                }
                                            }
                                        }

                var info2 = dSelf.edcmDlg.add("statictext",[210,40,560,55],"Edit EXP Name"); info2.justify = "left";
                dSelf.UI_fgColor255(info2,[255,190,90]);
                var edNGrp = dSelf.edcmDlg.add("group",[210,60,560,90]);
                dSelf.UI_bgColor255(edNGrp,[50,50,50]);
                var edNObj = edNGrp.add("edittext",[0,5,350,25],strTxt[0],{borderless: true});
                dSelf.UI_bgColor255(edNObj,[50,50,50]);
                dSelf.UI_fgColor255(edNObj,[80,200,255]);

                var info3 = dSelf.edcmDlg.add("statictext",[210,95,280,110],"Edit EXP"); info3.justify = "left";
                dSelf.UI_fgColor255(info3,[255,190,90]);
                var info4 = dSelf.edcmDlg.add("statictext",[285,95,560,110],"※ Enter [x NumPad] : 改行 / Alt + X : タブスペース"); info4.justify = "left";
                dSelf.UI_fgColor255(info4,[230,230,230]);
                var eddObj = dSelf.edcmDlg.add("edittext",[210,115,590,390],strTxt[1],{multiline:true, wantReturn:true, borderless: true});
                dSelf.UI_bgColor255(eddObj,[50,50,50]);
                dSelf.UI_fgColor255(eddObj,[80,200,255]);
                eddObj.addEventListener('keydown',dSelf.edFunc2);

                var dlABtn = dSelf.edcmDlg.add("button",[220,5,320,30],"Delete EXP");
                dlABtn.helpTip = "選択中のEXPを削除します";
                dlABtn.onClick = function()
                                        {
                                            if(0 < dlObj.selection.index){
                                                //配列から削除
                                                ddSelf.expData.splice(dlObj.selection.index-1,1);
                                                edNObj.text = "※EXPを追加";
                                                eddObj.text = "";

                                                //リストを更新して再表示
                                                while(1 < dlObj.children.length)
                                                {
                                                    dlObj.remove(1);
                                                }
                                                for(var i=0;i<ddSelf.expData.length;i++){
                                                    dlObj.add("item",ddSelf.expData[i].ename,i+1);
                                                }
                                                dlObj.selection = 0;
                                            }
                                        }
                var saveABtn = dSelf.edcmDlg.add("button",[380,5,480,30],"Save");
                saveABtn.helpTip = "編集内容を保存します";
                saveABtn.onClick = function()
                                        {
                                            ddSelf.saveEXP(ddSelf);
                                            ddSelf.edcmDlg.close();
                                        }
                var okABtn = dSelf.edcmDlg.add("button",[490,5,590,30],"Add EXP");
                okABtn.helpTip = "一時的に適用します ※Saveしない限り保存されません";
                okABtn.onClick = function()
                                        {
                                            var curNO = 0;
                                            //追加
                                            if(dlObj.selection.index == 0){
                                                if(edNObj.text != "" && eddObj.text != ""){
                                                    //配列に追加後、名前でソート
                                                    ddSelf.expData.push({ename:edNObj.text, exp:eddObj.text});
                                                    edNObj.text = "※EXPを追加";
                                                    eddObj.text = "";
                                                    ddSelf.expData.sort(ddSelf.smallName);
                                                }else{
                                                    alert("未入力の欄があります");
                                                }
                                            //編集
                                            }else{
                                                ddSelf.expData[dlObj.selection.index-1].ename = edNObj.text;
                                                ddSelf.expData[dlObj.selection.index-1].exp = eddObj.text;
                                                curNO = dlObj.selection.index;
                                            }
                                            //リストを更新して再表示
                                            while(1 < dlObj.children.length)
                                            {
                                                dlObj.remove(1);
                                            }
                                            for(var i=0;i<ddSelf.expData.length;i++){
                                                dlObj.add("item",ddSelf.expData[i].ename,i+1);
                                            }
                                            dlObj.selection = curNO;
                                        }

                dSelf.edcmDlg.onResize = function()
                                                {
                                                    if(ddSelf.edcmDlg.size[0] < 600){
                                                        ddSelf.edcmDlg.size[0] = 600;
                                                    }
                                                    if(ddSelf.edcmDlg.size[1] < 400){
                                                        ddSelf.edcmDlg.size[1] = 400;
                                                    }

                                                    edNObj.size[0] = ddSelf.edcmDlg.size[0]-250;
                                                    eddObj.size = [ddSelf.edcmDlg.size[0]-220,ddSelf.edcmDlg.size[1]-125];
                                                }
                dSelf.edcmDlg.onClose = function()
                                                {
                                                    ddSelf.valED = false;
                                                    ddSelf.impTXT();
                                                }

                dSelf.edcmDlg.center();
                dSelf.edcmDlg.show();
                dSelf.valED = true;
            },

            //カスタムExp 保存
            saveEXP: function(dSelf)
            {
                var saveTxt = "";
                var valE2 = false;

                for(var i=0;i<dSelf.expData.length;i++){
                    if(dSelf.expData[i].ename != "" && dSelf.expData[i].exp != ""){
                        if(i == 0){
                            saveTxt = "expName:" + dSelf.expData[i].ename +dSelf.CF+ dSelf.expData[i].exp;
                        }else{
                            saveTxt += dSelf.CF+ "expName:" + dSelf.expData[i].ename +dSelf.CF+ dSelf.expData[i].exp;
                        }
                    }else{
                        valE2 = true;
                    }
                }
                //alert(saveTxt);

                if(saveTxt != ""){
                    var exFile = new File(dSelf.txtPath);

                    //UTF-8にエンコード
                    exFile.encoding = "UTF-8";
                    if(exFile.exists){
                        if(exFile.open("w")){
                            try
                            {
                                //複数行を一気に書き込み
                                exFile.writeln(saveTxt);
                                exFile.close();
                                dSelf.impTXT();
                            }catch(e){

                            }
                        }else{
                            alert("******保存できませんでした******");
                        }
                    }else{
                        alert("******ファイルをありませんでした******");
                    }
                }
            },

            //****** ソート用関数 sort(関数名)******
            smallName: function(a,b)
            {
                return (a.ename > b.ename) ? 1 : -1 ;
            },

            //各ボタン用ファンクション*************************************************************************
            //レイヤープロパティをエディタに追加
            addProp: function(gSelf)
            {
                gSelf.rdVal = new Array();
                gSelf.getDlg(gSelf);
                //alert(gSelf.rdVal[0] +"_"+ gSelf.rdVal[1]);

                if(gSelf.rdVal[0] == "A"){
                    var addTxt = "comp("+"\""+ gSelf.selProp[0].name +"\""+").layer("+"\""+ gSelf.selLys[0].name + "\""+")";
                }else{
                    var addTxt = "comp("+"\""+ gSelf.selProp[0].name +"\""+").layer("+ gSelf.selLys[0].index +")";
                }

                for(var i=1;i<gSelf.selProp.length;i++){
                    switch (gSelf.rdVal[1])
                    {
                        case "A": addTxt += "("+"\"" + gSelf.selProp[i].matchName +"\""+")"; break;
                        case "B": addTxt += "("+"\"" + gSelf.selProp[i].name +"\""+")"; break;
                        case "C": addTxt += "(" + gSelf.selProp[i].propertyIndex + ")"; break;
                    }
                }
                //addTxt += ";";
                return addTxt
            },

            //エクスプレッションをレイヤープロパティに適用
            applyExp: function(gSelf,expTxt)
            {
                try{
                    app.beginUndoGroup("Exp editor");
                    gSelf.selProp[gSelf.selProp.length-1].expression = expTxt;
                    app.endUndoGroup();
                }catch(e){
                    alert("******このプロパティにはエクスプレッションを適用できません******");
                }
            },

            //エクスプレッションをエディタにロード
            loadExp: function(gSelf,expObj){
                app.beginUndoGroup("Exp editor");
                expObj.text = gSelf.selProp[gSelf.selProp.length-1].expression;
                app.endUndoGroup();
            },

            //keyイベントファンクション************************************************************
            edFunc: function(ekd)
            {
               switch(ekd.keyName)
                {
                   case "X":    //Tab Space
                                if(ekd.altKey){
                                    dSelf.edBox.textselection = dSelf.tabS;
                                //X
                                }else{
                                    var curTxt = ekd.keyName;
                                    if(ekd.keyName != undefined){
                                        if(!ekd.shiftKey)
                                        {
                                            dSelf.rWord += curTxt.toLowerCase();
                                        }else{
                                            dSelf.rWord += curTxt;
                                        }
                                        dSelf.log.text = dSelf.rWord;
                                    }
                                }
                                break;
                   case "Space":    if(ekd.altKey){
                                        if(dSelf.rWord != ""){
                                            var expNum = new Array();
                                            for(var i=0;i<dSelf.expData.length;i++){
                                                if(dSelf.expData[i].ename.indexOf(dSelf.rWord) == 0){
                                                    expNum.push(i);
                                                }
                                            }
                                            //alert(expNum.length);
                                            if(expNum.length > 0){
                                                dSelf.expMenu_Bld(dSelf,[dSelf.dlg.location[0]+200,dSelf.dlg.location[1]+100],expNum);
                                            }
                                        }else{
                                            var expNum = new Array();
                                            for(var i=0;i<dSelf.expData.length;i++){
                                                expNum[i] = i;
                                            }
                                            dSelf.expMenu_Bld(dSelf,[dSelf.dlg.location[0]+200,dSelf.dlg.location[1]+100],expNum);
                                        }
                                    }
                                    dSelf.rWord = "";
                                    dSelf.log.text = "";
                                    break;
                    case "Enter": dSelf.rWord = ""; dSelf.log.text = ""; break;
                    case "Control" : dSelf.rWord = ""; dSelf.log.text = ""; break;
                    case "Escape" : dSelf.rWord = ""; dSelf.log.text = ""; break;
                    case "Right": break;
                    case "Left": break;
                    case "Up": break;
                    case "Down": break;
                    case "Alt": break;
                    case "Shift": break;
                    case "Backspace": dSelf.rWord = dSelf.rWord.substring(0, dSelf.rWord.length-1); dSelf.log.text = dSelf.rWord; break;
                    case "Delete": dSelf.rWord = ""; dSelf.log.text = ""; break;
                    default:    var curTxt = ekd.keyName;
                                if(ekd.keyName != undefined){
                                    if(!ekd.shiftKey)
                                    {
                                        dSelf.rWord += curTxt.toLowerCase();
                                    }else{
                                        dSelf.rWord += curTxt;
                                    }
                                    dSelf.log.text = dSelf.rWord;
                                }
                                break;
                }
            },

            edFunc2: function(ekd)
            {
               switch(ekd.keyName)
                {
                   case "X":    //Tab Space
                                if(ekd.altKey){
                                    this.textselection = dSelf.tabS;
                                }
                                break;
                }
            },

            //maouse event*************************************************************************
            //mousedown
            mdFunc: function(md)
            {
                //右クリック
                if(md.button == 2){
                    if(dSelf.rWord != ""){
                        var expNum = new Array();
                        for(var i=0;i<dSelf.expData.length;i++){
                            if(dSelf.expData[i].ename.indexOf(dSelf.rWord) == 0){
                                expNum.push(i);
                            }
                        }
                        //alert(expNum.length);
                        if(expNum.length > 0){
                            dSelf.expMenu_Bld(dSelf,[md.screenX,md.screenY-10],expNum);
                        }
                    }else{
                        var expNum = new Array();
                        for(var i=0;i<dSelf.expData.length;i++){
                            expNum[i] = i;
                        }
                        dSelf.expMenu_Bld(dSelf,[md.screenX,md.screenY-10],expNum);
                    }
                }
                dSelf.valED = false;
            },

            mdFunc2: function(md)
            {
                //左クリック
                if(md.button == 0){
                    if(dSelf.valD2){
                        if(this.expID != "NON"){
                            var strExp = dSelf.expData[this.expID].exp.substring(dSelf.rWord.length,dSelf.expData[this.expID].exp.length);
                            dSelf.edBox.textselection = strExp;
                            dSelf.expPopDlg.close();
                        }
                    }else if(this.expID == "NON"){
                        if(! dSelf.valED){
                            dSelf.expPopDlg.close();
                            dSelf.editCmExp(dSelf);
                        }
                    }
                //右クリック
                }else if(md.button == 2){
                    dSelf.expPopDlg.close();
                }
            },

            //mouseover
            moFunc: function(mo)
            {
                var xLoc = dSelf.dlg.location[0]+155;
                var yLoc = dSelf.dlg.location[1] + dSelf.scGrp.location[1] + dSelf.scGP[this.id].location[1]-20;
                if(this.nameID == "GP"){
                    dSelf.UI_bgColor255(dSelf.scGP[this.id],[120,120,240]);

                    if(dSelf.valD){
                        dSelf.popDlg.close();
                        dSelf.popup_Bld(dSelf,[xLoc,yLoc],this.id);
                    }else{
                        dSelf.popup_Bld(dSelf,[xLoc,yLoc],this.id);
                    }
                }
            },

            moFunc2: function(mo)
            {
                var xLoc = dSelf.expPopDlg.location[0]+151;
                var yLoc = mo.screenY-20;
                if(this.nameID == "GP"){
                    dSelf.UI_bgColor255(dSelf.mnGP[this.id],[120,120,240]);

                    if(dSelf.valD2){
                        dSelf.popDlg2.close();
                        dSelf.valD2 = false;
                        if(this.expID != "NON"){
                            dSelf.popup_Bld2(dSelf,[xLoc,yLoc],this.expID);
                            dSelf.valED = false;
                        }
                    }else{
                        if(this.expID != "NON"){
                            dSelf.popup_Bld2(dSelf,[xLoc,yLoc],this.expID);
                            dSelf.valED = false;
                        }
                    }
                }
            },

            //mouseout
            mouFunc: function(mou)
            {
                for(var i=0;i<dSelf.scGP.length;i++){
                    dSelf.UI_bgColor255(dSelf.scGP[i],[70,70,70]);
                }
                if(this.nameID == "WIN"){
                    dSelf.popDlg.close();
                    dSelf.valD = false;
                }
            },

            mouFunc2: function(mou)
            {
                for(var i=0;i<dSelf.mnGP.length;i++){
                    dSelf.UI_bgColor255(dSelf.mnGP[i],[70,70,70]);
                }
                if(this.nameID == "WIN"){
                    dSelf.popDlg2.close();
                    dSelf.valD2 = false;
                }
            },

            //mousemove
            mvFunc: function(mv){
                if(dSelf.valDD){
                    var xMin = dSelf.expPopDlg.location[0];
                    var yMin = dSelf.expPopDlg.location[1];
                    var yMax = dSelf.expPopDlg.location[1] + dSelf.expPopDlg.size[1];
                }else if(dSelf.valD){
                    var xMin = dSelf.dlg.location[0] + dSelf.scGrp.location[0]+2;
                    var yMin = dSelf.dlg.location[1] + dSelf.scGrp.location[1]+2;
                    var yMax = dSelf.dlg.location[1] + dSelf.scGrp.location[1] + dSelf.scGrp.size[1]-2;
                }
                if(mv.screenX <= xMin || mv.screenY <= yMin || yMax <= mv.screenY){
                    if(dSelf.valD){
                        dSelf.popDlg.close();
                        dSelf.valD = false;
                        if(dSelf.valDD){
                            dSelf.expPopDlg.close();
                            dSelf.valDD = false;
                        }
                    }else if(dSelf.valDD){
                        dSelf.expPopDlg.close();
                        dSelf.valDD = false;
                    }
                }
                dSelf.logTxt.text = String(xMin) +"_"+ String(yMin) +"_"+ String(yMax) + " : "+ String(mv.screenX) +"/"+ String(mv.screenY);
            },

            //scriptUI graphics 用ファンクション****************************************************
            //get backgroundColor255
            getUI_bgColor255: function(uiObj)
            {
                var curColor = uiObj.graphics.backgroundColor.color;
                var bgColor = new Array();
                for(var i=0;i<3;i++){
                    bgColor[i] = Math.round(curColor[i] * 255);
                }

                return bgColor;
            },

            //backgroundColor(0～255)
            UI_bgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
                gUI.backgroundColor = uiBrush;
            },

            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            //font
            UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
            {
                var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
                var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
                uiObj.graphics.font = gFont;
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.impTXT();
                    if(! this.valE){
                        this.bld_DLG();
                    }
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CC over)
        if (parseFloat(app.version) < 12)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();