//    fontChanger CC  ver.1.0  2014.07.04
//
//
//    プロジェクト内にある複数のテキストレイヤーのフォント設定を変更するスクリプトです。
//
//    OSによって環境が変わるので適用したいフォントを登録する必要があります。
//    ※Photoshop がインストールされている場合のみ、フォントリストを自動で取得するスクリプトを同封しました。(psFontList.jsx)
//      Photoshop か Adobe ExtendScript Toolkit からスクリプトを実行し、"fontChanger_CC" フォルダを保存場所に指定してください。
//
//
//   ＝インストール＝
//
//   "fontChanger_CC" フォルダごと、AfterEffects の "Scripts" フォルダに移動してください。
//
//
//
//
//   使用方法などは下記のブログを参照してください。
//
//
//
//    =動作確認=
//
//    AfterEffects CC～
//
//    windows7   動作確認済
//
//
//   email:   curry_eggs@gmail.com       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_eggs
//
//

(function()
{

//main
app.beginUndoGroup("fontChanger");

FC_Obj(this);

app.endUndoGroup();


	function FC_Obj(thisObj)
	{
        function fcUI_Obj()
        {
            this.fontDataZ = new Array();
            this.fontDataH = new Array();
            this.fontData = new Array();
            this.actComp = null;
            this.compTxtLys = new Array();
            this.selTxtLys = new Array();
            this.allTxtLys = new Array();
            this.fID = 0;
            this.sID = 0;
            this.fontID = null;
            this.sizeList = [6,8,9,10,11,12,14,18,24,30,36,48,60,72,100,150,200,300];
            this.valS = false;
            this.valR = false;
            this.valG = false;
            this.valB = false;
            this.valSW = false;
            this.curX = 0;
            this.valSize = 0;
            this.valRed = 0;
            this.valGreen = 0;
            this.valBlue = 0;
            this.valsWidth = 0;
            this.valJustify = "left";

            this.valUI = false;
        }

		fcUI_Obj.prototype =
		{
		    //アプリバージョン確認・エラーコメント
            strErr: "****** CC 以上じゃないですよっと ******",

			//OSが、Win か Mac か
			osCHK: function()
			{
			    //AE CS バージョン取得
                var verVal = parseInt(app.version.split(".")[0]) - 5;
				if($.os.indexOf("Windows")==0){
					this.os = "Win";
					//CS4 で 64bit OSかどうか
                    //親フォルダのパス(Win)
                    this.defPath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts";
					//パスのバックスラッシュ(Win)
					this.cN = "\\";
					//改行コード(Win)
					this.CF = "\r\n";
					//フォントリストのパス
					this.txtPath = this.defPath + "/fontChanger_CC/fontListWin.txt";
					//フォントリスト ファイル名
                    this.fontList = "fontListWin.txt";
				}else if($.os.indexOf("Mac")==0){
					this.os = "Mac";
					//AE Scriptsフォルダパス
                    this.defPath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts";
					//パスのバックスラッシュ(Mac)
					this.cN = "/";
					//改行コード(Mac)
					this.CF = "\n";
					//フォントリストのパス
					this.txtPath = this.defPath + "/fontChanger_CC/fontListMac.txt";
					//フォントリスト ファイル名
					this.fontList = "fontListMac.txt";
				}

				//AE CS バージョン
				this.cs = verVal;

                //タブスペース
				this.cT = "\t";

				//alert(this.txtPath);
			},

			//フォントリストを読み込み
			impTXT: function()
			{
				this.fontData = new Array();
				this.fontDataZ = new Array();
				this.fontDataH = new Array();

				var impFile = new File(this.txtPath);
				if(impFile.exists){
					if(impFile.open("r")){
						try
						{
							var f=0;
							var ff=0;
							while(!impFile.eof)
							{
								var txt = impFile.readln();
								var txtList = new Array();
								var sList = new Array();
								var pList = new Array();
								if(this.os == "Win"){
									if(txt.indexOf("Windows") != 0){
										txtList = txt.split("//");
										for(var i=2;i<txtList.length;i++){
											sList.push(txtList[i].split(":")[0]);
											pList.push(txtList[i].split(":")[1]);
										}

										//連想配列
										if(this.CheckLength(txtList[0], 1)){
											this.fontDataZ[f] = {jName: txtList[0], eName: txtList[1], fStyle: sList, pName: pList};
											f++;
										}else{
											this.fontDataH[ff] = {jName: txtList[0], eName: txtList[1], fStyle: sList, pName: pList};
											ff++;
										}
									}
								}else if(this.os == "Mac"){
									if(txt.indexOf("Mac") != 0){
										txtList = txt.split("//");
										for(var i=2;i<txtList.length;i++){
											sList.push(txtList[i].split(":")[0]);
											pList.push(txtList[i].split(":")[1]);
										}

										//連想配列
										if(this.CheckLength(txtList[0], 1)){
											this.fontDataZ[f] = {jName: txtList[0], eName: txtList[1], fStyle: sList, pName: pList};
											f++
										}else{
											this.fontDataH[ff] = {jName: txtList[0], eName: txtList[1], fStyle: sList, pName: pList};
											ff++
										}
									}
								}
							}
							this.fontData = this.fontDataZ.concat(this.fontDataH);
						}catch(e){

						}
					}else{
						alert("******ファイルを読み込めませんでした******");
					}
				}else{
					alert("******ファイルがありませんでした******");
				}
				//alert(this.fontData.length);
				//alert(this.fontData[this.fontData.length-1].pName)
			},

			//テキストレイヤーを取得
			getTxtLys: function()
			{
				var selLys = new Array();
				this.selTxtLys = new Array();
				var compLys = new Array();
				this.compTxtLys = new Array();
				this.actComp = app.project.activeItem;
				this.allTxtLys = new Array();

				if(this.actComp != null){
					//selected textLayers
					selLys = this.actComp.selectedLayers;
					if(selLys.length > 0){
						for(var i=0;i<selLys.length;i++){
							if(selLys[i].toString() == "[object TextLayer]"){
								if(this.selTxtLys.length == 0){
									this.selTxtLys[0] = selLys[i];
								}else{
									this.selTxtLys.push(selLys[i]);
								}
							}
						}
					}

					//all textLayers in activeComp
					compLys = this.actComp.layers;
					if(compLys.length > 0){
						for(var i=1;i<=compLys.length;i++){
							if(compLys[i].toString() == "[object TextLayer]"){
								if(this.compTxtLys.length == 0){
									this.compTxtLys[0] = compLys[i];
								}else{
									this.compTxtLys.push(compLys[i]);
								}
							}
						}
					}
				}

				//all textLayers in project
				var allItems = app.project.items;
				if(allItems.length > 0){
					for(var i=1;i<=allItems.length;i++){
						if(allItems[i].toString() == "[object CompItem]"){
							if(allItems[i].numLayers > 0){
								for(var ii=1;ii<=allItems[i].numLayers;ii++){
									if(allItems[i].layer(ii).toString() == "[object TextLayer]"){
										if(this.allTxtLys.length == 0){
											this.allTxtLys[0] = allItems[i].layer(ii);
										}else{
											this.allTxtLys.push(allItems[i].layer(ii));
										}
									}
								}
							}
						}
					}
				}
			},

			//全角・半角チェック (str = 文字列, flg: 0 = 半角  1 = 全角)
			CheckLength: function(str,flg) {
			    for (var i = 0; i < str.length; i++) {
			        var c = str.charCodeAt(i);
			        // Shift_JIS: 0x0 ～ 0x80, 0xa0 , 0xa1 ～ 0xdf , 0xfd ～ 0xff
			        // Unicode : 0x0 ～ 0x80, 0xf8f0, 0xff61 ～ 0xff9f, 0xf8f1 ～ 0xf8f3
			        if ( (c >= 0x0 && c < 0x81) || (c == 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4)) {
			            if(!flg) return true;
			        } else {
			            if(flg) return true;
			        }
			    }
			    return false;
			},

			fcUI_build: function()
			{
				this.osCHK();
				this.impTXT();
				this.getTxtLys();
				pSelf = this;

				pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", "", [ 0, 0, 630, 400 ]);
                pal.ID = "pal";

				pal.fcGrp = pal.add("group", [ 0, 0, pal.size[0], pal.size[1]]);
				pal.fcGrp.addEventListener('mousemove', this.mvFunc1);
				pal.fcGrp.addEventListener('mouseup', this.muFunc1);
				pal.fcGrp.addEventListener('keydown',this.kdFunc1);
				this.UI_bgColor255(pal.fcGrp, [60,60,60]);
				this.UI_fgColor255(pal.fcGrp, [200,200,200]);

				pal.title = pal.fcGrp.add("statictext",[pal.size[0] - 300, 5, pal.size[0]-10, 20], "font Changer CC ver 1.0"); pal.title.justify="right";




				//font Group
				pal.flGrp = pal.fcGrp.add("panel", [10, 60, pal.size[0]-10, 280], "", {borderStyle: "gray"});

				///font List Group
				pal.fListGrp = pal.flGrp.add("group", [5, 5, 250, 125], "");
				//font List
				pal.infoName = pal.fListGrp.add("radiobutton", [10, 5, 130, 25], "font name");
				pal.infoName.value = true;
				pal.infoName.val = true;
				pal.infoName.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														pal.fontName.enabled = false;
														pal.fontStyle.enabled = false;
														pal.listBtnA.enabled = false;
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														pal.fontName.enabled = true;
														pal.fontStyle.enabled = true;
														pal.listBtnA.enabled = true;
													}
												}
	           //フォント名
				pal.fontName = pal.fListGrp.add("edittext", [20, 30, 210, 55],"");
				pal.fontName.helpTip = "フォントの指定";
				pal.fontName.addEventListener('keydown', this.kdFunc0);

				pal.listBtnA = pal.fListGrp.add("panel", [211, 30, 235, 55],"",{borderStyle: "gray"});
				pal.listBtnA.valBtn = "pal";
				pal.listBtnA.addEventListener('mousedown', this.mdFunc1);

				pal.listInfoA = pal.listBtnA.add("statictext", [3, 2, 18, 22], "▼");
				this.UI_fgColor255(pal.listInfoA, [180,180,180]);


				//font Style
				pal.infoStyle = pal.fListGrp.add("statictext", [25, 60, 95, 80], "font style"); pal.infoStyle.justify="left";
				pal.infoStyle.helpTip = "フォントスタイルの指定";

				pal.fontStyle = pal.fListGrp.add("dropdownlist", [20, 85, 210, 110]);


				//justification Group
				pal.jusGrp = pal.flGrp.add("group", [5, 130, 140, 210], "");
				pal.infoJus = pal.jusGrp.add("radiobutton", [10, 5, 125, 30], "justification");
				pal.infoJus.value = false;
				pal.infoJus.val = false;
				pal.infoJus.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														pal.jusL.enabled = false;
														pal.jusC.enabled = false;
														pal.jusR.enabled = false;
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														pal.jusL.enabled = true;
														pal.jusC.enabled = true;
														pal.jusR.enabled = true;
													}
												}
				pal.jusL = pal.jusGrp.add("panel",[10, 35, 40, 80], "", {borderStyle: "gray"});
				pal.jusL.helpTip = "テキストの左揃え";
				this.UI_bgColor255(pal.jusL, [60,140,200]);
				pal.infoL = pal.jusL.add("statictext", [0, 1, 29, 44], "---  "+this.CF+"---  "+this.CF+"---  ", {multiline: true}); pal.infoL.justify="left";
				pal.infoL.nameID = "jusL";
				pal.infoL.helpTip = "justification: left";
				this.UI_fgColor255(pal.infoL, [240,240,240]);
				pal.infoL.addEventListener('mousedown', this.mdFunc5);
				pal.jusL.enabled = false;

				pal.jusC = pal.jusGrp.add("panel",[50, 35, 80, 80], "", {borderStyle: "gray"});
				pal.jusC.helpTip = "テキストの中央揃え";
				pal.infoC = pal.jusC.add("statictext", [0, 1, 30, 44], " --- "+this.CF+" --- "+this.CF+" --- ", {multiline: true}); pal.infoC.justify="left";
				pal.infoC.nameID = "jusC";
				this.UI_bgColor255(pal.jusC, [100,100,100]);
				pal.infoC.helpTip = "justification: center";
				this.UI_fgColor255(pal.infoC, [150,150,150]);
				pal.infoC.addEventListener('mousedown', this.mdFunc5);
				pal.jusC.enabled = false;

				pal.jusR = pal.jusGrp.add("panel",[90, 35, 120, 80], "", {borderStyle: "gray"});
				pal.jusR.helpTip = "テキストの右揃え";
				this.UI_bgColor255(pal.jusR, [100,100,100]);
				pal.infoR = pal.jusR.add("statictext", [1, 1, 31, 44], "  ---"+this.CF+"  ---"+this.CF+"  ---", {multiline: true}); pal.infoR.justify="left";
				pal.infoR.nameID = "jusR";
				pal.infoR.helpTip = "justification: right";
				this.UI_fgColor255(pal.infoR, [150,150,150]);
				pal.infoR.addEventListener('mousedown', this.mdFunc5);
				pal.jusR.enabled = false;



				///font Size Group
				pal.fSizeGrp = pal.flGrp.add("group", [250, 5, 350, 60], "");
				//font Size
				pal.infoSize = pal.fSizeGrp.add("radiobutton", [5, 5, 90, 25], "font size");
				pal.infoSize.helpTip = "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.infoSize.value = false;
				pal.infoSize.val = false;
				pal.infoSize.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														pal.fontSize.enabled = false;
														pal.fontSizeLine.enabled = false;
														pal.listBtnC.enabled = false;
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														pal.fontSize.enabled = true;
														pal.fontSizeLine.enabled = true;
														pal.listBtnC.enabled = true;
													}
												}

				pal.fontSize = pal.fSizeGrp.add("statictext", [15, 25, 50, 40], "12"); pal.fontSize.justify="right";
				pal.fontSize.nameID = "fontSize";
				pal.fontSize.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.fontSize, [250,150,0]);
				pal.fontSize.enabled = false;
				pal.fontSizeLine = pal.fSizeGrp.add("statictext", [20, 35, 50, 45], "----------");
				this.UI_fgColor255(pal.fontSizeLine, [250,150,0]);
				pal.fontSizeLine.enabled = false;
				pal.fontSizePx = pal.fSizeGrp.add("statictext", [55, 28, 70, 43], "px"); pal.fontSizePx.justify="right";

				pal.listBtnC = pal.fSizeGrp.add("panel", [75, 25, 100, 45], "", {borderStyle: "gray"});
				pal.listBtnC.addEventListener('mousedown', this.mdFunc3);

				pal.listInfoC = pal.listBtnC.add("statictext", [4, 0, 20, 19], "▼");
				this.UI_fgColor255(pal.listInfoC, [150,150,150]);
				pal.listBtnC.enabled = false;

				pal.fontSizeED = pal.fSizeGrp.add("edittext", [20, 25, 70, 42]);
				pal.fontSizeED.visible = false;




				//RGB Group
				pal.rgbGrp = pal.flGrp.add("group", [270, 75, 350, 160], "");

				//R
				pal.rInfo = pal.rgbGrp.add("statictext", [5, 7, 20, 22], "R: "); pal.rInfo.justify="right";
				pal.rInfo.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.rTxt = pal.rgbGrp.add("statictext", [25, 5, 60, 20], "255"); pal.rTxt.justify="right";
				pal.rTxt.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.rTxt.nameID = "rTxt";
				pal.rTxt.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.rTxt, [250,150,0]);
				pal.rTxt.enabled = false;
				pal.rTxtLine = pal.rgbGrp.add("statictext", [30, 15, 60, 25], "----------");
				pal.rTxtLine.nameID = "rTxt";
				pal.rTxtLine.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.rTxtLine, [250,150,0]);
				pal.rTxtLine.enabled = false;

				pal.rTxtED = pal.rgbGrp.add("edittext", [25, 5, 60, 25]);
				pal.rTxtED.visible = false;
				//pal.rTxtED.addEventListener('keydown',this.kdFunc1);

				//G
				pal.gInfo = pal.rgbGrp.add("statictext", [5, 30, 20, 45], "G: "); pal.gInfo.justify="right";
				pal.gInfo.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.gTxt = pal.rgbGrp.add("statictext", [25, 28, 60, 43], "255"); pal.gTxt.justify="right";
				pal.gTxt.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.gTxt.nameID = "gTxt";
				pal.gTxt.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.gTxt, [250,150,0]);
				pal.gTxt.enabled = false;
				pal.gTxtLine = pal.rgbGrp.add("statictext", [30, 38, 60, 48], "----------");
				pal.gTxtLine.nameID = "gTxt";
				pal.gTxtLine.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.gTxtLine, [250,150,0]);
				pal.gTxtLine.enabled = false;

				pal.gTxtED = pal.rgbGrp.add("edittext", [25, 28, 60, 48]);
				pal.gTxtED.visible = false;
				//pal.gTxtED.addEventListener('keydown',this.kdFunc1);

				//B
				pal.bInfo = pal.rgbGrp.add("statictext", [5, 53, 20, 68], "B: "); pal.bInfo.justify="right";
				pal.bInfo.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.bTxt = pal.rgbGrp.add("statictext", [25, 51, 60, 66], "255"); pal.bTxt.justify="right";
				pal.bTxt.helpTip = "[fill color] か [stroke color] の四角アイコンをクリックでアクティブにすることで変更可能" +this.CF+
                                     "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.bTxt.nameID = "bTxt";
				pal.bTxt.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.bTxt, [250,150,0]);
				pal.bTxt.enabled = false;
				pal.bTxtLine = pal.rgbGrp.add("statictext", [30, 61, 60, 71], "----------");
				pal.bTxtLine.nameID = "bTxt";
				pal.bTxtLine.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.bTxtLine, [250,150,0]);
				pal.bTxtLine.enabled = false;

				pal.bTxtED = pal.rgbGrp.add("edittext", [25, 51, 60, 71]);
				pal.bTxtED.visible = false;
				//pal.bTxtED.addEventListener('keydown',this.kdFunc1);




				//fill Color Group
				pal.fColorGrp = pal.flGrp.add("group", [355, 5, 465, 110], "");
				//fill Color
				pal.infoFill = pal.fColorGrp.add("radiobutton", [5, 5, 100, 25], "fill color");
				pal.infoFill.helpTip = "四角アイコンをクリックでアクティブにした後、RGB数値を設定可能" +this.CF+
                                        "もう1度クリックで塗りのカラーなし";
				pal.infoFill.value = false;
				pal.infoFill.val = false;
				pal.infoFill.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														if(pal.fColorNon.visible){
															pal.fColorNon.enabled = false;
														}else{
															if(pal.fColorOFF.visible){
																pal.fColorOFF.enabled = false;
															}else{
																pal.fColorON.visible = false;
																pal.fColorOFF.visible = true;
																pal.fColorOFF.enabled = false;
															}
														}
														if(!pal.infoStroke.value && pal.rTxt.enabled){
															pal.rTxt.enabled = false;
															pal.rTxtLine.enabled = false;
															pal.gTxt.enabled = false;
															pal.gTxtLine.enabled = false;
															pal.bTxt.enabled = false;
															pal.bTxtLine.enabled = false;
														}
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														if(pal.fColorOFF.visible){
															pal.fColorOFF.enabled = true;
														}else if(pal.fColorNon.visible){
															pal.fColorNon.enabled = true;
														}
													}
												}
				//塗りあり アクティブ
				pal.fColorON = pal.fColorGrp.add("group", [20, 30, 80, 90], "");
				pal.fColorON.helpTip = "クリックで塗りのカラー切り替え";
				pal.fColorON.cID = "fON";
				this.UI_bgColor255(pal.fColorON, [150,150,250]);
				pal.fColorAA = pal.fColorON.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.fColorA = pal.fColorAA.add("group", [0, 0, 56, 56], "");
				pal.fColorA.cID = "fON";
				this.UI_bgColor255(pal.fColorA, [255,0,0]);
				pal.fColorA.addEventListener('mousedown', this.mdFunc6);
				pal.fColorON.visible = false;

				//塗りあり 非アクティブ
				pal.fColorOFF = pal.fColorGrp.add("group", [20, 30, 80, 90], "");
				pal.fColorOFF.helpTip = "クリックでアクティブにした後、RGB数値を設定可能" +this.CF+
				                        "もう1度クリックで塗りのカラーなし";
				pal.fColorOFF.cID = "fOFF";
				pal.fColorBB = pal.fColorOFF.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.fColorB = pal.fColorBB.add("group", [0, 0, 56, 56], "");
				pal.fColorB.cID = "fOFF";
				this.UI_bgColor255(pal.fColorB, [255,0,0]);
				pal.fColorB.addEventListener('mousedown', this.mdFunc6);
				pal.fColorOFF.visible = false;

				//塗りなし
				pal.fColorNon = pal.fColorGrp.add("group", [20, 30, 80, 90], "");
				pal.fColorNon.helpTip = "クリックで塗りのカラーあり";
				pal.fColorNon.cID = "fNon";
				pal.fColorCC = pal.fColorNon.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.fColorC = pal.fColorCC.add("group", [0, 0, 56, 56], "");
				pal.fColorC.cID = "fNon";
				this.UI_bgColor255(pal.fColorC, [120,120,120]);
				pal.fColorX = pal.fColorC.add("statictext", [0,0,53,53],"×"); pal.fColorX.justify = "center";
				pal.fColorX.cID = "fNon";
				this.UI_fgColor255(pal.fColorX, [255,0,0]);
				pal.fColorNon.enabled = false;
				pal.fColorC.addEventListener('mousedown', this.mdFunc6);




				//stroke Color Group
				pal.sColorGrp = pal.flGrp.add("group", [470, 5, 600, 100], "");
				//stroke Color
				pal.infoStroke = pal.sColorGrp.add("radiobutton", [5, 5, 125, 25], "stroke color");
				pal.infoStroke.helpTip = "四角アイコンをクリックでアクティブにした後、RGB数値を設定可能" +this.CF+
                                        "もう1度クリックで線のカラーなし";
				pal.infoStroke.value = false;
				pal.infoStroke.val = false;
				pal.infoStroke.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														if(pal.sColorNon.visible){
															pal.sColorNon.enabled = false;
														}else{
															if(pal.sColorOFF.visible){
																pal.sColorOFF.enabled = false;
															}else{
																pal.sColorON.visible = false;
																pal.sColorOFF.visible = true;
																pal.sColorOFF.enabled = false;
															}
														}

														if(!pal.infoFill.value && pal.rTxt.enabled){
															pal.rTxt.enabled = false;
															pal.rTxtLine.enabled = false;
															pal.gTxt.enabled = false;
															pal.gTxtLine.enabled = false;
															pal.bTxt.enabled = false;
															pal.bTxtLine.enabled = false;
														}
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														if(pal.sColorOFF.visible){
															pal.sColorOFF.enabled = true;
														}else if(pal.sColorNon.visible){
															pal.sColorNon.enabled = true;
														}
													}
												}
				//線あり アクティブ
				pal.sColorON = pal.sColorGrp.add("group", [20, 30, 80, 90], "");
				pal.sColorON.helpTip = "クリックで線のカラーなし";
				pal.sColorON.cID = "sON";
				this.UI_bgColor255(pal.sColorON, [150,150,250]);
				pal.sColorAA = pal.sColorON.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.sColorA = pal.sColorAA.add("group", [0, 0, 56, 56], "");
				pal.sColorA.cID = "sON";
				this.UI_bgColor255(pal.sColorA, [255,255,255]);
				pal.sColorA.addEventListener('mousedown', this.mdFunc6);
				pal.sColorONL = pal.sColorA.add("panel", [17, 17, 35, 35], "", {borderStyle: "gray"});
				this.UI_bgColor255(pal.sColorONL, [240,240,240]);
				pal.sColorON.visible = false;

				//線あり 非アクティブ
				pal.sColorOFF = pal.sColorGrp.add("group", [20, 30, 80, 90], "");
				pal.sColorOFF.helpTip = "クリックでアクティブにした後、RGB数値を設定可能" +this.CF+
                                        "もう1度クリックで線のカラーなし";
				pal.sColorOFF.cID = "sOFF";
				pal.sColorBB = pal.sColorOFF.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.sColorB = pal.sColorBB.add("group", [0, 0, 56, 56], "");
				pal.sColorB.cID = "sOFF";
				this.UI_bgColor255(pal.sColorB, [255,255,255]);
				pal.sColorB.addEventListener('mousedown', this.mdFunc6);
				pal.sColorOFFL = pal.sColorB.add("panel", [17, 17, 35, 35], "", {borderStyle: "gray"});
				this.UI_bgColor255(pal.sColorOFFL, [240,240,240]);
				pal.sColorOFF.visible = false;

				//線なし
				pal.sColorNon = pal.sColorGrp.add("group", [20, 30, 80, 90], "");
				pal.sColorNon.helpTip = "クリックで線のカラーあり";
				pal.sColorNon.cID = "sNon";
				pal.sColorCC = pal.sColorNon.add("panel", [2, 2, 58, 58], "", {borderStyle: "gray"});
				pal.sColorC = pal.sColorCC.add("group", [0, 0, 56, 56], "");
				pal.sColorC.cID = "sNon";
				this.UI_bgColor255(pal.sColorC, [120,120,120]);
				pal.sColorNonL = pal.sColorC.add("panel", [17, 17, 35, 35], "", {borderStyle: "gray"});
				this.UI_bgColor255(pal.sColorNonL, [240,240,240]);
				pal.sColorX = pal.sColorNonL.add("statictext", [0,0,15,13],"×"); pal.sColorX.justify = "center";
				this.UI_fgColor255(pal.sColorX, [255,0,0]);
				pal.sColorNon.enabled = false;
				pal.sColorC.addEventListener('mousedown', this.mdFunc6);




				//strokeWidth
				pal.sWidthGrp = pal.flGrp.add("group", [470, 105, 600, 165], "");
				pal.sWidthInfo = pal.sWidthGrp.add("radiobutton", [5, 5, 125, 25], "stroke Width");
				pal.sWidthInfo.helpTip = "数字上を左右にドラッグ or ダブルクリックで数字入力で変更可";
				pal.sWidthInfo.value = false;
				pal.sWidthInfo.val = false;
				pal.sWidthInfo.onClick = function()
												{
													if(this.val){
														this.value = false;
														this.val = false;
														this.active = false;

														pal.sWidth.enabled = false;
														pal.sWidthLine.enabled = false;
													}else{
														this.value = true;
														this.val = true;
														this.active = false;

														pal.sWidth.enabled = true;
														pal.sWidthLine.enabled = true;
													}
												}
				pal.sWidth = pal.sWidthGrp.add("statictext", [60, 26, 95, 41], "2", {readonly: true}); pal.sWidth.justify="right";
				pal.sWidth.nameID = "sWidth";
				pal.sWidth.addEventListener('mousedown', this.mdFunc5);
				this.UI_fgColor255(pal.sWidth, [250,150,0]);
				pal.sWidth.enabled = false;
				pal.sWidthLine = pal.sWidthGrp.add("statictext", [65, 42, 95, 51], "----------");
				this.UI_fgColor255(pal.sWidthLine, [250,150,0]);
				pal.sWidthLine.enabled = false;
				pal.sWidthPx = pal.sWidthGrp.add("statictext", [100, 26, 115, 50], "px"); pal.sWidthPx.justify="right";
				pal.sWidthED = pal.sWidthGrp.add("edittext", [60, 26, 115, 51]);
				pal.sWidthED.visible = false;
				//pal.fontSizeED.addEventListener('keydown',this.kdFunc1);




				//strokeOverFill
				pal.sofGrp = pal.flGrp.add("group", [470, 170, 600, 220], "");
				pal.sofInfo = pal.sofGrp.add("checkbox", [5, 5, 130, 22], "stroke Over Fill");
				pal.sofInfo.helpTip = "塗りの上に線";
				pal.sofInfo.value = false;




				//edit FontList
				pal.addBtn = pal.flGrp.add("button", [240, 180, 340, 210], "Edit  Font List");
				pal.addBtn.helpTip = "フォントリストを編集";
				this.UI_fgColor255(pal.addBtn, [200,200,200]);
				pal.addBtn.onClick = function()
												{
													pSelf.editFont_UI_Bld(pSelf);
													pSelf.impTXT();
												}




				//select Radio Button
				pal.selsctGrp = pal.fcGrp.add("panel", [ 10, 290, pal.size[0]-10, 390], "", {borderStyle: "gray"});

				//対象レイヤー セレクト
				pal.selGrp = pal.selsctGrp.add("group", [5, 5, 300, 95], "");
				pal.rBtnA = pal.selGrp.add("radiobutton", [5, 5, 290, 25], "selected textLayers in activeComp");
				pal.rBtnA.henlTip = "選択中のテキストレイヤーのみに適用";
				pal.rBtnA.value = true;
				pal.rBtnID = "A";
				pal.rBtnA.onClick = function()
												{
													pSelf.getTxtLys();
													pal.rBtnID = "A";
												    pal.numTxt.text = "num textLayers: " + pSelf.selTxtLys.length;
												}

				pal.rBtnB = pal.selGrp.add("radiobutton", [5, 35, 290, 55], "all textLayers in activeComp");
				pal.rBtnB.helpTip = "アクティブコンポ内の全てのテキストレイヤーに適用";
				pal.rBtnB.onClick = function()
												{
													pSelf.getTxtLys();
													pal.rBtnID = "B";
												    pal.numTxt.text = "num textLayers: " + pSelf.compTxtLys.length;
												}

				pal.rBtnC = pal.selGrp.add("radiobutton", [5, 65, 290, 85], "all textLayers in project");
				pal.rBtnC.helpTip = "プロジェクト内の全てのテキストレイヤーに適用";
				pal.rBtnC.onClick = function()
												{
													pSelf.getTxtLys();
													pal.rBtnID = "C";
												    pal.numTxt.text = "num textLayers: " + pSelf.allTxtLys.length;
												}



				pal.numTxt = pal.selsctGrp.add("statictext", [pal.selsctGrp.size[0]-140, 10, pal.selsctGrp.size[0]-10, 30], "num textLayers: " + this.selTxtLys.length);
				this.UI_fgColor255(pal.numTxt, [240,80,80]);


				pal.applyBtn = pal.selsctGrp.add("button", [pal.selsctGrp.size[0]-100, 60, pal.selsctGrp.size[0]-10, 90], "apply");
				pal.applyBtn.onClick = function()
												{
													pSelf.fontChange();
												}

				pal.onClose = function()
                        				{
                        				    //pSelf.UI_reMove(pSelf, this);
                        				}

				pal.center();
				pal.show();
			},

			//ウインドウオブジェクト 削除
            UI_reMove: function(uiSelf, uiObj)
            {
                while (uiObj.children.length > 0)
                {
                    if(uiObj.children[0].length > 0 && uiObj.children[0].children.length > 0){
                        uiSelf.UI_reMove(uiSelf, uiObj.children[0]);
                    }else{
                        uiObj.remove(0);
                    }
                }
            },

			//fontData用 ソート(連想配列用ソート)
			asort: function(setObj, key){
  				setObj.sort ( function (b1, b2) { return b1[key] > b2[key] ? 1 : -1; } );
			},

			//フォントリスト 保存
			saveFontList: function(adSelf,valSave)
			{
			    if(valSave == "Add"){
    				//名前をソート(半角の名前のみ)
    				if(app.language == Language.JAPANESE){
    					//this.asort(this.fontDataZ, "jName");
    					adSelf.asort(adSelf.fontDataH, "jName");
    				}else if(app.language == Language.ENGLISH){
    					//this.asort(this.fontDataZ, "eName");
    					adSelf.asort(adSelf.fontDataH, "eName");
    				}

    				adSelf.fontData = new Array();

    				if(adSelf.fontDataZ.length > 0 && adSelf.fontDataH.length > 0){
    					adSelf.fontData = adSelf.fontDataZ.concat(adSelf.fontDataH);
    				}else if(adSelf.fontDataZ.length == 0){
    					adSelf.fontData = adSelf.fontDataH;
    				}else{
    					adSelf.fontData = adSelf.fontDataZ;
    				}
			    }else if(valSave == "Edit"){
			        //名前をソート(半角の名前のみ)
                    if(app.language == Language.JAPANESE){
                        adSelf.asort(adSelf.fontData, "jName");
                    }else if(app.language == Language.ENGLISH){
                        adSelf.asort(adSelf.fontData, "eName");
                    }
			    }

				var saveTxt = String($.os) + "[フォント表記名<日本語>//フォント表記名<英語>//フォントスタイル:ポストスクリプト名>]" + adSelf.CF;
				for(var i=0;i<adSelf.fontData.length;i++){
					var spName = "";
					for(var ii=0;ii<adSelf.fontData[i].fStyle.length;ii++){
						spName +=  "//"+ adSelf.fontData[i].fStyle[ii] +":"+ adSelf.fontData[i].pName[ii];
					}
					//alert(spName);

					if(i != adSelf.fontData.length-1){
						saveTxt += adSelf.fontData[i].jName +"//"+ adSelf.fontData[i].eName + spName + adSelf.CF;
					}else{
						saveTxt += adSelf.fontData[i].jName +"//"+ adSelf.fontData[i].eName + spName;
					}
				}
				//alert(saveTxt);

				if(saveTxt != ""){
					var exFile = new File(adSelf.txtPath);
					//UTF-8にエンコード
					exFile.encoding = "UTF-8";
					if(exFile.exists){
						if(exFile.open("w")){
							try
							{
								//複数行を一気に書き込み
								exFile.writeln(saveTxt);
								exFile.close();
							}catch(e){

							}
						}else{
						    var errTxt = "保存できませんでした。" +adSelf.CF+
						                 adSelf.fontList + " へのアクセス権限が不可の可能性があります。";
							alert(errTxt);
						}
					}else{
						alert("******ファイルをありませんでした******");
					}
				}
			},

			//edit font listダイアログ
			editFont_UI_Bld: function(pSelf)
			{
			    adSelf = pSelf;
				afObj = new Window("palette", "  edit  Font List", [0, 0, 380, 300]);
				afObj.ID = "afObj";

				afObj.infoTxt = afObj.add("statictext", [20, 5, 210, 20],"select Font Name"); afObj.infoTxt.justify="left";

				//フォント名
                afObj.fontName = afObj.add("edittext", [20, 23, 210, 48],"");
                afObj.fontName.helpTip = "フォントの指定";
                afObj.fontName.valBtn = "afObj";
                afObj.fontName.addEventListener('keydown', pSelf.kdFunc0);

                afObj.listBtnA = afObj.add("panel", [211, 23, 235, 48],"",{borderStyle: "gray"});
                afObj.listBtnA.valBtn = "afObj";
                afObj.listBtnA.addEventListener('mousedown', pSelf.mdFunc1);

                afObj.listInfoA = afObj.listBtnA.add("statictext", [3, 2, 18, 22], "▼");
                pSelf.UI_fgColor255(afObj.listInfoA, [180,180,180]);

                //get font
                afObj.getBtn = afObj.add("button", [40, 73, 340, 98],"Get  postscript name  of  Selected TextLayers[0]");
                afObj.getBtn.onClick = function()
                                                {
                                                    var curSel = app.project.activeItem.selectedLayers;
                                                    if(curSel.length > 0 && curSel[0].toString() == "[object TextLayer]"){
                                                        afObj.fontName.text = "";
                                                        var curTD = curSel[0].property("ADBE Text Properties").property("ADBE Text Document");
                                                        afObj.jED.text = "";
                                                        afObj.eED.text = "";
                                                        afObj.fsED.text = "";
                                                        afObj.psED.text = curTD.value.font;
                                                        adSelf.UI_fgColor255(afObj.psED, [40,40,40]);
                                                    }
                                                }


                //edit
                afObj.addJInfo = afObj.add("statictext", [15, 115, 115, 130], "japanese name"); afObj.addJInfo.justify="left";
                afObj.jED = afObj.add("edittext", [10, 133, 170, 158],"");

                afObj.addEInfo = afObj.add("statictext", [190, 115, 290, 130], "english name"); afObj.addEInfo.justify="left";
                afObj.eED = afObj.add("edittext", [190, 133, 370, 158],"");

                afObj.addFsInfo = afObj.add("statictext", [15, 165, 100, 180], "font style"); afObj.addFsInfo.justify="left";
                afObj.fsED = afObj.add("edittext",  [10, 183, 120, 290],"",{multiline: true, wantReturn:true});

                afObj.addPsInfo = afObj.add("statictext", [135, 165, 290, 180], "postscript name"); afObj.addPsInfo.justify="left";
                afObj.psED = afObj.add("edittext", [130, 183, 370, 290],"",{multiline: true, wantReturn:true});


                //ok
                afObj.okBtn = afObj.add("button", [270, 10, 370, 35], "Save");
                afObj.okBtn.onClick = function()
                                                {
                                                    var newFont = new Array();
                                                    if(afObj.jED.text != ""){
                                                        if(afObj.eED.text != ""){
                                                            if(afObj.fsED.text != ""){
                                                                if(afObj.psED.text != ""){
                                                                    if(this.text == "Save"){
                                                                        var curFS = new Array();
                                                                        var curPN = new Array();

                                                                        if(afObj.fsED.text.indexOf(adSelf.CF) == -1){
                                                                            curFS[0] = afObj.fsED.text;
                                                                            curPN[0] = afObj.psED.text;
                                                                        }else{
                                                                            curFS = afObj.fsED.text.split(adSelf.CF)
                                                                            curPN = afObj.psED.text.split(adSelf.CF)
                                                                        }

                                                                        if(curFS.length == curPN.length){
                                                                            //重複していなければ追加
                                                                            var valR = new Array();
                                                                            valR = adSelf.psnCHK(adSelf, curPN);
                                                                            if(valR[0]){
                                                                                if(adSelf.CheckLength(afObj.jED.text, 1)){
                                                                                    adSelf.fontDataZ[adSelf.fontDataZ.length] = { jName:afObj.jED.text,
                                                                                                                                eName:afObj.eED.text,
                                                                                                                                fStyle:curFS,
                                                                                                                                pName:curPN
                                                                                                                              }
                                                                                    //alert(aSelf.fontDataZ[aSelf.fontDataZ.length-1].pName);
                                                                                }else{
                                                                                    adSelf.fontDataH[adSelf.fontDataH.length] = { jName:afObj.jED.text,
                                                                                                                                eName:afObj.eED.text,
                                                                                                                                fStyle:curFS,
                                                                                                                                pName:curPN
                                                                                                                              }
                                                                                    //alert(adSelf.fontDataH[adSelf.fontDataH.length-1].pName);
                                                                                }
                                                                                adSelf.saveFontList(adSelf,"Add");
                                                                                afObj.close();
                                                                                //リスト再取得
                                                                                adSelf.impTXT();
                                                                                adSelf.fontID = null
                                                                            //名前を編集
                                                                            }else{
                                                                                if(adSelf.fontID != null && valR[1]){
                                                                                    //変更前のものを削除
                                                                                    for(var i=0;i<adSelf.fontDataZ.length;i++){
                                                                                        if(adSelf.fontDataZ[i].pName[0] == adSelf.fontData[adSelf.fontID].pName[0]){
                                                                                            adSelf.fontDataZ.splice(i,1);
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    for(var i=0;i<adSelf.fontDataH.length;i++){
                                                                                        if(adSelf.fontDataH[i].pName[0] == adSelf.fontData[adSelf.fontID].pName[0]){
                                                                                            adSelf.fontDataH.splice(i,1);
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    //変更後のものを追加
                                                                                    if(adSelf.CheckLength(afObj.jED.text, 1)){
                                                                                        adSelf.fontDataZ[adSelf.fontDataZ.length] = { jName:afObj.jED.text,
                                                                                                                                    eName:afObj.eED.text,
                                                                                                                                    fStyle:curFS,
                                                                                                                                    pName:curPN
                                                                                                                                  }
                                                                                        //alert(aSelf.fontDataZ[aSelf.fontDataZ.length-1].pName);
                                                                                    }else{
                                                                                        adSelf.fontDataH[adSelf.fontDataH.length] = { jName:afObj.jED.text,
                                                                                                                                    eName:afObj.eED.text,
                                                                                                                                    fStyle:curFS,
                                                                                                                                    pName:curPN
                                                                                                                                  }
                                                                                        //alert(adSelf.fontDataH[adSelf.fontDataH.length-1].pName);
                                                                                    }
                                                                                    adSelf.saveFontList(adSelf,"Add");
                                                                                    afObj.close();
                                                                                    //リスト再取得
                                                                                    adSelf.impTXT();
                                                                                    adSelf.fontID = null
                                                                                }
                                                                            }
                                                                        }else{
                                                                            alert("******[フォントスタイル名]と[ポストスクリプト名]の数を合わせてください******");
                                                                        }
                                                                    }else if(this.text == "Delete"){
                                                                            //削除
                                                                            if(adSelf.fontID != null){
                                                                                adSelf.fontData.splice(adSelf.fontID,1);
                                                                                adSelf.saveFontList(adSelf,"Edit");
                                                                                afObj.close();
                                                                                //リスト再取得
                                                                                adSelf.impTXT();
                                                                                adSelf.fontID = null
                                                                            }
                                                                        }
                                                                }else{
                                                                    alert("******[ポストスクリプト名]を記入してください******");
                                                                }
                                                            }else{
                                                                alert("******[フォントスタイル名]を記入してください******");
                                                            }
                                                        }else{
                                                            alert("******[英語名]を記入してください******");
                                                        }
                                                    }else{
                                                        alert("******[日本語名]を記入してください******");
                                                    }
                                                }


                afObj.dlChk = afObj.add("checkbox", [240, 40, 300, 60], "delete");
                afObj.dlChk.onClick = function()
                                                {
                                                    if(this.value){
                                                        afObj.okBtn.text = "Delete";
                                                    }else{
                                                        afObj.okBtn.text = "Save";
                                                    }
                                                }


				afObj.clBtn = afObj.add("button", [310, 40, 370, 60], "cancel");
				afObj.clBtn.onClick = function()
												{
													afObj.close();
												}

				afObj.location = [pal.location[0]+230, pal.location[1]+250];
				afObj.show();
			},

			//ポストスクリプトネーム 重複チェック
			psnCHK: function(pSelf, curPSN)
			{
			    var valPSN = true;
			    var valED = false;
			    for(var i=0;i<pSelf.fontData.length;i++){
			        for(var ii=0;ii<curPSN.length;ii++){
    			        var iii=0;
    			        for each(var oS in pSelf.fontData[i].pName){
        			        if(oS == curPSN[ii]){
        			            var errTxt2 = curPSN[ii] + " は登録済ですが名前を上書きしますか？" +pSelf.CF+
        			                          "japanese name: " + pSelf.fontData[i].jName + " → " + afObj.jED.text +pSelf.CF+
        			                          "english name: " + pSelf.fontData[i].eName + " → " + afObj.eED.text;
        			            var flag = confirm(errTxt2);
        			            if(flag){
                                    valED = true;
        			            }
                                valPSN = false;
        			            break;
        			        }
        			        iii++;
    			        }
    			        if(! valPSN){
    			            break;
    			        }
			        }
			        if(! valPSN){
                        break;
                    }
			    }
			    return [valPSN,valED];
			},

			//font name ドロップダウンリスト UI
			dl_UI_Bld: function(pSelf,oObj, strTxt)
			{
			    if(! this.valUI){
    				var fN = new Array();
    				var fNID = new Array();
    				var ii=0;
    				for(var i=0;i<pSelf.fontData.length;i++){
    					//日本語OS
    					if(app.language == Language.JAPANESE){
    						//1文字検索じゃない場合
    						if(strTxt == ""|| strTxt.length > 1){
    							fN[i] = pSelf.fontData[i].jName;
    						//1文字検索の場合
    						}else{
    							if(pSelf.fontData[i].jName.toLowerCase().indexOf(strTxt) == 0){
    								fN[ii] = pSelf.fontData[i].jName;
    								fNID[ii] = i;
    								ii++;
    							}
    						}
    					//英語OS
    					}else if(app.language == Language.ENGLISH){
    						//1文字検索じゃない場合
    						if(strTxt == "" || strTxt.length > 1){
    							fN[i] = pSelf.fontData[i].eName;
    						//1文字検索の場合
    						}else{
    							if(pSelf.fontData[i].eName.toLowerCase().indexOf(strTxt) == 0){
    								fN[ii] = pSelf.fontData[i].eName;
    								fNID[ii] = i;
    								ii++;
    							}
    						}
    					}
    				}

    				var dlObj = new Window("dialog", "", [0, 0, 212, 300],{borderless: true});

    				dlObj.addEventListener('mousedown', pSelf.mdFunc4);
    				dlObj.addEventListener('keydown',pSelf.edFunc1);

    				dlObj.listPop = dlObj.add("listbox", [0, 0, dlObj.size[0], dlObj.size[1]], fN);
    				dlObj.listPop.objID = "dl";

                    var dSelf = pSelf;
    				dlObj.listPop.onChange = function()
    													{
    														if(this.selection != null){
    															oObj.fontName.text = this.selection;
    															//alert(this.selection.index);

    															//fontStyle を更新
    															//1文字検索じゃない場合
    															if(fNID.length == 0){
    															    if(oObj.ID == "pal"){
        															    while(oObj.fontStyle.children.length > 0){
        															        oObj.fontStyle.remove(0);
        															    }
        															    for(var i=0;i<dSelf.fontData[this.selection.index].fStyle.length;i++){
                                                                            oObj.fontStyle.add("item",dSelf.fontData[this.selection.index].fStyle[i],i+1);
        															    }
    																    dSelf.fID = this.selection.index;
    																    oObj.fontStyle.selection = 0;
                                                                        oObj.fontStyle.active = false;
    																}else if(oObj.ID == "afObj"){
    																    dSelf.fontID = this.selection.index;

    																    oObj.jED.text = dSelf.fontData[dSelf.fontID].jName;
                                                                        oObj.eED.text = dSelf.fontData[dSelf.fontID].eName;
                                                                        var sVal = dSelf.fontData[dSelf.fontID].fStyle;
                                                                        oObj.fsED.text = sVal.join(dSelf.CF);
                                                                        var pVal = dSelf.fontData[dSelf.fontID].pName;
                                                                        oObj.psED.text = pVal.join(dSelf.CF);
                                                                        dSelf.UI_fgColor255(oObj.psED, [200,60,60]);
    																}
    															//1文字検索の場合
    															}else{
    															    if(oObj.ID == "pal"){
        															    while(oObj.fontStyle.children.length > 0){
                                                                            oObj.fontStyle.remove(0);
                                                                        }
                                                                        for(var i=0;i<dSelf.fontData[ fNID[this.selection.index] ].fStyle.length;i++){
                                                                            oObj.fontStyle.add("item",dSelf.fontData[ fNID[this.selection.index] ].fStyle[i],i+1);
                                                                        }
    																    dSelf.fID = fNID[this.selection.index];
    																    oObj.fontStyle.selection = 0;
                                                                        oObj.fontStyle.active = false;
    																}else if(oObj.ID == "afObj"){
    																    dSelf.fontID = fNID[this.selection.index];

    																    oObj.jED.text = dSelf.fontData[dSelf.fontID].jName;
                                                                        oObj.eED.text = dSelf.fontData[dSelf.fontID].eName;
                                                                        var sVal = dSelf.fontData[dSelf.fontID].fStyle;
                                                                        oObj.fsED.text = sVal.join(dSelf.CF);
                                                                        var pVal = dSelf.fontData[dSelf.fontID].pName;
                                                                        oObj.psED.text = pVal.join(dSelf.CF);
                                                                        dSelf.UI_fgColor255(oObj.psED, [200,60,60]);
    																}
    															}
    														}

    														dlObj.close();
    													}
                    if(oObj.ID == "pal"){
    				    dlObj.location = [ (oObj.location[0] + 37), (oObj.location[1] + 120)];
                    }else if(oObj.ID == "afObj"){
                        dlObj.location = [ (oObj.location[0] + 20), (oObj.location[1] + 55)];
                    }

                    dlObj.onClose = function()
                                            {
                                                //dSelf.UI_reMove(dSelf, this);
                                            }

    				dlObj.show();
    				pSelf.valUI = true;
			    }else{
			        pSelf.valUI = false;
			    }
			},

			//font size ドロップダウンリスト UI
			dlSI_UI_Bld: function()
			{
			    if(! this.valUI){
    			    var dlSIObj = new Window("dialog", "", [0, 0, 50, 215],{borderless: true});
    				dlSIObj.addEventListener('mousedown', this.mdFunc4);
    				//dlSIObj.addEventListener('keydown',this.edFunc1);

    				dlSIObj.listPop = dlSIObj.add("listbox", [0, 0, dlSIObj.size[0], dlSIObj.size[1]], this.sizeList);
    				dlSIObj.listPop.objID = "dlSI";

    				var dSelf = this;

    				dlSIObj.listPop.onChange = function()
    													{
    														if(this.selection != null){
    															pal.fontSize.text = this.selection;
    															//alert(this.selection.index);
    														}

    														dlSIObj.close();
    													}

    				dlSIObj.location = [ (pal.location[0] + 300), (pal.location[1] + 115)];

    				dlSIObj.onClose = function()
                                            {
                                                //dSelf.UI_reMove(dSelf, this);
                                            }

    				dlSIObj.show();
    				this.valUI = true;
			    }else{
			        this.valUI = false;
			    }
			},


			//Font Change
			fontChange: function()
			{
				//alert(pal.rBtnID);
				switch(pal.rBtnID)
				{
					case "A": for(var i=0;i<this.selTxtLys.length;i++){
							    this.setTxtDoc(this.selTxtLys[i]);
							  }
							  break;
					case "B": for(var i=0;i<this.compTxtLys.length;i++){
							    this.setTxtDoc(this.compTxtLys[i]);
							  }
							  break;
					case "C": for(var i=0;i<this.allTxtLys.length;i++){
							    this.setTxtDoc(this.allTxtLys[i]);
							  }
							  break;
				}
			},

			//set text Document
			setTxtDoc: function(curTextLayer)
			{
				var textDoc = curTextLayer.property("ADBE Text Properties").property("ADBE Text Document");
				var chgText = textDoc.value;
				chgText.resetCharStyle();
				if(pal.infoName.value){
					if(pal.fontName.text != ""){
						chgText.font = this.fontData[this.fID].pName[this.sID];
					}else{
						chgText.font = textDoc.value.font;
					}
				}else{
					chgText.font = textDoc.value.font;
				}
				if(pal.infoJus.value){
					if(this.valJustify == "left"){
						chgText.justification = ParagraphJustification.LEFT_JUSTIFY;
					}else if(this.valJustify == "center"){
						chgText.justification = ParagraphJustification.CENTER_JUSTIFY;
					}else if(this.valJustify == "right"){
						chgText.justification = ParagraphJustification.RIGHT_JUSTIFY;
					}
				}else{
				    chgText.justification = textDoc.value.justification;
				    //alert(textDoc.value.justification);
				}
				if(pal.infoSize.value){
					chgText.fontSize = Number(pal.fontSize.text);
				}else{
					chgText.fontSize = textDoc.value.fontSize;
				}
				if(pal.infoFill.value){
					if(pal.fColorNon.visible){
						chgText.applyFill = false;
					}else{
						chgText.applyFill = true;
						var fC = [pal.fColorB.graphics.backgroundColor.color[0], pal.fColorB.graphics.backgroundColor.color[1], pal.fColorB.graphics.backgroundColor.color[2]];
						chgText.fillColor = fC;
					}
				}else{
					chgText.applyFill = textDoc.value.applyFill;
					if(chgText.applyFill){
						chgText.fillColor = textDoc.value.fillColor;
					}
				}
				if(pal.infoStroke.value){
					if(pal.sColorNon.visible){
						chgText.applyStroke = false;
					}else{
						chgText.applyStroke = true;
						var sC = [pal.sColorB.graphics.backgroundColor.color[0], pal.sColorB.graphics.backgroundColor.color[1], pal.sColorB.graphics.backgroundColor.color[2]];
						chgText.strokeColor = sC;
					}
				}else{
					chgText.applyStroke = textDoc.value.applyStroke;
					if(chgText.applyStroke){
						chgText.strokeColor = textDoc.value.strokeColor;
					}
				}
				if(pal.infoStroke.value){
    				if(pal.sWidthInfo.value){
    					if(chgText.applyStroke){
    						chgText.strokeWidth = parseInt(pal.sWidth.text);
    					}else{
    						chgText.strokeWidth = textDoc.value.strokeWidth;
    					}
    				}else{
    					chgText.strokeWidth = textDoc.value.strokeWidth;
    				}
				}else{
				    chgText.strokeWidth = textDoc.value.strokeWidth;
				}
				if(pal.infoStroke.value){
    				if(chgText.applyStroke){
    				    if(pal.sofInfo.value){
    						chgText.strokeOverFill = true;
    					}else{
    						chgText.strokeOverFill = false;
    					}
    				}else{
    					chgText.strokeOverFill = textDoc.value.strokeOverFill;
    				}
				}else{
				    chgText.strokeOverFill = textDoc.value.strokeOverFill;
				}

				textDoc.setValue(chgText);
			},


			//mouseイベント ファンクション*************************************************************************
			mdFunc1: function(md)
			{
				if(md.button == 0){
				    if(this.valBtn == "pal"){
					   pSelf.dl_UI_Bld(pSelf,pal, pal.fontName.text);
				    }else if(this.valBtn == "afObj"){
				        pSelf.dl_UI_Bld(pSelf,afObj, afObj.fontName.text);
				    }
				}
			},

			mdFunc3: function(md3)
			{
				if(md3.button == 0){
					pSelf.dlSI_UI_Bld();
				}
			},


			mdFunc4: function(md4)
			{
				if(md4.button == 2){
					if(this.objID == "dl"){
						dlObj.active = true;
						dlObj.close();
					}else if(this.objID == "dlS"){
						dlSObj.active = true;
						dlSObj.close();
					}else if(this.objID == "dlSI"){
						dlSIObj.active = true;
						dlSIObj.close();
					}
				}
			},

			mdFunc5: function(md5)
			{
				if(md5.detail == 1){
					switch(this.nameID)
					{
						case "fontSize":if(pal.infoSize.value){
    				                        pSelf.valS = true;
    				                        pSelf.valSize = pal.fontSize.text;
						                }
				                        break;
						case "rTxt": if(pal.infoFill.value || pal.infoStroke.value){
    						            if(pal.fColorON.visible || pal.sColorON.visible){
                						    pSelf.valR = true;
                						    pSelf.valRed = pal.rTxt.text;
                						}
						            }
            						break;
						case "gTxt": if(pal.infoFill.value || pal.infoStroke.value){
    						            if(pal.fColorON.visible || pal.sColorON.visible){
                						    pSelf.valG = true;
                						    pSelf.valGreen = pal.gTxt.text;
                						}
						            }
            						break;
						case "bTxt": if(pal.infoFill.value || pal.infoStroke.value){
    						            if(pal.fColorON.visible || pal.sColorON.visible){
                						    pSelf.valB = true;
                						    pSelf.valBlue = pal.bTxt.text;
                						}
						            }
            						break;
						case "sWidth":if(pal.sWidthInfo.value){
                						pSelf.valSW = true;
                						pSelf.valsWidth = pal.sWidth.text;
						              }
                						break;
						case "jusL": pSelf.UI_bgColor255(pal.jusL, [60,140,200]);
									 pSelf.UI_fgColor255(pal.infoL, [240,240,240]);
									 pSelf.UI_bgColor255(pal.jusC, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoC, [150,150,150]);
									 pSelf.UI_bgColor255(pal.jusR, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoR, [150,150,150]);
									 pSelf.valJustify = "left";
									 break;
						case "jusC": pSelf.UI_bgColor255(pal.jusL, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoL, [150,150,150]);
									 pSelf.UI_bgColor255(pal.jusC, [60,140,200]);
									 pSelf.UI_fgColor255(pal.infoC, [240,240,240]);
									 pSelf.UI_bgColor255(pal.jusR, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoR, [150,150,150]);
									 pSelf.valJustify = "center";
									 break;
						case "jusR": pSelf.UI_bgColor255(pal.jusL, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoL, [150,150,150]);
									 pSelf.UI_bgColor255(pal.jusC, [100,100,100]);
									 pSelf.UI_fgColor255(pal.infoC, [150,150,150]);
									 pSelf.UI_bgColor255(pal.jusR, [60,140,200]);
									 pSelf.UI_fgColor255(pal.infoR, [240,240,240]);
									 pSelf.valJustify = "right";
									 break;
					}
					pSelf.curX = md5.screenX;
				}else if(md5.detail == 2){
					switch(this.nameID)
					{
						case "fontSize":if(pal.infoSize.value){
    						                pal.fontSize.visible = false;
    										pal.fontSizeLine.visible = false;
    										pal.fontSizePx.visible = false;
    										pal.listBtnC.visible = false;
    										//pal.fontSizeED.text = pal.fontSize.text;
    										pal.fontSizeED.visible = true;
    										pal.fontSizeED.active = true;
						                }
										break;
						case "rTxt":if(pal.fColorON.visible || pal.sColorON.visible){
    						            pal.rTxt.visible = false;
    									pal.rTxtLine.visible = false;
    									//pal.rTxtED.text = pal.rTxt.text;
    									pal.rTxtED.visible = true;
    									pal.rTxtED.active = true;
    									pal.rTxtED.textselection = pal.rTxtED.text;
						            }
									break;
						case "gTxt":if(pal.fColorON.visible || pal.sColorON.visible){
    						            pal.gTxt.visible = false;
    									pal.gTxtLine.visible = false;
    									//pal.gTxtED.text = pal.gTxt.text;
    									pal.gTxtED.visible = true;
    									pal.gTxtED.active = true;
    									pal.gTxtED.textselection = pal.gTxtED.text;
						            }
									break;
						case "bTxt":if(pal.fColorON.visible || pal.sColorON.visible){
    						            pal.bTxt.visible = false;
    									pal.bTxtLine.visible = false;
    									//pal.bTxtED.text = pal.bTxt.text;
    									pal.bTxtED.visible = true;
    									pal.bTxtED.active = true;
						            }
									break;
						case "sWidth":  if(pal.sWidthInfo.value){
    						                pal.sWidth.visible = false;
    										pal.sWidthLine.visible = false;
    										pal.sWidthPx.visible = false;
    										//pal.sWidthED.text = pal.sWidth.text;
    										pal.sWidthED.visible = true;
    										pal.sWidthED.active = true;
						                }
										break;
					}
				}
			},

			mdFunc6: function(md6)
			{
				if(md6.button == 0){
				    //alert(this.cID);
					switch(this.cID)
					{
						case "fON": if(pal.infoFill.value){
    						            pal.fColorON.visible = false;
    									pal.fColorNon.visible = true;
    									if(!pal.sColorON.visible && pal.rTxt.enabled){
    										pal.rTxt.enabled = false;
    										pal.rTxtLine.enabled = false;
    										pal.gTxt.enabled = false;
    										pal.gTxtLine.enabled = false;
    										pal.bTxt.enabled = false;
    										pal.bTxtLine.enabled = false;
    									}
						            }
									break;
						case "fOFF": if(pal.infoFill.value){
    						             pal.fColorOFF.visible = false;
    									 pal.fColorON.visible = true;
    									 if(pal.sColorON.visible){
    									 	pal.sColorON.visible = false;
                                            pal.sColorOFF.visible = true;
    									 }
    									 var cRGB = pal.fColorB.graphics.backgroundColor.color;
    									 pal.rTxt.text = Math.round(255*cRGB[0]);
    									 pal.gTxt.text = Math.round(255*cRGB[1]);
    									 pal.bTxt.text = Math.round(255*cRGB[2]);
    									 if(!pal.rTxt.enabled){
    										pal.rTxt.enabled = true;
    										pal.rTxtLine.enabled = true;
    										pal.gTxt.enabled = true;
    										pal.gTxtLine.enabled = true;
    										pal.bTxt.enabled = true;
    										pal.bTxtLine.enabled = true;
    									}
						            }
									 break;
						case "fNon": if(pal.infoFill.value){
    						             pal.fColorNon.visible = false;
    									 pal.fColorON.visible = true;
    									 if(pal.sColorON.visible){
    									 	pal.sColorON.visible = false;
    									 	pal.sColorOFF.visible = true;
    									 }
    									 var cRGB = pal.fColorB.graphics.backgroundColor.color;
    									 pal.rTxt.text = Math.round(255*cRGB[0]);
    									 pal.gTxt.text = Math.round(255*cRGB[1]);
    									 pal.bTxt.text = Math.round(255*cRGB[2]);
    									 if(!pal.rTxt.enabled){
    										pal.rTxt.enabled = true;
    										pal.rTxtLine.enabled = true;
    										pal.gTxt.enabled = true;
    										pal.gTxtLine.enabled = true;
    										pal.bTxt.enabled = true;
    										pal.bTxtLine.enabled = true;
    									}
						            }
									 break;
						case "sON": if(pal.infoStroke.value){
    						            pal.sColorON.visible = false;
    									pal.sColorNon.visible = true;
    									if(!pal.fColorON.visible && pal.rTxt.enabled){
    										pal.rTxt.enabled = false;
    										pal.rTxtLine.enabled = false;
    										pal.gTxt.enabled = false;
    										pal.gTxtLine.enabled = false;
    										pal.bTxt.enabled = false;
    										pal.bTxtLine.enabled = false;
    									}
						            }
									break;
						case "sOFF": if(pal.infoStroke.value){
    						             pal.sColorOFF.visible = false;
    									 pal.sColorON.visible = true;
    									 if(pal.fColorON.visible){
    									 	pal.fColorON.visible = false;
    									 	pal.fColorOFF.visible = true;
    									 }
    									 var cRGB = pal.sColorB.graphics.backgroundColor.color;
    									 pal.rTxt.text = Math.round(255*cRGB[0]);
    									 pal.gTxt.text = Math.round(255*cRGB[1]);
    									 pal.bTxt.text = Math.round(255*cRGB[2]);
    									 if(!pal.rTxt.enabled){
    										pal.rTxt.enabled = true;
    										pal.rTxtLine.enabled = true;
    										pal.gTxt.enabled = true;
    										pal.gTxtLine.enabled = true;
    										pal.bTxt.enabled = true;
    										pal.bTxtLine.enabled = true;
    									}
						            }
									 break;
						case "sNon": if(pal.infoStroke.value){
    						             pal.sColorNon.visible = false;
    									 pal.sColorON.visible = true;
    									 if(pal.fColorON.visible){
    									 	pal.fColorON.visible = false;
    									 	pal.fColorOFF.visible = true;
    									 }
    									 var cRGB = pal.sColorB.graphics.backgroundColor.color;
    									 pal.rTxt.text = Math.round(255*cRGB[0]);
    									 pal.gTxt.text = Math.round(255*cRGB[1]);
    									 pal.bTxt.text = Math.round(255*cRGB[2]);
    									 if(!pal.rTxt.enabled){
    										pal.rTxt.enabled = true;
    										pal.rTxtLine.enabled = true;
    										pal.gTxt.enabled = true;
    										pal.gTxtLine.enabled = true;
    										pal.bTxt.enabled = true;
    										pal.bTxtLine.enabled = true;
    									}
						            }
									 break;
					}
				}
			},

			muFunc1: function(mu1)
			{
				pSelf.valS = false;
				pSelf.valR = false;
				pSelf.valG = false;
				pSelf.valB = false;
				pSelf.valSW = false;
			},

			mvFunc1: function(mv1)
			{
				var sX = mv1.screenX - pSelf.curX;
				if(mv1.screenX < (pal.location[0] + 600)){
					if(pSelf.valS){
						var calS = Number(pSelf.valSize) + sX;
						if(calS < 0){
							pal.fontSize.text = 0;
						}else{
							pal.fontSize.text = calS;
						}
					}else if(pSelf.valR){
						var calS = Number(pSelf.valRed) + sX;
						if(calS < 0){
							pal.rTxt.text = "0";
						}else if(calS < 256){
							pal.rTxt.text = calS;
						}else{
							pal.rTxt.text = "255";
						}

						if(pal.fColorON.visible){
							var cR = new Array();
							cR[0] = 1/255*Math.round(Number(pal.rTxt.text));
							cR[1] = pal.fColorB.graphics.backgroundColor.color[1];
							cR[2] = pal.fColorB.graphics.backgroundColor.color[2];
							pSelf.UI_bgColor(pal.fColorA, cR);
							pSelf.UI_bgColor(pal.fColorB, cR);
						}else if(pal.sColorON.visible){
							var cR = new Array();
							cR[0] = 1/255*Math.round(Number(pal.rTxt.text));
							cR[1] = pal.sColorB.graphics.backgroundColor.color[1];
							cR[2] = pal.sColorB.graphics.backgroundColor.color[2];
							pSelf.UI_bgColor(pal.sColorA, cR);
							pSelf.UI_bgColor255(pal.sColorONL, [240,240,240]);
							pSelf.UI_bgColor(pal.sColorB, cR);
							pSelf.UI_bgColor255(pal.sColorOFFL, [240,240,240]);
						}
					}else if(pSelf.valG){
						var calS = Number(pSelf.valGreen) + sX;
						if(calS < 0){
							pal.gTxt.text = "0";
						}else if(calS < 256){
							pal.gTxt.text = calS;
						}else{
							pal.gTxt.text = "255";
						}

						if(pal.fColorON.visible){
							var cG = new Array();
							cG[0] = pal.fColorB.graphics.backgroundColor.color[0];
							cG[1] = 1/255*Math.round(Number(pal.gTxt.text));
							cG[2] = pal.fColorB.graphics.backgroundColor.color[2];
							pSelf.UI_bgColor(pal.fColorA, cG);
							pSelf.UI_bgColor(pal.fColorB, cG);
						}else if(pal.sColorON.visible){
							var cG = new Array();
							cG[0] = pal.sColorB.graphics.backgroundColor.color[0];
							cG[1] = 1/255*Math.round(Number(pal.gTxt.text));
							cG[2] = pal.sColorB.graphics.backgroundColor.color[2];
							pSelf.UI_bgColor(pal.sColorA, cG);
							pSelf.UI_bgColor255(pal.sColorONL, [240,240,240]);
							pSelf.UI_bgColor(pal.sColorB, cG);
							pSelf.UI_bgColor255(pal.sColorOFFL, [240,240,240]);
						}
					}else if(pSelf.valB){
						var calS = Number(pSelf.valBlue) + sX;
						if(calS < 0){
							pal.bTxt.text = "0";
						}else if(calS < 256){
							pal.bTxt.text = calS;
						}else{
							pal.bTxt.text = "255";
						}

						if(pal.fColorON.visible){
							var cB = new Array();
							cB[0] = pal.fColorB.graphics.backgroundColor.color[0];
							cB[1] = pal.fColorB.graphics.backgroundColor.color[1];
							cB[2] = 1/255*Math.round(Number(pal.bTxt.text));
							pSelf.UI_bgColor(pal.fColorA, cB);
							pSelf.UI_bgColor(pal.fColorB, cB);
						}else if(pal.sColorON.visible){
							var cB = new Array();
							cB[0] = pal.sColorB.graphics.backgroundColor.color[0];
							cB[1] = pal.sColorB.graphics.backgroundColor.color[1];
							cB[2] = 1/255*Math.round(Number(pal.bTxt.text));
							pSelf.UI_bgColor(pal.sColorA, cB);
							pSelf.UI_bgColor255(pal.sColorONL, [240,240,240]);
							pSelf.UI_bgColor(pal.sColorB, cB);
							pSelf.UI_bgColor255(pal.sColorOFFL, [240,240,240]);
						}
					}else if(pSelf.valSW){
						var calSW = Number(pSelf.valsWidth) + sX;
						if(calSW < 0){
							pal.sWidth.text = 0;
						}else{
							pal.sWidth.text = calSW;
						}
					}
				}else{
					pSelf.valS = false;
					pSelf.valR = false;
					pSelf.valG = false;
					pSelf.valB = false;
					pSelf.valSW = false;
				}
			},


			//keyイベントファンクション************************************************************
			kdFunc0: function(ekd)
            {
                switch(ekd.keyName)
                {
                    case "Enter":  if(this.valBtn == "pal"){
                                        pSelf.dl_UI_Bld(pSelf,pal, pal.fontName.text);
                                    }else if(this.valBtn == "afObj"){
                                        pSelf.dl_UI_Bld(pSelf,afObj, afObj.fontName.text);
                                    }
                                   break;
                }
            },

			edFunc1: function(ekd)
			{
				switch(ekd.keyName)
				{
					case "Escape": if(this.objID == "dl"){
										dlObj.active = true;
										dlObj.close();
									}else if(this.objID == "dlS"){
										dlSObj.active = true;
										dlSObj.close();
									}else if(this.objID == "dlSI"){
										dlSIObj.active = true;
										dlSIObj.close();
									}
									break;
					case "Enter":  pSelf.dl_UI_Bld(pSelf,pal, pal.fontName.text);
				}
			},

			kdFunc1: function(kd1)
			{
				switch(kd1.keyName)
				{
					case "Enter": if(pal.fontSizeED.visible){
					                  if(pal.fontSizeED.text != ""){
									      pal.fontSize.text = pal.fontSizeED.text;
					                  }
									  pal.fontSize.visible = true;
									  pal.fontSizeLine.visible = true;
									  pal.fontSizePx.visible = true;
									  pal.listBtnC.visible = true;

									  pal.fontSizeED.visible = false;
									  pal.fontSizeED.text = "";
									  pal.fontSizeED.active = false;
								  }else if(pal.rTxtED.visible){
								      if(pal.rTxtED.text != ""){
									      pal.rTxt.text = pal.rTxtED.text;
								      }
									  pal.rTxt.visible = true;
									  pal.rTxtLine.visible = true;

									  pal.rTxtED.visible = false;
									  pal.rTxtED.text = "";
									  pal.rTxtED.active = false;
									  if(pal.fColorON.visible){
    									  pSelf.UI_bgColor255(pal.fColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
    									  pSelf.UI_bgColor255(pal.fColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
									  }else if(pal.sColorON.visible){
									      pSelf.UI_bgColor255(pal.sColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                          pSelf.UI_bgColor255(pal.sColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
									  }
								  }else if(pal.gTxtED.visible){
								      if(pal.gTxtED.text != ""){
									      pal.gTxt.text = pal.gTxtED.text;
								      }
									  pal.gTxt.visible = true;
									  pal.gTxtLine.visible = true;

									  pal.gTxtED.visible = false;
									  pal.gTxtED.text = "";
									  pal.gTxtED.active = false;
									  if(pal.fColorON.visible){
                                          pSelf.UI_bgColor255(pal.fColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                          pSelf.UI_bgColor255(pal.fColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                      }else if(pal.sColorON.visible){
                                          pSelf.UI_bgColor255(pal.sColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                          pSelf.UI_bgColor255(pal.sColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                      }
								  }else if(pal.bTxtED.visible){
									  if(pal.bTxtED.text != ""){
                                          pal.bTxt.text = pal.bTxtED.text;
                                      }
									  pal.bTxt.visible = true;
									  pal.bTxtLine.visible = true;

									  pal.bTxtED.visible = false;
									  pal.bTxtED.text = "";
									  pal.bTxtED.active = false;
									  if(pal.fColorON.visible){
                                          pSelf.UI_bgColor255(pal.fColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                          pSelf.UI_bgColor255(pal.fColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                      }else if(pal.sColorON.visible){
                                          pSelf.UI_bgColor255(pal.sColorA, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                          pSelf.UI_bgColor255(pal.sColorB, [pal.rTxt.text,pal.gTxt.text,pal.bTxt.text]);
                                      }
								  }else if(pal.sWidthED.visible){
								    if(pal.sWidthED.text != ""){
								  	    pal.sWidth.text = pal.sWidthED.text;
								    }
								  	pal.sWidth.visible = true;
								  	pal.sWidthLine.visible = true;
								  	pal.sWidthPx.visible = true;

								  	pal.sWidthED.visible = false;
								  	pal.sWidthED.text = "";
								  	pal.sWidthED.active = false;
								  }
								  break;
					case "Escape": if(pal.fontSizeED.visible){
									   pal.fontSize.visible = true;
									   pal.fontSizeLine.visible = true;
									   pal.fontSizePx.visible = true;
									   pal.listBtnC.visible = true;

									   pal.fontSizeED.visible = false;
									   pal.fontSizeED.text = "";
									   pal.fontSizeED.active = false;
									}else if(pal.rTxtED.visible){
										pal.rTxt.visible = true;
										pal.rTxtLine.visible = true;

										pal.rTxtED.visible = false;
										pal.rTxtED.text = "";
										pal.rTxtED.active = false;
									}else if(pal.gTxtED.visible){
										pal.gTxt.visible = true;
										pal.gTxtLine.visible = true;

										pal.gTxtED.visible = false;
										pal.gTxtED.text = "";
										pal.gTxtED.active = false;
									}else if(pal.bTxtED.visible){
										pal.bTxt.visible = true;
										pal.bTxtLine.visible = true;

										pal.bTxtED.visible = false;
										pal.bTxtED.text = "";
										pal.bTxtED.active = false;
									}else if(pal.sWidthED.visible){
										pal.sWidth.visible = true;
										pal.sWidthLine.visible = true;
										pal.sWidthPx.visible = true;

										pal.sWidthED.visible = false;
										pal.sWidthED.text = "";
										pal.sWidthED.active = false;
									}
								 	break;

				}
			},



			//scriptUI graphics 用ファンクション****************************************************
			//backgroundColor(0～255)
			UI_bgColor255: function(uiObj, uiColor)
			{
				var gColor = new Array();
				for(var i=0;i<3;i++){
					gColor[i] = 1/255*Math.round(uiColor[i]);
					//alert(gColor[i]);
				}
				var gUI = uiObj.graphics;
				var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
				gUI.backgroundColor = uiBrush;
			},

			//foregroundColor(0～255)
			UI_fgColor255: function(uiObj, uiColor)
			{
				var gColor = new Array();
				for(var i=0;i<3;i++){
					gColor[i] = 1/255*Math.round(uiColor[i]);
					//alert(gColor[i]);
				}
				var gUI = uiObj.graphics;
				var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
				gUI.foregroundColor = uiPen;
			},

			//backgroundColor(0～1)
			UI_bgColor: function(uiObj, uiColor)
			{
				var gColor = new Array();
				gColor = uiColor;
				var gUI = uiObj.graphics;
				var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
				gUI.backgroundColor = uiBrush;
			},

			//foregroundColor(0～1)
			UI_fgColor: function(uiObj, uiColor)
			{
				var gColor = new Array();
				gColor = uiColor;
				var gUI = uiObj.graphics;
				var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
				gUI.foregroundColor = uiPen;
			},

			//font
			UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
			{
				var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
				var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
				uiObj.graphics.font = gFont;
			}

		}

		//main******************************************************
		var FC = new fcUI_Obj(thisObj);

		//アプリのバージョン確認(CC以上)
		if (parseFloat(app.version) < 12)
		{
			alert(FC.strErr);
			return;
		}else{
			fcUI = FC.fcUI_build(thisObj);
		}
		//**********************************************************
	}
})();