﻿//     psFontList  20140701
//
//      fontChanger.jsx 用フォントリスト作成スクリプト
//      フォトショップで実行し、AfterEffects のスクリプトフォルダにある[fontChanger] or [fontChanger_CC]フォルダを指定
//
//      AfterEffects CS4～
//

//ExtendScript ToolKid用
#target photoshop

(function()
{
    temp_jsx(this);

    function temp_jsx(thisObj)
    {
        function runScr()
        {
            this.valE = false;
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS4 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //appフォルダパス
                    var dirFolder = "C:/Program Files/Adobe/";
                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //appフォルダパス
                    var dirFolder = "/Applications/";
                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //fontChanger フォルダ
                this.fcFol = new Folder(dirFolder).selectDlg(" select [fontChanger_CC]Folder");
                if(this.fcFol == null){
                    this.valE = true;
                }

                //alert(this.aePath);
            },

            //get FontList
            getFontList: function()
            {
                var PsFonts =app.fonts
                var FontsList =''
                for(var i =0;i<PsFonts.length;i++){
                    if(i == 0){
                        FontsList = String($.os) + "[フォント表記名<日本語>//フォント表記名<英語>//フォントスタイル:ポストスクリプト名>]" +this.CF+ PsFonts[i].family + "//" + PsFonts[i].family + "//" + PsFonts[i].style + ":" + PsFonts[i].postScriptName;
                    }else if(PsFonts[i].family != PsFonts[i-1].family){
                        FontsList += this.CF + PsFonts[i].family + "//" + PsFonts[i].family + "//" + PsFonts[i].style + ":" + PsFonts[i].postScriptName;
                    }else{
                        FontsList += "//" + PsFonts[i].style + ":" + PsFonts[i].postScriptName;
                    }
                }
                return FontsList;
            },

            //save Txt
            saveTxt: function(oList)
            {
                var exFile = new File(this.fcFol.fsName + "/fontList" + this.OS + ".txt");
                //UTF-8にエンコード
                exFile.encoding = "UTF-8";
                if(exFile.open("w")){
                    try
                    {
                        //複数行を一気に書き込み
                        exFile.writeln(oList);
                        exFile.close();
                        alert("******保存しました******");
                    }catch(e){

                    }
                }else{
                    alert("******保存できませんでした******");
                }
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    if(! this.valE){
                        this.saveTxt(this.getFontList());
                    }
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS4 over)
        if (parseFloat(app.version) < 9)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();