//conte_Compositor  ver 3.0  2016.02.08
//
//アニメコンテ撮用のスクリプト集
//
//mail:curryeggs@gmail.com
//twitter:@curry_eggs
//blog:http://curryegg.blog.shinobi.jp/
//
{
    conte_Compositor(this);

    function conte_Compositor(thisObj)
    {
        function runScr()
        {

        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS6 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            bld_UI: function(thisObj)
            {
                var ctrlPnl = (thisObj instanceof Panel) ? thisObj : new Window("palette", "Timeline Controller ver3.0", [0,0,250,250],{resizeable: false});

                if(ctrlPnl != null){

                    this.bld_Pnl(ctrlPnl);

                    ctrlPnl.onResize = function(){}
                }

                return ctrlPnl;
            },

            bld_Pnl: function(thisPnl)
            {
                var bSelf = this;
                this.savePrefALL([true,true,2,true,null,null,null,null,null]);
                thisPnl.ctrlGrp0 = thisPnl.add("group",[0,0,250,250]);
                thisPnl.ctrlGrp = thisPnl.ctrlGrp0.add("panel",[5,5,245,47],"TimeLine Control",{borderStyle:"black"});

                thisPnl.iBtn = thisPnl.ctrlGrp.add("button",[5,8,45,27],"inP");
                thisPnl.iBtn.helpTip = "選択レイヤーのイン・ポイントに時間軸を移動";
                thisPnl.iBtn.onClick = function(){bSelf.lys_SL("<");}

                thisPnl.oBtn = thisPnl.ctrlGrp.add("button",[50,8,90,27],"outP");
                thisPnl.oBtn.helpTip = "選択レイヤーのアウト・ポイントに時間軸を移動";
                thisPnl.oBtn.onClick = function(){bSelf.lys_SL(">");}

                thisPnl.rBtn = thisPnl.ctrlGrp.add("button",[105,8,165,27],"|<");
                thisPnl.rBtn.helpTip = "選択レイヤーのイン・ポイントを現在の時間に合わせてずらす";
                thisPnl.rBtn.onClick = function(){bSelf.lys_SL("|<");}

                thisPnl.pBtn = thisPnl.ctrlGrp.add("button",[170,8,230,27],">|");
                thisPnl.pBtn.helpTip = "選択レイヤーのアウト・ポイントを現在の時間に合わせてずらす";
                thisPnl.pBtn.onClick = function(){bSelf.lys_SL(">|");}

                thisPnl.edGrp = thisPnl.ctrlGrp0.add("panel",[5,50,245,93],"",{borderStyle:"black"});
                thisPnl.fitLBtn = thisPnl.edGrp.add("checkbox",[2,2,73,18],"Fit Comp");
                thisPnl.fitLBtn.helpTip = "ソース元のコンポ内のレイヤー(ソースがコンポ含む)のラストを変更後のコンポのラストに合わせる ※[/]頭切り以外";
                thisPnl.fitLBtn.value = true;
                thisPnl.fitLBtn.onClick = function(){if(this.value){thisPnl.fitKBtn.enabled = true;}else{thisPnl.fitKBtn.enabled = false;}}
                thisPnl.fitKBtn = thisPnl.edGrp.add("checkbox",[10,21,73,41],"Fit Key");
                thisPnl.fitKBtn.helpTip = "[Fit Comp]がONなら尺変更後の下層コンポの範囲外にキーがある場合、尺変更後のコンポにキーを合わせる";
                thisPnl.fitKBtn.value = true;
                thisPnl.edTxt = thisPnl.edGrp.add("edittext",[75,5,120,30],"");
                thisPnl.edTxt.helpTip = "先頭に[-]でコンポの尻切り、[+]でコンポの尻足し、[/]でコンポの頭切り : [秒 + フレーム] or [フレーム数]　入力可";
                thisPnl.edInfo = thisPnl.edGrp.add("statictext",[123,13,138,28],"Fr"); thisPnl.edInfo.justify = "left";
                thisPnl.edBtn = thisPnl.edGrp.add("button",[140,5,230,30],"edit Comp");
                thisPnl.edBtn.helpTip = "レイヤー選択からコンポ尺を編集 : レイヤー未選択時はアクティブコンポの尺編集";
                thisPnl.edBtn.onClick = function(){bSelf.editComp(thisPnl.fitKBtn.value,thisPnl.fitLBtn.value,thisPnl.edTxt,bSelf);}

                thisPnl.slGrp = thisPnl.ctrlGrp0.add("panel",[5,95,245,150],"",{borderStyle:"black"});
                thisPnl.raGrp = thisPnl.slGrp.add("group",[2,1,135,55]);
                thisPnl.raBtn = new Array();
                thisPnl.raBtn[0] = thisPnl.raGrp.add("radiobutton",[1,2,130,16],"First Frame"); thisPnl.raBtn[0].ID = "C";
                thisPnl.raBtn[0].helpTip = "コンポの1Fr目から並べる";
                thisPnl.raBtn[1] = thisPnl.raGrp.add("radiobutton",[1,17,130,32],"Current Time"); thisPnl.raBtn[1].ID = "T";
                thisPnl.raBtn[1].helpTip = "コンポの現在の時間から並べる";
                thisPnl.raBtn[2] = thisPnl.raGrp.add("radiobutton",[1,33,130,48],"U Layer OutPoint"); thisPnl.raBtn[2].ID = "L";
                thisPnl.raBtn[2].helpTip = "下レイヤーの尻から並べる : 最下層のレイヤー選択時はコンポの1Fr目から並べる";
                thisPnl.raBtn[2].value = true;
                thisPnl.slBtn = thisPnl.slGrp.add("button",[140,12,230,37],"Stairway Lys");
                thisPnl.slBtn.helpTip = "選択レイヤーを下から階段状に並べる";
                thisPnl.slBtn.onClick = function()
                  {
                    for(var i=0;i<thisPnl.raBtn.length;i++){
                      if(thisPnl.raBtn[i].value){
                        bSelf.setStairway(thisPnl.raBtn[i].ID,bSelf);
                        break;
                      }
                    }
                  }

                thisPnl.swGrp = thisPnl.ctrlGrp0.add("panel",[5,152,245,195],"",{borderStyle:"black"});
                thisPnl.swChk = thisPnl.swGrp.add("checkbox",[5,13,115,28],"Create Counter");
                thisPnl.swChk.helpTip = "カウンター表示レイヤーを追加";
                thisPnl.swChk.value = true;
                thisPnl.swBtn = thisPnl.swGrp.add("button",[140,5,230,30],"set WorkArea");
                thisPnl.swBtn.helpTip = "選択レイヤーに合わせてワークエリアをトリム : カウンターがあれば合わせてトリム";
                thisPnl.swBtn.onClick = function(){bSelf.setArea(thisPnl.swChk.value,bSelf);}

                thisPnl.posGrp = thisPnl.ctrlGrp0.add("panel",[5,197,245,245],"set Conte Position",{borderStyle:"black"});
                thisPnl.posBtn = new Array();
                for(var pp=0;pp<5;pp++){
                  thisPnl.posBtn[pp] = thisPnl.posGrp.add("button",[2+(pp*32),7,(pp+1)*32,35],"--");
                  thisPnl.posBtn[pp].ID = pp;
                  thisPnl.posBtn[pp].helpTip = "選択レイヤーの現在の時間の[アンカー,位置,スケール]を適用 & 記録([OverRide]ON時は記録) ※位置のみに停止キーを追加(アンカー、スケールは既にキーがあればキーを追加)";
                  thisPnl.posBtn[pp].onClick = function()
                      {
                        bSelf.contePos(this,thisPnl.orChk,bSelf);
                      }
                }
                thisPnl.resetBtn = thisPnl.posGrp.add("button",[165,2,235,20],"Reset");
                thisPnl.resetBtn.helpTip = "各ボタンの記録をリセット";
                thisPnl.resetBtn.onClick = function()
                  {
                    for(var rr=0;rr<5;rr++){
                      bSelf.savePref("cPos"+rr,null);
                      thisPnl.posBtn[rr].text = "--";
                    }
                  }
                thisPnl.orChk = thisPnl.posGrp.add("checkbox",[165,22,235,38],"OverRide");
                thisPnl.orChk.helpTip = "ON時、選択レイヤーの現在時間の[アンカー,位置,スケール]を各ボタンへ記録";
            },

            //loadPref
            loadPref: function(prefName)
            {
              var strC = "conte_Compositor_pref";
              var strD = prefName;
              var reVal = null;
              //環境設定があるか判定
              if(app.preferences.havePref(strC, strD)){
                  //環境設定を読み込み
                  var mVal = app.preferences.getPrefAsString(strC, strD);
                  reVal = mVal.split("_");
              }
              return reVal;
            },

            //loadPref ALL
            loadPrefALL: function()
            {
              var strC = "conte_Compositor_pref";
              var strD = ["Fit Comp Value","Fit Key Value","Start Value","Create Value","cPos0","cPos1","cPos2","cPos3","cPos4"];
              var reVal = new Array();
              for(var pr=0;pr<strD.length;pr++){
                //環境設定があるか判定
                if(app.preferences.havePref(strC, strD[pr])){
                    //環境設定を読み込み
                    var mVal = app.preferences.getPrefAsString(strC, strD[pr]);
                    reVal.push(mVal);
                }else{
                  reVal.push(null);
                }
              }
              return reVal;
            },

            //save Pref
            savePref: function(prefName,prefVal)
            {
                //環境設定に書き込み
                var strA = "conte_Compositor_pref";
                var strB = [prefName, String(prefVal)];
                app.preferences.savePrefAsString(strA, strB[0], strB[1]);
                app.preferences.saveToDisk();
                app.preferences.reload();
            },

            //save Pref ALL
            savePrefALL: function(fcVal,fkVal,stVal,crVal,cp0Val,cp1Val,cp2Val,cp3Val,cp4Val)
            {
                //環境設定に書き込み
                var strA = "conte_Compositor_pref";
                var strB = [    ["Fit Comp Value", String(fcVal)],
                                ["Fit Key Value", String(fkVal)],
                                ["Start Value", String(stVal)],
                                ["Create Value", String(crVal)],
                                ["cPos0", String(cp0Val)],
                                ["cPos1", String(cp1Val)],
                                ["cPos2", String(cp2Val)],
                                ["cPos3", String(cp3Val)],
                                ["cPos4", String(cp4Val)]
                            ]
                for(var i=0;i<strB.length;i++){
                    app.preferences.savePrefAsString(strA, strB[i][0], strB[i][1]);
                }
                app.preferences.saveToDisk();
                app.preferences.reload();
            },

            //
            contePos: function(curVal,orVal,cSelf)
            {
              var curComp = app.project.activeItem;
              if(curComp != null){
                var selLys = new Array();
                selLys = curComp.selectedLayers;
                if(selLys.length == 1){
                  var aProp = selLys[0]("ADBE Transform Group")("ADBE Anchor Point");
                  var pProp = selLys[0]("ADBE Transform Group")("ADBE Position");
                  var sProp = selLys[0]("ADBE Transform Group")("ADBE Scale");
                  //resetがONだったら上書き
                  if(orVal.value){
                    var cAnc = aProp.valueAtTime(curComp.time,false);
                    var cPos = pProp.valueAtTime(curComp.time,false);
                    var cSca = sProp.valueAtTime(curComp.time,false);
                    var strVal = cAnc.join().replace(/,/g,"_") +"_"+ cPos.join().replace(/,/g,"_") +"_"+ cSca.join().replace(/,/g,"_");

                    cSelf.savePref("cPos" + curVal.ID,strVal);
                    curVal.text = Number(curVal.ID)+1;
                    orVal.value = false;
                  //resetがOFFだったら実効
                  }else{
                    if(curVal.text == "--"){
                      alert("登録されていません");
                    }else{
                      var curPref = new Array();
                      curPref = cSelf.loadPref("cPos" + curVal.ID);
                      if(curPref == null){
                        curVal.text = "--";
                        alert("登録されていません");
                      }else{
                        //プロパティにキーがある場合
                        if(aProp.isTimeVarying){
                          aProp.setValueAtTime(curComp.time,[parseFloat(curPref[0]),parseFloat(curPref[1]),parseFloat(curPref[2])]);
                        }else{
                          aProp.setValue ([parseFloat(curPref[0]),parseFloat(curPref[1]),parseFloat(curPref[2])]);
                        }
                        //positionのみキーを打つ
                        pProp.setValueAtTime(curComp.time,[parseFloat(curPref[3]),parseFloat(curPref[4]),parseFloat(curPref[5])]);
                        var curP = pProp.nearestKeyIndex(curComp.time);
                        if(curComp.time == pProp.keyTime(curP)){
                          pProp.setInterpolationTypeAtKey(curP,KeyframeInterpolationType.HOLD,KeyframeInterpolationType.HOLD);
                        }
                        //プロパティにキーがある場合
                        if(aProp.isTimeVarying){
                          sProp.setValueAtTime(curComp.time,[parseFloat(curPref[6]),parseFloat(curPref[7]),parseFloat(curPref[8])]);
                        }else{
                          sProp.setValue([parseFloat(curPref[6]),parseFloat(curPref[7]),parseFloat(curPref[8])]);
                        }
                      }
                    }
                  }
                }else{
                  alert("レイヤーを１つ選択してください");
                }
              }
            },

            //コンポ尺変更
            editComp: function(kVal,IVal,txtVal,bSelf)
            {
              if(txtVal.text != ""){
                var curComp = app.project.activeItem;
                if(curComp != null){
                    if(curComp instanceof CompItem){
                        var selLys = new Array();
                        selLys = curComp.selectedLayers;
                        var edComp = new Array();
                        if(selLys.length == 0){
                          inComp(curComp,edComp);
                        }else if(selLys.length == 1){
                          if(selLys[0] instanceof AVLayer){
                            if(selLys[0].source instanceof CompItem){
                              inComp(selLys[0].source,edComp);
                            }else{
                              alert("コンポソースのレイヤーを1つ選択してください:G");
                            }
                          }else{
                            alert("コンポソースのレイヤーを1つ選択してください:F");
                          }
                        }else{
                          alert("コンポ、もしくはコンポソースのレイヤーを１つ選択してください:E");
                        }

                        function inComp(oComp,edComp)
                        {
                              edComp.push(oComp);
                              var oNum = 1;
                              do{
                                  if(oComp.numLayers > 0 && oComp.layer(oNum).source instanceof CompItem && oComp.layer(oNum).outPoint == oComp.duration){
                                      inComp(oComp.layer(oNum).source,edComp);
                                  }
                                  oNum++;
                              }while(oNum <= oComp.numLayers)
                        }

                        if(edComp.length > 0){
                          app.beginUndoGroup("script : editComp");
                          clearOutput();
                          writeLn("run script:editComp");
                          edComp.reverse();
                          for(var ed=0;ed<edComp.length;ed++){
                              var oFr = 1/edComp[ed].frameRate;
                              var durVal = edComp[ed].duration;
                              var cDur = 0;
                              var cDur2 = 0;
                              //コンポの尻を切る
                              if(txtVal.text.charAt(0) == "-"){
                                var mVal = txtVal.text.split("-")[1];
                                if(mVal.indexOf("+") == -1){
                                  cDur = durVal - (oFr*Number(mVal));
                                }else{
                                  var secVal = mVal.split("+")[0];
                                  var frVal = mVal.split("+")[1];
                                  cDur = durVal - (oFr*((Number(secVal)*edComp[ed].frameRate) + Number(frVal)));
                                }
                              //コンポの尻に追加
                              }else if(txtVal.text.charAt(0) == "+"){
                                var mVal = txtVal.text.substring(1,txtVal.text.length);
                                if(mVal.indexOf("+") == -1){
                                  cDur = durVal + (oFr*Number(mVal));
                                }else{
                                  var secVal = mVal.split("+")[0];
                                  var frVal = mVal.split("+")[1];
                                  cDur = durVal + (oFr*((Number(secVal)*edComp[ed].frameRate) + Number(frVal)));
                                }
                              //コンポの頭を切る
                              }else if(txtVal.text.charAt(0) == "/"){
                                var mVal = txtVal.text.split("/")[1];
                                if(mVal.indexOf("+") == -1){
                                  cDur2 = oFr*Number(mVal);
                                  cDur = durVal - (oFr*Number(mVal));
                                }else{
                                  var secVal = mVal.split("+")[0];
                                  var frVal = mVal.split("+")[1];
                                  cDur2 = oFr*((Number(secVal)*edComp[ed].frameRate) + Number(frVal));
                                  cDur = durVal - (oFr*((Number(secVal)*edComp[ed].frameRate) + Number(frVal)));
                                }
                              //コンポ尺を変更
                              }else{
                                if(txtVal.text.indexOf("+") == -1){
                                  cDur = oFr*Number(txtVal.text);
                                }else{
                                  var secVal = txtVal.text.split("+")[0];
                                  var frVal = txtVal.text.split("+")[1];
                                  cDur = oFr*((Number(secVal)*edComp[ed].frameRate) + Number(frVal));
                                }
                              }

                              //[/]頭切り以外の場合
                              if(cDur2 == 0){
                                if(IVal){
                                  edComp[ed].duration = cDur;
                                  writeLn("[ "+ edComp[ed].name +" : run Script ]");
                                }else{
                                  if(ed = edComp.length-1){
                                    edComp[ed].duration = cDur;
                                    writeLn("[ "+ edComp[ed].name +" : run Script ]");
                                  }
                                }
                                if(edComp[ed].numLayers > 0 && cDur > 0){
                                  for(var i=1;i<=edComp[ed].numLayers;i++){
                                    //レイヤーがロックされていない場合
                                    if(! edComp[ed].layer(i).locked){
                                      //レイヤーのラストが変更前のコンポのラストだった場合、尺変更後のコンポのラストに合わせる
                                      if(IVal){
                                        //レイヤーのラストが変更前ののコンポと同じか判別
                                        if(edComp[ed].layer(i).outPoint == durVal){
                                          //変更後のコンポの範囲内だったら実行
                                          if(edComp[ed].layer(i).inPoint < cDur){
                                            edComp[ed].layer(i).outPoint = cDur;
                                          }
                                        }

                                        //変更後のコンポの範囲外だったらログを残す
                                        if(edComp[ed].layer(i).inPoint >= cDur){
                                          writeLn(" / [ "+ edComp[ed].layer(i).name +" : Out of range ]");
                                        }

                                        //コンポの範囲外にキーが合ったら尺変更後のコンポに合わせる
                                        if(kVal){
                                          for(var ii=1;ii<=edComp[ed].layer(i).numProperties;ii++){
                                            endProp(edComp[ed].layer(i),edComp[ed].layer(i).property(ii),cDur,durVal,bSelf);
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              //[/]頭切りの場合、対象コンポのみ変更
                              }else{
                                if(ed = edComp.length-1){
                                  edComp[ed].duration = cDur;
                                  for(var i=1;i<=edComp[ed].numLayers;i++){
                                    //レイヤーがロックされていない場合
                                    if(! edComp[ed].layer(i).locked){
                                      edComp[ed].layer(i).startTime = edComp[ed].layer(i).startTime - cDur2;
                                    }
                                  }
                                  writeLn("[ "+ edComp[ed].name +" : run Script [/] ]");
                                }
                              }
                          }

                          if(selLys.length > 0){
                            selLys[0].outPoint = parseFloat(selLys[0].startTime) + parseFloat(cDur);
                          }
                          txtVal.text = "";
                          app.endUndoGroup();

                          function endProp(oLy,oProp,cDur,durVal,bSelf)
                          {
                            if(oProp.numProperties != undefined && oProp.numProperties > 0){
                              var iii=oProp.numProperties;
                              do{
                                  endProp(oLy,oProp.property(iii),cDur,durVal,bSelf);
                                  iii--;
                              }while(iii > 0)
                            }else{
                              //プロパティにキーがある場合
                              if(oProp.isTimeVarying){
                                var keyArray = new Array();
                                var timeArray = new Array();
                                var errorVal = false;
                                //尺が短くなる場合
                                if(cDur < durVal){
                                  var timeVal = durVal - cDur;
                                  for(var k=1;k<=oProp.numKeys;k++){
                                    //切り取る範囲にキーがあった場合
                                    if(cDur <= oProp.keyTime(k) + oFr){
                                      var eKey = oProp.nearestKeyIndex(oProp.keyTime(k) + oFr - timeVal);
                                      if(0 >= oProp.keyTime(k) + oFr - timeVal || oProp.keyTime(eKey) + oFr == oProp.keyTime(k) + oFr - timeVal){
                                        errorVal = true;
                                        writeLn("[ comp:"+ oLy.containingComp.name +"/"+ oLy.name +"/"+ oProp.name +" : 移動先にキーがある or 0以下 ]");
                                        alert("移動先にキーがある or 0以下の為、キーの移動はキャンセルされました" +bSelf.CF+ "[ comp:"+ oLy.containingComp.name +"/"+ oLy.name +"/"+ oProp.name + " ]");
                                        keyArray = new Array();
                                        timeArray = new Array();
                                        break;
                                      }else{
                                        keyArray.push(bSelf.copyKey(oProp,k));
                                        timeArray.push(oProp.keyTime(k) + oFr - timeVal);
                                      }
                                    }
                                  }
                                //尺が長くなる場合
                                }else if(cDur > durVal){
                                  var timeVal = cDur - durVal;
                                  for(var k=1;k<=oProp.numKeys;k++){
                                    //前尺ラスト以降にキーがある場合
                                    if(durVal <= oProp.keyTime(k) + oFr){
                                      keyArray.push(bSelf.copyKey(oProp,k));
                                      timeArray.push(oProp.keyTime(k) + oFr + timeVal);
                                    }
                                  }
                                }

                                if(! errorVal && keyArray.length > 0 && timeArray.length > 0){
                                  bSelf.pasteKey(oProp,keyArray,timeArray);
                                }

                              }
                            }
                          }
                        }else{
                          alert("コンポ、もしくはコンポソースのレイヤーを１つ選択してください:D");
                        }
                    }else{
                      alert("コンポ、もしくはコンポソースのレイヤーを１つ選択してください:C");
                    }
                }else{
                  alert("コンポ、もしくはコンポソースのレイヤーを１つ選択してください:B");
                }
              }else{
                alert("変更後のコンポ尺を入力してください:A");
              }
            },

            //キーを取得
            copyKey: function(prop,keyIndex)
            {
              var keyVal ={
                            "inCompObj" : prop.parentProperty.parentProperty.containingComp,
                            "layerObj" : prop.parentProperty.parentProperty,
                            "propObj" : prop,
                            "index" : keyIndex,
                            "time" : prop.keyTime(keyIndex),
                            "value" : prop.keyValue(keyIndex),
                            "in" : {
                                    "type" : prop.keyInInterpolationType(keyIndex),
                                    "value" : prop.keyInTemporalEase(keyIndex),
                                    "speed" : prop.keyInTemporalEase(keyIndex)[0].speed,
                                    "influence" : prop.keyInTemporalEase(keyIndex)[0].influence,
                                    },
                            "out" : {
                                        "type" : prop.keyOutInterpolationType(keyIndex),
                                        "value" : prop.keyOutTemporalEase(keyIndex),
                                        "speed" : prop.keyOutTemporalEase(keyIndex)[0].speed,
                                        "influence" : prop.keyOutTemporalEase(keyIndex)[0].influence,
                                    }
                        };

              if(prop.isSpatial){
                  keyVal["hasTangents"] = true;
                  keyVal["in"]["type"] = KeyframeInterpolationType.BEZIER;
                  keyVal["in"]["tangent"] = prop.keyInSpatialTangent(keyIndex);
                  keyVal["out"]["type"] = KeyframeInterpolationType.BEZIER;
                  keyVal["out"]["tangent"] = prop.keyOutSpatialTangent(keyIndex);
              } else {
                  keyVal["hasTangents"] = false;
              }
              return keyVal;
            },

            //キーを設定 : timeVal が "COPY" の場合はそのまま別レイヤーにコピー
            pasteKey: function(prop,keyVal,timeVal) ///(ペースト先 property,[コピー元キーデータ array],[ペースト先時間 array or "COPY"])
            {
              var newIndex = new Array();
              for(var p=0;p<keyVal.length;p++){
                if(timeVal == "COPY"){
                  var tVal = keyVal[p].time;
                }else{
                  //※keyTime は実際のtime - 1/frameRate
                  var oFr = 1/keyVal[p].inCompObj.frameRate;
                  var tVal = timeVal[p]-oFr;
                }
                prop.setValueAtTime(tVal,keyVal[p].value);
                var rmKey = prop.nearestKeyIndex(keyVal[p].time);
                prop.removeKey(rmKey);
                newIndex.push(prop.nearestKeyIndex(tVal));
              }

              for(var p=0;p<newIndex.length;p++){
                prop.setTemporalEaseAtKey(newIndex[p],keyVal[p].in.value,keyVal[p].out.value);

                if(keyVal[p].hasTangents){
                  prop.setSpatialTangentsAtKey(newIndex[p],keyVal[p].in.tangent,keyVal[p].out.tangent);
                }
                prop.setInterpolationTypeAtKey(newIndex[p],keyVal[p].in.type,keyVal[p].out.type);
              }
              writeLn("[ "+ keyVal[0].inCompObj.name +"/"+ keyVal[0].layerObj.name +"/"+ keyVal[0].propObj.name +" : move Key "+ newIndex.join() +" ]");
            },

            //レイヤーをずらす
            lys_SL: function(btnVal)
            {
                var curComp = app.project.activeItem;
                if(curComp != null && curComp instanceof CompItem){
                    var selLys = new Array();
                    selLys = curComp.selectedLayers;
                    if(selLys.length > 0){
                        if(btnVal == "<" || btnVal == "|<"){
                          selLys.sort(this.smallStartTime);
                          var inP = new Array();
                          for each(var oLy in selLys){
                              inP.push(parseFloat(oLy.inPoint));
                          }
                        }

                        if(btnVal == ">" || btnVal == ">|"){
                          selLys.sort(this.smallOutPoint);
                          var outP = new Array();
                          for each(var oLy in selLys){
                              outP.push(parseFloat(oLy.outPoint));
                          }
                        }

                        var frRate = curComp.frameRate;

                        switch(btnVal)
                        {
                            case "<": var oVal = null;
                                      for(var i=0;i<inP.length;i++){
                                        if(inP[i] == parseFloat(curComp.time)){
                                            if(i == inP.length - 1){
                                                oVal = 0;
                                            }else{
                                                oVal = i + 1;
                                            }
                                            break;
                                        }
                                      }

                                      if(oVal == null){oVal = 0}

                                      app.beginUndoGroup("TimeLine_Controller");
                                      curComp.time = inP[oVal];
                                      app.endUndoGroup();
                                      break;
                            case ">": var oVal = null;
                                      for(var i=outP.length-1;i>=0;i--){
                                        if(outP[i] == parseFloat(curComp.time)){
                                            if(i == 0){
                                                oVal = outP.length - 1;
                                            }else{
                                                oVal = i - 1;
                                            }
                                            break;
                                        }
                                      }

                                      if(oVal == null){oVal = outP.length - 1}

                                      app.beginUndoGroup("TimeLine_Controller");
                                      curComp.time = outP[oVal];
                                      app.endUndoGroup();
                                      break;
                            case "|<": var oVal = null;
                                       for(var i=0;i<inP.length;i++){
                                         if(inP[i] == parseFloat(curComp.time)){
                                             if(i == inP.length - 1){
                                                 oVal = 0;
                                             }else{
                                                 oVal = i + 1;
                                             }
                                             break;
                                         }
                                       }

                                       if(oVal == null){oVal = 0}
                                       var slVal = inP[oVal] - curComp.time;

                                       app.beginUndoGroup("TimeLine_Controller");
                                       for each(var oLy in selLys){
                                           oLy.startTime = oLy.startTime - slVal;
                                       }
                                       app.endUndoGroup();
                                       break;
                            case ">|": var oVal = null;
                                       for(var i=outP.length-1;i>=0;i--){
                                         if(outP[i] == parseFloat(curComp.time)){
                                             if(i == 0){
                                                 oVal = outP.length - 1;
                                             }else{
                                                 oVal = i - 1;
                                             }
                                             break;
                                         }
                                       }

                                       if(oVal == null){oVal = outP.length - 1}
                                       var slVal = outP[oVal] - curComp.time;

                                       app.beginUndoGroup("TimeLine_Controller");
                                       for each(var oLy in selLys){
                                           oLy.startTime = oLy.startTime - slVal;
                                       }
                                       app.endUndoGroup();
                                       break;
                        }
                    }else{
                        alert("レイヤーが選択されていません");
                    }
                }else{
                    alert("コンポが選択されていません");
                }
            },

            //レイヤーを階段状に並べる
            setStairway: function(raVal,bSelf)
            {
                var curComp = app.project.activeItem;
                if(curComp != null && curComp instanceof CompItem){
                    var selLys = new Array();
                    selLys = curComp.selectedLayers;
                    var numLys = curComp.numLayers;
                    var lysIndex = new Array();
                    if(selLys.length > 0){
                        selLys.sort(bSelf.bigIndex);
                        var oFr = 1 / curComp.frameDuration;

                        app.beginUndoGroup("script : StairwayLys");
                        for(var i=0;i<selLys.length;i++){
                            var slVal = selLys[i].inPoint - selLys[i].startTime;
                            if(raVal == "C"){
                              if(i == 0){
                                var baseFr = 0;
                              }else{
                                var baseFr = curComp.layer(selLys[i].index + 1).outPoint;
                              }
                            }else if(raVal == "T"){
                              if(i == 0){
                                var baseFr = curComp.time;
                              }else{
                                var baseFr = curComp.layer(selLys[i].index + 1).outPoint;
                              }
                            }else if(raVal == "L"){
                              if(selLys[i].index < numLys){
                                  var baseFr = curComp.layer(selLys[i].index + 1).outPoint;
                              }else{
                                  var baseFr = 0;
                              }
                            }

                            selLys[i].startTime = baseFr - slVal;
                            lysIndex.push(selLys[i].index);
                        }
                        clearOutput();
                        writeLn("run script:StairwayLys / layer:[ "+ lysIndex.join() +" ]");
                        app.endUndoGroup();
                    }else{
                      alert("レイヤーが選択されていません");
                    }
                }else{
                  alert("コンポが選択されていません");
                }
            },

            //ワークエリアを設定
            setArea: function(cVal,bSelf)
            {
                var curComp = app.project.activeItem;
                if(curComp != null && curComp instanceof CompItem){
                    app.beginUndoGroup("script : setWorkArea");

                    var selLys = curComp.selectedLayers;
                    var allLys = new Array();
                    allLys = curComp.layers;
                    if(selLys.length > 0){
                        var ctrlLy = null;
                        var curLy = new Array();
                        //カウンターレイヤーの有無
                        for(var i=1;i<=allLys.length;i++){
                            if(allLys[i].name == "_Ctrl_Counter"){
                                ctrlLy = allLys[i];
                            }
                        }
                        //選択レイヤーを取得
                        for each(var oLy in selLys){
                            if(oLy.name != "_Ctrl_Counter"){
                                curLy.push(oLy);
                            }
                        }

                        if(curLy.length > 0){
                            curLy.sort(bSelf.smallInPoint); 
                            var inP = curLy[0].inPoint;
                            curLy.sort(bSelf.smallOutPoint); 
                            var outP = curLy[curLy.length-1].outPoint;
                            var lockVal = false;
                            //ワークエリアを指定
                            curComp.workAreaStart = inP;
                            curComp.workAreaDuration = outP - inP;
                            //カウンターレイヤーが既にあればイン・アウトを指定
                            if(ctrlLy != null){
                                if(ctrlLy.locked){
                                    ctrlLy.locked = false;
                                    lockVal = true;
                                }
                                ctrlLy.startTime = inP;
                                ctrlLy.outPoint = outP;
                                if(lockVal){
                                    ctrlLy.locked = true;
                                }
                            //chk ON の場合、カウンターレイヤーが無ければ作成
                            }else{
                                if(cVal){
                                    var sSelf = bSelf;
                                    var setDlg = new Window("dialog", " set Counter", [0,0,260,100], {closeButton:false,minimizeButton:false,maximizeButton:false});

                                    var colorInfo = setDlg.add("statictext",[10,30,70,50],"Font Color");
                                    var setColor = setDlg.add("group",[80,10,120,50]);
                                    bSelf.UI_bgColor255(setColor,[242,242,242]);
                                    setColor.helpTip = "クリックで色変更";
                                    setColor.addEventListener('mousedown',mdFunc);

                                    var sizeInfo = setDlg.add("statictext",[150,30,200,50],"Font Size");
                                    var sizeET = setDlg.add("edittext",[210,20,250,50],"20");

                                    var addName = setDlg.add("checkbox",[10,70,130,90],"add CompName");
                                    addName.value = true;
                                    addName.helpTip = "コンポ名の表示 or 非表示";

                                    var okBtn = setDlg.add("button",[160,60,250,90],"OK");
                                    okBtn.onClick = function()
                                        {
                                            if(addName.value){
                                                var cName = "thisComp.name + ";
                                            }else{
                                                var cName = "";
                                            }
                                            var exTxt = "var curFD = thisComp.frameDuration;" +sSelf.CF+
                                                        "var FRALL = timeToFrames(t = time + thisComp.displayStartTime, fps = 1.0 / curFD, isDuration = false) - timeToFrames(t = thisLayer.startTime, fps = 1.0 / curFD, isDuration = false) + 1;" +sSelf.CF+
                                                        "var Sec = Math.floor(FRALL / (1 / curFD));" +sSelf.CF+
                                                        "var FR = Math.round(FRALL % (1 / curFD));" +sSelf.CF+
                                                        cName +"\""+ "  [ " +"\""+ "  + (" +"\""+ "000" +"\""+ " + Sec).slice(-4) + " +"\""+ " + " +"\""+ " + (" +"\""+ "0" +"\""+ " + FR).slice(-2) + " +"\""+ "  " +"\""+ " + (" +"\""+ "000" +"\""+ " + FRALL).slice(-4) + " +"\""+ " ]" +"\""+ ";";

                                            ctrlLy = curComp.layers.addText(" ");
                                            ctrlLy.size = [curComp.width,curComp.height];
                                            ctrlLy.name = "_Ctrl_Counter";
                                            ctrlLy("ADBE Text Properties")("ADBE Text Document").expression = exTxt;
                                            ctrlLy("ADBE Text Properties")("ADBE Text More Options")("ADBE Text Render Order").setValue(2);

                                            var txtD = ctrlLy("ADBE Text Properties")("ADBE Text Document").value;
                                            txtD.fontSize = Number(sizeET.text);
                                            txtD.fillColor = [setColor.graphics.backgroundColor.color[0],setColor.graphics.backgroundColor.color[1],setColor.graphics.backgroundColor.color[2]];
                                            txtD.strokeColor = [0,0,0];
                                            txtD.strokeWidth = 2;
                                            txtD.font = "Arial";
                                            txtD.strokeOverFill = true;
                                            txtD.applyStroke = true;
                                            txtD.applyFill = true;
                                            ctrlLy("ADBE Text Properties")("ADBE Text Document").setValue(txtD);

                                            ctrlLy("ADBE Transform Group")("ADBE Position").setValue([10,Number(sizeET.text),0]);

                                            ctrlLy.startTime = inP;
                                            ctrlLy.outPoint = outP;

                                            setDlg.close();
                                        }

                                    setDlg.center();
                                    setDlg.show();

                                    //カラーパレットがクリックされたらカラーピックで色を取得
                                    function　mdFunc()
                                    {
                                        //alert(e.button);
                                        var getCol2 = new Array();
                                        var gColor = new Array();
                                        gColor = sSelf.getUI_bgColor255(this);
                                        //alert(sSelf.rgbTo16(gColor));
                                        getCol2 = sSelf.colorPick(sSelf.rgbTo16(gColor));
                                        if(getCol2 != null){
                                            var uiBrush = this.graphics.newBrush(this.graphics.BrushType.SOLID_COLOR, [getCol2[0],getCol2[1], getCol2[2], 1]);
                                            this.graphics.backgroundColor = uiBrush;
                                        }
                                    }
                                }
                            }
                            //現在のフレームをイン・ポイントに移動
                            curComp.time = inP;

                            clearOutput();
                            writeLn("run script:setWarkArea / compTime:[ "+ ((curComp.time*curComp.frameRate)+1) +" Fr ]");
                        }

                    }else{
                        alert("レイヤーが選択されていません");
                    }
                    app.endUndoGroup();
                }else{
                  alert("コンポが選択されていません");
                }
            },

            //システムのカラーピックを利用して色を取得
            colorPick: function(cRGB)
            {
                var picCol = $.colorPicker(cRGB);
                //alert(picCol);
                if(picCol != -1){
                    var getRgbCol = [ picCol >> 16 , (picCol & 0x00ff00) >> 8 , picCol & 0xff ];
                    var getRGB = new Array();
                    for(var i=0;i<3;i++){ getRGB[i] = 1/255*Math.round(getRgbCol[i]); }
                    //alert("decimal = " + picCol + ", hex = " + picCol.toString(16) + ", RGB = " + getRgbCol[0] + ', ' + getRgbCol[1] + ', ' + getRgbCol[2]);
                    //alert(getRGB);
                }else{
                    var getRGB = null;
                }

                return getRGB;
            },

            //RGB → 16進数
            rgbTo16: function(col)
            {
                return "0x" + ("0" + parseInt(col[0]).toString(16)).slice(-2) + ("0" + parseInt(col[1]).toString(16)).slice(-2) + ("0" + parseInt(col[2]).toString(16)).slice(-2);
            },

            //****** ソート用関数 sort(関数名)******
            ////Index
            bigIndex: function(a,b)
            {
                return (a.index < b.index) ? 1 : -1 ;
            },

            //startTime
            smallStartTime: function(a,b)
            {
                return (a.startTime > b.startTime) ? 1 : -1 ;
            },

            //inPoint
            smallInPoint: function(a,b)
            {
                return (a.inPoint > b.inPoint) ? 1 : -1 ;
            },

            //outPoint
            smallOutPoint: function(a,b)
            {
                return (a.outPoint > b.outPoint) ? 1 : -1 ;
            },

            //scriptUI graphics 用ファンクション****************************************************
            //get backgroundColor255
            getUI_bgColor255: function(uiObj)
            {
                var curColor = uiObj.graphics.backgroundColor.color;
                var bgColor = new Array();
                for(var i=0;i<3;i++){
                    bgColor[i] = Math.round(curColor[i] * 255);
                }

                return bgColor;
            },

            //backgroundColor(0～255)
            UI_bgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
                gUI.backgroundColor = uiBrush;
            },

            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            //font
            UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
            {
                var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
                var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
                uiObj.graphics.font = gFont;
            },
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS6 over)
        if (parseFloat(app.version) < 11)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.osChk();
            var PNL = TMP.bld_UI(thisObj);
            if(PNL != null){
                //alert(PNL);
                if(PNL instanceof Window){
                    PNL.center();
                    PNL.show();
                }else (PNL instanceof Panel){
                    TMP.bld_Pnl(PNL);
                }
            }
        }
    }
}