﻿//  importCSV_toTimesheetAE.jsx ver.2.1 2018.06.01
//
//  CSVファイルを読み込み [timesheetAE] 形式で各レイヤーにシート付けします
//  レイヤーを選択後に実行 → CSVファイルを選択 → ダイアログから各レイヤーに対応するセルを選択後、OK
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    importCSV_toTimesheetAE(this);

    function importCSV_toTimesheetAE(thisObj)
    {
        function runScr()
        {
            this.actComp = app.project.activeItem;
            this.cellData = new Array();
            this.cellLys = new Array();

            //Smooth Plug-In
            this.smPlugIn = "OLMSmoother.aex";
            this.smName = "OLM Smoother";
            this.smVal = false; //Smooth PlugIn の有無判別
            this.valSM = false; //OLM Smoother の適用判定
            this.valSMRange = 6; //Smoother Range のデフォルト値
            this.valSMCKey = false; //Smoother ColorKey の適用判定

            //ColorKey Effect
            this.valCKey = false;   //ColorKey の適用判定
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS6 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = String.fromCharCode(10);
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = String.fromCharCode(10);
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            importCSV: function()
            {
                if(app.project.file != null){
                    var file = new File(app.project.file.path);
                }else{
                    var file = new File("~/Desktop/");
                }
                var textfile = file.openDlg("Select CSV File","*.csv")
                var startVal = null;
                if (textfile == null){
                    alert("キャンセルされました")
                }else{
                    var colVal = new Array();
                    var rowVal = new Array();
                    //textfile.execute()
                    textfile.open("r")
                     
                    colVal = textfile.read().split(this.CF)
                    //alert(colVal[1]);
                    rowVal = colVal[1].split(",")

                    //動画の記入行を抽出
                    for(var j=0;j<colVal[0].split(",").length;j++)
                    {
                        //alert(colVal[0].split(",")[j]);                        
                        if(colVal[0].split(",")[j]=="\"動画"+"\""){
                            startVal = j;
                            break;
                        }
                    }
                    //alert(rowVal);
                     
                    if(startVal != null){
                        this.setCellNO(startVal,colVal,rowVal);
                    }else{
                        alert("実行できませんでした");
                    }
                }
            },

            //レイヤーのインデックスでソート(降順)
            downIndex: function(a,b)
            {
                 return (a.index < b.index) ? 1 : -1 ;
            },

            //TSエフェクト適用
            setFX: function(curLy)
            {
                //TSエフェクトチェック
                var tsFxflag = [0,0,0,0];
                if(curLy.property("Effects").numProperties > 0){
                    for(var i=1;i<=curLy.property("Effects").numProperties;i++){
                        switch(curLy.property("Effects")(i).name)
                        {
                            case "TS_スライダ制御": tsFxflag[0] = 1; break;   //under CS4
                            case "TS_スライダー制御": tsFxflag[0] = 1; break;  //over CS5
                            case "TS_Slider Control":  tsFxflag[0] = 1; break;
                            case "TS_トランスフォーム": tsFxflag[1] = 1; break;
                            case "TS_Geometry2":    tsFxflag[1] = 1; break;
                            case "TS_カラーキー":    tsFxflag[2] = 1; break;
                            case "TS_Color Key":    tsFxflag[2] = 1; break;
                            case "TS_OLMSmoother":  tsFxflag[3] = 1; break;
                            case "TS_" + this.smName:  tsFxflag[3] = 1; break;
                        }
                    }
                }

                //Exp
                var tsTransformExp = "if ( effect("+"\""+"TS_Slider Control"+"\""+")("+"\""+"ADBE Slider Control-0001"+"\""+") == 0 ) { 0 } else { 100 }";
                var tsTimeRimapExp = "( effect("+"\""+"TS_Slider Control"+"\""+")("+"\""+"ADBE Slider Control-0001"+"\""+") - 1 ) * ( this_comp.frame_duration )";

                //TimeRemap check
                if ( curLy.canSetTimeRemapEnabled == true )
                {
                    if ( curLy.timeRemapEnabled != true )
                    {
                        curLy.timeRemapEnabled = true;
                        curLy.timeRemap.removeKey(2);
                        curLy.startTime = 0;
                        curLy.outPoint = this.Dur;
                    }
                }else{
                    curLy.startTime = 0;
                    curLy.outPoint = this.Dur;
                }

                //TSエフェクト適用
                if(tsFxflag[0] == 0){   //Slider
                    var curFx = curLy.property("ADBE Effect Parade").addProperty("ADBE Slider Control");
                    curFx.name = "TS_Slider Control";
                    curFx(1).addKey(0);
                    curFx.moveTo(1);
                    if ( tsFxflag[1] != 0 && curLy.property("ADBE Effect Parade")("TS_Geometry2")(9).expression.indexOf("TS_Slider Control") != -1 )
                    {
                        curLy.property("ADBE Effect Parade")("TS_Geometry2")(9).expressionEnabled = true;
                    }
                }
                if(tsFxflag[1] == 0){   //Transform
                    var curFx = curLy.property("ADBE Effect Parade").addProperty("ADBE Geometry2");
                    curFx.name = "TS_Geometry2";
                    curFx(9).expression = tsTransformExp;
                    curFx.moveTo(curLy.property("ADBE Effect Parade")("TS_Slider Control").propertyIndex+1);
                }
                if(tsFxflag[2] == 0){   //ColorKey
                    if(this.valCKey){
                        var curFx = curLy.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                        curFx.name = "TS_Color Key";
                        curFx(1).setValue([1,1,1,1]);
                        curFx.moveTo(curLy.property("ADBE Effect Parade")("TS_Geometry2").propertyIndex+1);
                    }
                }
                if(tsFxflag[3] == 0){   //Smooth plugIn
                    if(this.smVal && this.valSM){
                        var curFx = curLy.property("ADBE Effect Parade").addProperty(this.smName);
                        curFx.name = "TS_" + this.smName;
                        curFx(1).setValue(this.valSMCKey);
                        curFx(3).setValue(this.valSMRange);
                        if(curLy.property("Effects").numProperties == 3){
                            curFx.moveTo(curLy.property("ADBE Effect Parade")("TS_Geometry2").propertyIndex+1);
                        }else if(curLy.property("Effects").numProperties == 4){
                            curFx.moveTo(curLy.property("ADBE Effect Parade")("ADBE Color Key").propertyIndex+1);
                        }
                    }
                }

                if(curLy.canSetTimeRemapEnabled == true && curLy.timeRemap.expressionEnabled != true){
                    curLy.timeRemap.expression = tsTimeRimapExp;
                }
            },

            //各レイヤーにキーをセット
            setSLKey: function(valCell){
                app.beginUndoGroup("importCSV_toTimesheetAE");

                if(this.actComp.duration != (this.cellData[0].length / this.FrRate)){
                    this.actComp.duration = (this.cellData[0].length / this.FrRate);
                    this.Dur = this.actComp.duration;
                }

                //各コンポレイヤーに入力
                var setLys = new Array();
                for(var ii=0;ii<this.cellLys.length;ii++){
                    if(valCell[ii] > 0){
                        var curLy = this.cellLys[ii];
                        setLys.push(curLy);
                        //curLy.name = this.cellName[ii];
                        
                        //TSエフェクト適用
                        this.setFX(curLy);
                        //エクスプレッションを無効にしてから適用
                        curLy.timeRemap.expressionEnabled = false;
                        curLy.property("ADBE Effect Parade")("TS_Geometry2")(9).expressionEnabled = false;
                        //スライダーのキー番号
                        var nKey = 1;
                        for(var i=0;i<this.cellData[valCell[ii]-1].length;i++){
                            var curFr = i / this.FrRate;
                            //1フレーム目の場合
                            if(i == 0){
                                //２つ以上キーがあったら削除
                                var rKey = curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].numKeys;
                                if(rKey > 1){
                                    for(var nn=1;nn<rKey;nn++){
                                        curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].removeKey(2);
                                    }
                                }

                                //レイヤーの[インポイント]からキーを打つ
                                curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].setValueAtTime(curLy.inPoint + curFr,this.cellData[valCell[ii]-1][i]);
                                //キーをホールド
                                curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].setInterpolationTypeAtKey(nKey,KeyframeInterpolationType.HOLD);
                                nKey++;

                            //2フレーム目以降の場合
                            }else{
                                //前フレームと違うセルならキーを打つ
                                if(this.cellData[valCell[ii]-1][i] != this.cellData[valCell[ii]-1][i-1]){
                                    curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].setValueAtTime(curLy.inPoint + curFr,this.cellData[valCell[ii]-1][i]);
                                    //キーをホールド
                                    curLy.effect("TS_Slider Control")["ADBE Slider Control-0001"].setInterpolationTypeAtKey(nKey,KeyframeInterpolationType.HOLD);
                                    nKey++;
                                 }
                            }
                        }
                    }
                 }

                 //適用した全てのレイヤーのエクスプレッションを有効にする
                for(var ii=0;ii<setLys.length;ii++){
                     setLys[ii].timeRemap.expressionEnabled = true;
                     setLys[ii].property("ADBE Effect Parade")("TS_Geometry2")(9).expressionEnabled = true;
                 }

                 app.endUndoGroup();
            },

            setCellNO: function(startVal,COL,ROW)
            {
                this.actComp.time = 0;
                var sNum = 0;
                var valE = false;
                this.cellName = new Array();
                for(var i=startVal;i<ROW.length;i++){
                    if(ROW[i].indexOf("go") == -1){
                        var numArr = new Array();
                        var numArrB = new Array();
                        for(j=2;j<(COL.length)-1;j++)
                        {
                            var frNO = j-1;
                            var cellNO = COL[j].split(",")[i].split("\"")[1];
                            if(cellNO!=""){
                                if(cellNO=="×"){
                                    numArr.push(0);
                                    numArrB.push(0);
                                }else{
                                   numArr.push(cellNO);
                                   numArrB.push(cellNO);
                                }
                                //alert(numArr[numArr.length-1]);
                           　}else{
                                if(numArr.length == 0){
                                    numArr.push(0);
                                }else{
                                    numArr.push(numArr[numArr.length-1]);
                                }
                            }
                        }

                        if(numArrB.length > 0){
                            var strVal = ROW[i].split("\"")[1];
                            this.cellName.push(strVal);
                            this.cellData[sNum] = new Array();
                            this.cellData[sNum] = numArr;
                            sNum++;
                        }
                    }
                }
                //alert(this.cellData[0]);

                if(this.cellData[0].length > 0){
                    this.cellLys.sort(this.downIndex);
                    this.bld_DLG();
                }else{
                    alert("シートを正しく読み込み出来ませんでした");
                }
            },

            bld_DLG: function()
            {
                var bSelf = this;
                var itemArr = new Array();
                itemArr = this.cellName;
                itemArr.unshift("non");
                if(this.cellLys.length > 2){
                    var dlgWidth = 20+(this.cellLys.length*180);
                }else{
                    var dlgWidth = 20+(2*180);
                }
                var dlg = new Window("window"," importCSV_toTimesheetAE",[0,0,dlgWidth,140]);
                var scGrp = new Array();
                var scGP = new Array();
                var infoT = dlg.add("statictext",[5,5,140,20],"各レイヤーにセルを適用");
                var gpSize = 22;
                var infoGp = new Array();
                for(var i=0;i<this.cellLys.length;i++){
                    scGrp[i] = dlg.add("panel",[10+(i*180),50,10+((i+1)*180),120],"",{borderStyle:"black"});
                    infoGp[i] = scGrp[i].add("statictext",[5,5,140,20],this.cellLys[i].index +" : "+ this.cellLys[i].name);
                    scGP[i] = scGrp[i].add("dropdownlist",[5,30,170,60],itemArr);
                    scGP[i].id = i;
                    if(this.cellName.length > i){
                        scGP[i].selection = scGP[i].items[i+1];
                    }else{
                        scGP[i].selection = 0;
                    }
                    //scGrp[i].position = [5+(i*150),5];
                }

                var okBtn = dlg.add("button",[dlg.size[0]-150,5,dlg.size[0]-10,40],"Apply Cell");
                okBtn.onClick = function()
                                        {
                                            var selVal = new Array();
                                            for(var i=0;i<scGP.length;i++){
                                                selVal.push(scGP[i].selection.index);
                                            }
                                            //alert(selVal);
                                            bSelf.setSLKey(selVal);
                                            dlg.close();
                                        }

                dlg.center();
                dlg.show();
            },

            runFunc: function(thisObj)
            {
                if(this.actComp != null){
                    var Lys = this.actComp.layers;
                    if(Lys.length > 0){
                        for(var r=1;r<=Lys.length;r++){
                            if(Lys[r].selected){
                                this.cellLys.push(Lys[r]);
                            }
                        }
                    }
                    if(this.cellLys.length > 0){
                        this.Dur = this.actComp.duration;
                        this.FrRate = this.actComp.frameRate;
                        //alert(this.Dur * this.FrRate);
                        this.osChk();
                        this.importCSV();
                    }else{
                        alert("レイヤーが選択されていません");
                    }
                }
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS6 over)
        if (parseFloat(app.version) < 11)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();