﻿//  textKanji_reSize_CC.jsx ver 1.1 2018.08.09
//
//  テキストレイヤーを選択後に実行 ※複数可
//  テキストに含まれる漢字のみコントローラー用ヌルのスケール値でサイズ変更
//  
//  
//  ＝更新履歴＝
//  ver 1.1 複数のコントローラー用ヌルが使えるようにナンバリング仕様に変更 ＆ 部分修正
//
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    textKanji_reSize_CC(this);

    function textKanji_reSize_CC(thisObj)
    {
        function runScr()
        {
            this.valE = false;
            this.txtLys = new Array();
            this.uCode = new Array();
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CC 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //textFile path
                this.txtFile = this.aePath +"textKanji_reSize_CC/JIS0208_HiKanji.TXT"

                //alert(this.aePath);
            },

            getTxtLys: function()
            {
                this.actComp = app.project.activeItem;
                if(this.actComp != null){
                    var selLys = this.actComp.selectedLayers;
                    for (var i=0;i<selLys.length;i++){
                        //テキストレイヤーだったら取得
                        if(selLys[i].toString() == "[object TextLayer]"){this.txtLys.push(selLys[i])}
                    }
                    //テキストレイヤーが選ばれていたら次へ
                    if(this.txtLys.length > 0){
                        this.impJIS0208_HiKanji();
                    }else{
                        alert("[TextLayer] が選択されていません");
                    }
                }
            },

            //非漢字の文字コード(text File)を読み込み ※JIS X 0208に対応
            impJIS0208_HiKanji: function()
            {
                var impTxt = new File(this.txtFile);
                if(impTxt.exists){
                    if(impTxt.open("r")){
                        //行(セル)ごとに読み込み
                        try{
                            while(! impTxt.eof)
                            {
                                var txtVal = impTxt.readln();
                                if(txtVal != ""){
                                    //下４桁のみ取得
                                    var txt = txtVal.split(this.tabS)[2].substring(2,6);
                                    this.uCode.push(txt);
                                }
                            }
                            impTxt.close();
                            if(this.uCode.length != 524){
                                alert("******読み込みに失敗しました B******");
                            }else{
                                //読み込み成功だったら次へ
                                this.setAnim();
                            }
                        }catch(e){
                            alert("******読み込みに失敗しました A******");
                        }
                    }
                }else{
                    alert("[JIS0208_HiKanji.TXT] ファイルが見つかりませんでした")
                }
            },

            //文字コード判別
            serchKanji: function(STR)
            {
                var strH = new Array();
                for(var s=0;s<STR.length;s++){
                    var valH = false;
                    //文字コード取得
                    var val = escape(STR[s]).toString();
                    //6桁以外排除 ※NaN含め
                    if(val.length == 6){
                        //下4桁のみ取得
                        var curVal = val.substring(2,6)
                        //非漢字コードと比較
                        for(var u=0;u<this.uCode.length;u++){
                            //非漢字だったら排除
                            if(curVal == this.uCode[u]){
                                valH = true;
                                break;
                            }
                        }
                        //漢字のみ取得
                        if(! valH){
                            strH.push(s);
                        }
                    }
                }
                return strH
            },

            setAnim: function()
            {
                //コントローラーヌルが複数ある場合を想定してナンバリング
                var nVal = 1;
                for(var i=1;i<=this.actComp.numLayers;i++){
                    var curName = this.actComp.layer(i).name
                    if(curName.indexOf("Ctrl_Kanji_Scale") != -1){
                        nVal++;
                    }
                }
                //スケールコントローラー用ヌル
                var ctrlNull = this.actComp.layers.addNull();
                var nCount = ("00" + nVal).slice(-2);
                ctrlNull.source.name = "Ctrl_Kanji_Scale_" + nCount;
                ctrlNull.enabled = false;
                for(var i=0;i<this.txtLys.length;i++){
                    //各テキストに漢字があるか判別
                    var strIndex = this.serchKanji(this.txtLys[i]("ADBE Text Properties")("ADBE Text Document").value.toString());
                    //漢字があれば適用
                    if(strIndex.length > 0){
                        //テキスト アニメーター グループに追加
                        var curProp = this.txtLys[i]("ADBE Text Properties")("ADBE Text Animators").addProperty("ADBE Text Animator");
                        curProp.name = "Kanji_Scale";
                        for(var ii=0;ii<strIndex.length;ii++){
                            //テキスト セレクター グループに追加
                            var curSet = curProp("ADBE Text Selectors").addProperty("ADBE Text Selector");
                            //隠れているプロパティを表示 ※["ADBE Text Index Start"],["ADBE Text Index End"],["ADBE Text Index Offset"]の３つ
                            curSet("ADBE Text Range Advanced")("ADBE Text Range Units").setValue(2);  
                            curSet("ADBE Text Index Start").setValue(strIndex[ii]);
                            curSet("ADBE Text Index End").setValue(strIndex[ii]+1);
                            curSet("ADBE Text Index Offset").setValue(0);
                            //スケール
                            curProp("ADBE Text Animator Properties").addProperty("ADBE Text Scale 3D");
                            //コントローラー用ヌルとリンク
                            curProp("ADBE Text Animator Properties")("ADBE Text Scale 3D").expression = "thisComp.layer("+"\""+"Ctrl_Kanji_Scale_"+ nCount +"\""+").transform.scale;";
                            //トラッキングのタイプ
                            curProp("ADBE Text Animator Properties").addProperty("ADBE Text Track Type");
                            //トラッキング
                            curProp("ADBE Text Animator Properties").addProperty("ADBE Text Tracking Amount");
                            //スケールが100%増減するごとに72増減するエクスプレッションを適用 ※この数値は適当
                            curProp("ADBE Text Animator Properties")("ADBE Text Tracking Amount").expression = "((text.animator("+"\""+"Kanji_Scale"+"\""+").property.scale[0]*0.01)*72)-72;";
                        }
                    }
                }
            },

            runFunc: function(thisObj)
            {
                app.beginUndoGroup("textKanji_reSize_CC");
                this.osChk();
                this.getTxtLys();
                app.endUndoGroup();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CC over)
        if (parseFloat(app.version) < 12)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();