﻿//  toggleShyLys.jsx ver.1.0    2019.01.20
//
//  実行する度に選択レイヤー以外のレイヤーのshyをON・OFF
//  ※選択レイヤー以外にshy OFFのレイヤーがあれば、選択レイヤー以外の全てのレイヤーをshy ON(選択レイヤーのみ表示)
//  ※選択レイヤーのみがshy OFFだった場合は全てのレイヤーをshy OFF(全レイヤーを表示)
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    toggleShyLys(this);

    function toggleShyLys(thisObj)
    {
        function runScr()
        {
            this.actComp = app.project.activeItem;
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS4 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            setShyLys: function()
            {
                if(this.actComp == null){
                    alert("コンポがアクティブな状態で実行してください");
                }else{
                    var selLys = this.actComp.selectedLayers;
                    if(selLys.length == 0){
                        alert("選択レイヤーが1つ以上で実行してください");
                    }else{
                        app.beginUndoGroup("toggleShyLys");
                        //shyスイッチをON
                        this.actComp.hideShyLayers = true;
                        var allLys = this.actComp.layers;
                        var valE = false;
                        var chkLys = new Array();
                        for(var i=1;i<=allLys.length;i++){
                            //選択レイヤーでshy ONのレイヤーを取得
                            if(!allLys[i].selected && !allLys[i].shy){
                                valE = true;
                                chkLys.push(allLys[i]);
                            }
                        }
                        //選択レイヤー以外にshy OFFのレイヤーがある場合、shy ONにする
                        if(valE){
                            for(var i=0;i<chkLys.length;i++){
                                chkLys[i].shy = true;
                            }
                        //選択レイヤー以外が全てshy ONだった場合、全てのレイヤーをshy OFFにする
                        }else{
                            for(var i=1;i<=allLys.length;i++){
                                if(allLys[i].shy){
                                    allLys[i].shy = false;
                                }
                            }
                            //shyスイッチをOFF
                            this.actComp.hideShyLayers = false;
                        }
                        app.endUndoGroup();
                    }
                }
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.setShyLys();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS4 over)
        if (parseFloat(app.version) < 9)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();