﻿//reNamer.jsx  ver 1.0  2016.03.04
//
//選択アイテムへのリネームスクリプト
//いろいろ組み合わせることで任意の変更が可能
//
//mail:curryeggs@gmail.com
//twitter:@curry_eggs
//blog:http://curryegg.blog.shinobi.jp/
//


(function()
{
    reNamer(this);

    function reNamer(thisObj)
    {
        function runScr()
        {
            this.countVal = "";
            this.scVER = "reNamer ver.1.0";
            this.newName = new Array();
            this.projVal = false;
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS4 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            //
            getSel: function(bSelf)
            {
                bSelf.selItems = new Array();
                var beforeTxt = "";
                var actItem = app.project.activeItem;
                if(actItem != null){
                    var selLys = app.project.activeItem.selectedLayers;
                    if(selLys != undefined && selLys.length > 0){
                        var i=0;
                        for each(var oLy in selLys){
                            bSelf.selItems.push(oLy);
                            bSelf.selItems[i].selectNum = i;
                            i++;
                        }
                        if(bSelf.selItems.length == 1){
                            bSelf.countVal = "comp : "+ actItem.name +" < 1 Layer";
                        }else{
                            bSelf.countVal = "comp : "+ actItem.name +" < "+ bSelf.selItems.length +" Layers";
                            bSelf.selItems.sort(bSelf.smallSelect);
                        }                    }else{
                        if(app.project.selection.length == 1 && app.project.selection[0] == actItem){
                            //ファイルだったら除外
                            if(actItem.mainSource instanceof FileSource == false){
                                bSelf.selItems.push(actItem);
                                bSelf.selItems.selectNum = 0;
                                bSelf.countVal = "project < 1 Item";
                                bSelf.projVal = true;
                            }else{
                                allSels[i].selected = false;
                                beforeTxt = null;
                            }
                        }else{
                            beforeTxt = null;
                        }
                    }
                }else{
                    var allSels = app.project.selection;
                    if(allSels.length > 0){
                        var ii=0;
                        for(var i=0;i<allSels.length;i++){
                            //ファイルだったら除外
                            if(allSels[i].mainSource instanceof FileSource == false){
                                bSelf.selItems.push(allSels[i]);
                                bSelf.selItems[ii].selectNum = ii;
                                ii++;
                            }else{
                                allSels[i].selected = false;
                            }
                        }
                        if(bSelf.selItems.length > 0){
                            if(bSelf.selItems.length == 1){
                                bSelf.countVal = "project < 1 Item";
                            }else{
                                bSelf.countVal = "project < "+ bSelf.selItems.length +" Items";
                                bSelf.selItems.sort(bSelf.smallName);
                            }
                            bSelf.projVal = true;
                        }else{
                            beforeTxt = null;
                        }
                    }else{
                        beforeTxt = null;
                    }
                }
                if(beforeTxt != null){
                    for(var i=0;i<bSelf.selItems.length;i++){
                        beforeTxt += bSelf.selItems[i].name +bSelf.CF;
                    }
                }else{
                    beforeTxt ="ファイル以外のアイテムを1つ以上選択してください";
                }
                return beforeTxt;
            },

            //
            bld_UI: function(beforeTxt)
            {
                if(beforeTxt == "ファイル以外のアイテムを1つ以上選択してください"){
                    alert(beforeTxt);
                }else{
                    var bSelf = this;
                    var winH = 350;
                    var bld = new Window("window", this.scVER, [0,0,500,winH]);

                    var btnGrp = bld.add("group",[0,0,210,25]);
                    var chkBtnA = btnGrp.add("checkbox",[10,10,100,30],"Rename");
                    chkBtnA.helpTip = "チェックON:置き換え＆前後に追加";
                    chkBtnA.value = true;
                    chkBtnA.onClick = function()
                                                {
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }
                    var chkBtnB = btnGrp.add("checkbox",[110,10,210,30],"add Numbering");
                    chkBtnB.helpTip = "チェックON:連番を追加  ※元の名前に追加する場合は[Rename]のチェックをOFF";
                    chkBtnB.onClick = function()
                                                {
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }

                    var info00 = bld.add("statictext",[230,10,490,25],this.countVal); info00.justify = "left";
                    this.UI_fgColor255(info00,[220,150,0]);

                    var edGrp = bld.add("group",[0,25,395,80]);
                    var infoA = edGrp.add("statictext",[15,6,80,24],"Search :"); infoA.justify = "left";
                    this.UI_fgColor255(infoA,[220,150,0]);
                    var targetName = edGrp.add("edittext",[10,25,110,55],"");
                    targetName.helpTip = "= Search Option ="+this.CF+"[入力なし] : 全て置き換え"+this.CF+"[*] : 名前の前に置換文字を挿入"+this.CF+"[**] : 名前の後ろに置換文字を挿入"+this.CF+"[*-数字] : 頭から数字分の文字を削除"+this.CF+"[**-数字] : お尻から数字分の文字を削除";
                    targetName.onChanging = function()
                                                    {
                                                        afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                    };
                    var infoTxt1 = edGrp.add("statictext",[112,25,128,55],"→"); infoTxt1.justify = "center";
                    var infoB = edGrp.add("statictext",[135,6,200,24],"Replace :"); infoB.justify = "left";
                    this.UI_fgColor255(infoB,[220,150,0]);
                    var edName = edGrp.add("edittext",[130,25,240,55],"");
                    edName.onChanging = function()
                                                    {
                                                        afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                    };
                    var infoC = edGrp.add("statictext",[255,6,310,24],"Number :"); infoC.justify = "left";
                    this.UI_fgColor255(infoC,[220,150,0]);
                    var edNum = edGrp.add("edittext",[250,25,310,55],"_####");
                    edNum.helpTip = "= Number Option ="+this.CF+"1文字目に[*] : 名前の前に連番を挿入"+this.CF+"[#]の前に[_] : 連結文字(アンダーバーのみ可)"+this.CF+"※[#]はどの文字でもOK(文字数で桁を判定)";
                    edNum.onChanging = function()
                                                    {
                                                        afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                    };
                    var infoD = edGrp.add("statictext",[325,6,395,24],"Count :"); infoD.justify = "left";
                    this.UI_fgColor255(infoD,[220,150,0]);
                    var edCount = edGrp.add("edittext",[320,25,350,55],"1");
                    edCount.onChanging = function()
                                                    {
                                                        if(isNaN(edCount.text)){
                                                            edCount.text = 1;
                                                        }
                                                        afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                    };
                    var btnGrp2 = edGrp.add("group",[355,20,395,60]);
                    var tglBtnA = btnGrp2.add("radiobutton",[2,2,38,18],"＋");
                    tglBtnA.value = true;
                    tglBtnA.onClick = function()
                                                {
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }
                    var tglBtnB = btnGrp2.add("radiobutton",[2,22,38,38],"－");
                    tglBtnB.onClick = function()
                                                {
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }

                    var listGrp = bld.add("group",[0,90,500,winH]);
                    var sortGrp =listGrp.add("group",[10,0,230,36]);
                    var rdInfo = sortGrp.add("statictext",[5,2,50,20],"sort by:"); rdInfo.justify = "left";
                    this.UI_fgColor255(rdInfo,[220,150,0]);
                    var rdSortBtnA = sortGrp.add("radiobutton",[55,5,105,20],"Select");
                    rdSortBtnA.helpTip = "選択した順番に上からソート";
                    if(!bSelf.projVal){
                        rdSortBtnA.value = true;
                    }
                    rdSortBtnA.onClick = function()
                                                {
                                                    beforeTxt = "";
                                                    bSelf.selItems.sort(bSelf.smallSelect);
                                                    for(var i=0;i<bSelf.selItems.length;i++){
                                                        beforeTxt += bSelf.selItems[i].name +bSelf.CF;
                                                    }
                                                    beforeList.text = beforeTxt;
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }
                    var rdSortBtnB = sortGrp.add("radiobutton",[110,5,160,20],"Index");
                    rdSortBtnB.helpTip = "レイヤーインデックス順に上からソート";
                    if(bSelf.projVal){
                        rdSortBtnB.text = "ID";
                    }
                    rdSortBtnB.onClick = function()
                                                {
                                                    beforeTxt = "";
                                                    //プロジェクトでの選択だったら ID
                                                    if(bSelf.projVal){
                                                        bSelf.selItems.sort(bSelf.smallId);
                                                    //コンポでの選択だったら Index
                                                    }else{
                                                        bSelf.selItems.sort(bSelf.smallIndex);
                                                    }
                                                    for(var i=0;i<bSelf.selItems.length;i++){
                                                        beforeTxt += bSelf.selItems[i].name +bSelf.CF;
                                                    }
                                                    beforeList.text = beforeTxt;
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }
                    var rdSortBtnC = sortGrp.add("radiobutton",[165,5,215,20],"Name");
                    rdSortBtnC.helpTip = "名前順に上からソート";
                    if(bSelf.projVal){
                        rdSortBtnC.value = true;
                    }
                    rdSortBtnC.onClick = function()
                                                {
                                                    beforeTxt = "";
                                                    bSelf.selItems.sort(bSelf.smallName);
                                                    for(var i=0;i<bSelf.selItems.length;i++){
                                                        beforeTxt += bSelf.selItems[i].name +bSelf.CF;
                                                    }
                                                    beforeList.text = beforeTxt;
                                                    afterList.text = bSelf.repTxt(chkBtnA.value,targetName.text,edName.text,chkBtnB.value,edNum.text,edCount.text,tglBtnA.value,bSelf);
                                                }
                    var infoE = listGrp.add("statictext",[15,32,60,48],"Name :"); infoE.justify = "left";
                    this.UI_fgColor255(infoE,[220,150,0]);
                    var beforeList = listGrp.add("edittext",[10,50,230,listGrp.size[1]-10],beforeTxt, {readonly: true,multiline: true, borderless: true});
                    var infoTxt2 = listGrp.add("statictext",[235,beforeList.size[1]/2,255,beforeList.size[1]/2+15],"→"); infoTxt2.justify = "center";
                    var infoF = listGrp.add("statictext",[265,32,330,48],"Renamed :"); infoF.justify = "left";
                    this.UI_fgColor255(infoF,[220,150,0]);
                    var afterList = listGrp.add("edittext",[260,50,490,listGrp.size[1]-10],beforeTxt, {readonly: true,multiline: true, borderless: true});

                    var clBtn = bld.add("button",[400,26,490,46],"CLOSE");
                    clBtn.onClick = function()
                                                {
                                                    bld.close();
                                                }

                    var okBtn = bld.add("button",[400,50,490,80],"OK");
                    okBtn.onClick = function()
                                                {
                                                    bSelf.reName(bSelf,bld);
                                                }

                    var scriptTitle = bld.add("statictext",[380,85,495,100],"- " + this.scVER + " -"); scriptTitle.justify = "right";

                    bld.center();
                    bld.show();
                }
            },

            //replaceTxt
            repTxt:function(repBool,tTxt,edTxt,numBool,eNum,ecNum,pmBool,bSelf)
            {
                var afterTxt = "";
                var zero = "";
                var appSTR = "";
                var beforeName = "";
                var eNumVal = false;
                if(eNum.charAt(0) == "*"){
                    eNumVal = true;
                    eNum = eNum.split("*")[1];
                }
                if(eNum.charAt(0) == "_"){
                    var rNum = eNum.split("_")[1].length;
                    var addNum = "_";
                }else{
                    var rNum = eNum.length;
                    var addNum = "";
                }
                for(var i=0;i<rNum;i++){
                    zero += "0"; 
                }
                if(pmBool){
                    var pmVal = 1;
                }else{
                    var pmVal = -1;
                }

                bSelf.newName = new Array(); //初期化
                for(var i=0;i<bSelf.selItems.length;i++){
                    //置き換えON
                    if(repBool){
                        //オプション＆エラー回避
                        if(tTxt.indexOf("+") != -1 || tTxt.indexOf("*") != -1 || tTxt.indexOf('\\') !=-1){
                            if(bSelf.selItems[i].name.indexOf(tTxt) != -1){var flag = true;}
                        }else if(tTxt == ""){
                            var flag = false;
                        //置き換える文字が一致した場合
                        }else{
                            var repVal = new RegExp(tTxt,"g");
                            var flag = bSelf.selItems[i].name.match(repVal);
                        }
                        if(flag){
                            //連番追加ON
                            if(numBool){
                                //連番を前に挿入
                                if(eNumVal){
                                    bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + bSelf.selItems[i].name.replace(tTxt,edTxt));
                                //連番を後ろに挿入
                                }else{
                                    bSelf.newName.push(bSelf.selItems[i].name.replace(tTxt,edTxt) + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                                }
                                afterTxt += bSelf.newName[i] +bSelf.CF;
                            //連番追加OFF
                            }else{
                                bSelf.newName.push(bSelf.selItems[i].name.replace(tTxt,edTxt));
                                afterTxt += bSelf.newName[i] +bSelf.CF;
                            }
                        //置き換える文字が不一致の場合
                        }else{
                            //オプション [**] ※元の名前の後ろに追加
                            if(tTxt.indexOf("**") != -1){
                                //[-] オプションの場合は元の名前のお尻を数字分削除
                                if(tTxt.split("**")[1].charAt(0) == "-"){
                                    var cName = bSelf.selItems[i].name.substr(0,bSelf.selItems[i].name.length - tTxt.split("**-")[1]);
                                }else{
                                    var cName = bSelf.selItems[i].name;
                                }
                                //連番追加ON
                                if(numBool){
                                    //連番を前に挿入
                                    if(eNumVal){
                                        bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + cName + edTxt);
                                    //連番を後ろに挿入
                                    }else{
                                        bSelf.newName.push(cName + edTxt + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                                    }
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                //連番追加OFF
                                }else{
                                    bSelf.newName.push(cName + edTxt);
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                }
                            //オプション [*] ※元の名前の前に追加
                            }else if(tTxt.indexOf("*") != -1){
                                //[-] オプションの場合は元の名前の頭を数字分削除
                                if(tTxt.split("*")[1].charAt(0) == "-"){
                                    var cName = bSelf.selItems[i].name.substr(tTxt.split("*-")[1],bSelf.selItems[i].name.length);
                                }else{
                                    var cName = bSelf.selItems[i].name;
                                }
                                //連番追加ON
                                if(numBool){
                                    //連番を前に挿入
                                    if(eNumVal){
                                        bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + edTxt + cName);
                                    //連番を後ろに挿入
                                    }else{
                                        bSelf.newName.push(edTxt + cName + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                                    }
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                //連番追加OFF
                                }else{
                                    bSelf.newName.push(edTxt + cName);
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                }
                            //オプション [] ※入力なしの場合は名前を上書き
                            }else if(tTxt == ""){
                                //連番追加ON
                                if(numBool){
                                    //連番を前に挿入
                                    if(eNumVal){
                                        bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + edTxt);
                                    //連番を後ろに挿入
                                    }else{
                                        bSelf.newName.push(edTxt + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                                    }
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                //連番追加OFF
                                }else{
                                    bSelf.newName.push(edTxt);
                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                }
                            //完全に不一致の場合は元の名前のまま
                            }else{
                                //連番追加ON
                                if(numBool){
                                    //連番を前に挿入
                                    if(eNumVal){
                                        bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + bSelf.selItems[i].name);
                                    //連番を後ろに挿入
                                    }else{
                                        bSelf.newName.push(bSelf.selItems[i].name + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                                    }

                                    afterTxt += bSelf.newName[i] +bSelf.CF;
                                //連番追加OFF
                                }else{
                                    bSelf.newName.push(bSelf.selItems[i].name);
                                    afterTxt += bSelf.selItems[i].name +bSelf.CF;
                                }
                            }
                        }
                    //連番追加ON のみ ※元の名前に連番追加
                    }else if(numBool){
                        //連番を前に挿入
                        if(eNumVal){
                            bSelf.newName.push(addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1) + bSelf.selItems[i].name);
                        //連番を後ろに挿入
                        }else{
                            bSelf.newName.push(bSelf.selItems[i].name + addNum + (zero + (eval(ecNum)+(i*pmVal))).slice(rNum*-1));
                        }
                        afterTxt += bSelf.newName[i] +bSelf.CF;
                    //どちらもOFF ※変更なし
                    }else{
                        bSelf.newName.push(bSelf.selItems[i].name);
                        afterTxt += bSelf.selItems[i].name +bSelf.CF;
                    }
                }
                return afterTxt;
            },

            //reName
            reName: function(bSelf,bldDlg)
            {
                if(bSelf.newName.length > 0){
                    app.beginUndoGroup("script : " + bSelf.scVER);
                    for(var i=0;i<bSelf.selItems.length;i++){
                        bSelf.selItems[i].name = bSelf.newName[i];
                    }
                    app.endUndoGroup();

                    bldDlg.close();
                }else{
                    alert("置き換える文字がありません");
                }
            },

            //****** ソート用関数 sort(関数名)******
            //Name
            smallSelect: function(a,b)
            {
                return (a.selectNum > b.selectNum) ? 1 : -1 ;
            },

            //Name
            smallName: function(a,b)
            {
                return (a.name > b.name) ? 1 : -1 ;
            },

            //layer Index
            smallIndex: function(a,b)
            {
                return (a.index > b.index) ? 1 : -1 ;
            },

            //item ID
            smallId: function(a,b)
            {
                return (a.id > b.id) ? 1 : -1 ;
            },

            //scriptUI graphics 用ファンクション****************************************************
            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.bld_UI(this.getSel(this));
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS4 over)
        if (parseFloat(app.version) < 9)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();