﻿//  colors_GraFX ver 1.0 2019.03.14
//  
//  カラー数と色を指定してグラデーションスクリプト(キャラ処理用)
//  ※アルファマット用のマスクレイヤーも作成してプリコンポーズ
//  
//  1.元になる素材のレイヤーを選択した状態で実行
//  2.新規コンポ名と色数(1色以上)を指定してＯＫ
//  3.作成されたコンポレイヤーのエフェクトの色数分の色を拾ってブラーの数値を上げればグラデ完成
//  4.色数が1色の場合、単色ぼかしになります
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    colors_GraFX(this);

    function colors_GraFX(thisObj)
    {
        function runScr()
        {

        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS6 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            bldUI: function()
            {
                var bSelf = this;
                var bld = new Window("dialog"," colors_GraFX ver 1.0", [0,0,300,100]);
                var infoA = bld.add("statictext",[10,10,240,25],"コンポ名");
                var edTxtA = bld.add("edittext",[10,30,240,55],"");
                edTxtA.text = "_グラデ";
                var infoB = bld.add("statictext",[260,10,290,25],"色数");
                var edTxtB = bld.add("edittext",[260,30,290,55],"");
                edTxtB.text = "2";

                var clBtn = bld.add("button",[100,70,190,95],"CLOSE");
                clBtn.onClick = function(){bld.close();}
                var okBtn = bld.add("button",[200,70,290,95],"OK");
                okBtn.onClick = function()
                                        {
                                            if(edTxtA.text != "" && Number(edTxtB.text) > 0){
                                                bSelf.setFX(edTxtA.text,edTxtB.text);
                                                bld.close();
                                            }else{
                                                alert("空欄があるか、色数が有効ではありません");
                                            }
                                        }
                bld.center();
                bld.show();
            },

            setFX: function(oName,oNum)
            {
                var curComp = app.project.activeItem;
                if(curComp != null){
                    var curLy = curComp.selectedLayers;
                    if(curLy.length > 0){
                        app.beginUndoGroup("colors_GraFX");
                        var nCount = 0;
                        //同じ名前があったらカウント
                        for(var i=1;i<=app.project.numItems;i++){
                            if(app.project.item(i).name.indexOf(oName) != -1){
                                nCount++;
                            }
                        }
                        var newName = oName;
                        //同じ名前があったら末尾にカウント追記
                        if(nCount > 0){
                            newName += "_" + (nCount+1);
                        }

                        //選択レイヤーを２つ複製(グラデレイヤー＆マスクレイヤー)
                        var fLy = curLy[0].duplicate();
                        var fLy2 = curLy[0].duplicate();
                        if(oNum == 1){
                            var fLy3 = curLy[0].duplicate();
                        }
                        //レイヤーとマスクに色数分エフェクト追加
                        for(var i=1;i<=oNum;i++){
                            var oFX = fLy.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                            oFX.name = "color_"+i;
                            if(oNum == 1){
                                var oFX = fLy.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                                oFX.name = "color_mask";
                                var oFX = fLy3.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                                oFX.name = "color_Fill";
                            }
                            var oFX = fLy2.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                            oFX.name = "color_"+i;
                        }
                        //チャンネル反転
                        var oFX1 = fLy.property("ADBE Effect Parade").addProperty("ADBE Invert");
                        //アルファに変更
                        oFX1("ADBE Invert-0001").setValue(16);
                        fLy.comment = "mask";
                        //チャンネル反転
                        var oFX2 = fLy2.property("ADBE Effect Parade").addProperty("ADBE Invert");
                        //アルファに変更
                        oFX2("ADBE Invert-0001").setValue(16);
                        //ブラー(滑らか)
                        fLy2.property("ADBE Effect Parade").addProperty("ADBE Fast Blur");
                        if(oNum > 1){
                            var oFX3 = fLy2.property("ADBE Effect Parade").addProperty("ADBE Alpha Levels3");
                            //アルファレベル
                            oFX3("ADBE Alpha Levels3-0002").setValue(0);
                        }
                        //アルファマットに変更
                        fLy2.trackMatteType = TrackMatteType.ALPHA;
                        if(oNum == 1){
                            //チャンネル反転
                            var oFX3 = fLy3.property("ADBE Effect Parade").addProperty("ADBE Invert");
                            //アルファに変更
                            oFX3("ADBE Invert-0001").setValue(16);
                            //塗り
                            fLy3.property("ADBE Effect Parade").addProperty("ADBE Fill");
                        }
                        

                        //グラデレイヤー＆マスクレイヤーをプリコンポーズ
                        var newComp = curComp.layers.precompose([fLy.index,fLy2.index],newName,true);
                        //色数分のエフェクト用コントローラーを追加
                        for(var i=1;i<=oNum;i++){
                            var nFX = curComp.layer(newComp.name).property("ADBE Effect Parade").addProperty("ADBE Color Control");
                            nFX.name = "color_"+i;
                            //エクスプレッション追加
                            var oEXP = 'comp("'+curComp.name+'").layer("'+newComp.name+'").effect("color_'+i+'")(1);';
                            newComp.layer(1)("ADBE Effect Parade")("color_"+i)("ADBE Color Key-0001").expression = oEXP;
                            newComp.layer(2)("ADBE Effect Parade")("color_"+i)("ADBE Color Key-0001").expression = oEXP;
                            if(oNum == 1){
                                var nFX = curComp.layer(newComp.name).property("ADBE Effect Parade").addProperty("ADBE Color Control");
                                nFX.name = "color_mask";
                                //エクスプレッション追加
                                var oEXP2 = 'comp("'+curComp.name+'").layer("'+newComp.name+'").effect("color_mask")(1);';
                                newComp.layer(1)("ADBE Effect Parade")("color_mask")("ADBE Color Key-0001").expression = oEXP2;
                                //fLy3 エクスプレッション追加
                                fLy3("ADBE Effect Parade")("color_Fill")("ADBE Color Key-0001").expression = oEXP;
                                fLy3("ADBE Effect Parade")("ADBE Fill")("ADBE Fill-0002").expression = oEXP2;
                                fLy3.comment = "Fill_comp: "+newComp.name;
                            }
                        }
                        //ブラー用コントローラー
                        var nFX1 = curComp.layer(newComp.name).property("ADBE Effect Parade").addProperty("ADBE Slider Control");
                        nFX1.name = "Blur";
                        //エクスプレッション追加
                        var oEXP1 = 'comp("'+curComp.name+'").layer("'+newComp.name+'").effect("Blur")(1);';
                        newComp.layer(2)("ADBE Effect Parade")("ADBE Fast Blur")("ADBE Fast Blur-0001").expression = oEXP1;
                        app.endUndoGroup();
                    }else{
                        alert("対象のレイヤーを選択してください");
                    }
                }else{
                    alert("対象のレイヤーを選択してください");
                }
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.bldUI();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS6 over)
        if (parseFloat(app.version) < 11)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();