﻿//  toggle_lysView ver 1.0 2019.04.13
//  
//  選択したレイヤー(複数可)のみを表示するスクリプト
//  最初にフォルダを選択していれば、フォルダ内のレイヤー全てを表示にします
//  ※2回目以降の連続選択でフォルダを選んでもダメ
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    toggle_LysView(this);

    function toggle_LysView(thisObj)
    {
        function runScr()
        {

        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS6 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            toggleView: function(actLy)
            {
                //レイヤーセット内を含む全てのレイヤーを非表示
                var lySets = activeDocument.layerSets;
                for(var i=0;i<lySets.length;i++){
                    this.viewOff(lySets[i].layers);
                }
                var docObj = activeDocument.layers;
                this.viewOff(docObj);

                //選択レイヤーのみを表示
                this.showLys();

                if(activeDocument.activeLayer.typename !== "ArtLayer"){
                    this.viewON(activeDocument.activeLayer.layers);
                }
            },

            viewOff: function(obj)
            {
                for(var s=0;s<obj.length;s++){
                    if(obj[s].typename === "ArtLayer"){
                        obj[s].visible = false;
                    //フォルダだったら再帰処理
                    }else{
                        this.viewOff(obj[s].layers);
                    }
                }
            },

            viewON: function(obj)
            {
                for(var s=0;s<obj.length;s++){
                    if(obj[s].typename === "ArtLayer"){
                        obj[s].visible = true;
                    //フォルダだったら再帰処理
                    }else{
                        this.viewON(obj[s].layers);
                    }
                }
            },

            showLys: function()
            {
                var uID1 = charIDToTypeID('Shw ');
                var uDesc1 = new ActionDescriptor();
                var uID2 = charIDToTypeID( "null" );
                var uRef1 = new ActionReference();
                var uID3 = charIDToTypeID( "Lyr " );
                var uID4 = charIDToTypeID( "Ordn" );
                var uID5 = charIDToTypeID( "Trgt" );
                uRef1.putEnumerated( uID3, uID4, uID5 );
                uDesc1.putReference( uID2, uRef1 );
                executeAction( uID1, uDesc1, DialogModes.NO );
            },

            selLys: function()
            {
                var uID1 = charIDToTypeID('slct');
                var uDesc1 = new ActionDescriptor();
                var uID2 = charIDToTypeID( "null" );
                var uRef1 = new ActionReference();
                var uID3 = charIDToTypeID( "Lyr " );
                var uID4 = charIDToTypeID( "Ordn" );
                var uID5 = charIDToTypeID( "Trgt" );
                uRef1.putEnumerated( uID3, uID4, uID5 );
                uDesc1.putReference( uID2, uRef1 );
                executeAction( uID1, uDesc1, DialogModes.NO );
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.toggleView();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS6 over)
        if (parseFloat(app.version) < 11)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();