#ifndef _BK1088_H_
#define _BK1088_H_


// Port definition
#define BK1088_DATA PD7
#define BK1088_SCLK  PD6
#define BK1088_PORT PORTD
#define BK1088_DDR  DDRD
#define BK1088_PIN  PIND
#define BK1088_MASK (0xFF - ((1<<BK1088_DATA) | (1<<BK1088_SCLK)))

// Declared functions

// (interface)
uint8_t BK1088_Init(void);
void BK1088_SetMode(uint8_t mode);
void BK1088_SetChannel(uint16_t channel);
uint16_t BK1088_GetCurrentChannel(void);
uint8_t BK1088_IsTuned(void);
void BK1088_SeekNext(uint8_t direction);
void BK1088_SeekNext2(uint8_t direction);
void BK1088_UpdateStatus(void);
uint16_t BK1088_GetCurrentFreq(void);
void BK1088_SetVolume(void);

// (direct control)
void BK1088_Send(uint8_t addr, uint16_t data);
void BK1088_Receive(uint8_t addr, uint16_t* data);

// Constants & variables

// FM(JAPAN) ->  0x8A   76MHz  0.1MHz
// MW(JAPAN) ->  0x0E   522kHz  9kHz
// LW        ->  0x00   153kHz  1kHz
// SW        ->  0x09  2300kHz  5kHz

#define CHANNEL_FM_MAX 149
#define CHANNEL_MW_MAX 132
#define CHANNEL_LW_MAX 1259
#define CHANNEL_SW_MAX 3909

#define CHANNEL_FM 0x8A
#define CHANNEL_MW 0x0E
#define CHANNEL_LW 0x00
#define CHANNEL_SW 0x09
// Settings
struct tBk1088Settings{
	uint8_t mode;   // CHANNEL_AM/FM/SW/LW
	uint8_t config; // 0b00000000
					//   |||||||+ SEEKDIR(1)/(0)
					//   ||||||+ FIX MONORAL(1)/AUTO(0)
					//   ||||++ SEEK(00)/DIRECT(01)/PRESET(10)
					//   |||+
	uint16_t channel;// 15-bit channel
					// freq = BAND * channel * SPACE
	uint8_t vol;    // volume(0-31)
	
	uint8_t SNR_thre_FM;  // seek threshold of SNR
	uint8_t SNR_thre_AM;  // seek threshold of SNR
	uint8_t RSSI_thre_FM; // seek threshold of RSSI
	uint8_t RSSI_thre_AM; // seek threshold of RSSI
	
	uint16_t prevChannel[3]; // previous tuned channel (FM, MW, SW)
};
//g_radioSettings

// Status
struct tBk1088Status{
//	uint16_t curChannel; // 15-bit
	uint8_t  status; // 0b00000000
					//    |||||||+ TUNE (STC)
					//    ||||||+STEREO
	uint8_t SNR;     // SNR Value(0-127)[dB] (in Status1)
	uint8_t RSSI;    // RSSI Value(0-127) (in status2)
	uint16_t varactor; 
	
};
//g_radioStatus

extern struct tBk1088Settings g_radioSettings;
extern struct tBk1088Status   g_radioStatus;

#endif
