// NOkia-3300 LCD Control ROutine For WinAVR
// (c) 2013 Eleken 
// rev_c1815@yahoo.co.jp

#include "main.h"
#include "lcd3300.h"
#include "font1.h"
#include "font2.h"


/*
#define LCD_SCK   PD4
#define LCD_RESET PD3
#define LCD_CS    PD2
#define LCD_SDATA PD1
#define LCD_PORT  PORTD
#define LCD_DDR   DDRD
#define LCD_PIN   PIND

#define DISCTL	0b11001010 //3
#define COMSCN	0b10111011 //1
#define TMPGRD	0b10000010 //14
#define OSCON	0b11010001
#define SLPOUT	0b10010100
#define VOLCTR	0b10000001 //2
#define PWRCTR	0b00100000 //1
#define DISNOR	0b10100110
#define DISINV	0b10100111
#define PTLIN	0b10101000 //2
#define PTLOUT	0b10101001
#define ASCSET	0b10101010 //4
#define SCSTART	0b10101011 //1
#define DATCTL	0b10111100 //3
#define RGBSET8	0b11001110 //20
#define PASET	0b01110101 //2
#define CASET	0b00010101 //2
#define RAMWR	0b01011100
#define DISON	0b10101111
*/

static uint8_t gLCD3300_IsSleep = 0;

#define XOFFS 4

void LCD3300_SleepIn(void){
	if(gLCD3300_IsSleep) return;
	LCD3300_WriteCommand(DISOFF);
	LCD3300_WriteCommand(PWRCTR);
	LCD3300_WriteData(0x00);
	LCD3300_WriteCommand(OSCOFF);
	LCD3300_WriteCommand(SLPIN);
	gLCD3300_IsSleep = 1;
}
void LCD3300_SleepOut(void){
	uint8_t i;
	LCD3300_WriteCommand(SLPOUT);
	LCD3300_WriteCommand(OSCON);
	LCD3300_WriteCommand(PWRCTR);
	LCD3300_WriteData(0x0F);
	gLCD3300_IsSleep = 0;
	for(i=0; i<100; i++) _delay_ms(1);
	LCD3300_WriteCommand(DISON);
}

void LCD3300_PowOff(void){
	uint8_t i;
	LCD3300_WriteCommand(DISOFF);
	LCD3300_WriteCommand(PWRCTR);
	LCD3300_WriteData(0x00);
	LCD3300_WriteCommand(OSCOFF);
	LCD3300_WriteCommand(SLPIN);
	gLCD3300_IsSleep = 1;
	for(i=0; i<100; i++) _delay_ms(1);
}

void LCD3300_Init(void){
	uint8_t i;
	// init port
	LCD_DDR  = (LCD_DDR & LCD_MASK)  | (1<<LCD_SCK) | (1<<LCD_RESET) | (1<<LCD_CS) | (1<<LCD_SDATA);
	LCD_PORT = (LCD_PORT & LCD_MASK) | (1<<LCD_SCK) | (1<<LCD_RESET) | (1<<LCD_CS) | (1<<LCD_SDATA);
	for(i=0; i<50; i++) _delay_ms(1);
	
	// initialization sequence is same to one of datasheet.
	LCD3300_WriteCommand(DISCTL);
	LCD3300_WriteData(0);
	LCD3300_WriteData(32);
	
	LCD3300_WriteCommand(COMSCN);
	LCD3300_WriteData(1);
	LCD3300_WriteCommand(TMPGRD);
	LCD3300_WriteData(0);
	LCD3300_WriteCommand(OSCON);
	LCD3300_WriteCommand(SLPOUT);
	
	LCD3300_WriteCommand(VOLCTR);
	LCD3300_WriteData(53); //0(large)-63(small)
	LCD3300_WriteData(2);  //0(small)-7(large)
	LCD3300_WriteCommand(PWRCTR);
	LCD3300_WriteData(0x0F);
	
	LCD3300_WriteCommand(DISINV);
	LCD3300_WriteCommand(PTLOUT);

	LCD3300_WriteCommand(DATCTL);
	LCD3300_WriteData(0b00000101);
//	LCD3300_WriteData(0b00000110);
	LCD3300_WriteData(1);
	LCD3300_WriteData(1);
	
	// RGB pallete (R:0-8, G:9-16, B:17-20)
	uint8_t rtable[20] = {
		0,2,4,6,8,10,12,15,
		0,2,4,6,8,10,12,15,
		0,5,10,15};
	LCD3300_WriteCommand(RGBSET8);
	for(i=0; i<20; i++){
		LCD3300_WriteData(rtable[i]);
	}

	for(i=0; i<100; i++) _delay_ms(1);
	
	LCD3300_WriteCommand(DISON);
	LCD3300_ClearDisplay();
}

void LCD3300_ClearDisplay(void){
	if(gLCD3300_IsSleep) return ;
	LCD3300_DrawRect(0, 0, 128, 128, 0xFF);
}
// color: (3R<<5) | (3G<<2) | (2B)
uint8_t LCD3300_DrawRect(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t color){
	if(gLCD3300_IsSleep) return 1;
	uint16_t i, totalsize;
	if((y1 <= y0) || (x1 <= x0)) return 1;
	// Set rectangle
	LCD3300_WriteCommand(CASET);
	LCD3300_WriteData(XOFFS+x0);
	LCD3300_WriteData(XOFFS+x1-1);
	LCD3300_WriteCommand(PASET);
	LCD3300_WriteData(2+y0);
	LCD3300_WriteData(2+y1-1);
	
	// send data
	totalsize = (x1-x0) * (y1-y0);
	LCD3300_WriteCommand(RAMWR);
	for(i=0; i<totalsize; i++){
		LCD3300_WriteData(color);
	}
	
	return 0;
}
// Draw ascii text on 1 line (12x6 font)
// max length of text = 128/6 = 21
uint8_t LCD3300_DrawText(const char* text, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t textColor){
	if(gLCD3300_IsSleep) return 1;
	if(y0 > 128-12) return 1;
	uint8_t max_textlen = (128-x0)/6;

	uint8_t x, y, i;
	uint8_t textlen = 0;
	for(textlen=0; textlen<256; textlen++){
		if(text[textlen] == '\0') break;
	}
	if(textlen > max_textlen) textlen = max_textlen;
	
	// Set rectangle
	LCD3300_WriteCommand(CASET);
	LCD3300_WriteData(XOFFS+x0);
	LCD3300_WriteData(XOFFS+x0 + (textlen*6) - 1);
	LCD3300_WriteCommand(PASET);
	LCD3300_WriteData(2+y0);
	LCD3300_WriteData(2+y0 + 12 - 1);
	
	LCD3300_WriteCommand(RAMWR);
	for(i=0; i<textlen; i++){
		for(x=0; x<6; x++){
			// load font 
			uint8_t font;
			font = pgm_read_byte(&FONTS[(text[i]-0x20)*12 +x]);
			for(y=0; y<8; y++){
				if(font & 0x80) LCD3300_WriteData(textColor);
				else LCD3300_WriteData(bgColor);
				font = font << 1;
			}
			font = pgm_read_byte(&FONTS[(text[i]-0x20)*12 +6+x]);
			for(y=0; y<4; y++){
				if(font & 0x80) LCD3300_WriteData(textColor);
				else LCD3300_WriteData(bgColor);
				font = font << 1;
			}
		}
	}

	return 0;
}
// Draw ascii text on 1 line (24x16 font)
// max length of text = 128/16 = 8
uint8_t LCD3300_DrawBigText(const char* text, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t textColor){
	if(gLCD3300_IsSleep) return 1;
	if(y0 > 128-12) return 1;
	uint8_t max_textlen = (128-x0)/16;

	uint8_t x, y, i;
	uint8_t textlen = 0;
	for(textlen=0; textlen<256; textlen++){
		if(text[textlen] == '\0') break;
	}
	if(textlen > max_textlen) textlen = max_textlen;
	
	// Set rectangle
	LCD3300_WriteCommand(CASET);
	LCD3300_WriteData(XOFFS+x0);
	LCD3300_WriteData(XOFFS+x0 + (textlen*16) - 1);
	LCD3300_WriteCommand(PASET);
	LCD3300_WriteData(2+y0);
	LCD3300_WriteData(2+y0 + 24 - 1);
	
	LCD3300_WriteCommand(RAMWR);
	for(i=0; i<textlen; i++){
		uint8_t pos = (text[i]-'0');
		for(x=0; x<48; x+=1){
			// load font 
			uint8_t font;
			font = pgm_read_byte(&FONTS2[pos*48 +x]);
			for(y=0; y<8; y++){
				if(font & 0x80) LCD3300_WriteData(textColor);
				else LCD3300_WriteData(bgColor);
				font = font << 1;
			}
		}
	}

	return 0;
}
// value: 0-127
uint8_t LCD3300_DrawBarGraph(uint8_t value, uint8_t x0, uint8_t y0, uint8_t bgColor, uint8_t barColor){
	if(gLCD3300_IsSleep) return 1;
	if(y0 > 128-12) return 1;
	uint8_t x, y;
	
	// Set rectangle
	LCD3300_WriteCommand(CASET);
	LCD3300_WriteData(XOFFS+x0);
	LCD3300_WriteData(XOFFS+x0 + 127);
	LCD3300_WriteCommand(PASET);
	LCD3300_WriteData(2+y0);
	LCD3300_WriteData(2+y0 + 12 - 1);
	
	LCD3300_WriteCommand(RAMWR);
	for(x=0; x<128; x++){
		for(y=0; y<12; y++){
			if((x <= value) && (x&0x01)) LCD3300_WriteData(barColor);
			else LCD3300_WriteData(bgColor);
		}
	}

	return 0;
}

// enter command
void LCD3300_WriteCommand(uint8_t data){
	uint8_t i;
	CBI(LCD_PORT, LCD_CS);
	
	CBI(LCD_PORT, LCD_SDATA);
	CBI(LCD_PORT, LCD_SCK);
	SBI(LCD_PORT, LCD_SCK);
	for(i=0; i<8; i++){
		if(data & 0x80) SBI(LCD_PORT, LCD_SDATA);
		else CBI(LCD_PORT, LCD_SDATA);
		CBI(LCD_PORT, LCD_SCK);
		SBI(LCD_PORT, LCD_SCK);
		data = data << 1;
	}

	SBI(LCD_PORT, LCD_CS);
}

// enter data (parameters)
void LCD3300_WriteData(uint8_t data){
	uint8_t i;
	CBI(LCD_PORT, LCD_CS);
	
	SBI(LCD_PORT, LCD_SDATA);
	CBI(LCD_PORT, LCD_SCK);
	SBI(LCD_PORT, LCD_SCK);
	for(i=0; i<8; i++){
		if(data & 0x80) SBI(LCD_PORT, LCD_SDATA);
		else CBI(LCD_PORT, LCD_SDATA);
		CBI(LCD_PORT, LCD_SCK);
		SBI(LCD_PORT, LCD_SCK);
		data = data << 1;
	}


	SBI(LCD_PORT, LCD_CS);
}



