#ifndef _MAIN_H_
#define _MAIN_H_


#include <inttypes.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>

// macros
#define SBI(port, bit)	(port |= _BV(bit))
#define CBI(port, bit)	(port &= ~_BV(bit))

//#define show_string_direct_pgm(text, a, b, c)  strcpy_P(tbuf, PSTR(text)); show_string_direct(tbuf, a, b, c)
//#define show_string_direct_pgm(text, a, b, c)  show_string_direct(text, a, b, c)

#define LB(x) ((x)&0x00FF)
#define HB(x) (((x)>>8)&0x00FF)

// Variables 
extern volatile uint8_t g_swState ;

// grobal text buffer
extern char tbuf[22];

// Constants 
#define SW1 1 // SEL
#define SW2 2 // +
#define SW3 3 // -
#define SW4 4 // POW
#define SW_LONG 16
#define SW_PUSHING 32

#define LONGPUSH_WEIGHT 5
#define SW_PORT_MASK 0b00111100
#define SW1_PUSHED   0b00111000
#define SW2_PUSHED   0b00110100
#define SW3_PUSHED   0b00101100
#define SW4_PUSHED   0b00011100
#define SW_PORT PINB

#define COLOR_BG 0x00
#define COLOR_TEXT 0b00011100
#define COLOR_TEXT_AM 0b00010011
#define COLOR_TEXT_FM 0b00011100

#endif

